/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;

public class FuelRod
extends ReactorItem {
    private final int energyMult;
    private final double heatMult;
    private final int rodCount;
    private final boolean moxStyle;
    private static boolean GT509behavior = false;
    private static boolean GTNHbehavior = false;

    public static void setGT509Behavior(boolean value) {
        GT509behavior = value;
    }

    public static void setGTNHBehavior(boolean value) {
        GTNHbehavior = value;
    }

    public FuelRod(int id, String baseName, String name, Image image, double maxDamage, double maxHeat, String sourceMod, int energyMult, double heatMult, int rodCount, boolean moxStyle) {
        super(id, baseName, name, image, maxDamage, maxHeat, sourceMod);
        this.energyMult = energyMult;
        this.heatMult = heatMult;
        this.rodCount = rodCount;
        this.moxStyle = moxStyle;
    }

    public FuelRod(FuelRod other) {
        super(other);
        this.energyMult = other.energyMult;
        this.heatMult = other.heatMult;
        this.rodCount = other.rodCount;
        this.moxStyle = other.moxStyle;
    }

    @Override
    public boolean isNeutronReflector() {
        return !this.isBroken();
    }

    private int countNeutronNeighbors() {
        int neutronNeighbors = 0;
        ReactorItem component = this.parent.getComponentAt(this.row + 1, this.col);
        if (component != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row - 1, this.col)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        return neutronNeighbors;
    }

    protected List<ReactorItem> getHeatableNeighbors() {
        ArrayList<ReactorItem> heatableNeighbors = new ArrayList<ReactorItem>(4);
        ReactorItem component = this.parent.getComponentAt(this.row + 1, this.col);
        if (component != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row - 1, this.col)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        return heatableNeighbors;
    }

    protected List<ReactorItem> getGTHeatableNeighbors() {
        ArrayList<ReactorItem> heatableNeighbors = new ArrayList<ReactorItem>(4);
        ReactorItem component = this.parent.getComponentAt(this.row, this.col - 1);
        if (component != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row + 1, this.col)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row - 1, this.col)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        return heatableNeighbors;
    }

    protected void handleHeat(int heat) {
        List<ReactorItem> heatableNeighbors = this.getHeatableNeighbors();
        if (heatableNeighbors.isEmpty()) {
            this.parent.adjustCurrentHeat(heat);
            this.currentHullHeating = heat;
        } else {
            this.currentComponentHeating = heat;
            for (ReactorItem heatableNeighbor : heatableNeighbors) {
                heatableNeighbor.adjustCurrentHeat(heat / heatableNeighbors.size());
            }
            int remainderHeat = heat % heatableNeighbors.size();
            heatableNeighbors.get(0).adjustCurrentHeat(remainderHeat);
        }
    }

    protected void handleGTHeat(int heat) {
        List<ReactorItem> heatableNeighbors = this.getGTHeatableNeighbors();
        if (heatableNeighbors.isEmpty()) {
            this.parent.adjustCurrentHeat(heat);
            this.currentHullHeating = heat;
        } else {
            this.currentComponentHeating = heat;
            int everCycleHeat = heat / this.rodCount;
            for (int i = 0; i < heatableNeighbors.size(); ++i) {
                int toNeighborHeat = everCycleHeat / (heatableNeighbors.size() - i);
                everCycleHeat -= toNeighborHeat;
                heatableNeighbors.get(i).adjustCurrentHeat(this.rodCount * toNeighborHeat);
            }
        }
    }

    @Override
    public double generateHeat() {
        int pulses = this.countNeutronNeighbors() + 1 + this.rodCount / 2;
        int heat = (int)(this.heatMult * (double)pulses * (double)(pulses + 1));
        if (this.moxStyle && this.parent.isFluid() && this.parent.getCurrentHeat() / this.parent.getMaxHeat() > 0.5) {
            heat *= 2;
        }
        this.currentHeatGenerated = heat;
        this.minHeatGenerated = Math.min(this.minHeatGenerated, (double)heat);
        this.maxHeatGenerated = Math.max(this.maxHeatGenerated, (double)heat);
        if (GT509behavior || GTNHbehavior) {
            this.handleGTHeat(heat);
        } else {
            this.handleHeat(heat);
        }
        return this.currentHeatGenerated;
    }

    @Override
    public double generateEnergy() {
        int pulses = this.countNeutronNeighbors() + 1 + this.rodCount / 2;
        double energy = this.energyMult * pulses;
        if (GT509behavior || "GT5.09".equals(this.sourceMod)) {
            energy *= 2.0;
            if (this.moxStyle) {
                energy *= 1.0 + 1.5 * this.parent.getCurrentHeat() / this.parent.getMaxHeat();
            }
        } else if (GTNHbehavior || "GTNH".equals(this.sourceMod)) {
            energy *= 10.0;
            if (this.moxStyle) {
                energy *= 1.0 + 1.5 * this.parent.getCurrentHeat() / this.parent.getMaxHeat();
            }
        } else if (this.moxStyle) {
            energy *= 1.0 + 4.0 * this.parent.getCurrentHeat() / this.parent.getMaxHeat();
        }
        this.minEUGenerated = Math.min(this.minEUGenerated, energy);
        this.maxEUGenerated = Math.max(this.maxEUGenerated, energy);
        this.currentEUGenerated = energy;
        this.parent.addEUOutput(energy);
        this.applyDamage(1.0);
        return energy;
    }

    @Override
    public int getRodCount() {
        return this.rodCount;
    }

    @Override
    public double getCurrentOutput() {
        if (this.parent != null) {
            if (this.parent.isFluid()) {
                return this.currentHeatGenerated;
            }
            return this.currentEUGenerated;
        }
        return 0.0;
    }
}

