/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.Image;
import java.util.ArrayList;

public class Exchanger
extends ReactorItem {
    private final int switchSide;
    private final int switchReactor;

    public Exchanger(int id, String baseName, String name, Image image, double maxDamage, double maxHeat, String sourceMod, int switchSide, int switchReactor) {
        super(id, baseName, name, image, maxDamage, maxHeat, sourceMod);
        this.switchSide = switchSide;
        this.switchReactor = switchReactor;
    }

    public Exchanger(Exchanger other) {
        super(other);
        this.switchSide = other.switchSide;
        this.switchReactor = other.switchReactor;
    }

    @Override
    public void transfer() {
        ArrayList<ReactorItem> heatableNeighbors = new ArrayList<ReactorItem>(4);
        ReactorItem component = this.parent.getComponentAt(this.row, this.col - 1);
        if (component != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row - 1, this.col)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row + 1, this.col)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        double myHeat = 0.0;
        if (this.switchSide > 0) {
            for (ReactorItem heatableNeighbor : heatableNeighbors) {
                double mymed = this.getCurrentHeat() * 100.0 / this.getMaxHeat();
                double heatablemed = heatableNeighbor.getCurrentHeat() * 100.0 / heatableNeighbor.getMaxHeat();
                double add = (int)(heatableNeighbor.getMaxHeat() / 100.0 * (heatablemed + mymed / 2.0));
                if (add > (double)this.switchSide) {
                    add = this.switchSide;
                }
                if (heatablemed + mymed / 2.0 < 1.0) {
                    add = this.switchSide / 2;
                }
                if (heatablemed + mymed / 2.0 < 0.75) {
                    add = this.switchSide / 4;
                }
                if (heatablemed + mymed / 2.0 < 0.5) {
                    add = this.switchSide / 8;
                }
                if (heatablemed + mymed / 2.0 < 0.25) {
                    add = 1.0;
                }
                if ((double)Math.round(heatablemed * 10.0) / 10.0 > (double)Math.round(mymed * 10.0) / 10.0) {
                    add -= 2.0 * add;
                } else if ((double)Math.round(heatablemed * 10.0) / 10.0 == (double)Math.round(mymed * 10.0) / 10.0) {
                    add = 0.0;
                }
                myHeat -= add;
                heatableNeighbor.adjustCurrentHeat(add);
            }
        }
        if (this.switchReactor > 0) {
            double mymed = this.getCurrentHeat() * 100.0 / this.getMaxHeat();
            double Reactormed = this.parent.getCurrentHeat() * 100.0 / this.parent.getMaxHeat();
            int add = (int)Math.round(this.parent.getMaxHeat() / 100.0 * (Reactormed + mymed / 2.0));
            if (add > this.switchReactor) {
                add = this.switchReactor;
            }
            if (Reactormed + mymed / 2.0 < 1.0) {
                add = this.switchSide / 2;
            }
            if (Reactormed + mymed / 2.0 < 0.75) {
                add = this.switchSide / 4;
            }
            if (Reactormed + mymed / 2.0 < 0.5) {
                add = this.switchSide / 8;
            }
            if (Reactormed + mymed / 2.0 < 0.25) {
                add = 1;
            }
            if ((double)Math.round(Reactormed * 10.0) / 10.0 > (double)Math.round(mymed * 10.0) / 10.0) {
                add -= 2 * add;
            } else if ((double)Math.round(Reactormed * 10.0) / 10.0 == (double)Math.round(mymed * 10.0) / 10.0) {
                add = 0;
            }
            myHeat -= (double)add;
            this.parent.adjustCurrentHeat(add);
        }
        this.adjustCurrentHeat(myHeat);
    }

    @Override
    public double getHullCoolingCapacity() {
        return this.switchReactor;
    }
}

