/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.FuelRod;
import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.Image;

public class BreederCell
extends ReactorItem {
    private final int mHeatBonusStep;
    private final int mHeatBonusMultiplier;

    public BreederCell(int id, String baseName, String name, Image image, double maxDamage, double maxHeat, String sourceMod, int aHeatBonusStep, int aHeatBonusMultiplier) {
        super(id, baseName, name, image, maxDamage, maxHeat, sourceMod);
        this.mHeatBonusStep = aHeatBonusStep;
        this.mHeatBonusMultiplier = aHeatBonusMultiplier;
    }

    public BreederCell(BreederCell other) {
        super(other);
        this.mHeatBonusStep = other.mHeatBonusStep;
        this.mHeatBonusMultiplier = other.mHeatBonusMultiplier;
    }

    @Override
    public double generateHeat() {
        int i;
        double targetDamage = 1.0 + this.parent.getCurrentHeat() / (double)this.mHeatBonusStep * (double)this.mHeatBonusMultiplier;
        ReactorItem component = this.parent.getComponentAt(this.row - 1, this.col);
        if (component instanceof FuelRod) {
            for (i = 0; i < component.getRodCount(); ++i) {
                this.applyDamage(targetDamage);
            }
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) instanceof FuelRod) {
            for (i = 0; i < component.getRodCount(); ++i) {
                this.applyDamage(targetDamage);
            }
        }
        if ((component = this.parent.getComponentAt(this.row + 1, this.col)) instanceof FuelRod) {
            for (i = 0; i < component.getRodCount(); ++i) {
                this.applyDamage(targetDamage);
            }
        }
        if ((component = this.parent.getComponentAt(this.row, this.col - 1)) instanceof FuelRod) {
            for (i = 0; i < component.getRodCount(); ++i) {
                this.applyDamage(targetDamage);
            }
        }
        return 0.0;
    }
}

