/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import Ic2ExpReactorPlanner.ExceptionDialogDisplay;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class TextureFactory {
    private static final ZipFile TEXTURE_PACK = TextureFactory.getTexturePackZip();
    private static final String[] ASSET_PATHS = new String[]{"", "assets/ic2/textures/items/", "assets/ic2/textures/items/reactor/", "assets/ic2/textures/items/reactor/fuel_rod/", "assets/gregtech/textures/items/", "assets/fm/textures/items/", "assets/gtnh/textures/items/", "assets/goodgenerator/textures/items/"};

    private TextureFactory() {
    }

    public static Image getImage(String ... imageNames) {
        BufferedImage result = null;
        if (TEXTURE_PACK != null) {
            for (String imageName : imageNames) {
                for (String asset_path : ASSET_PATHS) {
                    ZipEntry entry;
                    if (result != null || (entry = TEXTURE_PACK.getEntry(asset_path + imageName)) == null) continue;
                    try (InputStream entryStream = TEXTURE_PACK.getInputStream(entry);){
                        result = ImageIO.read(entryStream);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        for (String asset_path : ASSET_PATHS) {
            if (result != null || TextureFactory.class.getResource("/" + asset_path + imageNames[0]) == null) continue;
            try (InputStream stream = TextureFactory.class.getResourceAsStream("/" + asset_path + imageNames[0]);){
                result = ImageIO.read(stream);
            }
            catch (IOException ex) {
                ExceptionDialogDisplay.showExceptionDialog(ex);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ZipFile getTexturePackZip() {
        try (FileInputStream configStream = new FileInputStream("erpprefs.xml");){
            ZipFile result;
            Properties config = new Properties();
            config.loadFromXML(configStream);
            String texturePackName = config.getProperty("texturePack");
            if (texturePackName == null) return null;
            ZipFile zipFile = result = new ZipFile(texturePackName);
            return zipFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        return null;
    }
}

