/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import Ic2ExpReactorPlanner.AutomationSimulator;
import Ic2ExpReactorPlanner.BundleHelper;
import Ic2ExpReactorPlanner.ComponentFactory;
import Ic2ExpReactorPlanner.ExceptionDialogDisplay;
import Ic2ExpReactorPlanner.HtmlSelection;
import Ic2ExpReactorPlanner.MaterialsList;
import Ic2ExpReactorPlanner.Reactor;
import Ic2ExpReactorPlanner.SimulationData;
import Ic2ExpReactorPlanner.components.FuelRod;
import Ic2ExpReactorPlanner.components.GGFuelRod;
import Ic2ExpReactorPlanner.components.ReactorItem;
import Ic2ExpReactorPlanner.components.Reflector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReactorPlannerFrame
extends JFrame {
    private static final String VERSION = "0.0.0";
    private final Reactor reactor = new Reactor();
    private final JButton[][] reactorButtons = new JButton[6][9];
    private final JPanel[][] reactorButtonPanels = new JPanel[6][9];
    private int selectedRow = -1;
    private int selectedColumn = -1;
    private boolean lockCode = false;
    private final JFileChooser csvChooser = new JFileChooser();
    private final JFileChooser textureChooser = new JFileChooser();
    private final ReactorItem[] paletteComponents = new ReactorItem[ComponentFactory.getComponentCount()];
    private int paletteComponentId = 0;
    private SpinnerNumberModel heatSpinnerModel = new SpinnerNumberModel();
    private final LinkedList<JButton> componentDetailButtons = new LinkedList();
    private static final Properties ADVANCED_CONFIG = new Properties();
    private Reactor simulatedReactor = null;
    private AutomationSimulator simulator = null;
    private String currentReactorCode = null;
    private String currentReactorOldCode = null;
    private AutomationSimulator prevSimulator = null;
    private String prevReactorCode = null;
    private String prevReactorOldCode = null;
    private final DecimalFormat comparisonFormat = new DecimalFormat(BundleHelper.getI18n("Comparison.CompareDecimalFormat"));
    private final DecimalFormat simpleFormat = new DecimalFormat(BundleHelper.getI18n("Comparison.SimpleDecimalFormat"));
    private JToggleButton advancedHeatExchangerButton;
    private JToggleButton advancedHeatVentButton;
    private JPanel advancedPanel;
    private JScrollPane advancedScroll;
    private JCheckBox automatedReactorCheck;
    private JPanel automationPanel;
    private JButton cancelButton;
    private JButton clearGridButton;
    private JTextField codeField;
    private JTextField comparisonCodeField;
    private JButton comparisonCopyCodeButton;
    private JLabel comparisonLabel;
    private JScrollPane comparisonScroll;
    private JTextArea componentArea;
    private JToggleButton componentHeatExchangerButton;
    private JLabel componentHeatLabel;
    private JSpinner componentHeatSpinner;
    private JToggleButton componentHeatVentButton;
    private JTextArea componentListArea;
    private JScrollPane componentListPane;
    private JScrollPane componentPane;
    private ButtonGroup componentsGroup;
    private JPanel componentsPanel;
    private JToggleButton containmentReactorPlatingButton;
    private JToggleButton coolantCell10kButton;
    private JToggleButton coolantCell30kButton;
    private JToggleButton coolantCell60kButton;
    private JToggleButton coolantCellHelium180kButton;
    private JToggleButton coolantCellHelium360kButton;
    private JToggleButton coolantCellHelium60kButton;
    private JToggleButton coolantCellNak180kButton;
    private JToggleButton coolantCellNak360kButton;
    private JToggleButton coolantCellNak60kButton;
    private JToggleButton coolantCellSpace180kButton;
    private JToggleButton coolantCellSpace360kButton;
    private JToggleButton coolantCellSpace540kButton;
    private JToggleButton coolantCellSpace1080kButton;
    private JToggleButton coolantCellNeutronium1GButton;
    private JButton copyCodeButton;
    private JButton copyComparisonButton;
    private JToggleButton coreHeatExchangerButton;
    private JButton csvBrowseButton;
    private JLabel csvFileLabel;
    private JSpinner csvLimitSpinner;
    private JCheckBox csvOutputCheck;
    private JPanel csvPanel;
    private JToggleButton dualFuelRodCesiumButton;
    private JToggleButton dualFuelRodCoaxiumButton;
    private JToggleButton dualFuelRodMoxButton;
    private JToggleButton dualFuelRodNaquadahButton;
    private JToggleButton dualFuelRodNaquadahGTNHButton;
    private JToggleButton dualFuelRodNaquadriaButton;
    private JToggleButton dualFuelRodThoriumButton;
    private JToggleButton dualFuelRodTiberiumButton;
    private JToggleButton dualFuelRodUraniumButton;
    private JToggleButton emptyButton;
    private JRadioButton euReactorRadio;
    private JCheckBox expandAdvancedAlloyCheck;
    private JRadioButton fluidReactorRadio;
    private JToggleButton fuelRodCesiumButton;
    private JToggleButton fuelRodCoaxiumButton;
    private JToggleButton fuelRodMoxButton;
    private JToggleButton fuelRodNaquadahButton;
    private JToggleButton fuelRodNaquadahGTNHButton;
    private JToggleButton fuelRodNaquadriaButton;
    private JToggleButton fuelRodTheCoreButton;
    private JToggleButton fuelRodThoriumButton;
    private JToggleButton fuelRodTiberiumButton;
    private JToggleButton fuelRodUraniumButton;
    private JToggleButton fuelRodCompressedUraniumButton;
    private JToggleButton dualFuelRodCompressedUraniumButton;
    private JToggleButton quadFuelRodCompressedUraniumButton;
    private JToggleButton fuelRodCompressedPlutoniumButton;
    private JToggleButton dualFuelRodCompressedPlutoniumButton;
    private JToggleButton quadFuelRodCompressedPlutoniumButton;
    private JToggleButton fuelRodLiquidUraniumButton;
    private JToggleButton dualFuelRodLiquidUraniumButton;
    private JToggleButton quadFuelRodLiquidUraniumButton;
    private JToggleButton fuelRodLiquidPlutoniumButton;
    private JToggleButton dualFuelRodLiquidPlutoniumButton;
    private JToggleButton quadFuelRodLiquidPlutoniumButton;
    private JToggleButton fuelRodGlowstone;
    private JComboBox<String> gtVersionCombo;
    private JToggleButton heatCapacityReactorPlatingButton;
    private JToggleButton heatExchangerButton;
    private JSpinner heatSpinner;
    private JToggleButton heatVentButton;
    private JToggleButton iridiumNeutronReflectorButton;
    private JLabel jLabel21;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JCheckBox lockPrevCodeCheck;
    private JToggleButton lzhCondensatorButton;
    private JTextArea materialsArea;
    private JScrollPane materialsListPane;
    private JLabel maxHeatLabel;
    private JLabel maxSimulationTicksLabel;
    private JSpinner maxSimulationTicksSpinner;
    private JComboBox<String> mcVersionCombo;
    private JToggleButton neutronReflectorButton;
    private JSpinner offPulseSpinner;
    private JSpinner onPulseSpinner;
    private JCheckBox onlyShowDiffCheck;
    private JTextArea outputArea;
    private JScrollPane outputPane;
    private JTabbedPane outputTabs;
    private JToggleButton overclockedHeatVentButton;
    private JButton pasteCodeButton;
    private JSpinner pauseSpinner;
    private JLabel placingLabel;
    private JLabel placingReactorPauseLabel;
    private JSpinner placingReactorPauseSpinner;
    private JLabel placingThresholdLabel;
    private JSpinner placingThresholdSpinner;
    private JPanel pulsePanel;
    private JCheckBox pulsedReactorCheck;
    private JToggleButton quadFuelRodCesiumButton;
    private JToggleButton quadFuelRodCoaxiumButton;
    private JToggleButton quadFuelRodMoxButton;
    private JToggleButton quadFuelRodNaquadahButton;
    private JToggleButton quadFuelRodNaquadahGTNHButton;
    private JToggleButton quadFuelRodNaquadriaButton;
    private JToggleButton quadFuelRodThoriumButton;
    private JToggleButton quadFuelRodTiberiumButton;
    private JToggleButton quadFuelRodUraniumButton;
    private JCheckBox reactorCoolantInjectorCheckbox;
    private JToggleButton reactorHeatVentButton;
    private JPanel reactorPanel;
    private JToggleButton reactorPlatingButton;
    private ButtonGroup reactorStyleGroup;
    private JButton resetPulseConfigButton;
    private JSpinner resumeTempSpinner;
    private JToggleButton rshCondensatorButton;
    private JLabel selectedComponentLabel;
    private JCheckBox showComponentDetailButtonsCheck;
    private JCheckBox showComponentPreconfigCheck;
    private JCheckBox showOldStyleReactorCodeCheck;
    private JButton simulateButton;
    private JSpinner suspendTempSpinner;
    private JPanel temperatureAndComponentsPanel;
    private JLabel temperatureEffectsLabel;
    private JButton texturePackBrowseButton;
    private JButton texturePackClearButton;
    private JLabel texturePackLabel;
    private JToggleButton thickNeutronReflectorButton;
    private JSpinner thresholdSpinner;
    private JLabel versionLabel;

    public ReactorPlannerFrame() {
        this.initComponents();
        this.advancedScroll.getVerticalScrollBar().setUnitIncrement(16);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        Enumeration<AbstractButton> buttons = this.componentsGroup.getElements();
        if (this.heatSpinner.getModel() instanceof SpinnerNumberModel) {
            this.heatSpinnerModel = (SpinnerNumberModel)this.heatSpinner.getModel();
        }
        while (buttons.hasMoreElements()) {
            final AbstractButton button = buttons.nextElement();
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactorItem tempComponent;
                    if ("empty".equals(button.getActionCommand())) {
                        ReactorPlannerFrame.this.placingLabel.setText(BundleHelper.getI18n("UI.ComponentPlacingDefault"));
                        ReactorPlannerFrame.this.paletteComponentId = 0;
                    } else if (button.getActionCommand() != null && (tempComponent = ComponentFactory.getDefaultComponent(button.getActionCommand())) != null) {
                        ReactorPlannerFrame.this.paletteComponentId = tempComponent.id;
                        if (ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId] == null) {
                            ((ReactorPlannerFrame)ReactorPlannerFrame.this).paletteComponents[((ReactorPlannerFrame)ReactorPlannerFrame.this).paletteComponentId] = ComponentFactory.createComponent(ReactorPlannerFrame.this.paletteComponentId);
                        }
                        ReactorPlannerFrame.this.placingLabel.setText(BundleHelper.formatI18n("UI.ComponentPlacingSpecific", ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].toString()));
                        ReactorPlannerFrame.this.componentHeatSpinner.setValue(ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].getInitialHeat());
                        ReactorPlannerFrame.this.placingThresholdSpinner.setValue(ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].getAutomationThreshold());
                        ReactorPlannerFrame.this.placingReactorPauseSpinner.setValue(ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].getReactorPause());
                    }
                }
            });
        }
        for (int row = 0; row < this.reactorButtons.length; ++row) {
            final int finalRow = row;
            for (int col = 0; col < this.reactorButtons[row].length; ++col) {
                final int finalCol = col;
                this.reactorButtonPanels[row][col] = new JPanel();
                this.reactorButtonPanels[row][col].setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.darkGray));
                this.reactorButtonPanels[row][col].setLayout(new GridBagLayout());
                this.reactorButtonPanels[row][col].setBackground(Color.LIGHT_GRAY);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                JButton automationButton = new JButton(BundleHelper.getI18n("UI.AutomateButton"));
                automationButton.setFont(Font.decode(BundleHelper.getI18n("UI.AutomateButtonFont")));
                automationButton.setMargin(new Insets(-2, 0, -2, 0));
                automationButton.setToolTipText(BundleHelper.getI18n("UI.AutomationTooltip"));
                automationButton.setFocusable(false);
                automationButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ReactorItem component = ReactorPlannerFrame.this.reactor.getComponentAt(finalRow, finalCol);
                        ReactorPlannerFrame.this.selectedRow = finalRow;
                        ReactorPlannerFrame.this.selectedColumn = finalCol;
                        if (component == null) {
                            ReactorPlannerFrame.this.selectedComponentLabel.setText(BundleHelper.formatI18n("UI.NoComponentRowCol", finalRow, finalCol));
                        } else {
                            ReactorPlannerFrame.this.selectedComponentLabel.setText(BundleHelper.formatI18n("UI.ChosenComponentRowCol", component.toString(), finalRow, finalCol));
                            ReactorPlannerFrame.this.thresholdSpinner.setValue(component.getAutomationThreshold());
                            ReactorPlannerFrame.this.pauseSpinner.setValue(component.getReactorPause());
                        }
                        ReactorPlannerFrame.this.outputTabs.setSelectedComponent(ReactorPlannerFrame.this.automationPanel);
                    }
                });
                this.reactorButtonPanels[row][col].add((Component)automationButton, constraints);
                this.componentDetailButtons.add(automationButton);
                this.reactorButtonPanels[row][col].add((Component)new JLabel(), constraints);
                constraints.gridwidth = 0;
                constraints.anchor = 13;
                JButton infoButton = new JButton(BundleHelper.getI18n("UI.ComponentInfoButton"));
                infoButton.setFont(Font.decode(BundleHelper.getI18n("UI.ComponentInfoButtonFont")));
                infoButton.setMargin(new Insets(-2, 0, -2, 0));
                infoButton.setFocusable(false);
                infoButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ReactorPlannerFrame.this.simulatedReactor != null) {
                            ReactorItem component = ReactorPlannerFrame.this.simulatedReactor.getComponentAt(finalRow, finalCol);
                            if (component == null) {
                                ReactorPlannerFrame.this.componentArea.setText(BundleHelper.formatI18n("UI.NoComponentLastSimRowCol", finalRow, finalCol));
                            } else {
                                ReactorPlannerFrame.this.componentArea.setText(BundleHelper.formatI18n("UI.ComponentInfoLastSimRowCol", component.toString(), finalRow, finalCol, component.info));
                            }
                        } else {
                            ReactorPlannerFrame.this.componentArea.setText(BundleHelper.getI18n("UI.NoSimulationRun"));
                        }
                        ReactorPlannerFrame.this.outputTabs.setSelectedComponent(ReactorPlannerFrame.this.componentPane);
                    }
                });
                infoButton.setToolTipText(BundleHelper.getI18n("UI.ComponentInfoButtonTooltip"));
                this.reactorButtonPanels[row][col].add((Component)infoButton, constraints);
                this.componentDetailButtons.add(infoButton);
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                constraints.gridwidth = 0;
                this.reactorButtons[row][col] = new JButton();
                this.reactorButtons[row][col].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if ((e.getModifiers() & 8) != 0) {
                            ReactorItem component = ReactorPlannerFrame.this.reactor.getComponentAt(finalRow, finalCol);
                            if (component != null) {
                                ReactorPlannerFrame.this.paletteComponentId = component.id;
                                if (ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId] == null) {
                                    ((ReactorPlannerFrame)ReactorPlannerFrame.this).paletteComponents[((ReactorPlannerFrame)ReactorPlannerFrame.this).paletteComponentId] = ComponentFactory.createComponent(ReactorPlannerFrame.this.paletteComponentId);
                                }
                                ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].setInitialHeat(component.getInitialHeat());
                                ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].setAutomationThreshold(component.getAutomationThreshold());
                                ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].setReactorPause(component.getReactorPause());
                                Enumeration<AbstractButton> buttons = ReactorPlannerFrame.this.componentsGroup.getElements();
                                while (buttons.hasMoreElements()) {
                                    AbstractButton button = buttons.nextElement();
                                    if (!component.baseName.equals(button.getActionCommand())) continue;
                                    button.doClick();
                                }
                            }
                            return;
                        }
                        ReactorItem componentToPlace = null;
                        ButtonModel selection = ReactorPlannerFrame.this.componentsGroup.getSelection();
                        if (selection != null && (componentToPlace = ComponentFactory.createComponent(selection.getActionCommand())) != null) {
                            componentToPlace.setInitialHeat(((Number)ReactorPlannerFrame.this.componentHeatSpinner.getValue()).intValue());
                            componentToPlace.setAutomationThreshold(((Number)ReactorPlannerFrame.this.placingThresholdSpinner.getValue()).intValue());
                            componentToPlace.setReactorPause(((Number)ReactorPlannerFrame.this.placingReactorPauseSpinner.getValue()).intValue());
                        }
                        ReactorPlannerFrame.this.reactor.setComponentAt(finalRow, finalCol, componentToPlace);
                        ReactorPlannerFrame.this.materialsArea.setText(ReactorPlannerFrame.this.reactor.getMaterials().toString());
                        ReactorPlannerFrame.this.componentListArea.setText(ReactorPlannerFrame.this.reactor.getComponentList().toString());
                        ReactorPlannerFrame.this.maxHeatLabel.setText(BundleHelper.formatI18n("UI.MaxHeatSpecific", ReactorPlannerFrame.this.reactor.getMaxHeat()));
                        ReactorPlannerFrame.this.heatSpinnerModel.setMaximum(Double.valueOf(ReactorPlannerFrame.this.reactor.getMaxHeat() - 1.0));
                        ReactorPlannerFrame.this.heatSpinnerModel.setValue(Math.min((double)((Number)ReactorPlannerFrame.this.heatSpinnerModel.getValue()).intValue(), ReactorPlannerFrame.this.reactor.getMaxHeat() - 1.0));
                        ReactorPlannerFrame.this.temperatureEffectsLabel.setText(BundleHelper.formatI18n("UI.TemperatureEffectsSpecific", (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.4), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.5), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.7), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.85), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 1.0)));
                        int buttonSize = Math.min(ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].getWidth(), ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].getHeight());
                        if (buttonSize > 2 && componentToPlace != null && componentToPlace.image != null) {
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setIcon(new ImageIcon(componentToPlace.image.getScaledInstance(buttonSize * 8 / 10, buttonSize * 8 / 10, 2)));
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setToolTipText(componentToPlace.toString());
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setBackground(Color.LIGHT_GRAY);
                        } else {
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setIcon(null);
                            if (componentToPlace != null) {
                                ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setToolTipText(componentToPlace.toString());
                            } else {
                                ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setToolTipText(null);
                            }
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setBackground(Color.LIGHT_GRAY);
                        }
                        ReactorPlannerFrame.this.lockCode = true;
                        ReactorPlannerFrame.this.updateCodeField();
                        ReactorPlannerFrame.this.lockCode = false;
                    }
                });
                this.reactorButtons[row][col].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ReactorItem component;
                        if (e.getButton() == 3) {
                            ReactorPlannerFrame.this.reactor.setComponentAt(finalRow, finalCol, null);
                            ReactorPlannerFrame.this.materialsArea.setText(ReactorPlannerFrame.this.reactor.getMaterials().toString());
                            ReactorPlannerFrame.this.componentListArea.setText(ReactorPlannerFrame.this.reactor.getComponentList().toString());
                            ReactorPlannerFrame.this.maxHeatLabel.setText(BundleHelper.formatI18n("UI.MaxHeatSpecific", ReactorPlannerFrame.this.reactor.getMaxHeat()));
                            ReactorPlannerFrame.this.heatSpinnerModel.setMaximum(Double.valueOf(ReactorPlannerFrame.this.reactor.getMaxHeat() - 1.0));
                            ReactorPlannerFrame.this.heatSpinnerModel.setValue(Math.min((double)((Number)ReactorPlannerFrame.this.heatSpinnerModel.getValue()).intValue(), ReactorPlannerFrame.this.reactor.getMaxHeat() - 1.0));
                            ReactorPlannerFrame.this.temperatureEffectsLabel.setText(BundleHelper.formatI18n("UI.TemperatureEffectsSpecific", (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.4), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.5), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.7), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 0.85), (int)(ReactorPlannerFrame.this.reactor.getMaxHeat() * 1.0)));
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setIcon(null);
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setToolTipText(null);
                            ReactorPlannerFrame.this.reactorButtons[finalRow][finalCol].setBackground(Color.LIGHT_GRAY);
                            ReactorPlannerFrame.this.lockCode = true;
                            ReactorPlannerFrame.this.updateCodeField();
                            ReactorPlannerFrame.this.lockCode = false;
                        } else if (e.getButton() == 2 && (component = ReactorPlannerFrame.this.reactor.getComponentAt(finalRow, finalCol)) != null) {
                            ReactorPlannerFrame.this.paletteComponentId = component.id;
                            if (ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId] == null) {
                                ((ReactorPlannerFrame)ReactorPlannerFrame.this).paletteComponents[((ReactorPlannerFrame)ReactorPlannerFrame.this).paletteComponentId] = ComponentFactory.createComponent(ReactorPlannerFrame.this.paletteComponentId);
                            }
                            ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].setInitialHeat(component.getInitialHeat());
                            ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].setAutomationThreshold(component.getAutomationThreshold());
                            ReactorPlannerFrame.this.paletteComponents[ReactorPlannerFrame.this.paletteComponentId].setReactorPause(component.getReactorPause());
                            Enumeration<AbstractButton> buttons = ReactorPlannerFrame.this.componentsGroup.getElements();
                            while (buttons.hasMoreElements()) {
                                AbstractButton button = buttons.nextElement();
                                if (!component.baseName.equals(button.getActionCommand())) continue;
                                button.doClick();
                            }
                        }
                    }
                });
                this.reactorButtons[row][col].setContentAreaFilled(false);
                this.reactorButtons[row][col].setOpaque(true);
                this.reactorButtons[row][col].setBackground(Color.LIGHT_GRAY);
                this.reactorButtonPanels[row][col].add((Component)this.reactorButtons[row][col], constraints);
                this.reactorPanel.add(this.reactorButtonPanels[row][col]);
            }
        }
        this.codeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!ReactorPlannerFrame.this.lockCode) {
                    ReactorPlannerFrame.this.lockCode = true;
                    ReactorPlannerFrame.this.reactor.setCode(ReactorPlannerFrame.this.codeField.getText());
                    ReactorPlannerFrame.this.updateReactorButtons();
                    if (ReactorPlannerFrame.this.reactor.isFluid()) {
                        ReactorPlannerFrame.this.fluidReactorRadio.setSelected(true);
                    } else {
                        ReactorPlannerFrame.this.euReactorRadio.setSelected(true);
                    }
                    ReactorPlannerFrame.this.automatedReactorCheck.setSelected(ReactorPlannerFrame.this.reactor.isAutomated());
                    ReactorPlannerFrame.this.pulsedReactorCheck.setSelected(ReactorPlannerFrame.this.reactor.isPulsed());
                    ReactorPlannerFrame.this.togglePulseConfigTab();
                    ReactorPlannerFrame.this.reactorCoolantInjectorCheckbox.setSelected(ReactorPlannerFrame.this.reactor.isUsingReactorCoolantInjectors());
                    ReactorPlannerFrame.this.heatSpinner.setValue(ReactorPlannerFrame.this.reactor.getCurrentHeat());
                    ReactorPlannerFrame.this.onPulseSpinner.setValue(ReactorPlannerFrame.this.reactor.getOnPulse());
                    ReactorPlannerFrame.this.offPulseSpinner.setValue(ReactorPlannerFrame.this.reactor.getOffPulse());
                    ReactorPlannerFrame.this.suspendTempSpinner.setValue(ReactorPlannerFrame.this.reactor.getSuspendTemp());
                    ReactorPlannerFrame.this.resumeTempSpinner.setValue(ReactorPlannerFrame.this.reactor.getResumeTemp());
                    ReactorPlannerFrame.this.maxSimulationTicksSpinner.setValue(ReactorPlannerFrame.this.reactor.getMaxSimulationTicks());
                    ReactorPlannerFrame.this.lockCode = false;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(null);
            }
        });
        this.loadAdvancedConfig();
    }

    private void loadAdvancedConfig() {
        try (FileInputStream configStream = new FileInputStream("erpprefs.xml");){
            String csvFileName;
            File texturePackFile;
            ADVANCED_CONFIG.loadFromXML(configStream);
            this.showComponentDetailButtonsCheck.setSelected(Boolean.valueOf(ADVANCED_CONFIG.getProperty("showComponentDetailButtons", "true")));
            this.showOldStyleReactorCodeCheck.setSelected(Boolean.valueOf(ADVANCED_CONFIG.getProperty("showOldStyleReactorCode", "false")));
            this.showComponentPreconfigCheck.setSelected(Boolean.valueOf(ADVANCED_CONFIG.getProperty("showComponentPreconfigControls", "true")));
            String mcVersion = ADVANCED_CONFIG.getProperty("mcVersion", "1.12.2");
            String gtVersion = ADVANCED_CONFIG.getProperty("gtVersion", "none");
            this.mcVersionCombo.setSelectedItem(mcVersion);
            if (!"none".equals(gtVersion)) {
                this.gtVersionCombo.setSelectedItem(gtVersion);
            }
            this.expandAdvancedAlloyCheck.setSelected(Boolean.valueOf(ADVANCED_CONFIG.getProperty("expandAdvancedAlloy", "false")));
            String texturePackName = ADVANCED_CONFIG.getProperty("texturePack");
            if (texturePackName != null && (texturePackFile = new File(texturePackName)).isFile()) {
                this.textureChooser.setSelectedFile(texturePackFile);
                this.texturePackLabel.setText(BundleHelper.formatI18n("UI.TexturePackSpecific", texturePackName));
            }
            if ((csvFileName = ADVANCED_CONFIG.getProperty("csvFile")) != null) {
                this.csvChooser.setSelectedFile(new File(csvFileName));
                this.csvFileLabel.setText(csvFileName);
            }
            this.showComponentDetailButtonsCheckActionPerformed(null);
            this.showComponentPreconfigCheckActionPerformed(null);
            this.expandAdvancedAlloyCheckActionPerformed(null);
            this.gtVersionComboActionPerformed(null);
            this.mcVersionComboActionPerformed(null);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
    }

    private void saveAdvancedConfig() {
        try (FileOutputStream configStream = new FileOutputStream("erpprefs.xml");){
            ADVANCED_CONFIG.setProperty("showComponentDetailButtons", Boolean.toString(this.showComponentDetailButtonsCheck.isSelected()));
            ADVANCED_CONFIG.setProperty("showOldStyleReactorCode", Boolean.toString(this.showOldStyleReactorCodeCheck.isSelected()));
            ADVANCED_CONFIG.setProperty("showComponentPreconfigControls", Boolean.toString(this.showComponentPreconfigCheck.isSelected()));
            ADVANCED_CONFIG.setProperty("mcVersion", this.mcVersionCombo.getSelectedItem().toString());
            if (BundleHelper.getI18n("UI.GregTechVersionNone").equals(this.gtVersionCombo.getSelectedItem().toString())) {
                ADVANCED_CONFIG.setProperty("gtVersion", "none");
            } else {
                ADVANCED_CONFIG.setProperty("gtVersion", this.gtVersionCombo.getSelectedItem().toString());
            }
            ADVANCED_CONFIG.setProperty("expandAdvancedAlloy", Boolean.toString(this.expandAdvancedAlloyCheck.isSelected()));
            if (this.csvChooser.getSelectedFile() != null) {
                ADVANCED_CONFIG.setProperty("csvFile", this.csvChooser.getSelectedFile().getAbsolutePath());
            }
            ADVANCED_CONFIG.storeToXML(configStream, null);
        }
        catch (IOException | ClassCastException | NullPointerException exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.componentsGroup = new ButtonGroup();
        this.reactorStyleGroup = new ButtonGroup();
        this.pulsePanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.onPulseSpinner = new JSpinner();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.offPulseSpinner = new JSpinner();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.suspendTempSpinner = new JSpinner();
        JLabel jLabel10 = new JLabel();
        this.resumeTempSpinner = new JSpinner();
        JLabel jLabel16 = new JLabel();
        this.resetPulseConfigButton = new JButton();
        JSplitPane jSplitPane1 = new JSplitPane();
        JPanel jPanel2 = new JPanel();
        JSplitPane jSplitPane2 = new JSplitPane();
        this.reactorPanel = new JPanel();
        JSplitPane jSplitPane3 = new JSplitPane();
        this.temperatureAndComponentsPanel = new JPanel();
        this.temperatureEffectsLabel = new JLabel();
        this.componentsPanel = new JPanel();
        this.emptyButton = new JToggleButton();
        this.fuelRodUraniumButton = new JToggleButton();
        this.dualFuelRodUraniumButton = new JToggleButton();
        this.quadFuelRodUraniumButton = new JToggleButton();
        this.fuelRodMoxButton = new JToggleButton();
        this.dualFuelRodMoxButton = new JToggleButton();
        this.quadFuelRodMoxButton = new JToggleButton();
        this.neutronReflectorButton = new JToggleButton();
        this.thickNeutronReflectorButton = new JToggleButton();
        this.iridiumNeutronReflectorButton = new JToggleButton();
        this.heatVentButton = new JToggleButton();
        this.advancedHeatVentButton = new JToggleButton();
        this.reactorHeatVentButton = new JToggleButton();
        this.componentHeatVentButton = new JToggleButton();
        this.overclockedHeatVentButton = new JToggleButton();
        this.coolantCell10kButton = new JToggleButton();
        this.coolantCell30kButton = new JToggleButton();
        this.coolantCell60kButton = new JToggleButton();
        this.heatExchangerButton = new JToggleButton();
        this.advancedHeatExchangerButton = new JToggleButton();
        this.coreHeatExchangerButton = new JToggleButton();
        this.componentHeatExchangerButton = new JToggleButton();
        this.reactorPlatingButton = new JToggleButton();
        this.heatCapacityReactorPlatingButton = new JToggleButton();
        this.containmentReactorPlatingButton = new JToggleButton();
        this.rshCondensatorButton = new JToggleButton();
        this.lzhCondensatorButton = new JToggleButton();
        this.fuelRodThoriumButton = new JToggleButton();
        this.dualFuelRodThoriumButton = new JToggleButton();
        this.quadFuelRodThoriumButton = new JToggleButton();
        this.coolantCellHelium60kButton = new JToggleButton();
        this.coolantCellHelium180kButton = new JToggleButton();
        this.coolantCellHelium360kButton = new JToggleButton();
        this.coolantCellNak60kButton = new JToggleButton();
        this.coolantCellNak180kButton = new JToggleButton();
        this.coolantCellNak360kButton = new JToggleButton();
        this.fuelRodNaquadahButton = new JToggleButton();
        this.dualFuelRodNaquadahButton = new JToggleButton();
        this.quadFuelRodNaquadahButton = new JToggleButton();
        this.fuelRodCoaxiumButton = new JToggleButton();
        this.dualFuelRodCoaxiumButton = new JToggleButton();
        this.quadFuelRodCoaxiumButton = new JToggleButton();
        this.fuelRodCesiumButton = new JToggleButton();
        this.dualFuelRodCesiumButton = new JToggleButton();
        this.quadFuelRodCesiumButton = new JToggleButton();
        this.fuelRodNaquadahGTNHButton = new JToggleButton();
        this.dualFuelRodNaquadahGTNHButton = new JToggleButton();
        this.quadFuelRodNaquadahGTNHButton = new JToggleButton();
        this.fuelRodNaquadriaButton = new JToggleButton();
        this.dualFuelRodNaquadriaButton = new JToggleButton();
        this.quadFuelRodNaquadriaButton = new JToggleButton();
        this.fuelRodTiberiumButton = new JToggleButton();
        this.dualFuelRodTiberiumButton = new JToggleButton();
        this.quadFuelRodTiberiumButton = new JToggleButton();
        this.fuelRodTheCoreButton = new JToggleButton();
        this.coolantCellSpace180kButton = new JToggleButton();
        this.coolantCellSpace360kButton = new JToggleButton();
        this.coolantCellSpace540kButton = new JToggleButton();
        this.coolantCellSpace1080kButton = new JToggleButton();
        this.coolantCellNeutronium1GButton = new JToggleButton();
        this.fuelRodCompressedUraniumButton = new JToggleButton();
        this.dualFuelRodCompressedUraniumButton = new JToggleButton();
        this.quadFuelRodCompressedUraniumButton = new JToggleButton();
        this.fuelRodCompressedPlutoniumButton = new JToggleButton();
        this.dualFuelRodCompressedPlutoniumButton = new JToggleButton();
        this.quadFuelRodCompressedPlutoniumButton = new JToggleButton();
        this.fuelRodLiquidUraniumButton = new JToggleButton();
        this.dualFuelRodLiquidUraniumButton = new JToggleButton();
        this.quadFuelRodLiquidUraniumButton = new JToggleButton();
        this.fuelRodLiquidPlutoniumButton = new JToggleButton();
        this.dualFuelRodLiquidPlutoniumButton = new JToggleButton();
        this.quadFuelRodLiquidPlutoniumButton = new JToggleButton();
        this.fuelRodGlowstone = new JToggleButton();
        JPanel jPanel8 = new JPanel();
        this.placingLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.componentHeatLabel = new JLabel();
        this.componentHeatSpinner = new JSpinner();
        this.placingThresholdLabel = new JLabel();
        this.placingThresholdSpinner = new JSpinner();
        this.placingReactorPauseLabel = new JLabel();
        this.placingReactorPauseSpinner = new JSpinner();
        this.jPanel1 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.euReactorRadio = new JRadioButton();
        this.fluidReactorRadio = new JRadioButton();
        JPanel jPanel4 = new JPanel();
        this.clearGridButton = new JButton();
        this.simulateButton = new JButton();
        this.cancelButton = new JButton();
        JPanel jPanel5 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.heatSpinner = new JSpinner();
        this.maxHeatLabel = new JLabel();
        JPanel jPanel6 = new JPanel();
        this.pulsedReactorCheck = new JCheckBox();
        this.automatedReactorCheck = new JCheckBox();
        JPanel jPanel7 = new JPanel();
        this.maxSimulationTicksLabel = new JLabel();
        this.maxSimulationTicksSpinner = new JSpinner();
        this.jLabel6 = new JLabel();
        this.reactorCoolantInjectorCheckbox = new JCheckBox();
        JLabel jLabel2 = new JLabel();
        this.codeField = new JTextField();
        this.copyCodeButton = new JButton();
        this.pasteCodeButton = new JButton();
        this.outputTabs = new JTabbedPane();
        this.outputPane = new JScrollPane();
        this.outputArea = new JTextArea();
        this.componentPane = new JScrollPane();
        this.componentArea = new JTextArea();
        this.automationPanel = new JPanel();
        this.selectedComponentLabel = new JLabel();
        JLabel jLabel12 = new JLabel();
        this.thresholdSpinner = new JSpinner();
        JLabel jLabel13 = new JLabel();
        JLabel jLabel14 = new JLabel();
        this.pauseSpinner = new JSpinner();
        JLabel jLabel15 = new JLabel();
        this.componentListPane = new JScrollPane();
        this.componentListArea = new JTextArea();
        this.materialsListPane = new JScrollPane();
        this.materialsArea = new JTextArea();
        this.csvPanel = new JPanel();
        this.csvOutputCheck = new JCheckBox();
        JLabel jLabel19 = new JLabel();
        this.csvLimitSpinner = new JSpinner();
        this.csvFileLabel = new JLabel();
        this.csvBrowseButton = new JButton();
        JLabel csvHelpLabel = new JLabel();
        this.advancedScroll = new JScrollPane();
        this.advancedPanel = new JPanel();
        JPanel jPanel10 = new JPanel();
        JLabel jLabel20 = new JLabel();
        this.mcVersionCombo = new JComboBox();
        this.jLabel21 = new JLabel();
        this.gtVersionCombo = new JComboBox();
        this.showComponentDetailButtonsCheck = new JCheckBox();
        this.showOldStyleReactorCodeCheck = new JCheckBox();
        this.showComponentPreconfigCheck = new JCheckBox();
        this.texturePackLabel = new JLabel();
        this.texturePackBrowseButton = new JButton();
        this.texturePackClearButton = new JButton();
        this.jLabel5 = new JLabel();
        this.expandAdvancedAlloyCheck = new JCheckBox();
        this.comparisonScroll = new JScrollPane();
        JPanel comparisonPanel = new JPanel();
        JLabel jLabel17 = new JLabel();
        this.comparisonCodeField = new JTextField();
        this.comparisonCopyCodeButton = new JButton();
        JPanel jPanel9 = new JPanel();
        this.lockPrevCodeCheck = new JCheckBox();
        this.onlyShowDiffCheck = new JCheckBox();
        this.copyComparisonButton = new JButton();
        JLabel jLabel18 = new JLabel();
        this.comparisonLabel = new JLabel();
        this.pulsePanel.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("Ic2ExpReactorPlanner/Bundle");
        jLabel3.setText(bundle.getString("Config.OnPulse"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)jLabel3, gridBagConstraints);
        this.onPulseSpinner.setModel(new SpinnerNumberModel(5000000, 0, 5000000, 1));
        this.onPulseSpinner.setMinimumSize(new Dimension(80, 20));
        this.onPulseSpinner.setPreferredSize(new Dimension(80, 20));
        this.onPulseSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.onPulseSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)this.onPulseSpinner, gridBagConstraints);
        jLabel4.setText(bundle.getString("Config.Seconds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)jLabel4, gridBagConstraints);
        jLabel7.setText(bundle.getString("Config.OffPulse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 12, 2, 2);
        this.pulsePanel.add((Component)jLabel7, gridBagConstraints);
        this.offPulseSpinner.setModel(new SpinnerNumberModel(0, 0, 5000000, 1));
        this.offPulseSpinner.setMinimumSize(new Dimension(80, 20));
        this.offPulseSpinner.setPreferredSize(new Dimension(80, 20));
        this.offPulseSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.offPulseSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)this.offPulseSpinner, gridBagConstraints);
        jLabel8.setText(bundle.getString("Config.Seconds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)jLabel8, gridBagConstraints);
        jLabel11.setText(bundle.getString("Config.PulseHelp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)jLabel11, gridBagConstraints);
        jLabel9.setText(bundle.getString("Config.SuspendTemp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)jLabel9, gridBagConstraints);
        this.suspendTempSpinner.setModel(new SpinnerNumberModel(120000, 0, 120000, 1));
        this.suspendTempSpinner.setMinimumSize(new Dimension(80, 20));
        this.suspendTempSpinner.setPreferredSize(new Dimension(80, 20));
        this.suspendTempSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.suspendTempSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)this.suspendTempSpinner, gridBagConstraints);
        jLabel10.setText(bundle.getString("Config.ResumeTemp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 12, 2, 2);
        this.pulsePanel.add((Component)jLabel10, gridBagConstraints);
        this.resumeTempSpinner.setModel(new SpinnerNumberModel(120000, 0, 120000, 1));
        this.resumeTempSpinner.setMinimumSize(new Dimension(80, 20));
        this.resumeTempSpinner.setPreferredSize(new Dimension(80, 20));
        this.resumeTempSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.resumeTempSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)this.resumeTempSpinner, gridBagConstraints);
        jLabel16.setText(bundle.getString("Config.SuspendTempHelp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)jLabel16, gridBagConstraints);
        this.resetPulseConfigButton.setText(bundle.getString("UI.ResetPulseConfig"));
        this.resetPulseConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.resetPulseConfigButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pulsePanel.add((Component)this.resetPulseConfigButton, gridBagConstraints);
        this.setDefaultCloseOperation(3);
        this.setTitle(bundle.getString("UI.MainTitle"));
        this.setMinimumSize(new Dimension(915, 700));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ReactorPlannerFrame.this.plannerResized(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        jSplitPane1.setOrientation(0);
        jSplitPane1.setResizeWeight(1.0);
        jPanel2.setLayout(new GridBagLayout());
        jSplitPane2.setResizeWeight(1.0);
        this.reactorPanel.setMinimumSize(new Dimension(450, 300));
        this.reactorPanel.setPreferredSize(new Dimension(450, 300));
        this.reactorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ReactorPlannerFrame.this.reactorPanelComponentResized(evt);
            }
        });
        this.reactorPanel.setLayout(new GridLayout(6, 9, 2, 2));
        jSplitPane2.setLeftComponent(this.reactorPanel);
        jSplitPane3.setOrientation(0);
        jSplitPane3.setResizeWeight(1.0);
        this.temperatureAndComponentsPanel.setMinimumSize(new Dimension(475, 240));
        this.temperatureAndComponentsPanel.setPreferredSize(new Dimension(475, 240));
        this.temperatureAndComponentsPanel.setLayout(new GridBagLayout());
        this.temperatureEffectsLabel.setText(bundle.getString("UI.TemperatureEffectsDefault"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.temperatureEffectsLabel, gridBagConstraints);
        this.componentsPanel.setMinimumSize(new Dimension(160, 80));
        this.componentsPanel.setPreferredSize(new Dimension(160, 80));
        this.componentsPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ReactorPlannerFrame.this.componentsPanelComponentResized(evt);
            }
        });
        this.componentsPanel.setLayout(new GridLayout(6, 9));
        this.componentsGroup.add(this.emptyButton);
        this.emptyButton.setActionCommand("empty");
        this.emptyButton.setMaximumSize(new Dimension(50, 50));
        this.emptyButton.setMinimumSize(new Dimension(50, 50));
        this.emptyButton.setPreferredSize(new Dimension(50, 50));
        this.componentsPanel.add(this.emptyButton);
        this.componentsGroup.add(this.fuelRodUraniumButton);
        this.fuelRodUraniumButton.setToolTipText(this.buildTooltipInfo("FuelRodUranium"));
        this.fuelRodUraniumButton.setActionCommand("fuelRodUranium");
        this.componentsPanel.add(this.fuelRodUraniumButton);
        this.componentsGroup.add(this.dualFuelRodUraniumButton);
        this.dualFuelRodUraniumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodUranium"));
        this.dualFuelRodUraniumButton.setActionCommand("dualFuelRodUranium");
        this.componentsPanel.add(this.dualFuelRodUraniumButton);
        this.componentsGroup.add(this.quadFuelRodUraniumButton);
        this.quadFuelRodUraniumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodUranium"));
        this.quadFuelRodUraniumButton.setActionCommand("quadFuelRodUranium");
        this.componentsPanel.add(this.quadFuelRodUraniumButton);
        this.componentsGroup.add(this.fuelRodMoxButton);
        this.fuelRodMoxButton.setToolTipText(this.buildTooltipInfo("FuelRodMox"));
        this.fuelRodMoxButton.setActionCommand("fuelRodMox");
        this.componentsPanel.add(this.fuelRodMoxButton);
        this.componentsGroup.add(this.dualFuelRodMoxButton);
        this.dualFuelRodMoxButton.setToolTipText(this.buildTooltipInfo("DualFuelRodMox"));
        this.dualFuelRodMoxButton.setActionCommand("dualFuelRodMox");
        this.componentsPanel.add(this.dualFuelRodMoxButton);
        this.componentsGroup.add(this.quadFuelRodMoxButton);
        this.quadFuelRodMoxButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodMox"));
        this.quadFuelRodMoxButton.setActionCommand("quadFuelRodMox");
        this.componentsPanel.add(this.quadFuelRodMoxButton);
        this.componentsGroup.add(this.neutronReflectorButton);
        this.neutronReflectorButton.setToolTipText(this.buildTooltipInfo("NeutronReflector"));
        this.neutronReflectorButton.setActionCommand("neutronReflector");
        this.componentsPanel.add(this.neutronReflectorButton);
        this.componentsGroup.add(this.thickNeutronReflectorButton);
        this.thickNeutronReflectorButton.setToolTipText(this.buildTooltipInfo("ThickNeutronReflector"));
        this.thickNeutronReflectorButton.setActionCommand("thickNeutronReflector");
        this.componentsPanel.add(this.thickNeutronReflectorButton);
        this.componentsGroup.add(this.iridiumNeutronReflectorButton);
        this.iridiumNeutronReflectorButton.setToolTipText(this.buildTooltipInfo("IridiumNeutronReflector"));
        this.iridiumNeutronReflectorButton.setActionCommand("iridiumNeutronReflector");
        this.componentsPanel.add(this.iridiumNeutronReflectorButton);
        this.componentsGroup.add(this.heatVentButton);
        this.heatVentButton.setToolTipText(this.buildTooltipInfo("HeatVent"));
        this.heatVentButton.setActionCommand("heatVent");
        this.componentsPanel.add(this.heatVentButton);
        this.componentsGroup.add(this.advancedHeatVentButton);
        this.advancedHeatVentButton.setToolTipText(this.buildTooltipInfo("AdvancedHeatVent"));
        this.advancedHeatVentButton.setActionCommand("advancedHeatVent");
        this.componentsPanel.add(this.advancedHeatVentButton);
        this.componentsGroup.add(this.reactorHeatVentButton);
        this.reactorHeatVentButton.setToolTipText(this.buildTooltipInfo("ReactorHeatVent"));
        this.reactorHeatVentButton.setActionCommand("reactorHeatVent");
        this.componentsPanel.add(this.reactorHeatVentButton);
        this.componentsGroup.add(this.componentHeatVentButton);
        this.componentHeatVentButton.setToolTipText(this.buildTooltipInfo("ComponentHeatVent"));
        this.componentHeatVentButton.setActionCommand("componentHeatVent");
        this.componentsPanel.add(this.componentHeatVentButton);
        this.componentsGroup.add(this.overclockedHeatVentButton);
        this.overclockedHeatVentButton.setToolTipText(this.buildTooltipInfo("OverclockedHeatVent"));
        this.overclockedHeatVentButton.setActionCommand("overclockedHeatVent");
        this.componentsPanel.add(this.overclockedHeatVentButton);
        this.componentsGroup.add(this.coolantCell10kButton);
        this.coolantCell10kButton.setToolTipText(this.buildTooltipInfo("CoolantCell10k"));
        this.coolantCell10kButton.setActionCommand("coolantCell10k");
        this.componentsPanel.add(this.coolantCell10kButton);
        this.componentsGroup.add(this.coolantCell30kButton);
        this.coolantCell30kButton.setToolTipText(this.buildTooltipInfo("CoolantCell30k"));
        this.coolantCell30kButton.setActionCommand("coolantCell30k");
        this.componentsPanel.add(this.coolantCell30kButton);
        this.componentsGroup.add(this.coolantCell60kButton);
        this.coolantCell60kButton.setToolTipText(this.buildTooltipInfo("CoolantCell60k"));
        this.coolantCell60kButton.setActionCommand("coolantCell60k");
        this.componentsPanel.add(this.coolantCell60kButton);
        this.componentsGroup.add(this.heatExchangerButton);
        this.heatExchangerButton.setToolTipText(this.buildTooltipInfo("HeatExchanger"));
        this.heatExchangerButton.setActionCommand("heatExchanger");
        this.componentsPanel.add(this.heatExchangerButton);
        this.componentsGroup.add(this.advancedHeatExchangerButton);
        this.advancedHeatExchangerButton.setToolTipText(this.buildTooltipInfo("AdvancedHeatExchanger"));
        this.advancedHeatExchangerButton.setActionCommand("advancedHeatExchanger");
        this.componentsPanel.add(this.advancedHeatExchangerButton);
        this.componentsGroup.add(this.coreHeatExchangerButton);
        this.coreHeatExchangerButton.setToolTipText(this.buildTooltipInfo("ReactorHeatExchanger"));
        this.coreHeatExchangerButton.setActionCommand("coreHeatExchanger");
        this.componentsPanel.add(this.coreHeatExchangerButton);
        this.componentsGroup.add(this.componentHeatExchangerButton);
        this.componentHeatExchangerButton.setToolTipText(this.buildTooltipInfo("ComponentHeatExchanger"));
        this.componentHeatExchangerButton.setActionCommand("componentHeatExchanger");
        this.componentsPanel.add(this.componentHeatExchangerButton);
        this.componentsGroup.add(this.reactorPlatingButton);
        this.reactorPlatingButton.setToolTipText(this.buildTooltipInfo("ReactorPlating"));
        this.reactorPlatingButton.setActionCommand("reactorPlating");
        this.componentsPanel.add(this.reactorPlatingButton);
        this.componentsGroup.add(this.heatCapacityReactorPlatingButton);
        this.heatCapacityReactorPlatingButton.setToolTipText(this.buildTooltipInfo("HeatCapacityReactorPlating"));
        this.heatCapacityReactorPlatingButton.setActionCommand("heatCapacityReactorPlating");
        this.componentsPanel.add(this.heatCapacityReactorPlatingButton);
        this.componentsGroup.add(this.containmentReactorPlatingButton);
        this.containmentReactorPlatingButton.setToolTipText(this.buildTooltipInfo("ContainmentReactorPlating"));
        this.containmentReactorPlatingButton.setActionCommand("containmentReactorPlating");
        this.componentsPanel.add(this.containmentReactorPlatingButton);
        this.componentsGroup.add(this.rshCondensatorButton);
        this.rshCondensatorButton.setToolTipText(this.buildTooltipInfo("RshCondensator"));
        this.rshCondensatorButton.setActionCommand("rshCondensator");
        this.componentsPanel.add(this.rshCondensatorButton);
        this.componentsGroup.add(this.lzhCondensatorButton);
        this.lzhCondensatorButton.setToolTipText(this.buildTooltipInfo("LzhCondensator"));
        this.lzhCondensatorButton.setActionCommand("lzhCondensator");
        this.componentsPanel.add(this.lzhCondensatorButton);
        this.componentsGroup.add(this.fuelRodThoriumButton);
        this.fuelRodThoriumButton.setToolTipText(this.buildTooltipInfo("FuelRodThorium"));
        this.fuelRodThoriumButton.setActionCommand("fuelRodThorium");
        this.fuelRodThoriumButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodThoriumButton);
        this.componentsGroup.add(this.dualFuelRodThoriumButton);
        this.dualFuelRodThoriumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodThorium"));
        this.dualFuelRodThoriumButton.setActionCommand("dualFuelRodThorium");
        this.dualFuelRodThoriumButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodThoriumButton);
        this.componentsGroup.add(this.quadFuelRodThoriumButton);
        this.quadFuelRodThoriumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodThorium"));
        this.quadFuelRodThoriumButton.setActionCommand("quadFuelRodThorium");
        this.quadFuelRodThoriumButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodThoriumButton);
        this.componentsGroup.add(this.coolantCellHelium60kButton);
        this.coolantCellHelium60kButton.setToolTipText(this.buildTooltipInfo("CoolantCell60kHelium"));
        this.coolantCellHelium60kButton.setActionCommand("coolantCellHelium60k");
        this.coolantCellHelium60kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellHelium60kButton);
        this.componentsGroup.add(this.coolantCellHelium180kButton);
        this.coolantCellHelium180kButton.setToolTipText(this.buildTooltipInfo("CoolantCell180kHelium"));
        this.coolantCellHelium180kButton.setActionCommand("coolantCellHelium180k");
        this.coolantCellHelium180kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellHelium180kButton);
        this.componentsGroup.add(this.coolantCellHelium360kButton);
        this.coolantCellHelium360kButton.setToolTipText(this.buildTooltipInfo("CoolantCell360kHelium"));
        this.coolantCellHelium360kButton.setActionCommand("coolantCellHelium360k");
        this.coolantCellHelium360kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellHelium360kButton);
        this.componentsGroup.add(this.coolantCellNak60kButton);
        this.coolantCellNak60kButton.setToolTipText(this.buildTooltipInfo("CoolantCell60kNak"));
        this.coolantCellNak60kButton.setActionCommand("coolantCellNak60k");
        this.coolantCellNak60kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellNak60kButton);
        this.componentsGroup.add(this.coolantCellNak180kButton);
        this.coolantCellNak180kButton.setToolTipText(this.buildTooltipInfo("CoolantCell180kNak"));
        this.coolantCellNak180kButton.setActionCommand("coolantCellNak180k");
        this.coolantCellNak180kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellNak180kButton);
        this.componentsGroup.add(this.coolantCellNak360kButton);
        this.coolantCellNak360kButton.setToolTipText(this.buildTooltipInfo("CoolantCell360kNak"));
        this.coolantCellNak360kButton.setActionCommand("coolantCellNak360k");
        this.coolantCellNak360kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellNak360kButton);
        this.componentsGroup.add(this.coolantCellNeutronium1GButton);
        this.coolantCellNeutronium1GButton.setToolTipText(this.buildTooltipInfo("CoolantCell1GNeutronium"));
        this.coolantCellNeutronium1GButton.setActionCommand("coolantCellNeutronium1G");
        this.coolantCellNeutronium1GButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellNeutronium1GButton);
        this.componentsGroup.add(this.fuelRodNaquadahButton);
        this.fuelRodNaquadahButton.setToolTipText(this.buildTooltipInfo("FuelRodNaquadah"));
        this.fuelRodNaquadahButton.setActionCommand("fuelRodNaquadah");
        this.fuelRodNaquadahButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodNaquadahButton);
        this.componentsGroup.add(this.dualFuelRodNaquadahButton);
        this.dualFuelRodNaquadahButton.setToolTipText(this.buildTooltipInfo("DualFuelRodNaquadah"));
        this.dualFuelRodNaquadahButton.setActionCommand("dualFuelRodNaquadah");
        this.dualFuelRodNaquadahButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodNaquadahButton);
        this.componentsGroup.add(this.quadFuelRodNaquadahButton);
        this.quadFuelRodNaquadahButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodNaquadah"));
        this.quadFuelRodNaquadahButton.setActionCommand("quadFuelRodNaquadah");
        this.quadFuelRodNaquadahButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodNaquadahButton);
        this.componentsGroup.add(this.fuelRodCoaxiumButton);
        this.fuelRodCoaxiumButton.setToolTipText(this.buildTooltipInfo("FuelRodCoaxium"));
        this.fuelRodCoaxiumButton.setActionCommand("fuelRodCoaxium");
        this.componentsPanel.add(this.fuelRodCoaxiumButton);
        this.componentsGroup.add(this.dualFuelRodCoaxiumButton);
        this.dualFuelRodCoaxiumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodCoaxium"));
        this.dualFuelRodCoaxiumButton.setActionCommand("dualFuelRodCoaxium");
        this.componentsPanel.add(this.dualFuelRodCoaxiumButton);
        this.componentsGroup.add(this.quadFuelRodCoaxiumButton);
        this.quadFuelRodCoaxiumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodCoaxium"));
        this.quadFuelRodCoaxiumButton.setActionCommand("quadFuelRodCoaxium");
        this.componentsPanel.add(this.quadFuelRodCoaxiumButton);
        this.componentsGroup.add(this.fuelRodCesiumButton);
        this.fuelRodCesiumButton.setToolTipText(this.buildTooltipInfo("FuelRodCesium"));
        this.fuelRodCesiumButton.setActionCommand("fuelRodCesium");
        this.componentsPanel.add(this.fuelRodCesiumButton);
        this.componentsGroup.add(this.dualFuelRodCesiumButton);
        this.dualFuelRodCesiumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodCesium"));
        this.dualFuelRodCesiumButton.setActionCommand("dualFuelRodCesium");
        this.componentsPanel.add(this.dualFuelRodCesiumButton);
        this.componentsGroup.add(this.quadFuelRodCesiumButton);
        this.quadFuelRodCesiumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodCesium"));
        this.quadFuelRodCesiumButton.setActionCommand("quadFuelRodCesium");
        this.componentsPanel.add(this.quadFuelRodCesiumButton);
        this.componentsGroup.add(this.fuelRodNaquadahGTNHButton);
        this.fuelRodNaquadahGTNHButton.setToolTipText(this.buildTooltipInfo("FuelRodNaquadahGTNH"));
        this.fuelRodNaquadahGTNHButton.setActionCommand("fuelRodNaquadahGTNH");
        this.fuelRodNaquadahGTNHButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodNaquadahGTNHButton);
        this.componentsGroup.add(this.dualFuelRodNaquadahGTNHButton);
        this.dualFuelRodNaquadahGTNHButton.setToolTipText(this.buildTooltipInfo("DualFuelRodNaquadahGTNH"));
        this.dualFuelRodNaquadahGTNHButton.setActionCommand("dualFuelRodNaquadahGTNH");
        this.dualFuelRodNaquadahGTNHButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodNaquadahGTNHButton);
        this.componentsGroup.add(this.quadFuelRodNaquadahGTNHButton);
        this.quadFuelRodNaquadahGTNHButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodNaquadahGTNH"));
        this.quadFuelRodNaquadahGTNHButton.setActionCommand("quadFuelRodNaquadahGTNH");
        this.quadFuelRodNaquadahGTNHButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodNaquadahGTNHButton);
        this.componentsGroup.add(this.fuelRodNaquadriaButton);
        this.fuelRodNaquadriaButton.setToolTipText(this.buildTooltipInfo("FuelRodNaquadria"));
        this.fuelRodNaquadriaButton.setActionCommand("fuelRodNaquadria");
        this.fuelRodNaquadriaButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodNaquadriaButton);
        this.componentsGroup.add(this.dualFuelRodNaquadriaButton);
        this.dualFuelRodNaquadriaButton.setToolTipText(this.buildTooltipInfo("DualFuelRodNaquadria"));
        this.dualFuelRodNaquadriaButton.setActionCommand("dualFuelRodNaquadria");
        this.dualFuelRodNaquadriaButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodNaquadriaButton);
        this.componentsGroup.add(this.quadFuelRodNaquadriaButton);
        this.quadFuelRodNaquadriaButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodNaquadria"));
        this.quadFuelRodNaquadriaButton.setActionCommand("quadFuelRodNaquadria");
        this.quadFuelRodNaquadriaButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodNaquadriaButton);
        this.componentsGroup.add(this.fuelRodTiberiumButton);
        this.fuelRodTiberiumButton.setToolTipText(this.buildTooltipInfo("FuelRodTiberium"));
        this.fuelRodTiberiumButton.setActionCommand("fuelRodTiberium");
        this.fuelRodTiberiumButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodTiberiumButton);
        this.componentsGroup.add(this.dualFuelRodTiberiumButton);
        this.dualFuelRodTiberiumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodTiberium"));
        this.dualFuelRodTiberiumButton.setActionCommand("dualFuelRodTiberium");
        this.dualFuelRodTiberiumButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodTiberiumButton);
        this.componentsGroup.add(this.quadFuelRodTiberiumButton);
        this.quadFuelRodTiberiumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodTiberium"));
        this.quadFuelRodTiberiumButton.setActionCommand("quadFuelRodTiberium");
        this.quadFuelRodTiberiumButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodTiberiumButton);
        this.componentsGroup.add(this.fuelRodTheCoreButton);
        this.fuelRodTheCoreButton.setToolTipText(this.buildTooltipInfo("FuelRodTheCore"));
        this.fuelRodTheCoreButton.setActionCommand("fuelRodTheCore");
        this.fuelRodTheCoreButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodTheCoreButton);
        this.componentsGroup.add(this.coolantCellSpace180kButton);
        this.coolantCellSpace180kButton.setToolTipText(this.buildTooltipInfo("CoolantCell180kSpace"));
        this.coolantCellSpace180kButton.setActionCommand("coolantCellSpace180k");
        this.coolantCellSpace180kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellSpace180kButton);
        this.componentsGroup.add(this.coolantCellSpace360kButton);
        this.coolantCellSpace360kButton.setToolTipText(this.buildTooltipInfo("CoolantCell360kSpace"));
        this.coolantCellSpace360kButton.setActionCommand("coolantCellSpace360k");
        this.coolantCellSpace360kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellSpace360kButton);
        this.componentsGroup.add(this.coolantCellSpace540kButton);
        this.coolantCellSpace540kButton.setToolTipText(this.buildTooltipInfo("CoolantCell540kSpace"));
        this.coolantCellSpace540kButton.setActionCommand("coolantCellSpace540k");
        this.coolantCellSpace540kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellSpace540kButton);
        this.componentsGroup.add(this.coolantCellSpace1080kButton);
        this.coolantCellSpace1080kButton.setToolTipText(this.buildTooltipInfo("CoolantCell1080kSpace"));
        this.coolantCellSpace1080kButton.setActionCommand("coolantCellSpace1080k");
        this.coolantCellSpace1080kButton.setEnabled(false);
        this.componentsPanel.add(this.coolantCellSpace1080kButton);
        this.componentsGroup.add(this.fuelRodCompressedUraniumButton);
        this.fuelRodCompressedUraniumButton.setToolTipText(this.buildTooltipInfo("FuelRodCompressedUranium"));
        this.fuelRodCompressedUraniumButton.setActionCommand("fuelRodCompressedUranium");
        this.fuelRodCompressedUraniumButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodCompressedUraniumButton);
        this.componentsGroup.add(this.dualFuelRodCompressedUraniumButton);
        this.dualFuelRodCompressedUraniumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodCompressedUranium"));
        this.dualFuelRodCompressedUraniumButton.setActionCommand("dualFuelRodCompressedUranium");
        this.dualFuelRodCompressedUraniumButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodCompressedUraniumButton);
        this.componentsGroup.add(this.quadFuelRodCompressedUraniumButton);
        this.quadFuelRodCompressedUraniumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodCompressedUranium"));
        this.quadFuelRodCompressedUraniumButton.setActionCommand("quadFuelRodCompressedUranium");
        this.quadFuelRodCompressedUraniumButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodCompressedUraniumButton);
        this.componentsGroup.add(this.fuelRodCompressedPlutoniumButton);
        this.fuelRodCompressedPlutoniumButton.setToolTipText(this.buildTooltipInfo("FuelRodCompressedPlutonium"));
        this.fuelRodCompressedPlutoniumButton.setActionCommand("fuelRodCompressedPlutonium");
        this.fuelRodCompressedPlutoniumButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodCompressedPlutoniumButton);
        this.componentsGroup.add(this.dualFuelRodCompressedPlutoniumButton);
        this.dualFuelRodCompressedPlutoniumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodCompressedPlutonium"));
        this.dualFuelRodCompressedPlutoniumButton.setActionCommand("dualFuelRodCompressedPlutonium");
        this.dualFuelRodCompressedPlutoniumButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodCompressedPlutoniumButton);
        this.componentsGroup.add(this.quadFuelRodCompressedPlutoniumButton);
        this.quadFuelRodCompressedPlutoniumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodCompressedPlutonium"));
        this.quadFuelRodCompressedPlutoniumButton.setActionCommand("quadFuelRodCompressedPlutonium");
        this.quadFuelRodCompressedPlutoniumButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodCompressedPlutoniumButton);
        this.componentsGroup.add(this.fuelRodLiquidUraniumButton);
        this.fuelRodLiquidUraniumButton.setToolTipText(this.buildTooltipInfo("FuelRodLiquidUranium"));
        this.fuelRodLiquidUraniumButton.setActionCommand("fuelRodLiquidUranium");
        this.fuelRodLiquidUraniumButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodLiquidUraniumButton);
        this.componentsGroup.add(this.dualFuelRodLiquidUraniumButton);
        this.dualFuelRodLiquidUraniumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodLiquidUranium"));
        this.dualFuelRodLiquidUraniumButton.setActionCommand("dualFuelRodLiquidUranium");
        this.dualFuelRodLiquidUraniumButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodLiquidUraniumButton);
        this.componentsGroup.add(this.quadFuelRodLiquidUraniumButton);
        this.quadFuelRodLiquidUraniumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodLiquidUranium"));
        this.quadFuelRodLiquidUraniumButton.setActionCommand("quadFuelRodLiquidUranium");
        this.quadFuelRodLiquidUraniumButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodLiquidUraniumButton);
        this.componentsGroup.add(this.fuelRodLiquidPlutoniumButton);
        this.fuelRodLiquidPlutoniumButton.setToolTipText(this.buildTooltipInfo("FuelRodLiquidPlutonium"));
        this.fuelRodLiquidPlutoniumButton.setActionCommand("fuelRodLiquidPlutonium");
        this.fuelRodLiquidPlutoniumButton.setEnabled(false);
        this.componentsPanel.add(this.fuelRodLiquidPlutoniumButton);
        this.componentsGroup.add(this.dualFuelRodLiquidPlutoniumButton);
        this.dualFuelRodLiquidPlutoniumButton.setToolTipText(this.buildTooltipInfo("DualFuelRodLiquidPlutonium"));
        this.dualFuelRodLiquidPlutoniumButton.setActionCommand("dualFuelRodLiquidPlutonium");
        this.dualFuelRodLiquidPlutoniumButton.setEnabled(false);
        this.componentsPanel.add(this.dualFuelRodLiquidPlutoniumButton);
        this.componentsGroup.add(this.quadFuelRodLiquidPlutoniumButton);
        this.quadFuelRodLiquidPlutoniumButton.setToolTipText(this.buildTooltipInfo("QuadFuelRodLiquidPlutonium"));
        this.quadFuelRodLiquidPlutoniumButton.setActionCommand("quadFuelRodLiquidPlutonium");
        this.quadFuelRodLiquidPlutoniumButton.setEnabled(false);
        this.componentsPanel.add(this.quadFuelRodLiquidPlutoniumButton);
        this.componentsGroup.add(this.fuelRodGlowstone);
        this.fuelRodGlowstone.setToolTipText(this.buildTooltipInfo("FuelRodGlowstone"));
        this.fuelRodGlowstone.setActionCommand("fuelRodGlowstone");
        this.fuelRodGlowstone.setEnabled(false);
        this.componentsPanel.add(this.fuelRodGlowstone);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.componentsPanel, gridBagConstraints);
        jPanel8.setLayout(new GridBagLayout());
        this.placingLabel.setText(bundle.getString("UI.ComponentPlacingDefault"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel8.add((Component)this.placingLabel, gridBagConstraints);
        this.versionLabel.setText(BundleHelper.formatI18n("UI.VersionNumber", VERSION));
        this.versionLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel8.add((Component)this.versionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.temperatureAndComponentsPanel.add((Component)jPanel8, gridBagConstraints);
        this.componentHeatLabel.setText(bundle.getString("Config.InitialComponentHeat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.componentHeatLabel, gridBagConstraints);
        this.componentHeatSpinner.setModel(new SpinnerNumberModel(0, 0, 1080000, 1));
        this.componentHeatSpinner.setMinimumSize(new Dimension(70, 20));
        this.componentHeatSpinner.setPreferredSize(new Dimension(70, 20));
        this.componentHeatSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.componentHeatSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.componentHeatSpinner, gridBagConstraints);
        this.placingThresholdLabel.setText(bundle.getString("Config.PlacingReplacementThreshold"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.placingThresholdLabel, gridBagConstraints);
        this.placingThresholdSpinner.setModel(new SpinnerNumberModel(9000, 0, 1080000, 1));
        this.placingThresholdSpinner.setMinimumSize(new Dimension(100, 20));
        this.placingThresholdSpinner.setPreferredSize(new Dimension(100, 20));
        this.placingThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.placingThresholdSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.placingThresholdSpinner, gridBagConstraints);
        this.placingReactorPauseLabel.setText(bundle.getString("Config.PlacingReactorPause"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.placingReactorPauseLabel, gridBagConstraints);
        this.placingReactorPauseSpinner.setModel(new SpinnerNumberModel(0, 0, 10000, 1));
        this.placingReactorPauseSpinner.setMinimumSize(new Dimension(100, 20));
        this.placingReactorPauseSpinner.setPreferredSize(new Dimension(100, 20));
        this.placingReactorPauseSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.placingReactorPauseSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.temperatureAndComponentsPanel.add((Component)this.placingReactorPauseSpinner, gridBagConstraints);
        jSplitPane3.setTopComponent(this.temperatureAndComponentsPanel);
        this.jPanel1.setMinimumSize(new Dimension(392, 170));
        this.jPanel1.setPreferredSize(new Dimension(392, 160));
        this.jPanel1.setLayout(new GridBagLayout());
        jPanel3.setOpaque(false);
        this.reactorStyleGroup.add(this.euReactorRadio);
        this.euReactorRadio.setSelected(true);
        this.euReactorRadio.setText(bundle.getString("Config.EUReactor"));
        this.euReactorRadio.setOpaque(false);
        this.euReactorRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.euReactorRadioActionPerformed(evt);
            }
        });
        jPanel3.add(this.euReactorRadio);
        this.reactorStyleGroup.add(this.fluidReactorRadio);
        this.fluidReactorRadio.setText(bundle.getString("Config.FluidReactor"));
        this.fluidReactorRadio.setOpaque(false);
        this.fluidReactorRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.fluidReactorRadioActionPerformed(evt);
            }
        });
        jPanel3.add(this.fluidReactorRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(-6, -6, -6, -6);
        this.jPanel1.add((Component)jPanel3, gridBagConstraints);
        jPanel4.setOpaque(false);
        this.clearGridButton.setText(bundle.getString("UI.ClearGridButton"));
        this.clearGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.clearGridButtonActionPerformed(evt);
            }
        });
        jPanel4.add(this.clearGridButton);
        this.simulateButton.setText(bundle.getString("UI.SimulateButton"));
        this.simulateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.simulateButtonActionPerformed(evt);
            }
        });
        jPanel4.add(this.simulateButton);
        this.cancelButton.setText(bundle.getString("UI.CancelButton"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        jPanel4.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(-2, -2, -2, -2);
        this.jPanel1.add((Component)jPanel4, gridBagConstraints);
        jPanel5.setOpaque(false);
        jLabel1.setText(bundle.getString("UI.InitialReactorHeat"));
        jPanel5.add(jLabel1);
        this.heatSpinner.setModel(new SpinnerNumberModel(0.0, 0.0, 9999.0, 1.0));
        this.heatSpinner.setToolTipText(bundle.getString("UI.InitialReactorHeatTooltip"));
        this.heatSpinner.setMinimumSize(new Dimension(70, 20));
        this.heatSpinner.setPreferredSize(new Dimension(70, 20));
        this.heatSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.heatSpinnerStateChanged(evt);
            }
        });
        jPanel5.add(this.heatSpinner);
        this.maxHeatLabel.setText(bundle.getString("UI.MaxHeatDefault"));
        jPanel5.add(this.maxHeatLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(-2, -2, -2, -2);
        this.jPanel1.add((Component)jPanel5, gridBagConstraints);
        jPanel6.setOpaque(false);
        this.pulsedReactorCheck.setText(bundle.getString("UI.PulsedReactor"));
        this.pulsedReactorCheck.setOpaque(false);
        this.pulsedReactorCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.pulsedReactorCheckActionPerformed(evt);
            }
        });
        jPanel6.add(this.pulsedReactorCheck);
        this.automatedReactorCheck.setText(bundle.getString("UI.AutomatedReactor"));
        this.automatedReactorCheck.setToolTipText(bundle.getString("UI.AutomatedReactorTooltip"));
        this.automatedReactorCheck.setOpaque(false);
        this.automatedReactorCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.automatedReactorCheckActionPerformed(evt);
            }
        });
        jPanel6.add(this.automatedReactorCheck);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(-4, -4, -4, -4);
        this.jPanel1.add((Component)jPanel6, gridBagConstraints);
        jPanel7.setOpaque(false);
        this.maxSimulationTicksLabel.setText(bundle.getString("UI.MaxSimulationTicks"));
        jPanel7.add(this.maxSimulationTicksLabel);
        this.maxSimulationTicksSpinner.setModel(new SpinnerNumberModel((Number)5000000, null, Integer.valueOf(5000000), (Number)1));
        this.maxSimulationTicksSpinner.setToolTipText(bundle.getString("UI.MaxSimulationTicksTooltip"));
        this.maxSimulationTicksSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.maxSimulationTicksSpinnerStateChanged(evt);
            }
        });
        jPanel7.add(this.maxSimulationTicksSpinner);
        this.jLabel6.setText(bundle.getString("Config.Seconds"));
        jPanel7.add(this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(-2, -2, -2, -2);
        this.jPanel1.add((Component)jPanel7, gridBagConstraints);
        this.reactorCoolantInjectorCheckbox.setText(bundle.getString("Config.ReactorCoolantInjectors"));
        this.reactorCoolantInjectorCheckbox.setOpaque(false);
        this.reactorCoolantInjectorCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.reactorCoolantInjectorCheckboxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.reactorCoolantInjectorCheckbox, gridBagConstraints);
        jSplitPane3.setBottomComponent(this.jPanel1);
        jSplitPane2.setRightComponent(jSplitPane3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jSplitPane2, gridBagConstraints);
        jLabel2.setText(bundle.getString("UI.CodeLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.codeField.setEditable(false);
        this.codeField.setMaximumSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.codeField, gridBagConstraints);
        this.copyCodeButton.setText(bundle.getString("UI.CopyCodeButton"));
        this.copyCodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.copyCodeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.copyCodeButton, gridBagConstraints);
        this.pasteCodeButton.setText(bundle.getString("UI.PasteCodeButton"));
        this.pasteCodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.pasteCodeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.pasteCodeButton, gridBagConstraints);
        jSplitPane1.setTopComponent(jPanel2);
        this.outputTabs.setTabLayoutPolicy(1);
        this.outputTabs.setPreferredSize(new Dimension(900, 220));
        this.outputArea.setEditable(false);
        this.outputArea.setColumns(20);
        this.outputArea.setRows(5);
        this.outputPane.setViewportView(this.outputArea);
        this.outputTabs.addTab(bundle.getString("UI.SimulationTab"), this.outputPane);
        this.componentArea.setColumns(20);
        this.componentArea.setRows(5);
        this.componentArea.setText(bundle.getString("UI.ComponentInfoDefault"));
        this.componentPane.setViewportView(this.componentArea);
        this.outputTabs.addTab(bundle.getString("UI.ComponentTab"), this.componentPane);
        this.automationPanel.setLayout(new GridBagLayout());
        this.selectedComponentLabel.setText(bundle.getString("Config.NoComponentSelected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.automationPanel.add((Component)this.selectedComponentLabel, gridBagConstraints);
        jLabel12.setText(bundle.getString("Config.ReplacementThreshold"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.automationPanel.add((Component)jLabel12, gridBagConstraints);
        this.thresholdSpinner.setModel(new SpinnerNumberModel(9000, 0, 1080000, 1));
        this.thresholdSpinner.setMinimumSize(new Dimension(100, 20));
        this.thresholdSpinner.setPreferredSize(new Dimension(100, 20));
        this.thresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.thresholdSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.automationPanel.add((Component)this.thresholdSpinner, gridBagConstraints);
        jLabel13.setText(bundle.getString("Config.ReplacementThresholdHelp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.automationPanel.add((Component)jLabel13, gridBagConstraints);
        jLabel14.setText(bundle.getString("Config.ReactorPause"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.automationPanel.add((Component)jLabel14, gridBagConstraints);
        this.pauseSpinner.setModel(new SpinnerNumberModel(0, 0, 10000, 1));
        this.pauseSpinner.setMinimumSize(new Dimension(100, 20));
        this.pauseSpinner.setPreferredSize(new Dimension(100, 20));
        this.pauseSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ReactorPlannerFrame.this.pauseSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.automationPanel.add((Component)this.pauseSpinner, gridBagConstraints);
        jLabel15.setText(bundle.getString("Config.ReactorPauseHelp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.automationPanel.add((Component)jLabel15, gridBagConstraints);
        this.outputTabs.addTab(bundle.getString("UI.ComponentAutomationTab"), this.automationPanel);
        this.componentListArea.setColumns(20);
        this.componentListArea.setRows(5);
        this.componentListPane.setViewportView(this.componentListArea);
        this.outputTabs.addTab(bundle.getString("UI.ComponentListTab"), this.componentListPane);
        this.materialsArea.setEditable(false);
        this.materialsArea.setColumns(20);
        this.materialsArea.setRows(5);
        this.materialsListPane.setViewportView(this.materialsArea);
        this.outputTabs.addTab(bundle.getString("UI.MaterialsTab"), this.materialsListPane);
        this.csvPanel.setLayout(new GridBagLayout());
        this.csvOutputCheck.setText(bundle.getString("Config.CSVCheckbox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.csvPanel.add((Component)this.csvOutputCheck, gridBagConstraints);
        jLabel19.setText(bundle.getString("Config.CSVLimit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.csvPanel.add((Component)jLabel19, gridBagConstraints);
        this.csvLimitSpinner.setModel(new SpinnerNumberModel(5000, 0, 5000000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.csvPanel.add((Component)this.csvLimitSpinner, gridBagConstraints);
        this.csvFileLabel.setText(bundle.getString("UI.CSVFileDefault"));
        this.csvFileLabel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.csvPanel.add((Component)this.csvFileLabel, gridBagConstraints);
        this.csvBrowseButton.setText(bundle.getString("UI.CSVBrowseButton"));
        this.csvBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.csvBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.csvPanel.add((Component)this.csvBrowseButton, gridBagConstraints);
        csvHelpLabel.setText(bundle.getString("UI.CSVHelp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.csvPanel.add((Component)csvHelpLabel, gridBagConstraints);
        this.outputTabs.addTab(bundle.getString("UI.CSVTab"), this.csvPanel);
        this.advancedPanel.setLayout(new GridBagLayout());
        jLabel20.setText(bundle.getString("UI.MinecraftVersion"));
        jPanel10.add(jLabel20);
        this.mcVersionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"1.12.2", "1.11.2", "1.10.2", "1.9.4", "1.8.9", "1.7.10"}));
        this.mcVersionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.mcVersionComboActionPerformed(evt);
            }
        });
        jPanel10.add(this.mcVersionCombo);
        this.jLabel21.setText(bundle.getString("UI.GregTechVersion"));
        jPanel10.add(this.jLabel21);
        this.gtVersionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{BundleHelper.getI18n("UI.GregTechVersionNone"), "5.08", "5.09", "GTNH"}));
        this.gtVersionCombo.setSelectedItem(BundleHelper.getI18n("UI.GregTechVersionNone"));
        this.gtVersionCombo.setToolTipText(bundle.getString("UI.GTReactorBehavior"));
        this.gtVersionCombo.setEnabled(false);
        this.gtVersionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.gtVersionComboActionPerformed(evt);
            }
        });
        jPanel10.add(this.gtVersionCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.advancedPanel.add((Component)jPanel10, gridBagConstraints);
        this.showComponentDetailButtonsCheck.setSelected(true);
        this.showComponentDetailButtonsCheck.setText(bundle.getString("UI.ShowComponentDetailButtons"));
        this.showComponentDetailButtonsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.showComponentDetailButtonsCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.advancedPanel.add((Component)this.showComponentDetailButtonsCheck, gridBagConstraints);
        this.showOldStyleReactorCodeCheck.setText(bundle.getString("UI.ShowOldStyleReactorCode"));
        this.showOldStyleReactorCodeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.showOldStyleReactorCodeCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.advancedPanel.add((Component)this.showOldStyleReactorCodeCheck, gridBagConstraints);
        this.showComponentPreconfigCheck.setSelected(true);
        this.showComponentPreconfigCheck.setText(bundle.getString("UI.ShowComponentPreconfigControls"));
        this.showComponentPreconfigCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.showComponentPreconfigCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.advancedPanel.add((Component)this.showComponentPreconfigCheck, gridBagConstraints);
        this.texturePackLabel.setText(bundle.getString("UI.TexturePackDefault"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 2, 2, 2);
        this.advancedPanel.add((Component)this.texturePackLabel, gridBagConstraints);
        this.texturePackBrowseButton.setText(bundle.getString("UI.TexturePackBrowseButton"));
        this.texturePackBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.texturePackBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.advancedPanel.add((Component)this.texturePackBrowseButton, gridBagConstraints);
        this.texturePackClearButton.setText(bundle.getString("UI.TexturePackClearButton"));
        this.texturePackClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.texturePackClearButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.advancedPanel.add((Component)this.texturePackClearButton, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("UI.TexturePackHelp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 2, 2, 2);
        this.advancedPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.expandAdvancedAlloyCheck.setText(bundle.getString("UI.ExpandAdvancedAlloy"));
        this.expandAdvancedAlloyCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.expandAdvancedAlloyCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.advancedPanel.add((Component)this.expandAdvancedAlloyCheck, gridBagConstraints);
        this.advancedScroll.setViewportView(this.advancedPanel);
        this.outputTabs.addTab(bundle.getString("UI.AdvancedTab"), this.advancedScroll);
        comparisonPanel.setLayout(new GridBagLayout());
        jLabel17.setText(bundle.getString("UI.CodeLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        comparisonPanel.add((Component)jLabel17, gridBagConstraints);
        this.comparisonCodeField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        comparisonPanel.add((Component)this.comparisonCodeField, gridBagConstraints);
        this.comparisonCopyCodeButton.setText(bundle.getString("UI.CopyCodeButton"));
        this.comparisonCopyCodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.comparisonCopyCodeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        comparisonPanel.add((Component)this.comparisonCopyCodeButton, gridBagConstraints);
        this.lockPrevCodeCheck.setText(bundle.getString("UI.LockInTabCode"));
        jPanel9.add(this.lockPrevCodeCheck);
        this.onlyShowDiffCheck.setText(bundle.getString("UI.OnlyShowDiffData"));
        this.onlyShowDiffCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.onlyShowDiffCheckActionPerformed(evt);
            }
        });
        jPanel9.add(this.onlyShowDiffCheck);
        this.copyComparisonButton.setText(bundle.getString("UI.CopyComparisonData"));
        this.copyComparisonButton.setEnabled(false);
        this.copyComparisonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReactorPlannerFrame.this.copyComparisonButtonActionPerformed(evt);
            }
        });
        jPanel9.add(this.copyComparisonButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        comparisonPanel.add((Component)jPanel9, gridBagConstraints);
        jLabel18.setText(bundle.getString("Comparison.Header"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        comparisonPanel.add((Component)jLabel18, gridBagConstraints);
        this.comparisonLabel.setFont(new Font("Arial", 0, 12));
        this.comparisonLabel.setText(bundle.getString("Comparison.Default"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        comparisonPanel.add((Component)this.comparisonLabel, gridBagConstraints);
        this.comparisonScroll.setViewportView(comparisonPanel);
        this.outputTabs.addTab(bundle.getString("UI.ComparisonTab"), this.comparisonScroll);
        jSplitPane1.setRightComponent(this.outputTabs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)jSplitPane1, gridBagConstraints);
        this.setSize(new Dimension(1109, 777));
        this.setLocationRelativeTo(null);
    }

    private void plannerResized(ComponentEvent evt) {
        Dimension dim = this.getSize();
        Dimension minDim = this.getMinimumSize();
        if (dim.width < minDim.width) {
            dim.width = minDim.width;
        }
        if (dim.height < minDim.height) {
            dim.height = minDim.height;
        }
        this.setSize(dim);
        Enumeration<AbstractButton> elements = this.componentsGroup.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = elements.nextElement();
            int buttonSize = Math.min(button.getWidth(), button.getHeight());
            if (buttonSize <= 2) continue;
            ReactorItem component = ComponentFactory.getDefaultComponent(button.getActionCommand());
            if (component != null && component.image != null) {
                button.setIcon(new ImageIcon(component.image.getScaledInstance(buttonSize * 8 / 10, buttonSize * 8 / 10, 2)));
                continue;
            }
            button.setIcon(null);
        }
        for (int row = 0; row < this.reactorButtons.length; ++row) {
            for (int col = 0; col < this.reactorButtons[row].length; ++col) {
                int buttonSize = Math.min(this.reactorButtons[row][col].getWidth(), this.reactorButtons[row][col].getHeight());
                if (buttonSize <= 2) continue;
                ReactorItem component = this.reactor.getComponentAt(row, col);
                if (component != null && component.image != null) {
                    this.reactorButtons[row][col].setIcon(new ImageIcon(component.image.getScaledInstance(buttonSize * 8 / 10, buttonSize * 8 / 10, 2)));
                    continue;
                }
                this.reactorButtons[row][col].setIcon(null);
            }
        }
    }

    private void clearGridButtonActionPerformed(ActionEvent evt) {
        this.reactor.clearGrid();
        for (int i = 0; i < this.reactorButtons.length; ++i) {
            for (int j = 0; j < this.reactorButtons[i].length; ++j) {
                this.reactorButtons[i][j].setIcon(null);
                this.reactorButtons[i][j].setToolTipText(null);
                this.reactorButtonPanels[i][j].setBackground(Color.LIGHT_GRAY);
            }
        }
        this.outputArea.setText(null);
        this.materialsArea.setText(this.reactor.getMaterials().toString());
        this.componentListArea.setText(this.reactor.getComponentList().toString());
        this.maxHeatLabel.setText(BundleHelper.formatI18n("UI.MaxHeatSpecific", this.reactor.getMaxHeat()));
        this.heatSpinnerModel.setMaximum(Double.valueOf(this.reactor.getMaxHeat() - 1.0));
        this.heatSpinnerModel.setValue(Math.min((double)((Number)this.heatSpinnerModel.getValue()).intValue(), this.reactor.getMaxHeat() - 1.0));
        this.temperatureEffectsLabel.setText(BundleHelper.formatI18n("UI.TemperatureEffectsSpecific", (int)(this.reactor.getMaxHeat() * 0.4), (int)(this.reactor.getMaxHeat() * 0.5), (int)(this.reactor.getMaxHeat() * 0.7), (int)(this.reactor.getMaxHeat() * 0.85), (int)(this.reactor.getMaxHeat() * 1.0)));
        this.lockCode = true;
        this.codeField.setText(null);
        this.lockCode = false;
    }

    private void simulateButtonActionPerformed(ActionEvent evt) {
        if (this.simulator != null) {
            if (this.simulator.getData() != null && !this.lockPrevCodeCheck.isSelected()) {
                this.prevSimulator = this.simulator;
                this.prevReactorCode = this.currentReactorCode;
                this.prevReactorOldCode = this.currentReactorOldCode;
            }
            this.simulator.cancel(true);
        }
        this.currentReactorCode = this.reactor.getCode();
        this.currentReactorOldCode = this.reactor.getOldCode();
        File csvFile = null;
        int csvLimit = -1;
        if (this.csvOutputCheck.isSelected()) {
            csvFile = this.csvChooser.getSelectedFile();
            Object value = this.csvLimitSpinner.getModel().getValue();
            if (value instanceof Number) {
                csvLimit = ((Number)value).intValue();
            }
        }
        this.outputArea = new JTextArea(5, 20);
        this.outputArea.setEditable(false);
        this.outputPane.setViewportView(this.outputArea);
        this.simulatedReactor = new Reactor();
        this.simulatedReactor.setCode(this.reactor.getCode());
        this.outputTabs.setSelectedComponent(this.outputPane);
        this.simulator = new AutomationSimulator(this.simulatedReactor, this.outputArea, this.reactorButtonPanels, csvFile, csvLimit);
        if (this.prevSimulator != null) {
            this.simulator.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("completed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                        ReactorPlannerFrame.this.updateComparison();
                    }
                }
            });
        }
        this.simulator.execute();
    }

    private void euReactorRadioActionPerformed(ActionEvent evt) {
        this.reactor.setFluid(false);
        this.updateCodeField();
    }

    private void updateCodeField() {
        this.lockCode = true;
        if (this.showOldStyleReactorCodeCheck.isSelected()) {
            this.codeField.setText(this.reactor.getOldCode());
        } else {
            this.codeField.setText(this.reactor.getCode());
        }
        this.lockCode = false;
    }

    private void fluidReactorRadioActionPerformed(ActionEvent evt) {
        this.reactor.setFluid(true);
        this.updateCodeField();
    }

    private void copyCodeButtonActionPerformed(ActionEvent evt) {
        StringSelection selection = new StringSelection(this.codeField.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    private void pasteCodeButtonActionPerformed(ActionEvent evt) {
        try {
            String code = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
            this.codeField.setText(code.replaceAll("[^0-9A-Za-z(),.?|:/+=]+", ""));
        }
        catch (UnsupportedFlavorException | IOException ex) {
            ExceptionDialogDisplay.showExceptionDialog(ex);
        }
    }

    private void thresholdSpinnerStateChanged(ChangeEvent evt) {
        if (this.selectedColumn >= 0 && this.selectedRow >= 0 && this.reactor.getComponentAt(this.selectedRow, this.selectedColumn) != null) {
            ReactorItem component = this.reactor.getComponentAt(this.selectedRow, this.selectedColumn);
            component.setAutomationThreshold(((Number)this.thresholdSpinner.getValue()).intValue());
            if (!this.lockCode) {
                this.updateCodeField();
            }
        }
    }

    private void pauseSpinnerStateChanged(ChangeEvent evt) {
        if (this.selectedColumn >= 0 && this.selectedRow >= 0 && this.reactor.getComponentAt(this.selectedRow, this.selectedColumn) != null) {
            ReactorItem component = this.reactor.getComponentAt(this.selectedRow, this.selectedColumn);
            component.setReactorPause(((Number)this.pauseSpinner.getValue()).intValue());
            if (!this.lockCode) {
                this.updateCodeField();
            }
        }
    }

    private void reactorCoolantInjectorCheckboxActionPerformed(ActionEvent evt) {
        this.reactor.setUsingReactorCoolantInjectors(this.reactorCoolantInjectorCheckbox.isSelected());
        this.updateCodeField();
    }

    private void heatSpinnerStateChanged(ChangeEvent evt) {
        this.reactor.setCurrentHeat(((Number)this.heatSpinner.getValue()).doubleValue());
        if (!this.lockCode) {
            this.updateCodeField();
        }
    }

    private void onPulseSpinnerStateChanged(ChangeEvent evt) {
        this.reactor.setOnPulse(((Number)this.onPulseSpinner.getValue()).intValue());
        if (!this.lockCode) {
            this.updateCodeField();
        }
    }

    private void offPulseSpinnerStateChanged(ChangeEvent evt) {
        this.reactor.setOffPulse(((Number)this.offPulseSpinner.getValue()).intValue());
        if (!this.lockCode) {
            this.updateCodeField();
        }
    }

    private void suspendTempSpinnerStateChanged(ChangeEvent evt) {
        this.reactor.setSuspendTemp(((Number)this.suspendTempSpinner.getValue()).intValue());
        if (!this.lockCode) {
            this.updateCodeField();
        }
    }

    private void resumeTempSpinnerStateChanged(ChangeEvent evt) {
        this.reactor.setResumeTemp(((Number)this.resumeTempSpinner.getValue()).intValue());
        if (!this.lockCode) {
            this.updateCodeField();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.simulator != null && !this.simulator.isDone() && !this.simulator.isCancelled()) {
            this.simulator.cancel(false);
        }
    }

    private void csvBrowseButtonActionPerformed(ActionEvent evt) {
        this.csvChooser.showSaveDialog(this);
        if (this.csvChooser.getSelectedFile() != null) {
            this.csvFileLabel.setText(this.csvChooser.getSelectedFile().getAbsolutePath());
        }
        this.saveAdvancedConfig();
    }

    private void pulsedReactorCheckActionPerformed(ActionEvent evt) {
        this.reactor.setPulsed(this.pulsedReactorCheck.isSelected());
        this.togglePulseConfigTab();
        this.updateCodeField();
    }

    private void togglePulseConfigTab() {
        if (this.pulsedReactorCheck.isSelected()) {
            if (this.outputTabs.indexOfComponent(this.pulsePanel) < 0) {
                this.outputTabs.insertTab(BundleHelper.getI18n("UI.PulseConfigurationTab"), null, this.pulsePanel, null, this.outputTabs.indexOfComponent(this.outputPane) + 1);
            }
        } else {
            this.outputTabs.remove(this.pulsePanel);
        }
    }

    private void automatedReactorCheckActionPerformed(ActionEvent evt) {
        this.reactor.setAutomated(this.automatedReactorCheck.isSelected());
        this.updateCodeField();
    }

    private void maxSimulationTicksSpinnerStateChanged(ChangeEvent evt) {
        this.reactor.setMaxSimulationTicks(((Number)this.maxSimulationTicksSpinner.getValue()).intValue());
        if (!this.lockCode) {
            this.updateCodeField();
        }
    }

    private void componentHeatSpinnerStateChanged(ChangeEvent evt) {
        if (this.paletteComponentId > 0 && this.paletteComponents[this.paletteComponentId] != null) {
            this.paletteComponents[this.paletteComponentId].setInitialHeat(((Number)this.componentHeatSpinner.getValue()).intValue());
        }
    }

    private void placingThresholdSpinnerStateChanged(ChangeEvent evt) {
        if (this.paletteComponentId > 0 && this.paletteComponents[this.paletteComponentId] != null) {
            this.paletteComponents[this.paletteComponentId].setAutomationThreshold(((Number)this.placingThresholdSpinner.getValue()).intValue());
        }
    }

    private void placingReactorPauseSpinnerStateChanged(ChangeEvent evt) {
        if (this.paletteComponentId > 0 && this.paletteComponents[this.paletteComponentId] != null) {
            this.paletteComponents[this.paletteComponentId].setReactorPause(((Number)this.placingReactorPauseSpinner.getValue()).intValue());
        }
    }

    private void showComponentDetailButtonsCheckActionPerformed(ActionEvent evt) {
        for (JButton componentDetailButton : this.componentDetailButtons) {
            componentDetailButton.setVisible(this.showComponentDetailButtonsCheck.isSelected());
        }
        this.saveAdvancedConfig();
    }

    private void showOldStyleReactorCodeCheckActionPerformed(ActionEvent evt) {
        this.updateCodeField();
        this.saveAdvancedConfig();
    }

    private void reactorPanelComponentResized(ComponentEvent evt) {
        this.plannerResized(null);
    }

    private void componentsPanelComponentResized(ComponentEvent evt) {
        this.plannerResized(null);
    }

    private void showComponentPreconfigCheckActionPerformed(ActionEvent evt) {
        boolean selected = this.showComponentPreconfigCheck.isSelected();
        this.componentHeatLabel.setVisible(selected);
        this.componentHeatSpinner.setVisible(selected);
        this.placingThresholdLabel.setVisible(selected);
        this.placingThresholdSpinner.setVisible(selected);
        this.placingReactorPauseLabel.setVisible(selected);
        this.placingReactorPauseSpinner.setVisible(selected);
        this.saveAdvancedConfig();
    }

    private void resetPulseConfigButtonActionPerformed(ActionEvent evt) {
        this.reactor.resetPulseConfig();
        this.updateCodeField();
    }

    private void texturePackBrowseButtonActionPerformed(ActionEvent evt) {
        this.textureChooser.showOpenDialog(this);
        if (this.textureChooser.getSelectedFile() != null) {
            ADVANCED_CONFIG.setProperty("texturePack", this.textureChooser.getSelectedFile().getAbsolutePath());
            this.texturePackLabel.setText(BundleHelper.formatI18n("UI.TexturePackSpecific", this.textureChooser.getSelectedFile().getAbsolutePath()));
            this.saveAdvancedConfig();
        }
    }

    private void texturePackClearButtonActionPerformed(ActionEvent evt) {
        ADVANCED_CONFIG.remove("texturePack");
        this.texturePackLabel.setText(BundleHelper.getI18n("UI.TexturePackDefault"));
        this.saveAdvancedConfig();
    }

    private void comparisonCopyCodeButtonActionPerformed(ActionEvent evt) {
        StringSelection selection = new StringSelection(this.comparisonCodeField.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    private void expandAdvancedAlloyCheckActionPerformed(ActionEvent evt) {
        MaterialsList.setExpandAdvancedAlloy(this.expandAdvancedAlloyCheck.isSelected());
        this.materialsArea.setText(this.reactor.getMaterials().toString());
        this.saveAdvancedConfig();
    }

    private void copyComparisonButtonActionPerformed(ActionEvent evt) {
        HtmlSelection selection = new HtmlSelection(this.comparisonLabel.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    private void onlyShowDiffCheckActionPerformed(ActionEvent evt) {
        this.updateComparison();
    }

    private void mcVersionComboActionPerformed(ActionEvent evt) {
        String mcVersion = this.mcVersionCombo.getSelectedItem().toString();
        Reflector.setMcVersion(mcVersion);
        if ("1.7.10".equals(mcVersion)) {
            this.gtVersionCombo.setEnabled(true);
            String gtVersion = this.gtVersionCombo.getSelectedItem().toString();
            this.iridiumNeutronReflectorButton.setEnabled("5.08".equals(gtVersion) || "5.09".equals(gtVersion) || "GTNH".equals(gtVersion));
            this.expandAdvancedAlloyCheck.setEnabled("5.08".equals(gtVersion) || "5.09".equals(gtVersion));
            this.reactorCoolantInjectorCheckbox.setSelected(false);
            this.reactorCoolantInjectorCheckbox.setEnabled(false);
            MaterialsList.setUseUfcForCoolantCells(false);
            MaterialsList.setExpandAdvancedAlloy(this.expandAdvancedAlloyCheck.isSelected() && !"5.08".equals(gtVersion) && !"5.09".equals(gtVersion) && !"GTNH".equals(gtVersion));
            MaterialsList.setGTVersion("5.08".equals(gtVersion) || "5.09".equals(gtVersion) || "GTNH".equals(gtVersion) ? gtVersion : "none");
            FuelRod.setGT509Behavior("5.09".equals(gtVersion));
        } else {
            this.gtVersionCombo.setSelectedItem(BundleHelper.getI18n("UI.GregTechVersionNone"));
            this.gtVersionCombo.setEnabled(false);
            this.iridiumNeutronReflectorButton.setEnabled(true);
            this.expandAdvancedAlloyCheck.setEnabled(true);
            this.reactorCoolantInjectorCheckbox.setEnabled(true);
            MaterialsList.setUseUfcForCoolantCells(true);
            MaterialsList.setExpandAdvancedAlloy(this.expandAdvancedAlloyCheck.isSelected());
            FuelRod.setGT509Behavior(false);
        }
        this.materialsArea.setText(this.reactor.getMaterials().toString());
        this.saveAdvancedConfig();
    }

    private void gtVersionComboActionPerformed(ActionEvent evt) {
        String mcVersion = this.mcVersionCombo.getSelectedItem().toString();
        String gtVersion = this.gtVersionCombo.getSelectedItem().toString();
        if ("5.08".equals(gtVersion)) {
            this.iridiumNeutronReflectorButton.setEnabled(true);
            this.fuelRodThoriumButton.setEnabled(true);
            this.dualFuelRodThoriumButton.setEnabled(true);
            this.quadFuelRodThoriumButton.setEnabled(true);
            this.coolantCellHelium60kButton.setEnabled(true);
            this.coolantCellHelium180kButton.setEnabled(true);
            this.coolantCellHelium360kButton.setEnabled(true);
            this.coolantCellNak60kButton.setEnabled(true);
            this.coolantCellNak180kButton.setEnabled(true);
            this.coolantCellNak360kButton.setEnabled(true);
            this.coolantCellNeutronium1GButton.setEnabled(false);
            this.fuelRodNaquadahButton.setEnabled(false);
            this.dualFuelRodNaquadahButton.setEnabled(false);
            this.quadFuelRodNaquadahButton.setEnabled(false);
            this.fuelRodCesiumButton.setEnabled(false);
            this.dualFuelRodCesiumButton.setEnabled(false);
            this.quadFuelRodCesiumButton.setEnabled(false);
            this.fuelRodCoaxiumButton.setEnabled(false);
            this.dualFuelRodCoaxiumButton.setEnabled(false);
            this.quadFuelRodCoaxiumButton.setEnabled(false);
            this.fuelRodNaquadahGTNHButton.setEnabled(false);
            this.dualFuelRodNaquadahGTNHButton.setEnabled(false);
            this.quadFuelRodNaquadahGTNHButton.setEnabled(false);
            this.coolantCellSpace180kButton.setEnabled(false);
            this.coolantCellSpace360kButton.setEnabled(false);
            this.coolantCellSpace540kButton.setEnabled(false);
            this.coolantCellSpace1080kButton.setEnabled(false);
            this.fuelRodNaquadriaButton.setEnabled(false);
            this.dualFuelRodNaquadriaButton.setEnabled(false);
            this.quadFuelRodNaquadriaButton.setEnabled(false);
            this.fuelRodTiberiumButton.setEnabled(false);
            this.dualFuelRodTiberiumButton.setEnabled(false);
            this.quadFuelRodTiberiumButton.setEnabled(false);
            this.fuelRodTheCoreButton.setEnabled(false);
            this.expandAdvancedAlloyCheck.setEnabled(false);
            this.fuelRodCompressedUraniumButton.setEnabled(false);
            this.dualFuelRodCompressedUraniumButton.setEnabled(false);
            this.quadFuelRodCompressedUraniumButton.setEnabled(false);
            this.fuelRodCompressedPlutoniumButton.setEnabled(false);
            this.dualFuelRodCompressedPlutoniumButton.setEnabled(false);
            this.quadFuelRodCompressedPlutoniumButton.setEnabled(false);
            this.fuelRodLiquidUraniumButton.setEnabled(false);
            this.dualFuelRodLiquidUraniumButton.setEnabled(false);
            this.quadFuelRodLiquidUraniumButton.setEnabled(false);
            this.fuelRodLiquidPlutoniumButton.setEnabled(false);
            this.dualFuelRodLiquidPlutoniumButton.setEnabled(false);
            this.quadFuelRodLiquidPlutoniumButton.setEnabled(false);
            this.fuelRodGlowstone.setEnabled(false);
            MaterialsList.setExpandAdvancedAlloy(false);
            MaterialsList.setGTVersion("5.08");
            FuelRod.setGT509Behavior(false);
            FuelRod.setGTNHBehavior(false);
            GGFuelRod.setGTNHBehavior(false);
        } else if ("5.09".equals(gtVersion)) {
            this.iridiumNeutronReflectorButton.setEnabled(true);
            this.fuelRodThoriumButton.setEnabled(true);
            this.dualFuelRodThoriumButton.setEnabled(true);
            this.quadFuelRodThoriumButton.setEnabled(true);
            this.coolantCellHelium60kButton.setEnabled(true);
            this.coolantCellHelium180kButton.setEnabled(true);
            this.coolantCellHelium360kButton.setEnabled(true);
            this.coolantCellNak60kButton.setEnabled(true);
            this.coolantCellNak180kButton.setEnabled(true);
            this.coolantCellNak360kButton.setEnabled(true);
            this.coolantCellNeutronium1GButton.setEnabled(true);
            this.fuelRodNaquadahButton.setEnabled(true);
            this.dualFuelRodNaquadahButton.setEnabled(true);
            this.quadFuelRodNaquadahButton.setEnabled(true);
            this.fuelRodCesiumButton.setEnabled(false);
            this.dualFuelRodCesiumButton.setEnabled(false);
            this.quadFuelRodCesiumButton.setEnabled(false);
            this.fuelRodCoaxiumButton.setEnabled(false);
            this.dualFuelRodCoaxiumButton.setEnabled(false);
            this.quadFuelRodCoaxiumButton.setEnabled(false);
            this.fuelRodNaquadahGTNHButton.setEnabled(false);
            this.dualFuelRodNaquadahGTNHButton.setEnabled(false);
            this.quadFuelRodNaquadahGTNHButton.setEnabled(false);
            this.coolantCellSpace180kButton.setEnabled(false);
            this.coolantCellSpace360kButton.setEnabled(false);
            this.coolantCellSpace540kButton.setEnabled(false);
            this.coolantCellSpace1080kButton.setEnabled(false);
            this.fuelRodNaquadriaButton.setEnabled(false);
            this.dualFuelRodNaquadriaButton.setEnabled(false);
            this.quadFuelRodNaquadriaButton.setEnabled(false);
            this.fuelRodTiberiumButton.setEnabled(false);
            this.dualFuelRodTiberiumButton.setEnabled(false);
            this.quadFuelRodTiberiumButton.setEnabled(false);
            this.fuelRodTheCoreButton.setEnabled(false);
            this.expandAdvancedAlloyCheck.setEnabled(false);
            this.fuelRodCompressedUraniumButton.setEnabled(false);
            this.dualFuelRodCompressedUraniumButton.setEnabled(false);
            this.quadFuelRodCompressedUraniumButton.setEnabled(false);
            this.fuelRodCompressedPlutoniumButton.setEnabled(false);
            this.dualFuelRodCompressedPlutoniumButton.setEnabled(false);
            this.quadFuelRodCompressedPlutoniumButton.setEnabled(false);
            this.fuelRodLiquidUraniumButton.setEnabled(false);
            this.dualFuelRodLiquidUraniumButton.setEnabled(false);
            this.quadFuelRodLiquidUraniumButton.setEnabled(false);
            this.fuelRodLiquidPlutoniumButton.setEnabled(false);
            this.dualFuelRodLiquidPlutoniumButton.setEnabled(false);
            this.quadFuelRodLiquidPlutoniumButton.setEnabled(false);
            this.fuelRodGlowstone.setEnabled(false);
            MaterialsList.setExpandAdvancedAlloy(false);
            MaterialsList.setGTVersion("5.09");
            FuelRod.setGT509Behavior(true);
            FuelRod.setGTNHBehavior(false);
            GGFuelRod.setGTNHBehavior(false);
        } else if ("GTNH".equals(gtVersion)) {
            this.iridiumNeutronReflectorButton.setEnabled(true);
            this.fuelRodThoriumButton.setEnabled(true);
            this.dualFuelRodThoriumButton.setEnabled(true);
            this.quadFuelRodThoriumButton.setEnabled(true);
            this.coolantCellHelium60kButton.setEnabled(true);
            this.coolantCellHelium180kButton.setEnabled(true);
            this.coolantCellHelium360kButton.setEnabled(true);
            this.coolantCellNak60kButton.setEnabled(true);
            this.coolantCellNak180kButton.setEnabled(true);
            this.coolantCellNak360kButton.setEnabled(true);
            this.coolantCellNeutronium1GButton.setEnabled(true);
            this.fuelRodNaquadahButton.setEnabled(false);
            this.dualFuelRodNaquadahButton.setEnabled(false);
            this.quadFuelRodNaquadahButton.setEnabled(false);
            this.fuelRodCesiumButton.setEnabled(false);
            this.dualFuelRodCesiumButton.setEnabled(false);
            this.quadFuelRodCesiumButton.setEnabled(false);
            this.fuelRodCoaxiumButton.setEnabled(false);
            this.dualFuelRodCoaxiumButton.setEnabled(false);
            this.quadFuelRodCoaxiumButton.setEnabled(false);
            this.fuelRodNaquadahGTNHButton.setEnabled(true);
            this.dualFuelRodNaquadahGTNHButton.setEnabled(true);
            this.quadFuelRodNaquadahGTNHButton.setEnabled(true);
            this.coolantCellSpace180kButton.setEnabled(true);
            this.coolantCellSpace360kButton.setEnabled(true);
            this.coolantCellSpace540kButton.setEnabled(true);
            this.coolantCellSpace1080kButton.setEnabled(true);
            this.fuelRodNaquadriaButton.setEnabled(true);
            this.dualFuelRodNaquadriaButton.setEnabled(true);
            this.quadFuelRodNaquadriaButton.setEnabled(true);
            this.fuelRodTiberiumButton.setEnabled(true);
            this.dualFuelRodTiberiumButton.setEnabled(true);
            this.quadFuelRodTiberiumButton.setEnabled(true);
            this.fuelRodTheCoreButton.setEnabled(true);
            this.expandAdvancedAlloyCheck.setEnabled(false);
            this.fuelRodCompressedUraniumButton.setEnabled(true);
            this.dualFuelRodCompressedUraniumButton.setEnabled(true);
            this.quadFuelRodCompressedUraniumButton.setEnabled(true);
            this.fuelRodCompressedPlutoniumButton.setEnabled(true);
            this.dualFuelRodCompressedPlutoniumButton.setEnabled(true);
            this.quadFuelRodCompressedPlutoniumButton.setEnabled(true);
            this.fuelRodLiquidUraniumButton.setEnabled(true);
            this.dualFuelRodLiquidUraniumButton.setEnabled(true);
            this.quadFuelRodLiquidUraniumButton.setEnabled(true);
            this.fuelRodLiquidPlutoniumButton.setEnabled(true);
            this.dualFuelRodLiquidPlutoniumButton.setEnabled(true);
            this.quadFuelRodLiquidPlutoniumButton.setEnabled(true);
            this.fuelRodGlowstone.setEnabled(true);
            MaterialsList.setExpandAdvancedAlloy(false);
            MaterialsList.setGTVersion("GTNH");
            FuelRod.setGT509Behavior(false);
            FuelRod.setGTNHBehavior(true);
            GGFuelRod.setGTNHBehavior(true);
        } else {
            this.iridiumNeutronReflectorButton.setEnabled(!"1.7.10".equals(mcVersion));
            this.fuelRodThoriumButton.setEnabled(false);
            this.dualFuelRodThoriumButton.setEnabled(false);
            this.quadFuelRodThoriumButton.setEnabled(false);
            this.coolantCellHelium60kButton.setEnabled(false);
            this.coolantCellHelium180kButton.setEnabled(false);
            this.coolantCellHelium360kButton.setEnabled(false);
            this.coolantCellNak60kButton.setEnabled(false);
            this.coolantCellNak180kButton.setEnabled(false);
            this.coolantCellNak360kButton.setEnabled(false);
            this.coolantCellNeutronium1GButton.setEnabled(false);
            this.fuelRodNaquadahButton.setEnabled(false);
            this.dualFuelRodNaquadahButton.setEnabled(false);
            this.quadFuelRodNaquadahButton.setEnabled(false);
            this.fuelRodCesiumButton.setEnabled(true);
            this.dualFuelRodCesiumButton.setEnabled(true);
            this.quadFuelRodCesiumButton.setEnabled(true);
            this.fuelRodCoaxiumButton.setEnabled(true);
            this.dualFuelRodCoaxiumButton.setEnabled(true);
            this.quadFuelRodCoaxiumButton.setEnabled(true);
            this.fuelRodNaquadahGTNHButton.setEnabled(false);
            this.dualFuelRodNaquadahGTNHButton.setEnabled(false);
            this.quadFuelRodNaquadahGTNHButton.setEnabled(false);
            this.coolantCellSpace180kButton.setEnabled(false);
            this.coolantCellSpace360kButton.setEnabled(false);
            this.coolantCellSpace540kButton.setEnabled(false);
            this.coolantCellSpace1080kButton.setEnabled(false);
            this.fuelRodNaquadriaButton.setEnabled(false);
            this.dualFuelRodNaquadriaButton.setEnabled(false);
            this.quadFuelRodNaquadriaButton.setEnabled(false);
            this.fuelRodTiberiumButton.setEnabled(false);
            this.dualFuelRodTiberiumButton.setEnabled(false);
            this.quadFuelRodTiberiumButton.setEnabled(false);
            this.fuelRodTheCoreButton.setEnabled(false);
            this.expandAdvancedAlloyCheck.setEnabled(true);
            this.fuelRodCompressedUraniumButton.setEnabled(false);
            this.dualFuelRodCompressedUraniumButton.setEnabled(false);
            this.quadFuelRodCompressedUraniumButton.setEnabled(false);
            this.fuelRodCompressedPlutoniumButton.setEnabled(false);
            this.dualFuelRodCompressedPlutoniumButton.setEnabled(false);
            this.quadFuelRodCompressedPlutoniumButton.setEnabled(false);
            this.fuelRodLiquidUraniumButton.setEnabled(false);
            this.dualFuelRodLiquidUraniumButton.setEnabled(false);
            this.quadFuelRodLiquidUraniumButton.setEnabled(false);
            this.fuelRodLiquidPlutoniumButton.setEnabled(false);
            this.dualFuelRodLiquidPlutoniumButton.setEnabled(false);
            this.quadFuelRodLiquidPlutoniumButton.setEnabled(false);
            this.fuelRodGlowstone.setEnabled(false);
            MaterialsList.setExpandAdvancedAlloy(this.expandAdvancedAlloyCheck.isSelected());
            MaterialsList.setGTVersion("none");
            FuelRod.setGT509Behavior(false);
            FuelRod.setGTNHBehavior(false);
            GGFuelRod.setGTNHBehavior(false);
        }
        this.materialsArea.setText(this.reactor.getMaterials().toString());
        this.saveAdvancedConfig();
    }

    private void updateReactorButtons() {
        for (int row = 0; row < this.reactorButtons.length; ++row) {
            int finalRow = row;
            for (int col = 0; col < this.reactorButtons[row].length; ++col) {
                int finalCol = col;
                ReactorItem componentToPlace = this.reactor.getComponentAt(row, col);
                int buttonSize = Math.min(this.reactorButtons[finalRow][finalCol].getWidth(), this.reactorButtons[finalRow][finalCol].getHeight());
                if (buttonSize > 2 && componentToPlace != null && componentToPlace.image != null) {
                    this.reactorButtons[finalRow][finalCol].setIcon(new ImageIcon(componentToPlace.image.getScaledInstance(buttonSize * 8 / 10, buttonSize * 8 / 10, 2)));
                    this.reactorButtons[finalRow][finalCol].setToolTipText(componentToPlace.toString());
                    this.reactorButtons[finalRow][finalCol].setBackground(Color.LIGHT_GRAY);
                    continue;
                }
                this.reactorButtons[finalRow][finalCol].setIcon(null);
                if (componentToPlace != null) {
                    this.reactorButtons[finalRow][finalCol].setToolTipText(componentToPlace.toString());
                } else {
                    this.reactorButtons[finalRow][finalCol].setToolTipText(null);
                }
                this.reactorButtons[finalRow][finalCol].setBackground(Color.LIGHT_GRAY);
            }
        }
        this.materialsArea.setText(this.reactor.getMaterials().toString());
        this.componentListArea.setText(this.reactor.getComponentList().toString());
        this.maxHeatLabel.setText(BundleHelper.formatI18n("UI.MaxHeatSpecific", this.reactor.getMaxHeat()));
        this.heatSpinnerModel.setMaximum(Double.valueOf(this.reactor.getMaxHeat() - 1.0));
        this.heatSpinnerModel.setValue(Math.min((double)((Number)this.heatSpinnerModel.getValue()).intValue(), this.reactor.getMaxHeat() - 1.0));
        this.temperatureEffectsLabel.setText(BundleHelper.formatI18n("UI.TemperatureEffectsSpecific", (int)(this.reactor.getMaxHeat() * 0.4), (int)(this.reactor.getMaxHeat() * 0.5), (int)(this.reactor.getMaxHeat() * 0.7), (int)(this.reactor.getMaxHeat() * 0.85), (int)(this.reactor.getMaxHeat() * 1.0)));
    }

    private String buildIntComparisonString(String comparisonType, int left, int right, int defaultValue) {
        if (right == defaultValue) {
            return String.format(BundleHelper.getI18n("Comparison." + comparisonType + ".LeftOnly"), left);
        }
        if (left == defaultValue) {
            return String.format(BundleHelper.getI18n("Comparison." + comparisonType + ".RightOnly"), right);
        }
        return String.format(BundleHelper.getI18n("Comparison." + comparisonType + ".Both"), left - right, left, right);
    }

    private String buildColoredIntComparisonString(String comparisonType, int left, int right, int defaultValue, int threshold) {
        if (right == defaultValue) {
            return String.format(BundleHelper.getI18n("Comparison." + comparisonType + ".LeftOnly"), left);
        }
        if (left == defaultValue) {
            return String.format(BundleHelper.getI18n("Comparison." + comparisonType + ".RightOnly"), right);
        }
        String color = "orange";
        if (Math.abs(left - right) > Math.abs(threshold)) {
            color = Math.signum(left - right) == Math.signum(threshold) ? "green" : "red";
        }
        return String.format(BundleHelper.getI18n("Comparison." + comparisonType + ".BothColored"), color, left - right, left, right);
    }

    private String colorDecimal(double value, double threshold) {
        String color = "orange";
        if (Math.abs(value) > Math.abs(threshold)) {
            color = Math.signum(value) == Math.signum(threshold) ? "green" : "red";
        }
        return String.format("<font color=\"%s\">%s</font>", color, this.comparisonFormat.format(value));
    }

    private String simpleDecimal(double value) {
        return this.simpleFormat.format(value);
    }

    private void updateComparison() {
        String replacedDiff;
        String componentDiff;
        if (this.simulator == null || this.simulator.getData() == null || this.prevSimulator == null || this.prevSimulator.getData() == null) {
            return;
        }
        if (this.showOldStyleReactorCodeCheck.isSelected()) {
            this.comparisonCodeField.setText(this.prevReactorOldCode);
        } else {
            this.comparisonCodeField.setText(this.prevReactorCode);
        }
        this.comparisonScroll.getVerticalScrollBar().setUnitIncrement(16);
        StringBuilder text = new StringBuilder(1000);
        StringBuilder prebreakText = new StringBuilder(500);
        StringBuilder predepleteText = new StringBuilder(500);
        StringBuilder postsimText = new StringBuilder(500);
        boolean alwaysDiff = !this.onlyShowDiffCheck.isSelected();
        text.append("<html>");
        Reactor tempReactor = new Reactor();
        tempReactor.setCode(this.currentReactorCode);
        Reactor prevReactor = new Reactor();
        prevReactor.setCode(this.prevReactorCode);
        SimulationData leftData = this.simulator.getData();
        SimulationData rightData = this.prevSimulator.getData();
        if (!(leftData.timeToBelow50 == Integer.MAX_VALUE && rightData.timeToBelow50 == Integer.MAX_VALUE || !alwaysDiff && leftData.timeToBelow50 == rightData.timeToBelow50)) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.TimeToBelow50"));
            text.append(this.buildColoredIntComparisonString("Time", leftData.timeToBelow50, rightData.timeToBelow50, Integer.MAX_VALUE, 1));
        }
        if (!(leftData.timeToBurn == Integer.MAX_VALUE && rightData.timeToBurn == Integer.MAX_VALUE || !alwaysDiff && leftData.timeToBurn == rightData.timeToBurn)) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.TimeToBurn"));
            text.append(this.buildColoredIntComparisonString("Time", leftData.timeToBurn, rightData.timeToBurn, Integer.MAX_VALUE, 1));
        }
        if (!(leftData.timeToEvaporate == Integer.MAX_VALUE && rightData.timeToEvaporate == Integer.MAX_VALUE || !alwaysDiff && leftData.timeToEvaporate == rightData.timeToEvaporate)) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.TimeToEvaporate"));
            text.append(this.buildColoredIntComparisonString("Time", leftData.timeToEvaporate, rightData.timeToEvaporate, Integer.MAX_VALUE, 1));
        }
        if (!(leftData.timeToHurt == Integer.MAX_VALUE && rightData.timeToHurt == Integer.MAX_VALUE || !alwaysDiff && leftData.timeToHurt == rightData.timeToHurt)) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.TimeToHurt"));
            text.append(this.buildColoredIntComparisonString("Time", leftData.timeToHurt, rightData.timeToHurt, Integer.MAX_VALUE, 1));
        }
        if (!(leftData.timeToLava == Integer.MAX_VALUE && rightData.timeToLava == Integer.MAX_VALUE || !alwaysDiff && leftData.timeToLava == rightData.timeToLava)) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.TimeToLava"));
            text.append(this.buildColoredIntComparisonString("Time", leftData.timeToLava, rightData.timeToLava, Integer.MAX_VALUE, 1));
        }
        if (!(leftData.timeToXplode == Integer.MAX_VALUE && rightData.timeToXplode == Integer.MAX_VALUE || !alwaysDiff && leftData.timeToXplode == rightData.timeToXplode)) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.TimeToXplode"));
            text.append(this.buildColoredIntComparisonString("Time", leftData.timeToXplode, rightData.timeToXplode, Integer.MAX_VALUE, 1));
        }
        if (leftData.firstComponentBrokenTime != Integer.MAX_VALUE || rightData.firstComponentBrokenTime != Integer.MAX_VALUE) {
            if (alwaysDiff || Math.abs(leftData.firstComponentBrokenTime - rightData.firstComponentBrokenTime) > 10) {
                text.append(this.buildIntComparisonString("Time", leftData.firstComponentBrokenTime, rightData.firstComponentBrokenTime, Integer.MAX_VALUE));
            }
            if (leftData.firstComponentBrokenTime != Integer.MAX_VALUE && rightData.firstComponentBrokenTime != Integer.MAX_VALUE) {
                prebreakText.append(BundleHelper.getI18n("Comparison.Prefix.Prebreak"));
                if (!tempReactor.isFluid()) {
                    if (!prevReactor.isFluid()) {
                        if (leftData.prebreakMinEUoutput <= leftData.prebreakMaxEUoutput && rightData.prebreakMinEUoutput <= rightData.prebreakMaxEUoutput && (alwaysDiff || Math.abs(leftData.prebreakTotalEUoutput - rightData.prebreakTotalEUoutput) > 1000.0 || Math.abs(leftData.prebreakAvgEUoutput - rightData.prebreakAvgEUoutput) > 0.1 || Math.abs(leftData.prebreakMinEUoutput - rightData.prebreakMinEUoutput) > 0.1 || Math.abs(leftData.prebreakMaxEUoutput - rightData.prebreakMaxEUoutput) > 0.1)) {
                            prebreakText.append(BundleHelper.formatI18n("Comparison.EUEUoutput", this.colorDecimal(leftData.prebreakTotalEUoutput - rightData.prebreakTotalEUoutput, 1000.0), this.simpleDecimal(leftData.prebreakTotalEUoutput), this.simpleDecimal(rightData.prebreakTotalEUoutput), this.colorDecimal(leftData.prebreakAvgEUoutput - rightData.prebreakAvgEUoutput, 0.1), this.simpleDecimal(leftData.prebreakAvgEUoutput), this.simpleDecimal(rightData.prebreakAvgEUoutput), this.colorDecimal(leftData.prebreakMinEUoutput - rightData.prebreakMinEUoutput, 0.1), this.simpleDecimal(leftData.prebreakMinEUoutput), this.simpleDecimal(rightData.prebreakMinEUoutput), this.colorDecimal(leftData.prebreakMaxEUoutput - rightData.prebreakMaxEUoutput, 0.1), this.simpleDecimal(leftData.prebreakMaxEUoutput), this.simpleDecimal(rightData.prebreakMaxEUoutput)));
                        }
                    } else if (leftData.prebreakMinEUoutput <= leftData.prebreakMaxEUoutput && rightData.prebreakMinHUoutput <= rightData.prebreakMaxHUoutput) {
                        prebreakText.append(BundleHelper.formatI18n("Comparison.EUHUoutput", this.simpleDecimal(leftData.prebreakTotalEUoutput), this.simpleDecimal(rightData.prebreakTotalHUoutput), this.simpleDecimal(leftData.prebreakAvgEUoutput), this.simpleDecimal(rightData.prebreakAvgHUoutput), this.simpleDecimal(leftData.prebreakMinEUoutput), this.simpleDecimal(rightData.prebreakMinHUoutput), this.simpleDecimal(leftData.prebreakMaxEUoutput), this.simpleDecimal(rightData.prebreakMaxHUoutput)));
                    }
                } else if (!prevReactor.isFluid()) {
                    if (leftData.prebreakMinHUoutput <= leftData.prebreakMaxHUoutput && rightData.prebreakMinEUoutput <= rightData.prebreakMaxEUoutput) {
                        prebreakText.append(BundleHelper.formatI18n("Comparison.HUEUoutput", this.simpleDecimal(leftData.prebreakTotalHUoutput), this.simpleDecimal(rightData.prebreakTotalEUoutput), this.simpleDecimal(leftData.prebreakAvgHUoutput), this.simpleDecimal(rightData.prebreakAvgEUoutput), this.simpleDecimal(leftData.prebreakMinHUoutput), this.simpleDecimal(rightData.prebreakMinEUoutput), this.simpleDecimal(leftData.prebreakMaxHUoutput), this.simpleDecimal(rightData.prebreakMaxEUoutput)));
                    }
                } else if (leftData.prebreakMinHUoutput <= leftData.prebreakMaxHUoutput && rightData.prebreakMinHUoutput <= rightData.prebreakMaxHUoutput && (alwaysDiff || Math.abs(leftData.prebreakTotalHUoutput - rightData.prebreakTotalHUoutput) > 1000.0 || Math.abs(leftData.prebreakAvgHUoutput - rightData.prebreakAvgHUoutput) > 0.1 || Math.abs(leftData.prebreakMinHUoutput - rightData.prebreakMinHUoutput) > 0.1 || Math.abs(leftData.prebreakMaxHUoutput - rightData.prebreakMaxHUoutput) > 0.1)) {
                    prebreakText.append(BundleHelper.formatI18n("Comparison.HUHUoutput", this.colorDecimal(leftData.prebreakTotalHUoutput - rightData.prebreakTotalHUoutput, 1000.0), this.simpleDecimal(leftData.prebreakTotalHUoutput), this.simpleDecimal(rightData.prebreakTotalHUoutput), this.colorDecimal(leftData.prebreakAvgHUoutput - rightData.prebreakAvgHUoutput, 0.1), this.simpleDecimal(leftData.prebreakAvgHUoutput), this.simpleDecimal(rightData.prebreakAvgHUoutput), this.colorDecimal(leftData.prebreakMinHUoutput - rightData.prebreakMinHUoutput, 0.1), this.simpleDecimal(leftData.prebreakMinHUoutput), this.simpleDecimal(rightData.prebreakMinHUoutput), this.colorDecimal(leftData.prebreakMaxHUoutput - rightData.prebreakMaxHUoutput, 0.1), this.simpleDecimal(leftData.prebreakMaxHUoutput), this.simpleDecimal(rightData.prebreakMaxHUoutput)));
                }
            }
        }
        if (prebreakText.length() > 0) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.PrebreakTime"));
            text.append((CharSequence)prebreakText);
            text.append("<br>");
        }
        boolean moxStyleReactor = false;
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 9; ++col) {
                String baseName;
                ReactorItem component = tempReactor.getComponentAt(row, col);
                if (component == null || !"fuelRodMox".equals(baseName = component.baseName) && !"dualFuelRodMox".equals(baseName) && !"quadFuelRodMox".equals(baseName) && !"fuelRodNaquadah".equals(baseName) && !"dualFuelRodNaquadah".equals(baseName) && !"quadFuelRodNaquadah".equals(baseName)) continue;
                moxStyleReactor = true;
            }
        }
        if (leftData.firstRodDepletedTime != Integer.MAX_VALUE || rightData.firstRodDepletedTime != Integer.MAX_VALUE) {
            if (alwaysDiff || Math.abs(leftData.firstRodDepletedTime - rightData.firstRodDepletedTime) > 10) {
                text.append(BundleHelper.getI18n("Comparison.Prefix.PredepleteTime"));
                text.append(this.buildIntComparisonString("Time", leftData.firstRodDepletedTime, rightData.firstRodDepletedTime, Integer.MAX_VALUE));
            }
            if (leftData.totalRodCount > 0 && rightData.totalRodCount > 0) {
                if (!tempReactor.isFluid()) {
                    if (!prevReactor.isFluid()) {
                        if (leftData.predepleteMinEUoutput <= leftData.predepleteMaxEUoutput && rightData.predepleteMinEUoutput <= rightData.predepleteMaxEUoutput && (alwaysDiff || Math.abs(leftData.predepleteTotalEUoutput - rightData.predepleteTotalEUoutput) > 1000.0 || Math.abs(leftData.predepleteAvgEUoutput - rightData.predepleteAvgEUoutput) > 0.1 || Math.abs(leftData.predepleteMinEUoutput - rightData.predepleteMinEUoutput) > 0.1 || Math.abs(leftData.predepleteMaxEUoutput - rightData.predepleteMaxEUoutput) > 0.1)) {
                            predepleteText.append(BundleHelper.formatI18n("Comparison.EUEUoutput", this.colorDecimal(leftData.predepleteTotalEUoutput - rightData.predepleteTotalEUoutput, 1000.0), this.simpleDecimal(leftData.predepleteTotalEUoutput), this.simpleDecimal(rightData.predepleteTotalEUoutput), this.colorDecimal(leftData.predepleteAvgEUoutput - rightData.predepleteAvgEUoutput, 0.1), this.simpleDecimal(leftData.predepleteAvgEUoutput), this.simpleDecimal(rightData.predepleteAvgEUoutput), this.colorDecimal(leftData.predepleteMinEUoutput - rightData.predepleteMinEUoutput, 0.1), this.simpleDecimal(leftData.predepleteMinEUoutput), this.simpleDecimal(rightData.predepleteMinEUoutput), this.colorDecimal(leftData.predepleteMaxEUoutput - rightData.predepleteMaxEUoutput, 0.1), this.simpleDecimal(leftData.predepleteMaxEUoutput), this.simpleDecimal(rightData.predepleteMaxEUoutput)));
                        }
                    } else if (leftData.predepleteMinEUoutput <= leftData.predepleteMaxEUoutput && rightData.predepleteMinHUoutput <= rightData.predepleteMaxHUoutput) {
                        predepleteText.append(BundleHelper.formatI18n("Comparison.EUHUoutput", this.simpleDecimal(leftData.predepleteTotalEUoutput), this.simpleDecimal(rightData.predepleteTotalHUoutput), this.simpleDecimal(leftData.predepleteAvgEUoutput), this.simpleDecimal(rightData.predepleteAvgHUoutput), this.simpleDecimal(leftData.predepleteMinEUoutput), this.simpleDecimal(rightData.predepleteMinHUoutput), this.simpleDecimal(leftData.predepleteMaxEUoutput), this.simpleDecimal(rightData.predepleteMaxHUoutput)));
                    }
                } else if (!prevReactor.isFluid()) {
                    if (leftData.predepleteMinHUoutput <= leftData.predepleteMaxHUoutput && rightData.predepleteMinEUoutput <= rightData.predepleteMaxEUoutput) {
                        predepleteText.append(BundleHelper.formatI18n("Comparison.HUEUoutput", this.simpleDecimal(leftData.predepleteTotalHUoutput), this.simpleDecimal(rightData.predepleteTotalEUoutput), this.simpleDecimal(leftData.predepleteAvgHUoutput), this.simpleDecimal(rightData.predepleteAvgEUoutput), this.simpleDecimal(leftData.predepleteMinHUoutput), this.simpleDecimal(rightData.predepleteMinEUoutput), this.simpleDecimal(leftData.predepleteMaxHUoutput), this.simpleDecimal(rightData.predepleteMaxEUoutput)));
                    }
                } else if (leftData.predepleteMinHUoutput <= leftData.predepleteMaxHUoutput && rightData.predepleteMinHUoutput <= rightData.predepleteMaxHUoutput && (alwaysDiff || Math.abs(leftData.predepleteTotalHUoutput - rightData.predepleteTotalHUoutput) > 1000.0 || Math.abs(leftData.predepleteAvgHUoutput - rightData.predepleteAvgHUoutput) > 0.1 || Math.abs(leftData.predepleteMinHUoutput - rightData.predepleteMinHUoutput) > 0.1 || Math.abs(leftData.predepleteMaxHUoutput - rightData.predepleteMaxHUoutput) > 0.1)) {
                    predepleteText.append(BundleHelper.formatI18n("Comparison.HUHUoutput", this.colorDecimal(leftData.predepleteTotalHUoutput - rightData.predepleteTotalHUoutput, 1000.0), this.simpleDecimal(leftData.predepleteTotalHUoutput), this.simpleDecimal(rightData.predepleteTotalHUoutput), this.colorDecimal(leftData.predepleteAvgHUoutput - rightData.predepleteAvgHUoutput, 0.1), this.simpleDecimal(leftData.predepleteAvgHUoutput), this.simpleDecimal(rightData.predepleteAvgHUoutput), this.colorDecimal(leftData.predepleteMinHUoutput - rightData.predepleteMinHUoutput, 0.1), this.simpleDecimal(leftData.predepleteMinHUoutput), this.simpleDecimal(rightData.predepleteMinHUoutput), this.colorDecimal(leftData.predepleteMaxHUoutput - rightData.predepleteMaxHUoutput, 0.1), this.simpleDecimal(leftData.predepleteMaxHUoutput), this.simpleDecimal(rightData.predepleteMaxHUoutput)));
                }
                if (leftData.predepleteMinTemp <= leftData.predepleteMaxTemp && rightData.predepleteMinTemp <= rightData.predepleteMaxTemp) {
                    if (alwaysDiff || Math.abs(leftData.predepleteMinTemp - rightData.predepleteMinTemp) > 10.0) {
                        predepleteText.append(BundleHelper.formatI18n("Comparison.PredepleteMinTemp", this.colorDecimal(leftData.predepleteMinTemp - rightData.predepleteMinTemp, moxStyleReactor ? 10.0 : -10.0), this.simpleDecimal(leftData.predepleteMinTemp), this.simpleDecimal(rightData.predepleteMinTemp)));
                    }
                    if (alwaysDiff || Math.abs(leftData.predepleteMaxTemp - rightData.predepleteMaxTemp) > 10.0) {
                        String leftMaxTempDecimal = this.simpleDecimal(leftData.predepleteMaxTemp);
                        String rightMaxTempDecimal = this.simpleDecimal(rightData.predepleteMaxTemp);
                        if (leftData.predepleteMaxTemp >= tempReactor.getMaxHeat() * 0.85 != rightData.predepleteMaxTemp >= prevReactor.getMaxHeat() * 0.85) {
                            if (leftData.predepleteMaxTemp >= tempReactor.getMaxHeat() * 0.85) {
                                leftMaxTempDecimal = "<font color=\"red\">" + leftMaxTempDecimal + "</font>";
                                rightMaxTempDecimal = "<font color=\"green\">" + rightMaxTempDecimal + "</font>";
                            } else {
                                leftMaxTempDecimal = "<font color=\"green\">" + leftMaxTempDecimal + "</font>";
                                rightMaxTempDecimal = "<font color=\"red\">" + rightMaxTempDecimal + "</font>";
                            }
                        }
                        predepleteText.append(BundleHelper.formatI18n("Comparison.PredepleteMaxTemp", this.colorDecimal(leftData.predepleteMaxTemp - rightData.predepleteMaxTemp, moxStyleReactor ? 10.0 : -10.0), leftMaxTempDecimal, rightMaxTempDecimal));
                    }
                }
            }
        }
        if (predepleteText.length() > 0) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.Predeplete"));
            text.append((CharSequence)predepleteText);
            text.append("<br>");
        }
        if (alwaysDiff || Math.abs(leftData.totalReactorTicks - rightData.totalReactorTicks) > 10) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.PostSimulationTime"));
            text.append(this.buildIntComparisonString("Time", leftData.totalReactorTicks, rightData.totalReactorTicks, Integer.MAX_VALUE));
        }
        if (!tempReactor.isFluid()) {
            if (!prevReactor.isFluid()) {
                if (leftData.minEUoutput <= leftData.maxEUoutput && rightData.minEUoutput <= rightData.maxEUoutput && (alwaysDiff || Math.abs(leftData.totalEUoutput - rightData.totalEUoutput) > 1000.0 || Math.abs(leftData.avgEUoutput - rightData.avgEUoutput) > 0.1 || Math.abs(leftData.minEUoutput - rightData.minEUoutput) > 0.1 || Math.abs(leftData.maxEUoutput - rightData.maxEUoutput) > 0.1)) {
                    postsimText.append(BundleHelper.formatI18n("Comparison.EUEUoutput", this.colorDecimal(leftData.totalEUoutput - rightData.totalEUoutput, 1000.0), this.simpleDecimal(leftData.totalEUoutput), this.simpleDecimal(rightData.totalEUoutput), this.colorDecimal(leftData.avgEUoutput - rightData.avgEUoutput, 0.1), this.simpleDecimal(leftData.avgEUoutput), this.simpleDecimal(rightData.avgEUoutput), this.colorDecimal(leftData.minEUoutput - rightData.minEUoutput, 0.1), this.simpleDecimal(leftData.minEUoutput), this.simpleDecimal(rightData.minEUoutput), this.colorDecimal(leftData.maxEUoutput - rightData.maxEUoutput, 0.1), this.simpleDecimal(leftData.maxEUoutput), this.simpleDecimal(rightData.maxEUoutput)));
                }
            } else if (leftData.minEUoutput <= leftData.maxEUoutput && rightData.minHUoutput <= rightData.maxHUoutput) {
                postsimText.append(BundleHelper.formatI18n("Comparison.EUHUoutput", this.simpleDecimal(leftData.totalEUoutput), this.simpleDecimal(rightData.totalHUoutput), this.simpleDecimal(leftData.avgEUoutput), this.simpleDecimal(rightData.avgHUoutput), this.simpleDecimal(leftData.minEUoutput), this.simpleDecimal(rightData.minHUoutput), this.simpleDecimal(leftData.maxEUoutput), this.simpleDecimal(rightData.maxHUoutput)));
            }
        } else if (!prevReactor.isFluid()) {
            if (leftData.minHUoutput <= leftData.maxHUoutput && rightData.minEUoutput <= rightData.maxEUoutput) {
                postsimText.append(BundleHelper.formatI18n("Comparison.HUEUoutput", this.simpleDecimal(leftData.totalHUoutput), this.simpleDecimal(rightData.totalEUoutput), this.simpleDecimal(leftData.avgHUoutput), this.simpleDecimal(rightData.avgEUoutput), this.simpleDecimal(leftData.minHUoutput), this.simpleDecimal(rightData.minEUoutput), this.simpleDecimal(leftData.maxHUoutput), this.simpleDecimal(rightData.maxEUoutput)));
            }
        } else if (leftData.minHUoutput <= leftData.maxHUoutput && rightData.minHUoutput <= rightData.maxHUoutput && (alwaysDiff || Math.abs(leftData.totalHUoutput - rightData.totalHUoutput) > 1000.0 || Math.abs(leftData.avgHUoutput - rightData.avgHUoutput) > 0.1 || Math.abs(leftData.minHUoutput - rightData.minHUoutput) > 0.1 || Math.abs(leftData.maxHUoutput - rightData.maxHUoutput) > 0.1)) {
            postsimText.append(BundleHelper.formatI18n("Comparison.HUHUoutput", this.colorDecimal(leftData.totalHUoutput - rightData.totalHUoutput, 1000.0), this.simpleDecimal(leftData.totalHUoutput), this.simpleDecimal(rightData.totalHUoutput), this.colorDecimal(leftData.avgHUoutput - rightData.avgHUoutput, 0.1), this.simpleDecimal(leftData.avgHUoutput), this.simpleDecimal(rightData.avgHUoutput), this.colorDecimal(leftData.minHUoutput - rightData.minHUoutput, 0.1), this.simpleDecimal(leftData.minHUoutput), this.simpleDecimal(rightData.minHUoutput), this.colorDecimal(leftData.maxHUoutput - rightData.maxHUoutput, 0.1), this.simpleDecimal(leftData.maxHUoutput), this.simpleDecimal(rightData.maxHUoutput)));
        }
        if (leftData.minTemp <= leftData.maxTemp && rightData.minTemp <= rightData.maxTemp) {
            if (alwaysDiff || Math.abs(leftData.minTemp - rightData.minTemp) > 10.0) {
                postsimText.append(BundleHelper.formatI18n("Comparison.PostsimMinTemp", this.colorDecimal(leftData.minTemp - rightData.minTemp, moxStyleReactor ? 10.0 : -10.0), this.simpleDecimal(leftData.minTemp), this.simpleDecimal(rightData.minTemp)));
            }
            if (alwaysDiff || Math.abs(leftData.maxTemp - rightData.maxTemp) > 10.0) {
                String leftMaxTempDecimal = this.simpleDecimal(leftData.maxTemp);
                String rightMaxTempDecimal = this.simpleDecimal(rightData.maxTemp);
                if (leftData.maxTemp >= tempReactor.getMaxHeat() * 0.85 != rightData.maxTemp >= prevReactor.getMaxHeat() * 0.85) {
                    if (leftData.maxTemp >= tempReactor.getMaxHeat() * 0.85) {
                        leftMaxTempDecimal = "<font color=\"red\">" + leftMaxTempDecimal + "</font>";
                        rightMaxTempDecimal = "<font color=\"green\">" + rightMaxTempDecimal + "</font>";
                    } else {
                        leftMaxTempDecimal = "<font color=\"green\">" + leftMaxTempDecimal + "</font>";
                        rightMaxTempDecimal = "<font color=\"red\">" + rightMaxTempDecimal + "</font>";
                    }
                }
                postsimText.append(BundleHelper.formatI18n("Comparison.PostsimMaxTemp", this.colorDecimal(leftData.maxTemp - rightData.maxTemp, moxStyleReactor ? 10.0 : -10.0), leftMaxTempDecimal, rightMaxTempDecimal));
            }
        }
        if (postsimText.length() > 0) {
            text.append(BundleHelper.getI18n("Comparison.Prefix.PostSimulation"));
            text.append((CharSequence)postsimText);
            text.append("<br>");
        }
        if ((leftData.hullHeating != 0.0 || rightData.hullHeating != 0.0) && (alwaysDiff || Math.abs(leftData.hullHeating - rightData.hullHeating) > 1.0)) {
            text.append(BundleHelper.formatI18n("Comparison.HullHeating", this.colorDecimal(leftData.hullHeating - rightData.hullHeating, -1.0), this.simpleDecimal(leftData.hullHeating), this.simpleDecimal(rightData.hullHeating)));
        }
        if ((leftData.componentHeating != 0.0 || rightData.componentHeating != 0.0) && (alwaysDiff || Math.abs(leftData.componentHeating - rightData.componentHeating) > 1.0)) {
            text.append(BundleHelper.formatI18n("Comparison.ComponentHeating", this.colorDecimal(leftData.componentHeating - rightData.componentHeating, -1.0), this.simpleDecimal(leftData.componentHeating), this.simpleDecimal(rightData.componentHeating)));
        }
        if (leftData.hullCooling != 0.0 || rightData.hullCooling != 0.0) {
            if (alwaysDiff || Math.abs(leftData.hullCooling - rightData.hullCooling) > 1.0) {
                text.append(BundleHelper.formatI18n("Comparison.HullCooling", this.colorDecimal(leftData.hullCooling - rightData.hullCooling, 1.0), this.simpleDecimal(leftData.hullCooling), this.simpleDecimal(rightData.hullCooling)));
            }
            if (alwaysDiff || Math.abs(leftData.hullCoolingCapacity - rightData.hullCoolingCapacity) > 1.0) {
                text.append(BundleHelper.formatI18n("Comparison.HullCoolingPossible", this.colorDecimal(leftData.hullCoolingCapacity - rightData.hullCoolingCapacity, 1.0), this.simpleDecimal(leftData.hullCoolingCapacity), this.simpleDecimal(rightData.hullCoolingCapacity)));
            }
        }
        if (leftData.ventCooling != 0.0 || rightData.ventCooling != 0.0) {
            if (alwaysDiff || Math.abs(leftData.ventCooling - rightData.ventCooling) > 1.0) {
                text.append(BundleHelper.formatI18n("Comparison.VentCooling", this.colorDecimal(leftData.ventCooling - rightData.ventCooling, 1.0), this.simpleDecimal(leftData.ventCooling), this.simpleDecimal(rightData.ventCooling)));
            }
            if (alwaysDiff || Math.abs(leftData.ventCoolingCapacity - rightData.ventCoolingCapacity) > 1.0) {
                text.append(BundleHelper.formatI18n("Comparison.VentCoolingPossible", this.colorDecimal(leftData.ventCoolingCapacity - rightData.ventCoolingCapacity, 1.0), this.simpleDecimal(leftData.ventCoolingCapacity), this.simpleDecimal(rightData.ventCoolingCapacity)));
            }
        }
        text.append("<br>");
        String materialDiff = tempReactor.getMaterials().buildComparisonString(prevReactor.getMaterials(), alwaysDiff);
        if (!materialDiff.isEmpty()) {
            text.append(BundleHelper.getI18n("Comparison.MaterialsHeading"));
            text.append(materialDiff);
            text.append("<br>");
        }
        if (!(componentDiff = tempReactor.getComponentList().buildComparisonString(prevReactor.getComponentList(), alwaysDiff)).isEmpty()) {
            text.append(BundleHelper.getI18n("Comparison.ComponentsHeading"));
            text.append(componentDiff);
            text.append("<br>");
        }
        if (!(replacedDiff = leftData.replacedItems.buildComparisonString(rightData.replacedItems, alwaysDiff)).isEmpty()) {
            text.append(BundleHelper.getI18n("Comparison.ComponentsReplacedHeading"));
            text.append(replacedDiff);
        }
        if (text.toString().replace("<html>", "").replace("<br>", "").isEmpty()) {
            text.append(BundleHelper.getI18n("Comparison.NoDifferences"));
        }
        text.append("</html>");
        this.comparisonLabel.setText(text.toString());
        this.copyComparisonButton.setEnabled(true);
    }

    private String buildTooltipInfo(String compType) {
        StringBuilder result = new StringBuilder(500);
        result.append("<html>");
        result.append(BundleHelper.getI18n("ComponentName." + compType));
        result.append("<br>");
        result.append(BundleHelper.getI18n("ComponentData." + compType));
        result.append("</html>");
        return result.toString();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionDialogDisplay());
        System.setProperty("sun.awt.exception.handler", ExceptionDialogDisplay.class.getName());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ReactorPlannerFrame().setVisible(true);
            }
        });
    }
}

