/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;

public class HtmlSelection
implements Transferable,
ClipboardOwner {
    private final DataFlavor htmlFlavor = new DataFlavor("text/html; charset=utf-8", null);
    private final DataFlavor plainFlavor = new DataFlavor("text/plain; charset=utf-8", null);
    private final DataFlavor rtfFlavor = new DataFlavor("text/rtf", null);
    private final String data;

    public HtmlSelection(String data) {
        this.data = data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.htmlFlavor, this.plainFlavor, this.rtfFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.htmlFlavor) || flavor.equals(this.plainFlavor) || flavor.equals(this.rtfFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(this.htmlFlavor)) {
            return new ByteArrayInputStream(this.data.getBytes("utf-8"));
        }
        if (flavor.equals(this.plainFlavor)) {
            return new ByteArrayInputStream(this.data.replace("<br>", "\n").replaceAll("<[^>]+>", "").getBytes("utf-8"));
        }
        if (flavor.equals(this.rtfFlavor)) {
            return new ByteArrayInputStream(HtmlSelection.convertToRTF(this.data).getBytes("us-ascii"));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private static String convertToRTF(String htmlStr) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        RTFEditorKit rtfEditorKit = new RTFEditorKit();
        String rtfStr = null;
        String tempStr = htmlStr.replace("</font>", "#END_FONT#").replace("<br>", "#NEW_LINE#");
        ByteArrayInputStream is = new ByteArrayInputStream(tempStr.getBytes());
        try {
            Document doc = htmlEditorKit.createDefaultDocument();
            htmlEditorKit.read(is, doc, 0);
            rtfEditorKit.write(os, doc, 0, doc.getLength());
            rtfStr = ((Object)os).toString();
            rtfStr = rtfStr.replace("#NEW_LINE#", "\\line ");
            rtfStr = rtfStr.replace("#END_FONT#", "\\cf0 ");
        }
        catch (IOException | BadLocationException e) {
            e.printStackTrace();
        }
        return rtfStr;
    }
}

