/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import Ic2ExpReactorPlanner.BundleHelper;
import Ic2ExpReactorPlanner.TextureFactory;
import Ic2ExpReactorPlanner.components.BreederCell;
import Ic2ExpReactorPlanner.components.Condensator;
import Ic2ExpReactorPlanner.components.CoolantCell;
import Ic2ExpReactorPlanner.components.Exchanger;
import Ic2ExpReactorPlanner.components.FuelRod;
import Ic2ExpReactorPlanner.components.GGFuelRod;
import Ic2ExpReactorPlanner.components.Plating;
import Ic2ExpReactorPlanner.components.ReactorItem;
import Ic2ExpReactorPlanner.components.Reflector;
import Ic2ExpReactorPlanner.components.Vent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ComponentFactory {
    private static final ReactorItem[] ITEMS = new ReactorItem[]{null, new FuelRod(1, "fuelRodUranium", BundleHelper.getI18n("ComponentName.FuelRodUranium"), TextureFactory.getImage("reactorUraniumSimple.png", "uranium.png"), 20000.0, 1.0, null, 100, 2.0, 1, false), new FuelRod(2, "dualFuelRodUranium", BundleHelper.getI18n("ComponentName.DualFuelRodUranium"), TextureFactory.getImage("reactorUraniumDual.png", "dual_uranium.png"), 20000.0, 1.0, null, 200, 4.0, 2, false), new FuelRod(3, "quadFuelRodUranium", BundleHelper.getI18n("ComponentName.QuadFuelRodUranium"), TextureFactory.getImage("reactorUraniumQuad.png", "quad_uranium.png"), 20000.0, 1.0, null, 400, 8.0, 4, false), new FuelRod(4, "fuelRodMox", BundleHelper.getI18n("ComponentName.FuelRodMox"), TextureFactory.getImage("reactorMOXSimple.png", "mox.png"), 10000.0, 1.0, null, 100, 2.0, 1, true), new FuelRod(5, "dualFuelRodMox", BundleHelper.getI18n("ComponentName.DualFuelRodMox"), TextureFactory.getImage("reactorMOXDual.png", "dual_mox.png"), 10000.0, 1.0, null, 200, 4.0, 2, true), new FuelRod(6, "quadFuelRodMox", BundleHelper.getI18n("ComponentName.QuadFuelRodMox"), TextureFactory.getImage("reactorMOXQuad.png", "quad_mox.png"), 10000.0, 1.0, null, 400, 8.0, 4, true), new Reflector(7, "neutronReflector", BundleHelper.getI18n("ComponentName.NeutronReflector"), TextureFactory.getImage("reactorReflector.png", "neutron_reflector.png"), 30000.0, 1.0, null), new Reflector(8, "thickNeutronReflector", BundleHelper.getI18n("ComponentName.ThickNeutronReflector"), TextureFactory.getImage("reactorReflectorThick.png", "thick_neutron_reflector.png"), 120000.0, 1.0, null), new Vent(9, "heatVent", BundleHelper.getI18n("ComponentName.HeatVent"), TextureFactory.getImage("reactorVent.png", "heat_vent.png"), 1.0, 1000.0, null, 6, 0, 0), new Vent(10, "advancedHeatVent", BundleHelper.getI18n("ComponentName.AdvancedHeatVent"), TextureFactory.getImage("reactorVentDiamond.png", "advanced_heat_vent.png"), 1.0, 1000.0, null, 12, 0, 0), new Vent(11, "reactorHeatVent", BundleHelper.getI18n("ComponentName.ReactorHeatVent"), TextureFactory.getImage("reactorVentCore.png", "reactor_heat_vent.png"), 1.0, 1000.0, null, 5, 5, 0), new Vent(12, "componentHeatVent", BundleHelper.getI18n("ComponentName.ComponentHeatVent"), TextureFactory.getImage("reactorVentSpread.png", "component_heat_vent.png"), 1.0, 1.0, null, 0, 0, 4), new Vent(13, "overclockedHeatVent", BundleHelper.getI18n("ComponentName.OverclockedHeatVent"), TextureFactory.getImage("reactorVentGold.png", "overclocked_heat_vent.png"), 1.0, 1000.0, null, 20, 36, 0), new CoolantCell(14, "coolantCell10k", BundleHelper.getI18n("ComponentName.CoolantCell10k"), TextureFactory.getImage("reactorCoolantSimple.png", "heat_storage.png"), 1.0, 10000.0, null), new CoolantCell(15, "coolantCell30k", BundleHelper.getI18n("ComponentName.CoolantCell30k"), TextureFactory.getImage("reactorCoolantTriple.png", "tri_heat_storage.png"), 1.0, 30000.0, null), new CoolantCell(16, "coolantCell60k", BundleHelper.getI18n("ComponentName.CoolantCell60k"), TextureFactory.getImage("reactorCoolantSix.png", "hex_heat_storage.png"), 1.0, 60000.0, null), new Exchanger(17, "heatExchanger", BundleHelper.getI18n("ComponentName.HeatExchanger"), TextureFactory.getImage("reactorHeatSwitch.png", "heat_exchanger.png"), 1.0, 2500.0, null, 12, 4), new Exchanger(18, "advancedHeatExchanger", BundleHelper.getI18n("ComponentName.AdvancedHeatExchanger"), TextureFactory.getImage("reactorHeatSwitchDiamond.png", "advanced_heat_exchanger.png"), 1.0, 10000.0, null, 24, 8), new Exchanger(19, "coreHeatExchanger", BundleHelper.getI18n("ComponentName.ReactorHeatExchanger"), TextureFactory.getImage("reactorHeatSwitchCore.png", "reactor_heat_exchanger.png"), 1.0, 5000.0, null, 0, 72), new Exchanger(20, "componentHeatExchanger", BundleHelper.getI18n("ComponentName.ComponentHeatExchanger"), TextureFactory.getImage("reactorHeatSwitchSpread.png", "component_heat_exchanger.png"), 1.0, 5000.0, null, 36, 0), new Plating(21, "reactorPlating", BundleHelper.getI18n("ComponentName.ReactorPlating"), TextureFactory.getImage("reactorPlating.png", "plating.png"), 1.0, 1.0, null, 1000, 0.9025), new Plating(22, "heatCapacityReactorPlating", BundleHelper.getI18n("ComponentName.HeatCapacityReactorPlating"), TextureFactory.getImage("reactorPlatingHeat.png", "heat_plating.png"), 1.0, 1.0, null, 1700, 0.9801), new Plating(23, "containmentReactorPlating", BundleHelper.getI18n("ComponentName.ContainmentReactorPlating"), TextureFactory.getImage("reactorPlatingExplosive.png", "containment_plating.png"), 1.0, 1.0, null, 500, 0.81), new Condensator(24, "rshCondensator", BundleHelper.getI18n("ComponentName.RshCondensator"), TextureFactory.getImage("reactorCondensator.png", "rsh_condensator.png"), 1.0, 20000.0, null), new Condensator(25, "lzhCondensator", BundleHelper.getI18n("ComponentName.LzhCondensator"), TextureFactory.getImage("reactorCondensatorLap.png", "lzh_condensator.png"), 1.0, 100000.0, null), new FuelRod(26, "fuelRodThorium", BundleHelper.getI18n("ComponentName.FuelRodThorium"), TextureFactory.getImage("gt.Thoriumcell.png"), 50000.0, 1.0, "GT5.08", 20, 0.5, 1, false), new FuelRod(27, "dualFuelRodThorium", BundleHelper.getI18n("ComponentName.DualFuelRodThorium"), TextureFactory.getImage("gt.Double_Thoriumcell.png"), 50000.0, 1.0, "GT5.08", 40, 1.0, 2, false), new FuelRod(28, "quadFuelRodThorium", BundleHelper.getI18n("ComponentName.QuadFuelRodThorium"), TextureFactory.getImage("gt.Quad_Thoriumcell.png"), 50000.0, 1.0, "GT5.08", 80, 2.0, 4, false), new CoolantCell(29, "coolantCellHelium60k", BundleHelper.getI18n("ComponentName.CoolantCell60kHelium"), TextureFactory.getImage("gt.60k_Helium_Coolantcell.png"), 1.0, 60000.0, "GT5.08"), new CoolantCell(30, "coolantCellHelium180k", BundleHelper.getI18n("ComponentName.CoolantCell180kHelium"), TextureFactory.getImage("gt.180k_Helium_Coolantcell.png"), 1.0, 180000.0, "GT5.08"), new CoolantCell(31, "coolantCellHelium360k", BundleHelper.getI18n("ComponentName.CoolantCell360kHelium"), TextureFactory.getImage("gt.360k_Helium_Coolantcell.png"), 1.0, 360000.0, "GT5.08"), new CoolantCell(32, "coolantCellNak60k", BundleHelper.getI18n("ComponentName.CoolantCell60kNak"), TextureFactory.getImage("gt.60k_NaK_Coolantcell.png"), 1.0, 60000.0, "GT5.08"), new CoolantCell(33, "coolantCellNak180k", BundleHelper.getI18n("ComponentName.CoolantCell180kNak"), TextureFactory.getImage("gt.180k_NaK_Coolantcell.png"), 1.0, 180000.0, "GT5.08"), new CoolantCell(34, "coolantCellNak360k", BundleHelper.getI18n("ComponentName.CoolantCell360kNak"), TextureFactory.getImage("gt.360k_NaK_Coolantcell.png"), 1.0, 360000.0, "GT5.08"), new Reflector(35, "iridiumNeutronReflector", BundleHelper.getI18n("ComponentName.IridiumNeutronReflector"), TextureFactory.getImage("gt.neutronreflector.png", "neutron_reflector.png"), 1.0, 1.0, null), new FuelRod(36, "fuelRodNaquadah", BundleHelper.getI18n("ComponentName.FuelRodNaquadah"), TextureFactory.getImage("gt.Naquadahcell.png"), 100000.0, 1.0, "GT5.09", 100, 2.0, 1, true), new FuelRod(37, "dualFuelRodNaquadah", BundleHelper.getI18n("ComponentName.DualFuelRodNaquadah"), TextureFactory.getImage("gt.Double_Naquadahcell.png"), 100000.0, 1.0, "GT5.09", 200, 4.0, 2, true), new FuelRod(38, "quadFuelRodNaquadah", BundleHelper.getI18n("ComponentName.QuadFuelRodNaquadah"), TextureFactory.getImage("gt.Quad_Naquadahcell.png"), 100000.0, 1.0, "GT5.09", 400, 8.0, 4, true), new FuelRod(39, "fuelRodCoaxium", BundleHelper.getI18n("ComponentName.FuelRodCoaxium"), TextureFactory.getImage("coaxium_rod.png"), 20000.0, 1.0, "Coaxium", 100, 0.0, 1, false), new FuelRod(40, "dualFuelRodCoaxium", BundleHelper.getI18n("ComponentName.DualFuelRodCoaxium"), TextureFactory.getImage("coaxium_rod_dual.png"), 20000.0, 1.0, "Coaxium", 200, 0.0, 2, false), new FuelRod(41, "quadFuelRodCoaxium", BundleHelper.getI18n("ComponentName.QuadFuelRodCoaxium"), TextureFactory.getImage("coaxium_rod_quad.png"), 20000.0, 1.0, "Coaxium", 400, 0.0, 4, false), new FuelRod(42, "fuelRodCesium", BundleHelper.getI18n("ComponentName.FuelRodCesium"), TextureFactory.getImage("coaxium_rod.png"), 10861.0, 1.0, "Coaxium", 200, 1.0, 1, false), new FuelRod(43, "dualFuelRodCesium", BundleHelper.getI18n("ComponentName.DualFuelRodCesium"), TextureFactory.getImage("coaxium_rod_dual.png"), 10861.0, 1.0, "Coaxium", 400, 6.0, 2, false), new FuelRod(44, "quadFuelRodCesium", BundleHelper.getI18n("ComponentName.QuadFuelRodCesium"), TextureFactory.getImage("coaxium_rod_quad.png"), 10861.0, 1.0, "Coaxium", 800, 24.0, 4, false), new FuelRod(45, "fuelRodNaquadahGTNH", BundleHelper.getI18n("ComponentName.FuelRodNaquadahGTNH"), TextureFactory.getImage("gt.Naquadahcell.png"), 100000.0, 1.0, "GTNH", 100, 2.0, 1, false), new FuelRod(46, "dualFuelRodNaquadahGTNH", BundleHelper.getI18n("ComponentName.DualFuelRodNaquadahGTNH"), TextureFactory.getImage("gt.Double_Naquadahcell.png"), 100000.0, 1.0, "GTNH", 200, 4.0, 2, false), new FuelRod(47, "quadFuelRodNaquadahGTNH", BundleHelper.getI18n("ComponentName.QuadFuelRodNaquadahGTNH"), TextureFactory.getImage("gt.Quad_Naquadahcell.png"), 100000.0, 1.0, "GTNH", 400, 8.0, 4, false), new FuelRod(48, "fuelRodNaquadria", BundleHelper.getI18n("ComponentName.FuelRodNaquadria"), TextureFactory.getImage("gt.MNqCell.png"), 100000.0, 1.0, "GTNH", 100, 2.0, 1, true), new FuelRod(49, "dualFuelRodNaquadria", BundleHelper.getI18n("ComponentName.DualFuelRodNaquadria"), TextureFactory.getImage("gt.Double_MNqCell.png"), 100000.0, 1.0, "GTNH", 200, 4.0, 2, true), new FuelRod(50, "quadFuelRodNaquadria", BundleHelper.getI18n("ComponentName.QuadFuelRodNaquadria"), TextureFactory.getImage("gt.Quad_MNqCell.png"), 100000.0, 1.0, "GTNH", 400, 8.0, 4, true), new FuelRod(51, "fuelRodTiberium", BundleHelper.getI18n("ComponentName.FuelRodTiberium"), TextureFactory.getImage("gt.Tiberiumcell.png"), 50000.0, 1.0, "GTNH", 100, 1.0, 1, false), new FuelRod(52, "dualFuelRodTiberium", BundleHelper.getI18n("ComponentName.DualFuelRodTiberium"), TextureFactory.getImage("gt.Double_Tiberiumcell.png"), 50000.0, 1.0, "GTNH", 200, 2.0, 2, false), new FuelRod(53, "quadFuelRodTiberium", BundleHelper.getI18n("ComponentName.QuadFuelRodTiberium"), TextureFactory.getImage("gt.Quad_Tiberiumcell.png"), 50000.0, 1.0, "GTNH", 400, 4.0, 4, false), new FuelRod(54, "fuelRodTheCore", BundleHelper.getI18n("ComponentName.FuelRodTheCore"), TextureFactory.getImage("gt.Core_Reactor_Cell.png"), 100000.0, 1.0, "GTNH", 12800, 64.0, 32, false), new CoolantCell(55, "coolantCellSpace180k", BundleHelper.getI18n("ComponentName.CoolantCell180kSpace"), TextureFactory.getImage("gt.180k_Space_Coolantcell.png"), 1.0, 180000.0, "GTNH"), new CoolantCell(56, "coolantCellSpace360k", BundleHelper.getI18n("ComponentName.CoolantCell360kSpace"), TextureFactory.getImage("gt.360k_Space_Coolantcell.png"), 1.0, 360000.0, "GTNH"), new CoolantCell(57, "coolantCellSpace540k", BundleHelper.getI18n("ComponentName.CoolantCell540kSpace"), TextureFactory.getImage("gt.540k_Space_Coolantcell.png"), 1.0, 540000.0, "GTNH"), new CoolantCell(58, "coolantCellSpace1080k", BundleHelper.getI18n("ComponentName.CoolantCell1080kSpace"), TextureFactory.getImage("gt.1080k_Space_Coolantcell.png"), 1.0, 1080000.0, "GTNH"), new CoolantCell(59, "coolantCellNeutronium1G", BundleHelper.getI18n("ComponentName.CoolantCell1GNeutronium"), TextureFactory.getImage("gt.1g_Neutronium_Coolantcell.png"), 1.0, 1.0E9, "GT5.09"), new GGFuelRod(60, "fuelRodCompressedUranium", BundleHelper.getI18n("ComponentName.FuelRodCompressedUranium"), TextureFactory.getImage("gg.CompressedUranium.png"), 70000.0, 1.0, "GTNH", 400, 2.0, 1, false, 0), new GGFuelRod(61, "dualFuelRodCompressedUranium", BundleHelper.getI18n("ComponentName.DualFuelRodCompressedUranium"), TextureFactory.getImage("gg.Double_CompressedUranium.png"), 70000.0, 1.0, "GTNH", 800, 4.0, 2, false, 0), new GGFuelRod(62, "quadFuelRodCompressedUranium", BundleHelper.getI18n("ComponentName.QuadFuelRodCompressedUranium"), TextureFactory.getImage("gg.Quad_CompressedUranium.png"), 70000.0, 1.0, "GTNH", 1600, 8.0, 4, false, 0), new GGFuelRod(63, "fuelRodCompressedPlutonium", BundleHelper.getI18n("ComponentName.FuelRodCompressedPlutonium"), TextureFactory.getImage("gg.CompressedPlutonium.png"), 30000.0, 1.0, "GTNH", 200, 2.0, 1, false, 6), new GGFuelRod(64, "dualFuelRodCompressedPlutonium", BundleHelper.getI18n("ComponentName.DualFuelRodCompressedPlutonium"), TextureFactory.getImage("gg.Double_CompressedPlutonium.png"), 30000.0, 1.0, "GTNH", 400, 4.0, 2, false, 6), new GGFuelRod(65, "quadFuelRodCompressedPlutonium", BundleHelper.getI18n("ComponentName.QuadFuelRodCompressedPlutonium"), TextureFactory.getImage("gg.Quad_CompressedPlutonium.png"), 30000.0, 1.0, "GTNH", 800, 8.0, 4, false, 6), new GGFuelRod(66, "fuelRodLiquidUranium", BundleHelper.getI18n("ComponentName.FuelRodLiquidUranium"), TextureFactory.getImage("gg.LiquidUranium.png"), 6000.0, 1.0, "GTNH", 4800, 16.0, 1, false, 0), new GGFuelRod(67, "dualFuelRodLiquidUranium", BundleHelper.getI18n("ComponentName.DualFuelRodLiquidUranium"), TextureFactory.getImage("gg.Double_LiquidUranium.png"), 6000.0, 1.0, "GTNH", 9600, 32.0, 2, false, 0), new GGFuelRod(68, "quadFuelRodLiquidUranium", BundleHelper.getI18n("ComponentName.QuadFuelRodLiquidUranium"), TextureFactory.getImage("gg.Quad_LiquidUranium.png"), 6000.0, 1.0, "GTNH", 19200, 64.0, 4, false, 0), new GGFuelRod(69, "fuelRodLiquidPlutonium", BundleHelper.getI18n("ComponentName.FuelRodLiquidPlutonium"), TextureFactory.getImage("gg.LiquidPlutonium.png"), 10000.0, 1.0, "GTNH", 6400, 16.0, 1, false, 2), new GGFuelRod(70, "dualFuelRodLiquidPlutonium", BundleHelper.getI18n("ComponentName.DualFuelRodLiquidPlutonium"), TextureFactory.getImage("gg.Double_LiquidPlutonium.png"), 10000.0, 1.0, "GTNH", 12800, 32.0, 2, false, 2), new GGFuelRod(71, "quadFuelRodLiquidPlutonium", BundleHelper.getI18n("ComponentName.QuadFuelRodLiquidPlutonium"), TextureFactory.getImage("gg.Quad_LiquidPlutonium.png"), 10000.0, 1.0, "GTNH", 25600, 64.0, 4, false, 2), new BreederCell(72, "fuelRodGlowstone", BundleHelper.getI18n("ComponentName.FuelRodGlowstone"), TextureFactory.getImage("gt.GlowstoneCell.png"), 10000.0, 1.0, "GTNH", 3000, 1)};
    private static final Map<String, ReactorItem> ITEM_MAP = ComponentFactory.makeItemMap();

    private ComponentFactory() {
    }

    private static Map<String, ReactorItem> makeItemMap() {
        HashMap<String, ReactorItem> result = new HashMap<String, ReactorItem>((int)((double)ITEMS.length * 1.5));
        for (ReactorItem reactorItem : ITEMS) {
            if (reactorItem == null) continue;
            result.put(reactorItem.baseName, reactorItem);
        }
        return Collections.unmodifiableMap(result);
    }

    private static ReactorItem copy(ReactorItem source) {
        if (source != null) {
            Class<?> aClass = source.getClass();
            if (aClass == Condensator.class) {
                return new Condensator((Condensator)source);
            }
            if (aClass == CoolantCell.class) {
                return new CoolantCell((CoolantCell)source);
            }
            if (aClass == Exchanger.class) {
                return new Exchanger((Exchanger)source);
            }
            if (aClass == FuelRod.class) {
                return new FuelRod((FuelRod)source);
            }
            if (aClass == Plating.class) {
                return new Plating((Plating)source);
            }
            if (aClass == Reflector.class) {
                return new Reflector((Reflector)source);
            }
            if (aClass == Vent.class) {
                return new Vent((Vent)source);
            }
            if (aClass == GGFuelRod.class) {
                return new GGFuelRod((GGFuelRod)source);
            }
            if (aClass == BreederCell.class) {
                return new BreederCell((BreederCell)source);
            }
        }
        return null;
    }

    public static ReactorItem getDefaultComponent(int id) {
        if (id >= 0 && id < ITEMS.length) {
            return ITEMS[id];
        }
        return null;
    }

    public static ReactorItem getDefaultComponent(String name) {
        if (name != null) {
            return ITEM_MAP.get(name);
        }
        return null;
    }

    public static ReactorItem createComponent(int id) {
        if (id >= 0 && id < ITEMS.length) {
            return ComponentFactory.copy(ITEMS[id]);
        }
        return null;
    }

    public static ReactorItem createComponent(String name) {
        if (name != null) {
            return ComponentFactory.copy(ITEM_MAP.get(name));
        }
        return null;
    }

    public static int getComponentCount() {
        return ITEMS.length;
    }
}

