/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import Ic2ExpReactorPlanner.BundleHelper;
import Ic2ExpReactorPlanner.MaterialsList;
import Ic2ExpReactorPlanner.Reactor;
import Ic2ExpReactorPlanner.SimulationData;
import Ic2ExpReactorPlanner.components.BreederCell;
import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class AutomationSimulator
extends SwingWorker<Void, String> {
    private final Reactor reactor;
    private final JTextArea output;
    private final JPanel[][] reactorButtonPanels;
    private final boolean[][] alreadyBroken = new boolean[6][9];
    private final boolean[][] needsCooldown = new boolean[6][9];
    private final int initialHeat;
    private final File csvFile;
    private final int csvLimit;
    private double minEUoutput = Double.MAX_VALUE;
    private double maxEUoutput = 0.0;
    private double minHeatOutput = Double.MAX_VALUE;
    private double maxHeatOutput = 0.0;
    private final int onPulseDuration;
    private final int offPulseDuration;
    private final int clockPeriod;
    private final int suspendTemp;
    private final int resumeTemp;
    private final int maxSimulationTicks;
    private boolean reachedBelow50;
    private boolean reachedBurn;
    private boolean reachedEvaporate;
    private boolean reachedHurt;
    private boolean reachedLava;
    private boolean reachedExplode;
    private boolean allFuelRodsDepleted = false;
    private boolean componentsIntact = true;
    private boolean anyRodsDepleted = false;
    private int activeTime = 0;
    private int inactiveTime = 0;
    private int currentActiveTime = 0;
    private int minActiveTime = Integer.MAX_VALUE;
    private int maxActiveTime = 0;
    private int currentInactiveTime = 0;
    private int minInactiveTime = Integer.MAX_VALUE;
    private int maxInactiveTime = 0;
    private double totalHullHeating = 0.0;
    private double totalComponentHeating = 0.0;
    private double totalHullCooling = 0.0;
    private double totalVentCooling = 0.0;
    private boolean showHeatingCoolingCalled = false;
    private boolean active = true;
    private int pauseTimer = 0;
    private int redstoneUsed = 0;
    private int lapisUsed = 0;
    private final MaterialsList replacedItems = new MaterialsList();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(BundleHelper.getI18n("Simulation.DecimalFormat"));
    private boolean completed = false;
    private final SimulationData data = new SimulationData();

    public SimulationData getData() {
        if (this.completed) {
            return this.data;
        }
        return null;
    }

    public AutomationSimulator(Reactor reactor, JTextArea output, JPanel[][] reactorButtonPanels, File csvFile, int csvLimit) {
        this.reactor = reactor;
        this.output = output;
        this.reactorButtonPanels = reactorButtonPanels;
        this.initialHeat = (int)reactor.getCurrentHeat();
        this.onPulseDuration = reactor.getOnPulse();
        this.offPulseDuration = reactor.getOffPulse();
        this.clockPeriod = this.onPulseDuration + this.offPulseDuration;
        this.suspendTemp = reactor.getSuspendTemp();
        this.resumeTemp = reactor.getResumeTemp();
        this.csvFile = csvFile;
        this.csvLimit = csvLimit;
        this.maxSimulationTicks = reactor.getMaxSimulationTicks();
    }

    @Override
    protected Void doInBackground() throws Exception {
        long startTime;
        block96: {
            PrintWriter csvOut = null;
            if (this.csvFile != null) {
                try {
                    csvOut = new PrintWriter(this.csvFile);
                }
                catch (IOException ex) {
                    this.publish(BundleHelper.getI18n("Simulation.CSVOpenFailure"));
                }
            }
            startTime = System.nanoTime();
            int reactorTicks = 0;
            int cooldownTicks = 0;
            int totalRodCount = 0;
            try {
                ReactorItem component;
                int col;
                int row;
                if (csvOut != null) {
                    csvOut.print(BundleHelper.getI18n("CSVData.HeaderReactorTick"));
                    csvOut.print(BundleHelper.getI18n("CSVData.HeaderCoreHeat"));
                    if (this.reactor.isFluid()) {
                        csvOut.print(BundleHelper.getI18n("CSVData.HeaderHUOutput"));
                    } else {
                        csvOut.print(BundleHelper.getI18n("CSVData.HeaderEUOutput"));
                    }
                    for (int row2 = 0; row2 < 6; ++row2) {
                        for (int col2 = 0; col2 < 9; ++col2) {
                            ReactorItem component2 = this.reactor.getComponentAt(row2, col2);
                            if (component2 != null && (component2.getMaxHeat() > 1.0 || component2.getMaxDamage() > 1.0)) {
                                csvOut.printf(BundleHelper.getI18n("CSVData.HeaderComponentName"), component2.name, row2, col2);
                            }
                            if (component2 == null || !component2.producesOutput()) continue;
                            csvOut.printf(BundleHelper.getI18n("CSVData.HeaderComponentOutput"), component2.name, row2, col2);
                        }
                    }
                    csvOut.println();
                }
                this.publish("");
                this.publish(BundleHelper.getI18n("Simulation.Started"));
                this.reactor.setCurrentHeat(this.initialHeat);
                this.reactor.clearVentedHeat();
                double minReactorHeat = this.initialHeat;
                double maxReactorHeat = this.initialHeat;
                this.reachedBelow50 = false;
                this.reachedBurn = (double)this.initialHeat >= 0.4 * this.reactor.getMaxHeat();
                this.reachedEvaporate = (double)this.initialHeat >= 0.5 * this.reactor.getMaxHeat();
                this.reachedHurt = (double)this.initialHeat >= 0.7 * this.reactor.getMaxHeat();
                this.reachedLava = (double)this.initialHeat >= 0.85 * this.reactor.getMaxHeat();
                this.reachedExplode = false;
                for (int row3 = 0; row3 < 6; ++row3) {
                    for (int col3 = 0; col3 < 9; ++col3) {
                        ReactorItem component3 = this.reactor.getComponentAt(row3, col3);
                        if (component3 != null) {
                            component3.clearCurrentHeat();
                            component3.clearDamage();
                            totalRodCount += component3.getRodCount();
                        }
                        this.publish(String.format("R%dC%d:0xC0C0C0", row3, col3));
                    }
                }
                this.data.totalRodCount = totalRodCount;
                double lastEUoutput = 0.0;
                double totalEUoutput = 0.0;
                double lastHeatOutput = 0.0;
                double totalHeatOutput = 0.0;
                double maxGeneratedHeat = 0.0;
                this.allFuelRodsDepleted = false;
                this.componentsIntact = true;
                this.anyRodsDepleted = false;
                do {
                    ReactorItem component4;
                    int col4;
                    int row4;
                    ++reactorTicks;
                    this.reactor.clearEUOutput();
                    this.reactor.clearVentedHeat();
                    for (int row5 = 0; row5 < 6; ++row5) {
                        for (int col5 = 0; col5 < 9; ++col5) {
                            ReactorItem component5 = this.reactor.getComponentAt(row5, col5);
                            if (component5 == null) continue;
                            component5.preReactorTick();
                        }
                    }
                    if (this.active) {
                        this.allFuelRodsDepleted = true;
                    }
                    double generatedHeat = 0.0;
                    for (row4 = 0; row4 < 6; ++row4) {
                        for (col4 = 0; col4 < 9; ++col4) {
                            component4 = this.reactor.getComponentAt(row4, col4);
                            if (component4 == null || component4.isBroken()) continue;
                            if (this.allFuelRodsDepleted && component4.getRodCount() > 0) {
                                this.allFuelRodsDepleted = false;
                            }
                            if (this.active) {
                                generatedHeat += component4.generateHeat();
                            }
                            component4.dissipate();
                            component4.transfer();
                        }
                    }
                    maxReactorHeat = Math.max(this.reactor.getCurrentHeat(), maxReactorHeat);
                    minReactorHeat = Math.min(this.reactor.getCurrentHeat(), minReactorHeat);
                    this.checkReactorTemperature(reactorTicks);
                    maxGeneratedHeat = Math.max(generatedHeat, maxGeneratedHeat);
                    if (this.active) {
                        for (row4 = 0; row4 < 6; ++row4) {
                            for (col4 = 0; col4 < 9; ++col4) {
                                component4 = this.reactor.getComponentAt(row4, col4);
                                if (component4 == null || component4.isBroken()) continue;
                                component4.generateEnergy();
                            }
                        }
                    }
                    lastEUoutput = this.reactor.getCurrentEUoutput();
                    totalEUoutput += lastEUoutput;
                    lastHeatOutput = this.reactor.getVentedHeat();
                    totalHeatOutput += lastHeatOutput;
                    if (this.reactor.getCurrentHeat() <= this.reactor.getMaxHeat()) {
                        if (this.reactor.isPulsed() || this.reactor.isAutomated()) {
                            if (this.active) {
                                ++this.activeTime;
                                ++this.currentActiveTime;
                                if (this.reactor.isPulsed() && (this.reactor.getCurrentHeat() >= (double)this.suspendTemp || reactorTicks % this.clockPeriod >= this.onPulseDuration)) {
                                    this.active = false;
                                    this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                                    this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                                    this.currentActiveTime = 0;
                                }
                            } else {
                                ++this.inactiveTime;
                                ++this.currentInactiveTime;
                                if (this.reactor.isAutomated() && this.pauseTimer > 0) {
                                    --this.pauseTimer;
                                } else if (this.reactor.isPulsed() && this.reactor.getCurrentHeat() <= (double)this.resumeTemp && reactorTicks % this.clockPeriod < this.onPulseDuration) {
                                    this.active = true;
                                    this.minInactiveTime = Math.min(this.currentInactiveTime, this.minInactiveTime);
                                    this.maxInactiveTime = Math.max(this.currentInactiveTime, this.maxInactiveTime);
                                    this.currentInactiveTime = 0;
                                }
                            }
                        }
                        this.minEUoutput = Math.min(lastEUoutput, this.minEUoutput);
                        this.maxEUoutput = Math.max(lastEUoutput, this.maxEUoutput);
                        this.minHeatOutput = Math.min(lastHeatOutput, this.minHeatOutput);
                        this.maxHeatOutput = Math.max(lastHeatOutput, this.maxHeatOutput);
                    }
                    this.calculateHeatingCooling(reactorTicks);
                    this.handleAutomation(reactorTicks);
                    if (csvOut != null && reactorTicks <= this.csvLimit) {
                        csvOut.printf(BundleHelper.getI18n("CSVData.EntryReactorTick"), reactorTicks);
                        csvOut.printf(BundleHelper.getI18n("CSVData.EntryCoreHeat"), this.reactor.getCurrentHeat());
                        if (this.reactor.isFluid()) {
                            csvOut.printf(BundleHelper.getI18n("CSVData.EntryHUOutput"), this.reactor.getVentedHeat() * 40.0);
                        } else {
                            csvOut.printf(BundleHelper.getI18n("CSVData.EntryEUOutput"), this.reactor.getCurrentEUoutput());
                        }
                        for (row4 = 0; row4 < 6; ++row4) {
                            for (col4 = 0; col4 < 9; ++col4) {
                                component4 = this.reactor.getComponentAt(row4, col4);
                                if (component4 != null && (component4.getMaxHeat() > 1.0 || component4.getMaxDamage() > 1.0)) {
                                    double componentValue = component4.getCurrentDamage();
                                    if (component4.getMaxHeat() > 1.0) {
                                        componentValue = component4.getCurrentHeat();
                                    }
                                    csvOut.printf(BundleHelper.getI18n("CSVData.EntryComponentValue"), componentValue);
                                }
                                if (component4 == null || !component4.producesOutput()) continue;
                                csvOut.printf(BundleHelper.getI18n("CSVData.EntryComponentOutput"), component4.getCurrentOutput());
                            }
                        }
                        csvOut.println();
                    }
                    this.handleBrokenComponents(reactorTicks, totalHeatOutput, totalRodCount, totalEUoutput, minReactorHeat, maxReactorHeat);
                } while (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat() && (!this.allFuelRodsDepleted || lastEUoutput > 0.0 || lastHeatOutput > 0.0) && reactorTicks < this.maxSimulationTicks && !this.isCancelled());
                if (csvOut != null) {
                    csvOut.close();
                }
                if (this.isCancelled()) {
                    this.publish(BundleHelper.formatI18n("Simulation.CancelledAtTick", reactorTicks));
                    return null;
                }
                this.data.minTemp = minReactorHeat;
                this.data.maxTemp = maxReactorHeat;
                this.publish(BundleHelper.formatI18n("Simulation.ReactorMinTemp", minReactorHeat));
                this.publish(BundleHelper.formatI18n("Simulation.ReactorMaxTemp", maxReactorHeat));
                if (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat()) {
                    String replacedItemsString;
                    this.publish(BundleHelper.formatI18n("Simulation.TimeWithoutExploding", reactorTicks));
                    if (this.reactor.isPulsed()) {
                        String rangeString = "";
                        if (this.maxActiveTime > this.minActiveTime) {
                            rangeString = BundleHelper.formatI18n("Simulation.ActiveTimeRange", this.minActiveTime, this.maxActiveTime);
                        } else if (this.minActiveTime < this.activeTime) {
                            rangeString = BundleHelper.formatI18n("Simulation.ActiveTimeSingle", this.minActiveTime);
                        }
                        this.publish(BundleHelper.formatI18n("Simulation.ActiveTime", this.activeTime, rangeString));
                        rangeString = "";
                        if (this.maxInactiveTime > this.minInactiveTime) {
                            rangeString = BundleHelper.formatI18n("Simulation.InactiveTimeRange", this.minInactiveTime, this.maxInactiveTime);
                        } else if (this.minInactiveTime < this.inactiveTime) {
                            rangeString = BundleHelper.formatI18n("Simulation.InactiveTimeSingle", this.minInactiveTime);
                        }
                        this.publish(BundleHelper.formatI18n("Simulation.InactiveTime", this.inactiveTime, rangeString));
                    }
                    if (!(replacedItemsString = this.replacedItems.toString()).isEmpty()) {
                        this.data.replacedItems = new MaterialsList(this.replacedItems);
                        this.publish(BundleHelper.formatI18n("Simulation.ComponentsReplaced", replacedItemsString));
                    }
                    if (reactorTicks > 0) {
                        this.data.totalReactorTicks = reactorTicks;
                        if (this.reactor.isFluid()) {
                            this.data.totalHUoutput = 40.0 * totalHeatOutput;
                            this.data.avgHUoutput = 2.0 * totalHeatOutput / (double)reactorTicks;
                            this.data.minHUoutput = 2.0 * this.minHeatOutput;
                            this.data.maxHUoutput = 2.0 * this.maxHeatOutput;
                            if (totalHeatOutput > 0.0) {
                                this.publish(BundleHelper.formatI18n("Simulation.HeatOutputs", DECIMAL_FORMAT.format(40.0 * totalHeatOutput), DECIMAL_FORMAT.format(2.0 * totalHeatOutput / (double)reactorTicks), DECIMAL_FORMAT.format(2.0 * this.minHeatOutput), DECIMAL_FORMAT.format(2.0 * this.maxHeatOutput)));
                                if (totalRodCount > 0) {
                                    this.publish(BundleHelper.formatI18n("Simulation.Efficiency", totalHeatOutput / (double)reactorTicks / 4.0 / (double)totalRodCount, this.minHeatOutput / 4.0 / (double)totalRodCount, this.maxHeatOutput / 4.0 / (double)totalRodCount));
                                }
                            }
                        } else {
                            this.data.totalEUoutput = totalEUoutput;
                            this.data.avgEUoutput = totalEUoutput / (double)(reactorTicks * 20);
                            this.data.minEUoutput = this.minEUoutput / 20.0;
                            this.data.maxEUoutput = this.maxEUoutput / 20.0;
                            if (totalEUoutput > 0.0) {
                                this.publish(BundleHelper.formatI18n("Simulation.EUOutputs", DECIMAL_FORMAT.format(totalEUoutput), DECIMAL_FORMAT.format(totalEUoutput / (double)(reactorTicks * 20)), DECIMAL_FORMAT.format(this.minEUoutput / 20.0), DECIMAL_FORMAT.format(this.maxEUoutput / 20.0)));
                                if (totalRodCount > 0) {
                                    this.publish(BundleHelper.formatI18n("Simulation.Efficiency", totalEUoutput / (double)reactorTicks / 100.0 / (double)totalRodCount, this.minEUoutput / 100.0 / (double)totalRodCount, this.maxEUoutput / 100.0 / (double)totalRodCount));
                                }
                            }
                        }
                    }
                    if (this.reactor.getCurrentHeat() > 0.0) {
                        this.publish(BundleHelper.formatI18n("Simulation.ReactorRemainingHeat", this.reactor.getCurrentHeat()));
                    }
                    double prevReactorHeat = this.reactor.getCurrentHeat();
                    double prevTotalComponentHeat = 0.0;
                    for (int row6 = 0; row6 < 6; ++row6) {
                        for (int col6 = 0; col6 < 9; ++col6) {
                            ReactorItem component6 = this.reactor.getComponentAt(row6, col6);
                            if (component6 == null || component6.isBroken() || !(component6.getCurrentHeat() > 0.0)) continue;
                            prevTotalComponentHeat += component6.getCurrentHeat();
                            this.publish(String.format("R%dC%d:0xFFA500", row6, col6));
                            component6.info.append(BundleHelper.formatI18n("ComponentInfo.RemainingHeat", component6.getCurrentHeat()));
                        }
                    }
                    if (prevReactorHeat == 0.0 && prevTotalComponentHeat == 0.0) {
                        this.publish(BundleHelper.getI18n("Simulation.NoCooldown"));
                    } else if (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat()) {
                        double currentTotalComponentHeat = prevTotalComponentHeat;
                        int reactorCooldownTime = 0;
                        do {
                            this.reactor.clearVentedHeat();
                            prevReactorHeat = this.reactor.getCurrentHeat();
                            if (prevReactorHeat == 0.0) {
                                reactorCooldownTime = cooldownTicks;
                            }
                            prevTotalComponentHeat = currentTotalComponentHeat;
                            for (row = 0; row < 6; ++row) {
                                for (col = 0; col < 9; ++col) {
                                    component = this.reactor.getComponentAt(row, col);
                                    if (component == null || component.isBroken()) continue;
                                    component.dissipate();
                                    component.transfer();
                                }
                            }
                            lastHeatOutput = this.reactor.getVentedHeat();
                            totalHeatOutput += lastHeatOutput;
                            this.minEUoutput = Math.min(lastEUoutput, this.minEUoutput);
                            this.maxEUoutput = Math.max(lastEUoutput, this.maxEUoutput);
                            this.minHeatOutput = Math.min(lastHeatOutput, this.minHeatOutput);
                            this.maxHeatOutput = Math.max(lastHeatOutput, this.maxHeatOutput);
                            ++cooldownTicks;
                            currentTotalComponentHeat = 0.0;
                            for (row = 0; row < 6; ++row) {
                                for (col = 0; col < 9; ++col) {
                                    component = this.reactor.getComponentAt(row, col);
                                    if (component == null || component.isBroken()) continue;
                                    currentTotalComponentHeat += component.getCurrentHeat();
                                    if (component.getCurrentHeat() != 0.0 || !this.needsCooldown[row][col]) continue;
                                    component.info.append(BundleHelper.formatI18n("ComponentInfo.CooldownTime", cooldownTicks));
                                    this.needsCooldown[row][col] = false;
                                }
                            }
                        } while (lastHeatOutput > 0.0 && cooldownTicks < 50000);
                        if (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat()) {
                            if (this.reactor.getCurrentHeat() == 0.0) {
                                this.publish(BundleHelper.formatI18n("Simulation.ReactorCooldownTime", reactorCooldownTime));
                            } else if (reactorCooldownTime > 0) {
                                this.publish(BundleHelper.formatI18n("Simulation.ReactorResidualHeat", this.reactor.getCurrentHeat(), reactorCooldownTime));
                            }
                            this.publish(BundleHelper.formatI18n("Simulation.TotalCooldownTime", cooldownTicks));
                        }
                    }
                } else {
                    this.publish(BundleHelper.formatI18n("Simulation.ReactorOverheatedTime", reactorTicks));
                    double explosionPower = 10.0;
                    double explosionPowerMult = 1.0;
                    for (int row7 = 0; row7 < 6; ++row7) {
                        for (int col7 = 0; col7 < 9; ++col7) {
                            ReactorItem component7 = this.reactor.getComponentAt(row7, col7);
                            if (component7 == null) continue;
                            explosionPower += component7.getExplosionPowerOffset();
                            explosionPowerMult *= component7.getExplosionPowerMultiplier();
                        }
                    }
                    this.publish(BundleHelper.formatI18n("Simulation.ExplosionPower", explosionPower *= explosionPowerMult));
                }
                double totalEffectiveVentCooling = 0.0;
                double totalVentCoolingCapacity = 0.0;
                double totalCellCooling = 0.0;
                double totalCondensatorCooling = 0.0;
                for (row = 0; row < 6; ++row) {
                    for (col = 0; col < 9; ++col) {
                        component = this.reactor.getComponentAt(row, col);
                        if (component == null) continue;
                        if (component.getVentCoolingCapacity() > 0.0) {
                            component.info.append(BundleHelper.formatI18n("ComponentInfo.UsedCooling", component.getBestVentCooling(), component.getVentCoolingCapacity()));
                            totalEffectiveVentCooling += component.getBestVentCooling();
                            totalVentCoolingCapacity += component.getVentCoolingCapacity();
                        } else if (component.getBestCellCooling() > 0.0) {
                            component.info.append(BundleHelper.formatI18n("ComponentInfo.ReceivedHeat", component.getBestCellCooling()));
                            totalCellCooling += component.getBestCellCooling();
                        } else if (component.getBestCondensatorCooling() > 0.0) {
                            component.info.append(BundleHelper.formatI18n("ComponentInfo.ReceivedHeat", component.getBestCondensatorCooling()));
                            totalCondensatorCooling += component.getBestCondensatorCooling();
                        } else if (component.getMaxHeatGenerated() > 0.0) {
                            if (!this.reactor.isFluid() && component.getMaxEUGenerated() > 0.0) {
                                component.info.append(BundleHelper.formatI18n("ComponentInfo.GeneratedEU", component.getMinEUGenerated(), component.getMaxEUGenerated()));
                            }
                            component.info.append(BundleHelper.formatI18n("ComponentInfo.GeneratedHeat", component.getMinHeatGenerated(), component.getMaxHeatGenerated()));
                        } else if (component instanceof BreederCell) {
                            component.info.append(BundleHelper.formatI18n("ComponentInfo.BreederProgress", component.getCurrentDamage() > component.getMaxDamage() ? (int)component.getMaxDamage() : (int)component.getCurrentDamage(), (int)component.getMaxDamage()));
                        }
                        if (!(component.getMaxReachedHeat() > 0.0)) continue;
                        component.info.append(BundleHelper.formatI18n("ComponentInfo.ReachedHeat", component.getMaxReachedHeat(), component.getMaxHeat()));
                    }
                }
                this.showHeatingCooling(reactorTicks);
                if (totalCellCooling > 0.0) {
                    this.publish(BundleHelper.formatI18n("Simulation.TotalCellCooling", totalCellCooling));
                }
                if (totalCondensatorCooling > 0.0) {
                    this.publish(BundleHelper.formatI18n("Simulation.TotalCondensatorCooling", totalCondensatorCooling));
                }
                if (maxGeneratedHeat > 0.0) {
                    this.publish(BundleHelper.formatI18n("Simulation.MaxHeatGenerated", maxGeneratedHeat));
                }
                if (this.redstoneUsed > 0) {
                    this.publish(BundleHelper.formatI18n("Simulation.RedstoneUsed", this.redstoneUsed));
                }
                if (this.lapisUsed > 0) {
                    this.publish(BundleHelper.formatI18n("Simulation.LapisUsed", this.lapisUsed));
                }
            }
            catch (Throwable e) {
                if (cooldownTicks == 0) {
                    this.publish(BundleHelper.formatI18n("Simulation.ErrorReactor", reactorTicks));
                } else {
                    this.publish(BundleHelper.formatI18n("Simulation.ErrorCooldown", cooldownTicks));
                }
                this.publish(e.toString(), " ", Arrays.toString(e.getStackTrace()));
                if (csvOut == null) break block96;
                csvOut.close();
            }
        }
        long endTime = System.nanoTime();
        this.publish(BundleHelper.formatI18n("Simulation.ElapsedTime", (double)(endTime - startTime) / 1.0E9));
        this.completed = true;
        this.firePropertyChange("completed", null, true);
        return null;
    }

    private void handleBrokenComponents(int reactorTicks, double totalHeatOutput, int totalRodCount, double totalEUoutput, double minReactorHeat, double maxReactorHeat) {
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 9; ++col) {
                ReactorItem component = this.reactor.getComponentAt(row, col);
                if (component == null || !component.isBroken() || this.alreadyBroken[row][col]) continue;
                this.alreadyBroken[row][col] = true;
                if (component.getRodCount() == 0) {
                    this.publish(String.format("R%dC%d:0xFF0000", row, col));
                    component.info.append(BundleHelper.formatI18n("ComponentInfo.BrokeTime", reactorTicks));
                    if (this.componentsIntact) {
                        this.componentsIntact = false;
                        this.data.firstComponentBrokenTime = reactorTicks;
                        this.data.firstComponentBrokenRow = row;
                        this.data.firstComponentBrokenCol = col;
                        this.data.firstComponentBrokenDescription = component.toString();
                        this.publish(BundleHelper.formatI18n("Simulation.FirstComponentBrokenDetails", component.toString(), row, col, reactorTicks));
                        if (this.reactor.isFluid()) {
                            this.data.prebreakTotalHUoutput = 40.0 * totalHeatOutput;
                            this.data.prebreakAvgHUoutput = 2.0 * totalHeatOutput / (double)reactorTicks;
                            this.data.prebreakMinHUoutput = 2.0 * this.minHeatOutput;
                            this.data.prebreakMaxHUoutput = 2.0 * this.maxHeatOutput;
                            this.publish(BundleHelper.formatI18n("Simulation.HeatOutputsBeforeBreak", DECIMAL_FORMAT.format(40.0 * totalHeatOutput), DECIMAL_FORMAT.format(2.0 * totalHeatOutput / (double)reactorTicks), DECIMAL_FORMAT.format(2.0 * this.minHeatOutput), DECIMAL_FORMAT.format(2.0 * this.maxHeatOutput)));
                            if (totalRodCount > 0) {
                                this.publish(BundleHelper.formatI18n("Simulation.Efficiency", totalHeatOutput / (double)reactorTicks / 4.0 / (double)totalRodCount, this.minHeatOutput / 4.0 / (double)totalRodCount, this.maxHeatOutput / 4.0 / (double)totalRodCount));
                            }
                        } else {
                            this.data.prebreakTotalEUoutput = totalEUoutput;
                            this.data.prebreakAvgEUoutput = totalEUoutput / (double)(reactorTicks * 20);
                            this.data.prebreakMinEUoutput = this.minEUoutput / 20.0;
                            this.data.prebreakMaxEUoutput = this.maxEUoutput / 20.0;
                            this.publish(BundleHelper.formatI18n("Simulation.EUOutputsBeforeBreak", DECIMAL_FORMAT.format(totalEUoutput), DECIMAL_FORMAT.format(totalEUoutput / (double)(reactorTicks * 20)), DECIMAL_FORMAT.format(this.minEUoutput / 20.0), DECIMAL_FORMAT.format(this.maxEUoutput / 20.0)));
                            if (totalRodCount > 0) {
                                this.publish(BundleHelper.formatI18n("Simulation.Efficiency", totalEUoutput / (double)reactorTicks / 100.0 / (double)totalRodCount, this.minEUoutput / 100.0 / (double)totalRodCount, this.maxEUoutput / 100.0 / (double)totalRodCount));
                            }
                        }
                    }
                } else if (!this.anyRodsDepleted) {
                    this.anyRodsDepleted = true;
                    this.data.firstRodDepletedTime = reactorTicks;
                    this.data.firstRodDepletedRow = row;
                    this.data.firstRodDepletedCol = col;
                    this.data.firstRodDepletedDescription = component.toString();
                    this.publish(BundleHelper.formatI18n("Simulation.FirstRodDepletedDetails", component.toString(), row, col, reactorTicks));
                    if (this.reactor.isFluid()) {
                        this.data.predepleteTotalHUoutput = 40.0 * totalHeatOutput;
                        this.data.predepleteAvgHUoutput = 2.0 * totalHeatOutput / (double)reactorTicks;
                        this.data.predepleteMinHUoutput = 2.0 * this.minHeatOutput;
                        this.data.predepleteMaxHUoutput = 2.0 * this.maxHeatOutput;
                        this.publish(BundleHelper.formatI18n("Simulation.HeatOutputsBeforeDepleted", DECIMAL_FORMAT.format(40.0 * totalHeatOutput), DECIMAL_FORMAT.format(2.0 * totalHeatOutput / (double)reactorTicks), DECIMAL_FORMAT.format(2.0 * this.minHeatOutput), DECIMAL_FORMAT.format(2.0 * this.maxHeatOutput)));
                        if (totalRodCount > 0) {
                            this.publish(BundleHelper.formatI18n("Simulation.Efficiency", totalHeatOutput / (double)reactorTicks / 4.0 / (double)totalRodCount, this.minHeatOutput / 4.0 / (double)totalRodCount, this.maxHeatOutput / 4.0 / (double)totalRodCount));
                        }
                    } else {
                        this.data.predepleteTotalEUoutput = totalEUoutput;
                        this.data.predepleteAvgEUoutput = totalEUoutput / (double)(reactorTicks * 20);
                        this.data.predepleteMinEUoutput = this.minEUoutput / 20.0;
                        this.data.predepleteMaxEUoutput = this.maxEUoutput / 20.0;
                        this.publish(BundleHelper.formatI18n("Simulation.EUOutputsBeforeDepleted", DECIMAL_FORMAT.format(totalEUoutput), DECIMAL_FORMAT.format(totalEUoutput / (double)(reactorTicks * 20)), DECIMAL_FORMAT.format(this.minEUoutput / 20.0), DECIMAL_FORMAT.format(this.maxEUoutput / 20.0)));
                        if (totalRodCount > 0) {
                            this.publish(BundleHelper.formatI18n("Simulation.Efficiency", totalEUoutput / (double)reactorTicks / 100.0 / (double)totalRodCount, this.minEUoutput / 100.0 / (double)totalRodCount, this.maxEUoutput / 100.0 / (double)totalRodCount));
                        }
                    }
                    this.data.predepleteMinTemp = minReactorHeat;
                    this.data.predepleteMaxTemp = maxReactorHeat;
                    this.publish(BundleHelper.formatI18n("Simulation.ReactorMinTempBeforeDepleted", minReactorHeat));
                    this.publish(BundleHelper.formatI18n("Simulation.ReactorMaxTempBeforeDepleted", maxReactorHeat));
                }
                this.showHeatingCooling(reactorTicks);
            }
        }
    }

    private void handleAutomation(int reactorTicks) {
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 9; ++col) {
                ReactorItem component = this.reactor.getComponentAt(row, col);
                if (component != null && this.reactor.isAutomated()) {
                    if (component.getMaxHeat() > 1.0) {
                        if ((double)component.getAutomationThreshold() > component.getInitialHeat() && component.getCurrentHeat() >= (double)component.getAutomationThreshold()) {
                            component.clearCurrentHeat();
                            this.replacedItems.add(component.name);
                            component.info.append(BundleHelper.formatI18n("ComponentInfo.ReplacedTime", reactorTicks));
                            if (component.getReactorPause() > 0) {
                                this.active = false;
                                this.pauseTimer = Math.max(this.pauseTimer, component.getReactorPause());
                                this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                                this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                                this.currentActiveTime = 0;
                            }
                        } else if ((double)component.getAutomationThreshold() < component.getInitialHeat() && component.getCurrentHeat() <= (double)component.getAutomationThreshold()) {
                            component.clearCurrentHeat();
                            this.replacedItems.add(component.name);
                            component.info.append(BundleHelper.formatI18n("ComponentInfo.ReplacedTime", reactorTicks));
                            if (component.getReactorPause() > 0) {
                                this.active = false;
                                this.pauseTimer = Math.max(this.pauseTimer, component.getReactorPause());
                                this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                                this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                                this.currentActiveTime = 0;
                            }
                        }
                    } else if (component.isBroken() || component.getMaxDamage() > 1.0 && component.getCurrentDamage() >= (double)component.getAutomationThreshold()) {
                        component.clearDamage();
                        this.replacedItems.add(component.name);
                        component.info.append(BundleHelper.formatI18n("ComponentInfo.ReplacedTime", reactorTicks));
                        if (component.getReactorPause() > 0) {
                            this.active = false;
                            this.pauseTimer = Math.max(this.pauseTimer, component.getReactorPause());
                            this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                            this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                            this.currentActiveTime = 0;
                        }
                    }
                }
                if (!this.reactor.isUsingReactorCoolantInjectors() || component == null || !component.needsCoolantInjected()) continue;
                component.injectCoolant();
                if ("rshCondensator".equals(component.baseName)) {
                    ++this.redstoneUsed;
                    continue;
                }
                if (!"lzhCondensator".equals(component.baseName)) continue;
                ++this.lapisUsed;
            }
        }
    }

    private void checkReactorTemperature(int reactorTicks) {
        if (this.reactor.getCurrentHeat() < 0.5 * this.reactor.getMaxHeat() && !this.reachedBelow50 && this.reachedEvaporate) {
            this.publish(BundleHelper.formatI18n("Simulation.TimeToBelow50", reactorTicks));
            this.reachedBelow50 = true;
            this.data.timeToBelow50 = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.4 * this.reactor.getMaxHeat() && !this.reachedBurn) {
            this.publish(BundleHelper.formatI18n("Simulation.TimeToBurn", reactorTicks));
            this.reachedBurn = true;
            this.data.timeToBurn = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.5 * this.reactor.getMaxHeat() && !this.reachedEvaporate) {
            this.publish(BundleHelper.formatI18n("Simulation.TimeToEvaporate", reactorTicks));
            this.reachedEvaporate = true;
            this.data.timeToEvaporate = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.7 * this.reactor.getMaxHeat() && !this.reachedHurt) {
            this.publish(BundleHelper.formatI18n("Simulation.TimeToHurt", reactorTicks));
            this.reachedHurt = true;
            this.data.timeToHurt = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.85 * this.reactor.getMaxHeat() && !this.reachedLava) {
            this.publish(BundleHelper.formatI18n("Simulation.TimeToLava", reactorTicks));
            this.reachedLava = true;
            this.data.timeToLava = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= this.reactor.getMaxHeat() && !this.reachedExplode) {
            this.publish(BundleHelper.formatI18n("Simulation.TimeToXplode", reactorTicks));
            this.reachedExplode = true;
            this.data.timeToXplode = reactorTicks;
        }
    }

    private void calculateHeatingCooling(int reactorTicks) {
        if (reactorTicks > 20) {
            for (int row = 0; row < 6; ++row) {
                for (int col = 0; col < 9; ++col) {
                    ReactorItem component = this.reactor.getComponentAt(row, col);
                    if (component == null) continue;
                    this.totalHullHeating += component.getCurrentHullHeating();
                    this.totalComponentHeating += component.getCurrentComponentHeating();
                    this.totalHullCooling += component.getCurrentHullCooling();
                    this.totalVentCooling += component.getCurrentVentCooling();
                }
            }
        }
    }

    private void showHeatingCooling(int reactorTicks) {
        if (!this.showHeatingCoolingCalled) {
            this.showHeatingCoolingCalled = true;
            if (reactorTicks >= 40) {
                double totalHullCoolingCapacity = 0.0;
                double totalVentCoolingCapacity = 0.0;
                for (int row = 0; row < 6; ++row) {
                    for (int col = 0; col < 9; ++col) {
                        ReactorItem component = this.reactor.getComponentAt(row, col);
                        if (component == null) continue;
                        totalHullCoolingCapacity += component.getHullCoolingCapacity();
                        totalVentCoolingCapacity += component.getVentCoolingCapacity();
                    }
                }
                this.data.hullHeating = this.totalHullHeating / (double)(reactorTicks - 20);
                this.data.componentHeating = this.totalComponentHeating / (double)(reactorTicks - 20);
                this.data.hullCooling = this.totalHullCooling / (double)(reactorTicks - 20);
                this.data.hullCoolingCapacity = totalHullCoolingCapacity;
                this.data.ventCooling = this.totalVentCooling / (double)(reactorTicks - 20);
                this.data.ventCoolingCapacity = totalVentCoolingCapacity;
                if (this.totalHullHeating > 0.0) {
                    this.publish(BundleHelper.formatI18n("Simulation.HullHeating", this.totalHullHeating / (double)(reactorTicks - 20)));
                }
                if (this.totalComponentHeating > 0.0) {
                    this.publish(BundleHelper.formatI18n("Simulation.ComponentHeating", this.totalComponentHeating / (double)(reactorTicks - 20)));
                }
                if (totalHullCoolingCapacity > 0.0) {
                    this.publish(BundleHelper.formatI18n("Simulation.HullCooling", this.totalHullCooling / (double)(reactorTicks - 20), totalHullCoolingCapacity));
                }
                if (totalVentCoolingCapacity > 0.0) {
                    this.publish(BundleHelper.formatI18n("Simulation.VentCooling", this.totalVentCooling / (double)(reactorTicks - 20), totalVentCoolingCapacity));
                }
            }
        }
    }

    @Override
    protected void process(List<String> chunks) {
        for (String chunk : chunks) {
            if (chunk.isEmpty()) {
                this.output.setText("");
                continue;
            }
            if (chunk.matches("R\\dC\\d:.*")) {
                String temp = chunk.substring(5);
                int row = chunk.charAt(1) - 48;
                int col = chunk.charAt(3) - 48;
                if (!temp.startsWith("0x")) continue;
                this.reactorButtonPanels[row][col].setBackground(Color.decode(temp));
                if ("0xC0C0C0".equals(temp)) {
                    this.reactorButtonPanels[row][col].setToolTipText(null);
                    continue;
                }
                if ("0xFF0000".equals(temp)) {
                    this.reactorButtonPanels[row][col].setToolTipText(BundleHelper.getI18n("ComponentTooltip.Broken"));
                    continue;
                }
                if (!"0xFFA500".equals(temp)) continue;
                this.reactorButtonPanels[row][col].setToolTipText(BundleHelper.getI18n("ComponentTooltip.ResidualHeat"));
                continue;
            }
            this.output.append(chunk);
        }
    }
}

