/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking.voiceservers.udp;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.ServerStreamManager;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;
import net.gliby.voicechat.common.networking.voiceservers.VoiceAuthenticatedServer;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPClient;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPPacket;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPServerChunkVoicePacket;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPServerEntityPositionPacket;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPServerVoiceEndPacket;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPServerVoicePacket;
import net.gliby.voicechat.common.networking.voiceservers.udp.UDPVoiceServerHandler;
import net.gliby.voicechat.common.networking.voiceservers.udp.UdpServer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;

public class UDPVoiceServer
extends VoiceAuthenticatedServer {
    public static volatile boolean running;
    private final VoiceChatServer voiceChat;
    private final ServerStreamManager manager;
    private UDPVoiceServerHandler handler;
    public Map<Integer, UDPClient> clientMap;
    private UdpServer server;
    ByteArrayDataOutput packetBuffer = ByteStreams.newDataOutput();

    public UDPVoiceServer(VoiceChatServer voiceChat) {
        this.voiceChat = voiceChat;
        this.manager = voiceChat.getServerNetwork().getDataManager();
    }

    @Override
    public void closeConnection(int id) {
        UDPClient client = this.clientMap.get(id);
        if (client != null) {
            this.handler.closeConnection(client.socketAddress);
        }
        this.clientMap.remove(id);
    }

    @Override
    public EnumVoiceNetworkType getType() {
        return EnumVoiceNetworkType.UDP;
    }

    @Override
    public void handleVoiceData(EntityPlayerMP player, byte[] data, byte divider, int id, boolean end) {
        this.manager.addQueue(player, data, divider, id, end);
    }

    @Override
    public void sendChunkVoiceData(EntityPlayerMP player, int entityID, boolean direct, byte[] samples, byte chunkSize, byte volume) {
        UDPClient client = this.clientMap.get(player.func_145782_y());
        if (client != null) {
            this.sendPacket(new UDPServerChunkVoicePacket(samples, entityID, direct, chunkSize, volume), client);
        }
    }

    @Override
    public void sendEntityPosition(EntityPlayerMP player, int entityID, double x, double y, double z) {
        UDPClient client = this.clientMap.get(player.func_145782_y());
        if (client != null) {
            this.sendPacket(new UDPServerEntityPositionPacket(entityID, x, y, z), client);
        }
    }

    public void sendPacket(UDPPacket packet, UDPClient client) {
        this.packetBuffer.writeByte((int)packet.id());
        packet.write(this.packetBuffer);
        byte[] data = this.packetBuffer.toByteArray();
        try {
            this.server.send(new DatagramPacket(data, data.length, client.socketAddress));
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.packetBuffer = ByteStreams.newDataOutput();
    }

    @Override
    public void sendVoiceData(EntityPlayerMP player, int entityID, boolean global, byte[] samples, byte volume) {
        UDPClient client = this.clientMap.get(player.func_145782_y());
        if (client != null) {
            this.sendPacket(new UDPServerVoicePacket(samples, entityID, global, volume), client);
        }
    }

    @Override
    public void sendVoiceEnd(EntityPlayerMP player, int entityID) {
        UDPClient client = this.clientMap.get(player.func_145782_y());
        if (client != null) {
            this.sendPacket(new UDPServerVoiceEndPacket(entityID), client);
        }
    }

    @Override
    public boolean start() {
        this.clientMap = new HashMap<Integer, UDPClient>();
        this.handler = new UDPVoiceServerHandler(this);
        MinecraftServer mc = MinecraftServer.func_71276_C();
        this.server = mc.func_71262_S() ? (StringUtils.func_151246_b((String)mc.func_71211_k()) ? new UdpServer(VoiceChatServer.getLogger(), this.voiceChat.getServerSettings().getUDPPort()) : new UdpServer(VoiceChatServer.getLogger(), mc.func_71211_k(), this.voiceChat.getServerSettings().getUDPPort())) : new UdpServer(VoiceChatServer.getLogger(), this.voiceChat.getServerSettings().getUDPPort());
        this.server.addUdpServerListener(new UdpServer.Listener(){

            @Override
            public void packetReceived(UdpServer.Event evt) {
                try {
                    UDPVoiceServer.this.handler.read(evt.getPacketAsBytes(), evt.getPacket());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.server.start();
        return true;
    }

    @Override
    public void stop() {
        running = false;
        this.handler.close();
        this.server.clearUdpListeners();
        this.server.stop();
        this.clientMap.clear();
        this.handler = null;
        this.server = null;
    }
}

