/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui.options;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.gui.GuiBoostSlider;
import net.gliby.voicechat.client.gui.GuiCustomButton;
import net.gliby.voicechat.client.gui.GuiDropDownMenu;
import net.gliby.voicechat.client.keybindings.EnumBinding;
import net.gliby.voicechat.client.sound.MicrophoneTester;
import net.gliby.voicechat.client.textures.IndependentGUITexture;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiScreenOptionsWizard
extends GuiScreen {
    private final VoiceChatClient voiceChat;
    private final GuiScreen parent;
    private boolean dirty;
    private String[] textBatch;
    private GuiDropDownMenu dropDown;
    private final MicrophoneTester tester;
    private GuiCustomButton nextButton;
    private GuiCustomButton previousButton;
    private GuiCustomButton doneButton;
    private GuiCustomButton backButton;
    private GuiBoostSlider boostSlider;
    private final Map<GuiButton, Integer> buttonMap = new HashMap<GuiButton, Integer>();
    private int currentPage = 1;
    private int lastPage = -1;
    private final int maxPages = 4;
    String title = "Voice Chat Setup Wizard.";
    String text = "";

    public GuiScreenOptionsWizard(VoiceChatClient voiceChat, GuiScreen parent) {
        this.voiceChat = voiceChat;
        this.parent = parent;
        this.tester = new MicrophoneTester(voiceChat);
    }

    public void func_146284_a(GuiButton button) {
        if ((button == this.nextButton || button == this.previousButton || this.doneButton == button || this.buttonMap.get(button) != null && this.buttonMap.get(button) == this.currentPage) && !this.dropDown.dropDownMenu) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.currentPage >= 4) break;
                    ++this.currentPage;
                    break;
                }
                case 1: {
                    if (this.currentPage < 2) break;
                    --this.currentPage;
                    break;
                }
                case 2: {
                    if (this.currentPage != 4) break;
                    this.voiceChat.getSettings().setSetupNeeded(false);
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 3: {
                    this.voiceChat.getSettings().setSetupNeeded(false);
                    this.field_146297_k.func_147108_a(this.parent);
                }
            }
        }
    }

    public void drawPage(int x, int y, float tick) {
        if (this.tester.recording && this.currentPage != 3) {
            this.tester.stop();
        }
        if (this.currentPage != 2 && this.dropDown.dropDownMenu) {
            this.dropDown.dropDownMenu = false;
        }
        if (!this.text.equals(this.textBatch[this.currentPage - 1])) {
            this.text = this.textBatch[this.currentPage - 1];
        }
        switch (this.currentPage) {
            case 1: {
                this.title = "Gliby's Voice Chat " + I18n.func_135052_a((String)"menu.setupWizard", (Object[])new Object[0]);
                break;
            }
            case 2: {
                this.title = I18n.func_135052_a((String)"menu.selectInputDevice", (Object[])new Object[0]);
                this.dropDown.func_146112_a(this.field_146297_k, x, y);
                break;
            }
            case 3: {
                if (this.lastPage != this.currentPage) {
                    this.tester.start();
                }
                this.title = I18n.func_135052_a((String)"menu.adjustMicrophone", (Object[])new Object[0]);
                IndependentGUITexture.GUI_WIZARD.bindTexture(this.field_146297_k);
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDisable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)(this.field_146294_l / 2) - 39.75f), (float)((float)(this.field_146295_m / 2) - 67.5f), (float)0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)0.0f);
                IndependentGUITexture.GUI_WIZARD.bindTexture(this.field_146297_k);
                this.func_73729_b(0, 0, 0, 127, 35, 20);
                float progress = this.tester.currentAmplitude;
                float procent = progress / 3.164557f;
                this.drawTexturedModalRect(3.35f, 0.0f, 35.0f, 127.0f, procent, 20.0f);
                GL11.glEnable((int)3008);
                GL11.glPopMatrix();
                String ratingText = I18n.func_135052_a((String)"menu.boostVoiceVolume", (Object[])new Object[0]);
                this.func_73732_a(this.field_146289_q, ratingText, this.field_146294_l / 2, this.field_146295_m / 2 - 26, -1);
                break;
            }
            case 4: {
                this.title = I18n.func_135052_a((String)"menu.finishWizard", (Object[])new Object[0]);
            }
        }
        this.lastPage = this.currentPage;
    }

    public void func_73863_a(int x, int y, float tick) {
        this.func_146276_q_();
        IndependentGUITexture.GUI_WIZARD.bindTexture(this.field_146297_k);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(this.field_146294_l / 2) - 142.5f), (float)((float)(this.field_146295_m / 2) - 94.5f), (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, 190, 127);
        GL11.glPopMatrix();
        this.func_73731_b(this.field_146297_k.field_71466_p, this.currentPage + "/" + 4, this.field_146294_l / 2 + 108, this.field_146295_m / 2 + 67, -1);
        if (this.title != null) {
            this.func_73731_b(this.field_146297_k.field_71466_p, EnumChatFormatting.BOLD + this.title, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(this.title) / 2 - 12, this.field_146295_m / 2 - 80, -1);
        }
        if (this.text != null) {
            this.field_146289_q.func_78279_b(EnumChatFormatting.func_110646_a((String)this.text), this.field_146294_l / 2 - 107 - 1 + 1, this.field_146295_m / 2 - 65 + 1, 230, 0);
            this.field_146289_q.func_78279_b(this.text, this.field_146294_l / 2 - 107 - 1, this.field_146295_m / 2 - 65, 230, -1);
        }
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            if (guibutton != this.nextButton && guibutton != this.previousButton && guibutton != this.doneButton && (this.buttonMap.get(guibutton) == null || this.buttonMap.get(guibutton) != this.currentPage)) continue;
            guibutton.func_146112_a(this.field_146297_k, x, y);
        }
        this.drawPage(x, y, tick);
    }

    public void drawTexturedModalRect(float par1, float par2, float par3, float par4, float par5, float par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + par6), (double)this.field_73735_i, (double)((par3 + 0.0f) * 0.00390625f), (double)((par4 + par6) * 0.00390625f));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)this.field_73735_i, (double)((par3 + par5) * 0.00390625f), (double)((par4 + par6) * 0.00390625f));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + par5) * 0.00390625f), (double)((par4 + 0.0f) * 0.00390625f));
        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + 0.0f) * 0.00390625f), (double)((par4 + 0.0f) * 0.00390625f));
        tessellator.func_78381_a();
    }

    public void func_73866_w_() {
        String[] array = new String[this.voiceChat.getSettings().getDeviceHandler().getDevices().size()];
        for (int i = 0; i < this.voiceChat.getSettings().getDeviceHandler().getDevices().size(); ++i) {
            array[i] = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(i).getName();
        }
        this.dropDown = new GuiDropDownMenu(-1, this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 55, 150, 20, this.voiceChat.getSettings().getInputDevice() != null ? this.voiceChat.getSettings().getInputDevice().getName() : "None", array);
        this.nextButton = new GuiCustomButton(0, this.field_146294_l / 2 - 90, this.field_146295_m / 2 + 60, 180, 20, I18n.func_135052_a((String)"menu.next", (Object[])new Object[0]) + " ->");
        this.field_146292_n.add(this.nextButton);
        this.previousButton = new GuiCustomButton(1, this.field_146294_l / 2 - 90, this.field_146295_m / 2, 180, 20, "<- " + I18n.func_135052_a((String)"menu.previous", (Object[])new Object[0]));
        this.field_146292_n.add(this.previousButton);
        this.doneButton = new GuiCustomButton(2, this.field_146294_l / 2 - 90, this.field_146295_m / 2, 180, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.doneButton);
        this.backButton = new GuiCustomButton(3, this.field_146294_l / 2 - 90, this.field_146295_m / 2 + 18, 180, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]));
        this.field_146292_n.add(this.backButton);
        this.boostSlider = new GuiBoostSlider(900, this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 15, "", I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : "" + (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"), 0.0f);
        this.field_146292_n.add(this.boostSlider);
        this.boostSlider.sliderValue = this.voiceChat.getSettings().getInputBoost();
        this.doneButton.field_146125_m = false;
        this.buttonMap.put(this.backButton, 1);
        this.buttonMap.put(this.boostSlider, 3);
        this.dirty = true;
        this.textBatch = new String[]{I18n.func_135052_a((String)"menu.setupWizardPageOne", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n").replaceAll(Pattern.quote("$a"), this.voiceChat.keyManager.getKeyName(EnumBinding.OPEN_GUI_OPTIONS)), I18n.func_135052_a((String)"menu.setupWizardPageTwo", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n"), I18n.func_135052_a((String)"menu.setupWizardPageThree", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n"), I18n.func_135052_a((String)"menu.setupWizardPageFour", (Object[])new Object[0]).replaceAll(Pattern.quote("$n"), "\n").replaceAll(Pattern.quote("$a"), this.voiceChat.keyManager.getKeyName(EnumBinding.OPEN_GUI_OPTIONS)).replaceAll(Pattern.quote("$b"), this.voiceChat.keyManager.getKeyName(EnumBinding.SPEAK))};
    }

    public void func_73864_a(int x, int y, int b) {
        if (this.currentPage == 2) {
            Device device;
            if (this.dropDown.getMouseOverInteger() != -1 && this.dropDown.dropDownMenu && !this.voiceChat.getSettings().getDeviceHandler().isEmpty() && (device = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(this.dropDown.getMouseOverInteger())) != null) {
                this.voiceChat.getSettings().setInputDevice(device);
                this.dropDown.setDisplayString(device.getName());
            }
            if (this.dropDown.func_146116_c(this.field_146297_k, x, y) && b == 0) {
                this.dropDown.func_146113_a(this.field_146297_k.func_147118_V());
                boolean bl = this.dropDown.dropDownMenu = !this.dropDown.dropDownMenu;
            }
        }
        if (b == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (guibutton != this.nextButton && guibutton != this.previousButton && this.doneButton != guibutton && (this.buttonMap.get(guibutton) == null || this.buttonMap.get(guibutton) != this.currentPage) || !guibutton.func_146116_c(this.field_146297_k, x, y)) continue;
                super.func_73864_a(x, y, b);
            }
        }
    }

    public void func_146281_b() {
        if (this.tester.recording) {
            this.tester.stop();
        }
        this.voiceChat.getSettings().getConfiguration().save();
    }

    public void func_73876_c() {
        this.boostSlider.setDisplayString(I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : "" + (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"));
        this.voiceChat.getSettings().setInputBoost(this.boostSlider.sliderValue);
        if (this.lastPage != this.currentPage || this.dirty) {
            if (this.currentPage == 1) {
                this.previousButton.field_146125_m = false;
                this.doneButton.field_146125_m = false;
                this.nextButton.field_146128_h = this.field_146294_l / 2 - 90;
                this.nextButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.nextButton.setWidth(180);
                this.nextButton.setHeight(20);
            } else if (this.currentPage == 2) {
                this.previousButton.field_146125_m = false;
                this.doneButton.field_146125_m = false;
                this.nextButton.field_146128_h = this.field_146294_l / 2 - 90;
                this.nextButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.nextButton.setWidth(180);
                this.nextButton.setHeight(20);
            } else if (this.currentPage == 4) {
                this.nextButton.field_146125_m = false;
                this.doneButton.field_146125_m = true;
                this.doneButton.field_146128_h = this.field_146294_l / 2;
                this.doneButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.doneButton.setWidth(95);
                this.doneButton.setHeight(20);
                this.previousButton.field_146128_h = this.field_146294_l / 2 - 95;
                this.previousButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.previousButton.setWidth(95);
                this.previousButton.setHeight(20);
            } else {
                this.previousButton.field_146125_m = true;
                this.nextButton.field_146125_m = true;
                this.doneButton.field_146125_m = false;
                this.nextButton.field_146128_h = this.field_146294_l / 2;
                this.nextButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.nextButton.setWidth(95);
                this.nextButton.setHeight(20);
                this.previousButton.field_146128_h = this.field_146294_l / 2 - 95;
                this.previousButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.previousButton.setWidth(95);
                this.previousButton.setHeight(20);
            }
            this.dirty = false;
        }
    }
}

