/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import net.gliby.gman.JINIFile;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.Settings;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.device.DeviceHandler;
import net.gliby.voicechat.client.gui.EnumUIPlacement;

@SideOnly(value=Side.CLIENT)
public class Configuration {
    private static final String VOLUME_CONTROL = "VolumeControl";
    private static final String INPUT_DEVICE = "InputDevice";
    private static final String WORLD_VOLUME = "WorldVolume";
    private static final String INPUT_BOOST = "InputBoost";
    private static final String SPEAK_MODE = "SpeakMode";
    private static final String ENCODING_QUALITY = "EncodingQuality";
    private static final String ENCODING_MODE = "EncodingMode";
    private static final String DECODING_ENCHANTMENT = "EnhancedDecoding";
    private static final String UI_OPACITY = "UIOpacity";
    private static final String UI_POSITION_PLATE = "UIPositionPlate";
    private static final String UI_POSITION_SPEAK = "UIPositionSpeak";
    private static final String VERSION = "LastVersion";
    private static final String DEBUG = "Debug";
    private static final String SNOOPER = "GlibysSnooper";
    private static final String MODPACK_ID = "ModPackID";
    private final File location;
    private JINIFile init;
    private final Settings settings;

    Configuration(Settings settings, File file) {
        this.settings = settings;
        this.location = file;
    }

    void init(DeviceHandler deviceHandler) {
        if (!this.load(deviceHandler)) {
            VoiceChat.getLogger().info("No Configuration file found, will create one with default settings.");
            this.settings.setSetupNeeded(true);
            if (this.save()) {
                VoiceChat.getLogger().info("Created Configuration file with default settings.");
            }
        }
    }

    private boolean load(DeviceHandler handler) {
        try {
            if (this.location.exists()) {
                this.init = new JINIFile(this.location);
                this.settings.setVolumeControl(this.init.ReadBool("Game", VOLUME_CONTROL, true));
                Device defaultDevice = handler.getDefaultDevice();
                if (defaultDevice != null) {
                    this.settings.setInputDevice(handler.getDeviceByName(this.init.ReadString("Audio", INPUT_DEVICE, defaultDevice.getName())));
                }
                this.settings.setWorldVolume(this.init.ReadFloat("Audio", WORLD_VOLUME, Float.valueOf(1.0f)).floatValue());
                this.settings.setInputBoost(this.init.ReadFloat("Audio", INPUT_BOOST, Float.valueOf(1.0f)).floatValue());
                this.settings.setSpeakMode(this.init.ReadFloat("Audio", SPEAK_MODE, Float.valueOf(0.0f)).intValue());
                this.settings.setEncodingQuality(this.init.ReadFloat("AdvancedAudio", ENCODING_QUALITY, Float.valueOf(1.0f)).floatValue());
                this.settings.setEncodingMode(this.init.ReadFloat("AdvancedAudio", ENCODING_MODE, Float.valueOf(1.0f)).intValue());
                this.settings.setPerceptualEnchantment(this.init.ReadBool("AdvancedAudio", DECODING_ENCHANTMENT, true));
                this.settings.setUIOpacity(this.init.ReadFloat("Interface", UI_OPACITY, Float.valueOf(1.0f)).floatValue());
                String[] positionArray = this.init.ReadString("Interface", UI_POSITION_SPEAK, this.settings.getUIPositionSpeak().x + ":" + this.settings.getUIPositionSpeak().y + ":" + this.settings.getUIPositionSpeak().type + ":" + this.settings.getUIPositionSpeak().scale).split(":");
                this.settings.setUIPosition(EnumUIPlacement.SPEAK, Float.parseFloat(positionArray[0]), Float.parseFloat(positionArray[1]), Float.parseFloat(positionArray[3]), Integer.parseInt(positionArray[2]));
                positionArray = this.init.ReadString("Interface", UI_POSITION_PLATE, this.settings.getUIPositionPlate().x + ":" + this.settings.getUIPositionPlate().y + ":" + this.settings.getUIPositionPlate().type + ":" + this.settings.getUIPositionPlate().scale).split(":");
                this.settings.setUIPosition(EnumUIPlacement.VOICE_PLATES, Float.parseFloat(positionArray[0]), Float.parseFloat(positionArray[1]), Float.parseFloat(positionArray[3]), Integer.parseInt(positionArray[2]));
                this.settings.setSnooperAllowed(this.init.ReadBool("Miscellaneous", SNOOPER, false));
                this.settings.setModPackID(this.init.ReadInteger("Miscellaneous", MODPACK_ID, 1));
                this.settings.setDebug(this.init.ReadBool("Miscellaneous", DEBUG, false));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public boolean save() {
        if (this.init == null || !this.location.exists()) {
            try {
                this.init = new JINIFile(this.location);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.init.WriteBool("Game", VOLUME_CONTROL, this.settings.isVolumeControlled());
        this.init.WriteString("Audio", INPUT_DEVICE, this.settings.getInputDevice() != null ? this.settings.getInputDevice().getName() : "none");
        this.init.WriteFloat("Audio", WORLD_VOLUME, this.settings.getWorldVolume());
        this.init.WriteFloat("Audio", INPUT_BOOST, this.settings.getInputBoost());
        this.init.WriteFloat("Audio", SPEAK_MODE, this.settings.getSpeakMode());
        this.init.WriteFloat("AdvancedAudio", ENCODING_QUALITY, this.settings.getEncodingQuality());
        this.init.WriteFloat("AdvancedAudio", ENCODING_MODE, this.settings.getEncodingMode());
        this.init.WriteBool("AdvancedAudio", DECODING_ENCHANTMENT, this.settings.isPerceptualEnchantmentAllowed());
        this.init.WriteFloat("Interface", UI_OPACITY, this.settings.getUIOpacity());
        this.init.WriteString("Interface", UI_POSITION_SPEAK, this.settings.getUIPositionSpeak().x + ":" + this.settings.getUIPositionSpeak().y + ":" + this.settings.getUIPositionSpeak().type + ":" + this.settings.getUIPositionSpeak().scale);
        this.init.WriteString("Interface", UI_POSITION_PLATE, this.settings.getUIPositionPlate().x + ":" + this.settings.getUIPositionPlate().y + ":" + this.settings.getUIPositionPlate().type + ":" + this.settings.getUIPositionPlate().scale);
        this.init.WriteString("Miscellaneous", VERSION, VoiceChat.getProxyInstance().getVersion());
        this.init.WriteBool("Miscellaneous", SNOOPER, this.settings.isSnooperAllowed());
        this.init.WriteBool("Miscellaneous", DEBUG, this.settings.isDebug());
        this.init.WriteInteger("Miscellaneous", MODPACK_ID, this.settings.getModPackID());
        return this.init.UpdateFile();
    }
}

