/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileVacuumChest
extends TileEntityEio
implements IEntitySelector,
IInventory,
IRedstoneModeControlable,
IRanged {
    public static final int ITEM_ROWS = 3;
    public static final int ITEM_SLOTS = 27;
    public static final int FILTER_SLOTS = 5;
    private final ItemStack[] inv = new ItemStack[27];
    private int range = Config.vacuumChestRange;
    private ItemFilter filter;
    private ItemStack filterItem;
    protected RedstoneControlMode redstoneControlMode = RedstoneControlMode.IGNORE;
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    private boolean showingRange;

    public void doUpdate() {
        if (this.redstoneStateDirty) {
            this.updateRedstoneStatus();
        }
        if (this.redstoneCheckPassed && !this.isFull()) {
            this.doHoover();
        }
    }

    private void updateRedstoneStatus() {
        boolean prevRedstoneCheckPassed = this.redstoneCheckPassed;
        this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
        this.redstoneStateDirty = false;
        if (this.redstoneCheckPassed != prevRedstoneCheckPassed) {
            this.updateBlock();
        }
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
    }

    public boolean func_82704_a(Entity entity) {
        if (entity.field_70128_L) {
            return false;
        }
        if (entity instanceof IProjectile) {
            return entity.field_70181_x < 0.01;
        }
        return entity instanceof EntityItem;
    }

    private void doHoover() {
        int rangeSqr = this.range * this.range;
        BoundingBox bb = new BoundingBox(this.getLocation());
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        aabb = aabb.func_72314_b((double)this.range, (double)this.range, (double)this.range);
        List interestingItems = this.field_145850_b.func_82733_a(EntityItem.class, aabb, (IEntitySelector)this);
        for (EntityItem entity : interestingItems) {
            if (this.filter != null && !this.filter.doesItemPassFilter(entity.func_92059_d())) continue;
            double x = (double)this.field_145851_c + 0.5 - entity.field_70165_t;
            double y = (double)this.field_145848_d + 0.5 - entity.field_70163_u;
            double z = (double)this.field_145849_e + 0.5 - entity.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.25) {
                this.hooverEntity((Entity)entity);
                continue;
            }
            double speed = 0.06;
            double distScale = 1.0 - Math.min(0.9, distance / (double)rangeSqr);
            distScale *= distScale;
            entity.field_70159_w += x / distance * distScale * speed;
            entity.field_70181_x += y / distance * distScale * 0.2;
            entity.field_70179_y += z / distance * distScale * speed;
        }
    }

    private void hooverEntity(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d().func_77946_l();
            int numInserted = ItemUtil.doInsertItem((Object)this, (ItemStack)stack, null);
            stack.field_77994_a -= numInserted;
            item.func_92058_a(stack);
            if (stack.field_77994_a == 0) {
                item.func_70106_y();
            }
        }
    }

    private boolean isFull() {
        for (ItemStack stack : this.inv) {
            if (stack != null && stack.field_77994_a >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inv.length) {
            return null;
        }
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack fromStack = this.inv[fromSlot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.field_77994_a <= amount) {
            this.inv[fromSlot] = null;
            return fromStack;
        }
        ItemStack result = new ItemStack(fromStack.func_77973_b(), amount, fromStack.func_77960_j());
        if (fromStack.field_77990_d != null) {
            result.field_77990_d = (NBTTagCompound)fromStack.field_77990_d.func_74737_b();
        }
        fromStack.field_77994_a -= amount;
        return result;
    }

    public void func_70299_a(int slot, ItemStack contents) {
        if (slot < 0 || slot >= this.inv.length) {
            System.out.println("TileVacumChest.setInventorySlotContents: " + slot);
            return;
        }
        this.inv[slot] = contents == null ? contents : contents.func_77946_l();
        if (contents != null && contents.field_77994_a > this.func_70297_j_()) {
            contents.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public String func_145825_b() {
        return ModObject.blockVacuumChest.unlocalisedName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public boolean isItemValidForFilter(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b() == EnderIO.itemBasicFilterUpgrade && itemstack.func_77960_j() == 0;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return null;
    }

    @Override
    public Vector3d getRange() {
        return new Vector3d((double)this.range, (double)this.range, (double)this.range);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @Override
    public int getColor() {
        return 0x660000FF;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            this.field_145850_b.func_72838_d((Entity)new RangeEntity(this));
        }
    }

    private int limitRange(int range) {
        return Math.max(1, Math.min(Config.vacuumChestRange, range));
    }

    public void setRange(int range) {
        this.range = this.limitRange(range);
        this.updateBlock();
    }

    public ItemStack getFilterItem() {
        return this.filterItem;
    }

    public void setFilterItem(ItemStack filterItem) {
        IItemFilter newFilter = FilterRegister.getFilterForUpgrade(filterItem);
        if (newFilter == null || newFilter instanceof ItemFilter) {
            this.filterItem = filterItem;
            this.filter = (ItemFilter)newFilter;
            this.updateBlock();
        }
    }

    public void setFilterBlacklist(boolean isBlacklist) {
        if (this.filter != null) {
            this.filter.setBlacklist(isBlacklist);
            this.updateFilterItem();
        }
    }

    public void setFilterMatchMeta(boolean matchMeta) {
        if (this.filter != null) {
            this.filter.setMatchMeta(matchMeta);
            this.updateFilterItem();
        }
    }

    public boolean hasItemFilter() {
        return this.filter != null;
    }

    public ItemFilter getItemFilter() {
        return this.filter;
    }

    public void setItemFilterSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < 5 && this.filter != null) {
            this.filter.func_70299_a(slot, stack);
            this.updateFilterItem();
        }
    }

    private void updateFilterItem() {
        FilterRegister.writeFilterToStack(this.filter, this.filterItem);
        this.updateBlock();
    }

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        this.readContentsFromNBT(nbtRoot);
        this.redstoneCheckPassed = nbtRoot.func_74767_n("redstoneCheckPassed");
    }

    public void readContentsFromNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = (NBTTagList)nbtRoot.func_74781_a("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemStack = itemList.func_150305_b(i);
                byte slot = itemStack.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)itemStack);
            }
        }
        this.range = nbtRoot.func_74764_b("range") ? this.limitRange(nbtRoot.func_74762_e("range")) : Config.vacuumChestRange;
        if (nbtRoot.func_74764_b("filter")) {
            NBTTagCompound filterTag = (NBTTagCompound)nbtRoot.func_74781_a("filter");
            this.filterItem = ItemStack.func_77949_a((NBTTagCompound)filterTag);
            IItemFilter flt = FilterRegister.getFilterForUpgrade(this.filterItem);
            if (flt instanceof ItemFilter) {
                this.filter = (ItemFilter)flt;
            } else {
                this.filterItem = null;
            }
        } else {
            this.filterItem = null;
            this.filter = null;
        }
        int rsContr = nbtRoot.func_74762_e("redstoneControlMode");
        if (rsContr < 0 || rsContr >= RedstoneControlMode.values().length) {
            rsContr = 0;
        }
        this.redstoneControlMode = RedstoneControlMode.values()[rsContr];
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        this.writeContentsToNBT(nbtRoot);
        nbtRoot.func_74757_a("redstoneCheckPassed", this.redstoneCheckPassed);
    }

    public void writeContentsToNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(itemStackNBT);
            itemList.func_74742_a((NBTBase)itemStackNBT);
        }
        nbtRoot.func_74782_a("Items", (NBTBase)itemList);
        nbtRoot.func_74768_a("range", this.range);
        if (this.filterItem != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filterItem.func_77955_b(filterNBT);
            nbtRoot.func_74782_a("filter", (NBTBase)filterNBT);
        }
        nbtRoot.func_74768_a("redstoneControlMode", this.redstoneControlMode.ordinal());
    }
}

