/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import com.brandon3055.brandonscore.common.handlers.IProcess;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.ReactorExplosion;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class ReactorExplosionTrace
implements IProcess {
    private final World world;
    private final int xCoord;
    private final int yCoord;
    private final int zCoord;
    private final float power;
    private boolean isDead = false;

    public ReactorExplosionTrace(World world, int x, int y, int z, float power) {
        this.world = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.power = power;
    }

    public void updateProcess() {
        List entities;
        Block block;
        int y;
        float energy = this.power * 10.0f;
        for (y = this.yCoord; y > 0 && energy > 0.0f; --y) {
            block = this.world.func_147439_a(this.xCoord, y, this.zCoord);
            entities = this.world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.xCoord, (double)y, (double)this.zCoord, (double)(this.xCoord + 1), (double)(y + 1), (double)(this.zCoord + 1)));
            for (Entity entity : entities) {
                entity.func_70097_a(ReactorExplosion.FUSION_EXPLOSION, this.power * 100.0f);
            }
            energy -= block instanceof BlockLiquid ? 10.0f : block.func_149638_a(null);
            boolean blockRemoved = false;
            if (energy >= 0.0f && block != Blocks.field_150350_a) {
                this.world.func_147468_f(this.xCoord, y, this.zCoord);
                blockRemoved = true;
            }
            if (!((energy -= 0.5f + 0.1f * (float)(this.yCoord - y)) <= 0.0f) || this.world.field_73012_v.nextInt(20) != 0 || !blockRemoved) continue;
            if (this.world.field_73012_v.nextInt(3) > 0) {
                this.world.func_147449_b(this.xCoord, y, this.zCoord, (Block)Blocks.field_150480_ab);
                continue;
            }
            this.world.func_147449_b(this.xCoord, y, this.zCoord, (Block)Blocks.field_150356_k);
        }
        energy = this.power * 20.0f;
        for (y = this.yCoord + 1; y < 255 && energy > 0.0f; energy -= 0.5f + 0.1f * (float)(y - this.yCoord), ++y) {
            block = this.world.func_147439_a(this.xCoord, y, this.zCoord);
            entities = this.world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.xCoord, (double)y, (double)this.zCoord, (double)(this.xCoord + 1), (double)(y + 1), (double)(this.zCoord + 1)));
            for (Entity entity : entities) {
                entity.func_70097_a(ReactorExplosion.FUSION_EXPLOSION, this.power * 100.0f);
            }
            if (!((energy -= block instanceof BlockLiquid ? 10.0f : block.func_149638_a(null)) >= 0.0f)) continue;
            this.world.func_147468_f(this.xCoord, y, this.zCoord);
        }
        this.isDead = true;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

