/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.armor;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.model.ModelDraconicArmorOld;
import com.brandon3055.draconicevolution.client.model.ModelWyvernArmor;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.items.armor.ICustomArmor;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolBase;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.IWarpingGear;
import thaumcraft.api.aspects.Aspect;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IWarpingGear", modid="Thaumcraft")})
public class WyvernArmor
extends ItemArmor
implements ISpecialArmor,
IConfigurableItem,
IInventoryTool,
IUpgradableItem,
ICustomArmor,
IVisDiscountGear,
IWarpingGear {
    @SideOnly(value=Side.CLIENT)
    private IIcon helmIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon chestIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon leggsIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bootsIcon;
    private int maxEnergy = BalanceConfigHandler.wyvernArmorBaseStorage;
    private int maxTransfer = BalanceConfigHandler.wyvernArmorMaxTransfer;
    @SideOnly(value=Side.CLIENT)
    private ModelBiped model;

    public WyvernArmor(ItemArmor.ArmorMaterial material, int armorType, String name) {
        super(material, 0, armorType);
        this.func_77655_b(name);
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
        if (ModItems.isEnabled((Item)this)) {
            GameRegistry.registerItem((Item)this, (String)name);
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs p_150895_2_, List list) {
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item), (String)"Energy", (int)0));
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item), (String)"Energy", (int)this.maxEnergy));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.helmIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_helmet");
        this.chestIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_chestplate");
        this.leggsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_leggings");
        this.bootsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_boots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack.func_77973_b() == ModItems.wyvernHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.wyvernHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (!ConfigHandler.useOldArmorModel) {
            return References.RESOURCESPREFIX + "textures/models/armor/armorWyvern.png";
        }
        if (stack.func_77973_b() == ModItems.wyvernHelm || stack.func_77973_b() == ModItems.wyvernChest || stack.func_77973_b() == ModItems.wyvernBoots) {
            return References.RESOURCESPREFIX + "textures/models/armor/wyvern_layer_1.png";
        }
        return References.RESOURCESPREFIX + "textures/models/armor/wyvern_layer_2.png";
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.uncommon;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemNBTHelper.getInteger((ItemStack)stack, (String)"Energy", (int)0) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    protected float getProtectionShare() {
        switch (this.field_77881_a) {
            case 0: {
                return 0.15f;
            }
            case 1: {
                return 0.4f;
            }
            case 2: {
                return 0.3f;
            }
            case 3: {
                return 0.15f;
            }
        }
        return 0.0f;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c() || source.func_151517_h() || source.func_82725_o()) {
            return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 100.0, 15);
        }
        return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 25.0, 1000);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)((double)this.getProtectionShare() * 20.0);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        InfoHelper.addEnergyAndLore((ItemStack)stack, (List)list);
        ToolBase.holdCTRLForUpgrades(list, stack);
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            list.add("");
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"tc.visdiscount") + ": " + this.getVisDiscount(stack, player, null) + "%");
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.maxTransfer));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(stored += receive));
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int extract = Math.min(maxExtract, Math.min(this.maxTransfer, stored));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(stored -= extract));
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
    }

    public int getMaxEnergyStored(ItemStack container) {
        int points = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(container);
        return BalanceConfigHandler.wyvernArmorBaseStorage + points * BalanceConfigHandler.wyvernArmorStoragePerUpgrade;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        ArrayList<ItemConfigField> list = new ArrayList<ItemConfigField>();
        if (this.field_77881_a == 2) {
            list.add(new ItemConfigField(4, slot, "ArmorSpeedMult").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(5.0f), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
            list.add(new ItemConfigField(6, slot, "ArmorSprintOnly").readFromItem(stack, false));
        } else if (this.field_77881_a == 3) {
            list.add(new ItemConfigField(4, slot, "ArmorJumpMult").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(5.0f), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
            list.add(new ItemConfigField(6, slot, "ArmorSprintOnly").readFromItem(stack, false));
        }
        return list;
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryEnch.txt");
    }

    @Override
    public int getInventorySlots() {
        return 0;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.armor || this.field_77881_a == 0 && enchant.field_77351_y == EnumEnchantmentType.armor_head || this.field_77881_a == 1 && enchant.field_77351_y == EnumEnchantmentType.armor_torso || this.field_77881_a == 2 && enchant.field_77351_y == EnumEnchantmentType.armor_legs || this.field_77881_a == 3 && enchant.field_77351_y == EnumEnchantmentType.armor_feet;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (ConfigHandler.useOldArmorModel) {
            return super.getArmorModel(entityLiving, itemStack, armorSlot);
        }
        if (!ConfigHandler.useOriginal3DArmorModel) {
            if (this.model == null) {
                this.model = this.field_77881_a == 0 ? new ModelWyvernArmor(1.0f, true, false, false, false) : (this.field_77881_a == 1 ? new ModelWyvernArmor(1.0f, false, true, false, false) : (this.field_77881_a == 2 ? new ModelWyvernArmor(1.0f, false, false, true, false) : new ModelWyvernArmor(1.0f, false, false, false, true)));
                this.model.field_78116_c.field_78806_j = this.field_77881_a == 0;
                this.model.field_78114_d.field_78806_j = this.field_77881_a == 0;
                this.model.field_78115_e.field_78806_j = this.field_77881_a == 1 || this.field_77881_a == 2;
                this.model.field_78113_g.field_78806_j = this.field_77881_a == 1;
                this.model.field_78112_f.field_78806_j = this.field_77881_a == 1;
                this.model.field_78124_i.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
                this.model.field_78123_h.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
            }
        } else if (this.model == null) {
            this.model = this.field_77881_a == 0 ? new ModelDraconicArmorOld(1.0f, true, false, false, false, false) : (this.field_77881_a == 1 ? new ModelDraconicArmorOld(1.0f, false, true, false, false, false) : (this.field_77881_a == 2 ? new ModelDraconicArmorOld(1.0f, false, false, true, false, false) : new ModelDraconicArmorOld(1.0f, false, false, false, true, false)));
            this.model.field_78116_c.field_78806_j = this.field_77881_a == 0;
            this.model.field_78114_d.field_78806_j = this.field_77881_a == 0;
            this.model.field_78115_e.field_78806_j = this.field_77881_a == 1 || this.field_77881_a == 2;
            this.model.field_78113_g.field_78806_j = this.field_77881_a == 1;
            this.model.field_78112_f.field_78806_j = this.field_77881_a == 1;
            this.model.field_78124_i.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
            boolean bl = this.model.field_78123_h.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
        }
        if (entityLiving == null) {
            return this.model;
        }
        this.model.field_78117_n = entityLiving.func_70093_af();
        this.model.field_78093_q = entityLiving.func_70115_ae();
        this.model.field_78091_s = entityLiving.func_70631_g_();
        this.model.field_78118_o = false;
        int n = this.model.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
        if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
            EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
            if (enumaction == EnumAction.block) {
                this.model.field_78120_m = 3;
            } else if (enumaction == EnumAction.bow) {
                this.model.field_78118_o = true;
            }
        }
        return this.model;
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        return new ArrayList<IUpgradableItem.EnumUpgrade>(){
            {
                this.add(IUpgradableItem.EnumUpgrade.RF_CAPACITY);
                this.add(IUpgradableItem.EnumUpgrade.SHIELD_CAPACITY);
                this.add(IUpgradableItem.EnumUpgrade.SHIELD_RECOVERY);
            }
        };
    }

    @Override
    public int getUpgradeCap(ItemStack itemstack) {
        return BalanceConfigHandler.wyvernArmorMaxUpgrades;
    }

    @Override
    public int getMaxTier(ItemStack itemstack) {
        return 1;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.RFCapacity.txt") + ": " + InfoHelper.HITC() + Utills.formatNumber((long)this.getMaxEnergyStored(stack)));
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.ShieldCapacity.txt") + ": " + InfoHelper.HITC() + (int)this.getProtectionPoints(stack));
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.ShieldRecovery.txt") + ": " + InfoHelper.HITC() + Utills.round((double)((double)this.getRecoveryPoints(stack) * 0.2), (double)10.0) + " EPS");
        return strings;
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return BalanceConfigHandler.wyvernArmorMaxCapacityUpgradePoints;
        }
        return BalanceConfigHandler.wyvernArmorMaxUpgradePoints;
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex, ItemStack stack) {
        return this.getMaxUpgradePoints(upgradeIndex);
    }

    @Override
    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.SHIELD_CAPACITY.index) {
            return (int)(this.getProtectionShare() * 10.0f) + (this.field_77881_a == 2 ? 1 : 0);
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.SHIELD_RECOVERY.index) {
            return 5;
        }
        return 0;
    }

    @Override
    public float getProtectionPoints(ItemStack stack) {
        return (float)IUpgradableItem.EnumUpgrade.SHIELD_CAPACITY.getUpgradePoints(stack) * 20.0f;
    }

    @Override
    public int getRecoveryPoints(ItemStack stack) {
        return IUpgradableItem.EnumUpgrade.SHIELD_RECOVERY.getUpgradePoints(stack);
    }

    @Override
    public float getSpeedModifier(ItemStack stack, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorSprintOnly", false)) {
            return player.func_70051_ag() ? IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorSpeedMult", 0.0f) : IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorSpeedMult", 0.0f) / 5.0f;
        }
        return IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorSpeedMult", 0.0f);
    }

    @Override
    public float getJumpModifier(ItemStack stack, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorSprintOnly", false)) {
            return player.func_70051_ag() || BrandonsCore.proxy.isCtrlDown() ? IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorJumpMult", 0.0f) : IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorJumpMult", 0.0f) / 5.0f;
        }
        return IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorJumpMult", 0.0f);
    }

    @Override
    public boolean hasHillStep(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public float getFireResistance(ItemStack stack) {
        return this.getProtectionShare();
    }

    @Override
    public boolean[] hasFlight(ItemStack stack) {
        return new boolean[]{false, false, false};
    }

    @Override
    public float getFlightSpeedModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Override
    public float getFlightVModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Override
    public int getEnergyPerProtectionPoint() {
        return BalanceConfigHandler.wyvernArmorEnergyPerProtectionPoint;
    }

    @Override
    public boolean hasProfiles() {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getVisDiscount(ItemStack itemStack, EntityPlayer entityPlayer, Aspect aspect) {
        return 10;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getWarp(ItemStack itemStack, EntityPlayer entityPlayer) {
        return 5;
    }
}

