/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.gui.GuiButtonAHeight;
import com.brandon3055.draconicevolution.common.container.ContainerDislocatorInhibitor;
import com.brandon3055.draconicevolution.common.inventory.SlotFakeItem;
import com.brandon3055.draconicevolution.common.network.DislocatorInhibitorButtonPacket;
import com.brandon3055.draconicevolution.common.network.SlotFakeClickPacket;
import com.brandon3055.draconicevolution.common.tileentities.TileDislocatorInhibitor;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GUIDislocatorInhibitor
extends GuiContainer
implements INEIGuiHandler {
    private static final ResourceLocation texture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/gui/Inhibitor.png");
    private int range = 5;
    private TileDislocatorInhibitor.ActivityControlType activityControlType = TileDislocatorInhibitor.ActivityControlType.ALWAYS_ACTIVE;
    private boolean whitelist = false;
    private final ContainerDislocatorInhibitor container = (ContainerDislocatorInhibitor)this.field_147002_h;

    public GUIDislocatorInhibitor(InventoryPlayer playerInventory, TileDislocatorInhibitor inhibitor) {
        super(inhibitor.getGuiContainer(playerInventory));
        this.field_146999_f = 176;
        this.field_147000_g = 142;
        this.syncWithServer();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonAHeight(0, this.field_147003_i + 7, this.field_147009_r + 11, 18, 18, "-"));
        this.field_146292_n.add(new GuiButtonAHeight(1, this.field_147003_i + 97, this.field_147009_r + 11, 18, 18, "+"));
        this.field_146292_n.add(new GuiButtonAHeight(2, this.field_147003_i + 151, this.field_147009_r + 11, 18, 18, ""));
        this.field_146292_n.add(new GuiButtonAHeight(3, this.field_147003_i + 151, this.field_147009_r + 33, 18, 18, ""));
    }

    protected void func_146979_b(int x, int y) {
        this.drawGuiText();
        this.drawGreyOutSlots();
        this.drawButtonIcons();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        super.func_73863_a(x, y, partialTicks);
        ArrayList<String> lines = new ArrayList<String>();
        if (x - this.field_147003_i > 7 && x - this.field_147003_i < 25 && y - this.field_147009_r > 11 && y - this.field_147009_r < 29) {
            lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.range.increase.txt"));
        } else if (x - this.field_147003_i > 97 && x - this.field_147003_i < 115 && y - this.field_147009_r > 11 && y - this.field_147009_r < 29) {
            lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.range.decrease.txt"));
        } else if (x - this.field_147003_i > 151 && x - this.field_147003_i < 169 && y - this.field_147009_r > 11 && y - this.field_147009_r < 29) {
            switch (this.activityControlType) {
                case ALWAYS_ACTIVE: {
                    lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.activity.always.txt"));
                    break;
                }
                case WITH_REDSTONE: {
                    lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.activity.with.txt"));
                    break;
                }
                case WITHOUT_REDSTONE: {
                    lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.activity.without.txt"));
                    break;
                }
                case NEVER_ACTIVE: {
                    lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.activity.never.txt"));
                }
            }
            lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.activity.cycle.txt"));
        } else if (x - this.field_147003_i > 151 && x - this.field_147003_i < 169 && y - this.field_147009_r > 33 && y - this.field_147009_r < 51) {
            if (this.whitelist) {
                lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.whitelist.txt"));
            } else {
                lines.add(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.tooltip.blacklist.txt"));
            }
        }
        if (!lines.isEmpty()) {
            this.drawHoveringText(lines, x, y, this.field_146289_q);
        }
    }

    protected void func_146984_a(Slot slotIn, int slotId, int clickedButton, int clickType) {
        if (slotIn instanceof SlotFakeItem) {
            SlotFakeItem sfi = (SlotFakeItem)slotIn;
            DraconicEvolution.network.sendToServer((IMessage)new SlotFakeClickPacket((byte)sfi.getSlotIndex(), this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()));
        } else {
            super.func_146984_a(slotIn, slotId, clickedButton, clickType);
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.range = Math.max(this.range - 1, 1);
                DraconicEvolution.network.sendToServer((IMessage)new DislocatorInhibitorButtonPacket(0, (byte)this.range));
                break;
            }
            case 1: {
                this.range = Math.min(this.range + 1, 16);
                DraconicEvolution.network.sendToServer((IMessage)new DislocatorInhibitorButtonPacket(0, (byte)this.range));
                break;
            }
            case 2: {
                this.activityControlType = this.activityControlType.getNext();
                byte controlMode = (byte)this.activityControlType.ordinal();
                DraconicEvolution.network.sendToServer((IMessage)new DislocatorInhibitorButtonPacket(1, controlMode));
                break;
            }
            case 3: {
                this.whitelist = !this.whitelist;
                byte whitelistMode = (byte)(this.whitelist ? 1 : 0);
                DraconicEvolution.network.sendToServer((IMessage)new DislocatorInhibitorButtonPacket(2, whitelistMode));
            }
        }
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        if (gui instanceof GUIDislocatorInhibitor) {
            for (Object slot : this.container.field_75151_b) {
                SlotFakeItem sfi;
                if (!(slot instanceof SlotFakeItem) || !(sfi = (SlotFakeItem)((Object)slot)).isOverSlot(mousex - this.field_147003_i, mousey - this.field_147009_r)) continue;
                draggedStack.field_77994_a = 0;
                DraconicEvolution.network.sendToServer((IMessage)new SlotFakeClickPacket((byte)sfi.getSlotIndex(), draggedStack));
                return true;
            }
        }
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return false;
    }

    private void drawGuiText() {
        this.field_146289_q.func_85187_a(StatCollector.func_74838_a((String)"gui.de.dislocatorInhibitor.range.txt"), 40, 17, 0, false);
        this.field_146289_q.func_85187_a(String.valueOf(this.range), this.range < 10 ? 78 : 75, 17, 0, false);
    }

    private void drawButtonIcons() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(151, 11, 0, 142 + 18 * this.activityControlType.ordinal(), 18, 18);
        this.func_73729_b(151, 33, 18, 142 + (this.whitelist ? 0 : 18), 18, 18);
    }

    private void drawGreyOutSlots() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        for (int i = 0; i < 8; ++i) {
            this.func_73729_b(7 + i * 18, 33, 36, 142, 18, 18);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    private void syncWithServer() {
        TileDislocatorInhibitor inhibitor = this.container.getTileEntity();
        this.whitelist = inhibitor.isWhitelist();
        this.range = inhibitor.getRange();
        this.activityControlType = inhibitor.getActivityControlType();
    }
}

