/*
 * Decompiled with CFR 0.152.
 */
package net.divinerpg.entities.twilight;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.divinerpg.entities.base.EntityDivineRPGTameable;
import net.divinerpg.entities.base.EntityStats;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityMoonWolf
extends EntityDivineRPGTameable {
    private float headRotationX;
    private float headRotationY;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private boolean isShaking;
    private boolean shakingAndDry;

    public EntityMoonWolf(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        if (!this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EntityStats.moonWolfHealth);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(EntityStats.moonWolfFollowRange);
    }

    public void func_70903_f(boolean par1) {
        super.func_70903_f(par1);
    }

    @Override
    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Float(this.func_110143_aJ()));
        this.field_70180_af.func_75682_a(19, (Object)new Byte(0));
    }

    protected void func_145780_a(int x, int y, int z, Block steppedOn) {
        this.func_85030_a("mob.wolf.step", 0.15f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAngry(compound.func_74767_n("Angry"));
    }

    @Override
    protected String func_70639_aQ() {
        return this.isAngry() ? "mob.wolf.growl" : (this.field_70146_Z.nextInt(3) == 0 ? (this.func_70909_n() && this.field_70180_af.func_111145_d(18) < 10.0f ? "mob.wolf.whine" : "mob.wolf.panting") : "mob.wolf.bark");
    }

    @Override
    protected String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    @Override
    protected String func_70673_aS() {
        return "mob.wolf.death";
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return null;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isShaking && !this.shakingAndDry && !this.func_70781_l() && this.field_70122_E) {
            this.shakingAndDry = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (this.isAngry()) {
            this.func_70624_b((EntityLivingBase)this.field_70170_p.func_72856_b((Entity)this, 24.0));
            if (this.field_70146_Z.nextInt(400) == 0 && this.func_70638_az() == null) {
                this.setAngry(false);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationY = this.headRotationX;
        this.headRotationX = this.isRotatingCalled() ? (this.headRotationX += (1.0f - this.headRotationX) * 0.4f) : (this.headRotationX += (0.0f - this.headRotationX) * 0.4f);
        if (this.isRotatingCalled()) {
            this.field_70700_bx = 10;
        }
        if (this.func_70026_G()) {
            this.isShaking = true;
            this.shakingAndDry = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isShaking || this.shakingAndDry) && this.shakingAndDry) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_85030_a("mob.wolf.shake", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isShaking = false;
                this.shakingAndDry = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.field_70121_D.field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getWolfShaking() {
        return this.isShaking;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileShaking(float par1) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * par1) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float par1, float par2) {
        float f2 = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * par1 + par2) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * MathHelper.func_76126_a((float)(f2 * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float par1) {
        return (this.headRotationY + (this.headRotationX - this.headRotationY) * par1) * 0.15f * (float)Math.PI;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.field_70911_d.func_75270_a(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        if (entity instanceof EntityPlayer && !this.func_70909_n()) {
            this.setAngry(true);
        }
        return super.func_70097_a(source, par2);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)EntityStats.moonWolfDamage);
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (this.func_70909_n()) {
            ItemFood food;
            if (stack != null && stack.func_77973_b() instanceof ItemFood && (food = (ItemFood)stack.func_77973_b()).func_77845_h() && this.field_70180_af.func_111145_d(18) < 200.0f) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                this.func_70691_i(food.func_150905_g(stack));
                if (stack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                return true;
            }
            if (!(!this.func_152114_e((EntityLivingBase)player) || this.field_70170_p.field_72995_K || stack != null && this.func_70877_b(stack))) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.func_70778_a(null);
                this.func_70784_b(null);
                this.func_70624_b(null);
            }
        } else if (stack != null && stack.func_77973_b() == Items.field_151103_aS && !this.isAngry()) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            if (stack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
                    this.func_152115_b(player.func_110124_au().toString());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.isAngry() ? 1.5393804f : (this.func_70909_n() ? (0.55f - (20.0f - this.field_70180_af.func_111145_d(18)) * 0.02f) * (float)Math.PI : 0.62831855f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack == null ? false : (!(stack.func_77973_b() instanceof ItemFood) ? false : ((ItemFood)stack.func_77973_b()).func_77845_h());
    }

    @Override
    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean par1) {
        byte b = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b & 0xFFFFFFFD)));
        }
    }

    public EntityMoonWolf createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public boolean isRotatingCalled() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    @Override
    public String mobName() {
        return "Moon Wolf";
    }
}

