/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft.forge;

import com.mia.craftstudio.CSProject;
import com.mia.craftstudio.CraftStudioLib;
import com.mia.craftstudio.api.ICSProject;
import com.mia.craftstudio.minecraft.AnimationState;
import com.mia.craftstudio.minecraft.BlockDimensionalPosition;
import com.mia.craftstudio.minecraft.CSMsgAnimationUpdate;
import com.mia.craftstudio.minecraft.IAnimatedTile;
import com.mia.craftstudio.minecraft.forge.ProxyCommon;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.Locale;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="PTRModelLib", name="PTRModelLib", version="1.0.0")
public class CSLibMod {
    @Mod.Instance(value="PTRModelLib")
    public static CSLibMod instance;
    @SidedProxy(clientSide="com.mia.craftstudio.minecraft.forge.ProxyClient", serverSide="com.mia.craftstudio.minecraft.forge.ProxyCommon")
    public static ProxyCommon proxy;
    public static final String modid = "PTRModelLib";
    public static Logger log;
    public static boolean displayOutline;
    private static Configuration config;
    private SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("CraftStudioLib");
        this.network.registerMessage(CSMsgAnimationUpdate.Handler.class, CSMsgAnimationUpdate.class, 0, Side.CLIENT);
        config = new Configuration(ev.getSuggestedConfigurationFile());
        try {
            config.load();
            displayOutline = config.getBoolean("displayOutline", "general", true, "Should we render the targeting outline ? Set false for better performances.");
        }
        catch (Exception e) {
            FMLLog.severe((String)"PTRModelLib has a problem loading it's configuration", (Object[])new Object[0]);
            FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
        proxy.preInit();
    }

    public static void startAnimation(TileEntity tile, ICSProject project, Integer animationID) {
        if (tile instanceof IAnimatedTile) {
            BlockDimensionalPosition tilePosition = ((IAnimatedTile)tile).getBlockPosDim();
            AnimationState anim = new AnimationState(project, animationID, System.currentTimeMillis(), 5, false);
            CSLibMod.instance.network.sendToAllAround((IMessage)new CSMsgAnimationUpdate((IAnimatedTile)tile, anim), new NetworkRegistry.TargetPoint(tilePosition.getDim(), (double)tilePosition.getX(), (double)tilePosition.getY(), (double)tilePosition.getZ(), 128.0));
        }
    }

    public static ICSProject getCSProject(String name) {
        ModContainer mod = Loader.instance().activeModContainer();
        return new CSProject(name, mod.getModId(), String.format("/assets/%s/models/%s", mod.getModId().toLowerCase(Locale.US), name), mod.getSource());
    }

    public static ICSProject getCSProjectAndLoad(String name) {
        CraftStudioLib.getTimer().start("Full project");
        ICSProject project = CSLibMod.getCSProject(name).addAllPacks().loadPacks();
        CraftStudioLib.getTimer().stop("Full project");
        CraftStudioLib.debug(String.format("Project loaded in %s ms", CraftStudioLib.getTimer().get("Full project")));
        return project;
    }

    static {
        log = LogManager.getLogger((String)modid);
        displayOutline = true;
        config = null;
    }
}

