/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted.item;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.item.IItemCustom;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.INpcScriptHandler;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.scripted.item.ScriptItemStack;

public class ScriptCustomItem
extends ScriptItemStack
implements IItemCustom,
INpcScriptHandler {
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public List<Integer> errored = new ArrayList<Integer>();
    public String scriptLanguage = "ECMAScript";
    public boolean enabled = false;
    public boolean loaded = false;
    public boolean durabilityShow = false;
    public double durabilityValue = 1.0;
    public int durabilityColor = -1;
    public int itemColor = 9127187;
    public int stackSize = 64;
    public int maxItemUseDuration = 20;
    public int itemUseAction = 0;
    public boolean isNormalItem = false;
    public boolean isTool = false;
    public int digSpeed = 1;
    public int armorType = -2;
    public int enchantability;
    public String texture = "minecraft:textures/items/iron_pickaxe.png";
    public float translateX;
    public float translateY;
    public float translateZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public float rotationX;
    public float rotationY;
    public float rotationZ;
    public float rotationXRate;
    public float rotationYRate;
    public float rotationZRate;
    public long lastInited = -1L;

    public ScriptCustomItem(ItemStack item) {
        super(item);
        this.loadItemData();
    }

    public NBTTagCompound getScriptNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    public void setScriptNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Scripts")) {
            this.scripts = NBTTags.GetScriptOld(compound.func_150295_c("Scripts", 10), this);
            this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
            this.enabled = compound.func_74767_n("ScriptEnabled");
        }
    }

    @Override
    public int getType() {
        return 6;
    }

    private boolean isEnabled() {
        return this.enabled && ScriptController.HasStart;
    }

    @Override
    public void callScript(EnumScriptType type, Event event) {
        this.callScript(type.function, event);
    }

    @Override
    public void callScript(String hookName, Event event) {
        if (!this.loaded) {
            this.loadScriptData();
            this.loaded = true;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (!Objects.equals(hookName, EnumScriptType.INIT.function)) {
                EventHooks.onScriptItemInit(this);
            }
        }
        for (int i = 0; i < this.scripts.size(); ++i) {
            ScriptContainer script = this.scripts.get(i);
            if (this.errored.contains(i) || script == null || script.errored || !script.hasCode()) continue;
            script.run(hookName, (Object)event);
            if (!script.errored) continue;
            this.errored.add(i);
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public void setScripts(List<ScriptContainer> list) {
        this.scripts = list;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String noticeString() {
        return "ScriptedItem";
    }

    @Override
    public Map<Long, String> getConsoleText() {
        return new TreeMap<Long, String>();
    }

    @Override
    public void clearConsole() {
    }

    @Override
    public String getTexture() {
        return this.texture == null ? "" : this.texture;
    }

    @Override
    public void setTexture(String texture) {
        if (texture == null) {
            texture = "";
        }
        this.texture = texture;
        this.saveItemData();
    }

    @Override
    public int getMaxStackSize() {
        return this.stackSize;
    }

    @Override
    public void setArmorType(int armorType) {
        this.armorType = armorType;
        this.saveItemData();
    }

    @Override
    public int getArmorType() {
        return this.armorType;
    }

    @Override
    public void setIsTool(boolean isTool) {
        this.isTool = isTool;
        this.saveItemData();
    }

    @Override
    public boolean isTool() {
        return this.isTool;
    }

    @Override
    public void setIsNormalItem(boolean normalItem) {
        this.isNormalItem = normalItem;
        this.saveItemData();
    }

    @Override
    public boolean isNormalItem() {
        return this.isNormalItem;
    }

    @Override
    public void setDigSpeed(int digSpeed) {
        this.digSpeed = digSpeed;
        this.saveItemData();
    }

    @Override
    public int getDigSpeed() {
        return this.digSpeed;
    }

    @Override
    public void setMaxStackSize(int size) {
        if (size < 1 || size > 127) {
            throw new CustomNPCsException("Stacksize has to be between 1 and 127", new Object[0]);
        }
        this.stackSize = size;
        this.saveItemData();
    }

    @Override
    public double getDurabilityValue() {
        return this.durabilityValue;
    }

    @Override
    public void setDurabilityValue(float value) {
        this.durabilityValue = value;
        this.saveItemData();
    }

    @Override
    public boolean getDurabilityShow() {
        return this.durabilityShow;
    }

    @Override
    public void setDurabilityShow(boolean bo) {
        this.durabilityShow = bo;
        this.saveItemData();
    }

    @Override
    public int getDurabilityColor() {
        return this.durabilityColor;
    }

    @Override
    public void setDurabilityColor(int color) {
        this.durabilityColor = color;
        this.saveItemData();
    }

    @Override
    public int getColor() {
        return this.itemColor;
    }

    @Override
    public void setColor(int color) {
        this.itemColor = color;
        this.saveItemData();
    }

    @Override
    public int getMaxItemUseDuration() {
        return this.maxItemUseDuration;
    }

    @Override
    public void setMaxItemUseDuration(int duration) {
        this.maxItemUseDuration = duration;
        this.saveItemData();
    }

    @Override
    public void setItemUseAction(int action) {
        this.itemUseAction = action;
        this.saveItemData();
    }

    @Override
    public int getItemUseAction() {
        return this.itemUseAction;
    }

    @Override
    public int getEnchantability() {
        return this.enchantability;
    }

    @Override
    public void setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        this.saveItemData();
    }

    @Override
    public void setRotation(float rotationX, float rotationY, float rotationZ) {
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.rotationZ = rotationZ;
        this.saveItemData();
    }

    @Override
    public void setRotationRate(float rotationXRate, float rotationYRate, float rotationZRate) {
        this.rotationXRate = rotationXRate;
        this.rotationYRate = rotationYRate;
        this.rotationZRate = rotationZRate;
        this.saveItemData();
    }

    @Override
    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.saveItemData();
    }

    @Override
    public void setTranslate(float translateX, float translateY, float translateZ) {
        this.translateX = translateX;
        this.translateY = translateY;
        this.translateZ = translateZ;
        this.saveItemData();
    }

    @Override
    public float getRotationX() {
        return this.rotationX;
    }

    @Override
    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public float getRotationZ() {
        return this.rotationZ;
    }

    @Override
    public float getRotationXRate() {
        return this.rotationXRate;
    }

    @Override
    public float getRotationYRate() {
        return this.rotationYRate;
    }

    @Override
    public float getRotationZRate() {
        return this.rotationZRate;
    }

    @Override
    public float getScaleX() {
        return this.scaleX;
    }

    @Override
    public float getScaleY() {
        return this.scaleY;
    }

    @Override
    public float getScaleZ() {
        return this.scaleZ;
    }

    @Override
    public float getTranslateX() {
        return this.translateX;
    }

    @Override
    public float getTranslateY() {
        return this.translateY;
    }

    @Override
    public float getTranslateZ() {
        return this.translateZ;
    }

    @Override
    public NBTTagCompound getMCNbt() {
        NBTTagCompound compound = super.getMCNbt();
        compound.func_74782_a("ItemData", (NBTBase)this.getItemNBT(new NBTTagCompound()));
        compound.func_74782_a("ScriptedData", (NBTBase)this.getScriptNBT(new NBTTagCompound()));
        return compound;
    }

    @Override
    public void setMCNbt(NBTTagCompound compound) {
        this.setScriptNBT(compound.func_74775_l("ScriptedData"));
        this.setItemNBT(compound.func_74775_l("ItemData"));
    }

    public NBTTagCompound getItemNBT(NBTTagCompound compound) {
        compound.func_74757_a("DurabilityShow", this.durabilityShow);
        compound.func_74780_a("DurabilityValue", this.durabilityValue);
        compound.func_74768_a("DurabilityColor", this.durabilityColor);
        compound.func_74768_a("ItemColor", this.itemColor);
        compound.func_74768_a("MaxStackSize", this.stackSize);
        compound.func_74778_a("ItemTexture", this.texture);
        compound.func_74776_a("RotationX", this.rotationX);
        compound.func_74776_a("RotationY", this.rotationY);
        compound.func_74776_a("RotationZ", this.rotationZ);
        compound.func_74776_a("RotationXRate", this.rotationXRate);
        compound.func_74776_a("RotationYRate", this.rotationYRate);
        compound.func_74776_a("RotationZRate", this.rotationZRate);
        compound.func_74776_a("ScaleX", this.scaleX);
        compound.func_74776_a("ScaleY", this.scaleY);
        compound.func_74776_a("ScaleZ", this.scaleZ);
        compound.func_74776_a("TranslateX", this.translateX);
        compound.func_74776_a("TranslateY", this.translateY);
        compound.func_74776_a("TranslateZ", this.translateZ);
        compound.func_74757_a("IsTool", this.isTool);
        compound.func_74757_a("IsNormalItem", this.isNormalItem);
        compound.func_74768_a("DigSpeed", this.digSpeed);
        compound.func_74768_a("ArmorType", this.armorType);
        compound.func_74768_a("Enchantability", this.enchantability);
        compound.func_74768_a("MaxItemUseDuration", this.maxItemUseDuration);
        compound.func_74768_a("ItemUseAction", this.itemUseAction);
        return compound;
    }

    public void setItemNBT(NBTTagCompound compound) {
        this.durabilityShow = compound.func_74767_n("DurabilityShow");
        this.durabilityValue = compound.func_74769_h("DurabilityValue");
        if (compound.func_74764_b("DurabilityColor")) {
            this.durabilityColor = compound.func_74762_e("DurabilityColor");
        }
        this.itemColor = compound.func_74762_e("ItemColor");
        this.stackSize = compound.func_74762_e("MaxStackSize");
        this.texture = compound.func_74779_i("ItemTexture");
        this.rotationX = compound.func_74760_g("RotationX");
        this.rotationY = compound.func_74760_g("RotationY");
        this.rotationZ = compound.func_74760_g("RotationZ");
        this.rotationXRate = compound.func_74760_g("RotationXRate");
        this.rotationYRate = compound.func_74760_g("RotationYRate");
        this.rotationZRate = compound.func_74760_g("RotationZRate");
        this.scaleX = compound.func_74760_g("ScaleX");
        this.scaleY = compound.func_74760_g("ScaleY");
        this.scaleZ = compound.func_74760_g("ScaleZ");
        this.translateX = compound.func_74760_g("TranslateX");
        this.translateY = compound.func_74760_g("TranslateY");
        this.translateZ = compound.func_74760_g("TranslateZ");
        this.isTool = compound.func_74767_n("IsTool");
        this.isNormalItem = compound.func_74767_n("IsNormalItem");
        this.digSpeed = compound.func_74762_e("DigSpeed");
        this.armorType = compound.func_74762_e("ArmorType");
        this.enchantability = compound.func_74762_e("Enchantability");
        this.maxItemUseDuration = compound.func_74762_e("MaxItemUseDuration");
        this.itemUseAction = compound.func_74762_e("ItemUseAction");
    }

    public void saveScriptData() {
        NBTTagCompound c = this.item.func_77978_p();
        if (c == null) {
            c = new NBTTagCompound();
            this.item.func_77982_d(c);
        }
        c.func_74782_a("ScriptedData", (NBTBase)this.getScriptNBT(new NBTTagCompound()));
    }

    public void loadScriptData() {
        NBTTagCompound c = this.item.func_77978_p();
        if (c != null) {
            this.setScriptNBT(c.func_74775_l("ScriptedData"));
        }
    }

    public void saveItemData() {
        NBTTagCompound c = this.item.func_77978_p();
        if (c == null) {
            c = new NBTTagCompound();
            this.item.func_77982_d(c);
        }
        c.func_74782_a("ItemData", (NBTBase)this.getItemNBT(new NBTTagCompound()));
    }

    public void loadItemData() {
        NBTTagCompound c = this.item.func_77978_p();
        if (c != null && !c.func_74775_l("ItemData").func_82582_d()) {
            this.setItemNBT(c.func_74775_l("ItemData"));
        }
    }
}

