/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import noppes.npcs.client.ClientCacheHandler;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.constants.EnumAnimationPart;
import noppes.npcs.controllers.data.AnimationData;
import noppes.npcs.controllers.data.Frame;
import noppes.npcs.controllers.data.FramePart;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModelRenderer.class})
public abstract class MixinModelRenderer {
    @Shadow
    public float rotationPointX;
    @Shadow
    public float rotationPointY;
    @Shadow
    public float rotationPointZ;
    @Shadow
    public float rotateAngleX;
    @Shadow
    public float rotateAngleY;
    @Shadow
    public float rotateAngleZ;
    @Shadow
    public float offsetX;
    @Shadow
    public float offsetY;
    @Shadow
    public float offsetZ;
    @Shadow
    public boolean isHidden;
    @Shadow
    public boolean showModel;
    @Shadow
    public boolean compiled;
    @Shadow
    private int displayList;
    @Shadow
    public List childModels;
    @Shadow
    public ModelBase baseModel;

    @Shadow
    abstract void compileDisplayList(float var1);

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public void render(float p_78785_1_) {
        if (ClientEventHandler.partNames.isEmpty()) {
            String[] headNames = new String[]{"field_78116_c", "bipedHead", "bipedHeadwear", "head", "Head", "headwear", "bipedHeadg", "bipedHeadt", "bipedHeadgh", "bipedHeadv", "bipedHeadb", "bipedHeadt2"};
            String[] bodyNames = new String[]{"field_78115_e", "bipedBody", "B1", "body", "Body", "UpperBody", "Body1", "BodyBase"};
            String[] larmNames = new String[]{"field_78113_g", "bipedLeftArm", "LA", "leftarm", "ArmL", "Arm1L", "ArmL1"};
            String[] rarmNames = new String[]{"field_78112_f", "bipedRightArm", "RA", "rightarm", "ArmR", "Arm1R", "ArmR1"};
            String[] llegNames = new String[]{"field_78124_i", "bipedLeftLeg", "LL", "leftleg", "LegL", "Leg1L", "LegL1"};
            String[] rlegNames = new String[]{"field_78123_h", "bipedRightLeg", "RL", "rightleg", "LegR", "Leg1R", "LegR1"};
            ClientEventHandler.partNames.put(EnumAnimationPart.HEAD, headNames);
            ClientEventHandler.partNames.put(EnumAnimationPart.BODY, bodyNames);
            ClientEventHandler.partNames.put(EnumAnimationPart.LEFT_ARM, larmNames);
            ClientEventHandler.partNames.put(EnumAnimationPart.RIGHT_ARM, rarmNames);
            ClientEventHandler.partNames.put(EnumAnimationPart.LEFT_LEG, llegNames);
            ClientEventHandler.partNames.put(EnumAnimationPart.RIGHT_LEG, rlegNames);
        }
        if (!this.isHidden && this.showModel) {
            AnimationData animData;
            if (!this.compiled) {
                this.compileDisplayList(p_78785_1_);
            }
            float prevPointX = this.rotationPointX;
            float prevPointY = this.rotationPointY;
            float prevPointZ = this.rotationPointZ;
            float prevAngleX = this.rotateAngleX;
            float prevAngleY = this.rotateAngleY;
            float prevAngleZ = this.rotateAngleZ;
            FramePart currentPart = null;
            if (ClientEventHandler.renderingNpc != null && ClientEventHandler.renderingNpc.display.animationData.isActive()) {
                animData = ClientEventHandler.renderingNpc.display.animationData;
                EnumAnimationPart partType = this.getPartType((ModelRenderer)this);
                if (partType != null && animData != null) {
                    Frame frame = (Frame)animData.animation.currentFrame();
                    if (frame.frameParts.containsKey((Object)partType)) {
                        currentPart = frame.frameParts.get((Object)partType);
                        currentPart.interpolateOffset();
                        currentPart.interpolateAngles();
                        this.rotationPointX += currentPart.prevPivots[0];
                        this.rotationPointY += currentPart.prevPivots[1];
                        this.rotationPointZ += currentPart.prevPivots[2];
                        this.rotateAngleX = currentPart.prevRotations[0];
                        this.rotateAngleY = currentPart.prevRotations[1];
                        this.rotateAngleZ = currentPart.prevRotations[2];
                    }
                }
            }
            if (ClientEventHandler.renderingPlayer != null) {
                ClientEventHandler.playerModel = ((ModelRenderer)this).field_78810_s;
            }
            if (ClientEventHandler.renderingPlayer != null && ClientCacheHandler.playerAnimations.containsKey(ClientEventHandler.renderingPlayer.func_110124_au())) {
                EnumAnimationPart partType;
                ClientEventHandler.playerModel = ((ModelRenderer)this).field_78810_s;
                animData = ClientCacheHandler.playerAnimations.get(ClientEventHandler.renderingPlayer.func_110124_au());
                EnumAnimationPart mainPartType = this.getPlayerPartType((ModelRenderer)this);
                EnumAnimationPart enumAnimationPart = partType = mainPartType != null ? mainPartType : this.pivotEqualPart((ModelRenderer)this);
                if (partType != null && animData != null && animData.animation != null && animData.isActive()) {
                    FramePart originalPart = ClientEventHandler.originalValues.get((ModelRenderer)this);
                    Frame frame = (Frame)animData.animation.currentFrame();
                    if (originalPart != null && frame != null && frame.frameParts.containsKey((Object)partType)) {
                        FramePart part = frame.frameParts.get((Object)partType);
                        if (partType == mainPartType) {
                            part.interpolateAngles();
                            part.interpolateOffset();
                            this.rotationPointX = originalPart.pivot[0] + part.prevPivots[0];
                            this.rotationPointY = originalPart.pivot[1] + part.prevPivots[1];
                            this.rotationPointZ = originalPart.pivot[2] + part.prevPivots[2];
                            this.rotateAngleX = part.prevRotations[0];
                            this.rotateAngleY = part.prevRotations[1];
                            this.rotateAngleZ = part.prevRotations[2];
                        } else {
                            currentPart = part;
                            this.rotateAngleZ += part.prevRotations[2];
                        }
                    }
                }
            }
            GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX == 0.0f && this.rotationPointY == 0.0f && this.rotationPointZ == 0.0f) {
                    GL11.glCallList((int)this.displayList);
                    if (this.childModels != null) {
                        for (int i = 0; i < this.childModels.size(); ++i) {
                            if (!(this.childModels.get(i) instanceof ModelRenderer)) continue;
                            ((ModelRenderer)this.childModels.get(i)).func_78785_a(p_78785_1_);
                        }
                    }
                } else {
                    GL11.glTranslatef((float)(this.rotationPointX * p_78785_1_), (float)(this.rotationPointY * p_78785_1_), (float)(this.rotationPointZ * p_78785_1_));
                    GL11.glCallList((int)this.displayList);
                    if (this.childModels != null) {
                        for (int i = 0; i < this.childModels.size(); ++i) {
                            if (!(this.childModels.get(i) instanceof ModelRenderer)) continue;
                            ((ModelRenderer)this.childModels.get(i)).func_78785_a(p_78785_1_);
                        }
                    }
                    GL11.glTranslatef((float)(-this.rotationPointX * p_78785_1_), (float)(-this.rotationPointY * p_78785_1_), (float)(-this.rotationPointZ * p_78785_1_));
                }
            } else {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(this.rotationPointX * p_78785_1_), (float)(this.rotationPointY * p_78785_1_), (float)(this.rotationPointZ * p_78785_1_));
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glCallList((int)this.displayList);
                if (this.childModels != null) {
                    for (int i = 0; i < this.childModels.size(); ++i) {
                        if (!(this.childModels.get(i) instanceof ModelRenderer)) continue;
                        ((ModelRenderer)this.childModels.get(i)).func_78785_a(p_78785_1_);
                    }
                }
                GL11.glPopMatrix();
            }
            if (currentPart != null) {
                this.rotationPointX = prevPointX;
                this.rotationPointY = prevPointY;
                this.rotationPointZ = prevPointZ;
                this.rotateAngleX = prevAngleX;
                this.rotateAngleY = prevAngleY;
                this.rotateAngleZ = prevAngleZ;
            }
        }
    }

    public EnumAnimationPart getPlayerPartType(ModelRenderer renderer) {
        if (renderer.field_78810_s instanceof ModelBiped) {
            if (renderer == ((ModelBiped)renderer.field_78810_s).field_78116_c || renderer == ((ModelBiped)renderer.field_78810_s).field_78114_d) {
                return EnumAnimationPart.HEAD;
            }
            if (renderer == ((ModelBiped)renderer.field_78810_s).field_78115_e) {
                return EnumAnimationPart.BODY;
            }
            if (renderer == ((ModelBiped)renderer.field_78810_s).field_78112_f) {
                return EnumAnimationPart.RIGHT_ARM;
            }
            if (renderer == ((ModelBiped)renderer.field_78810_s).field_78113_g) {
                return EnumAnimationPart.LEFT_ARM;
            }
            if (renderer == ((ModelBiped)renderer.field_78810_s).field_78123_h) {
                return EnumAnimationPart.RIGHT_LEG;
            }
            if (renderer == ((ModelBiped)renderer.field_78810_s).field_78124_i) {
                return EnumAnimationPart.LEFT_LEG;
            }
        }
        try {
            Field[] declared;
            Class<?> ModelBipedBody = Class.forName("JinRyuu.JRMCore.entity.ModelBipedBody");
            ModelBase model = renderer.field_78810_s;
            if (!(model instanceof ModelBiped)) {
                return null;
            }
            if (ClientEventHandler.declaredFieldCache.containsKey(ModelBipedBody)) {
                declared = ClientEventHandler.declaredFieldCache.get(ModelBipedBody);
            } else {
                declared = ModelBipedBody.getDeclaredFields();
                ClientEventHandler.declaredFieldCache.put(ModelBipedBody, declared);
            }
            Set<Map.Entry<EnumAnimationPart, String[]>> entrySet = ClientEventHandler.partNames.entrySet();
            for (Field f : declared) {
                f.setAccessible(true);
                for (Map.Entry<EnumAnimationPart, String[]> entry : entrySet) {
                    String[] names;
                    for (String partName : names = entry.getValue()) {
                        try {
                            if (!partName.equals(f.getName()) || renderer != f.get(model)) continue;
                            return entry.getKey();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public EnumAnimationPart pivotEqualPart(ModelRenderer renderer) {
        if (renderer.field_78810_s instanceof ModelBiped) {
            ModelRenderer head = ((ModelBiped)renderer.field_78810_s).field_78116_c;
            ModelRenderer body = ((ModelBiped)renderer.field_78810_s).field_78115_e;
            ModelRenderer larm = ((ModelBiped)renderer.field_78810_s).field_78113_g;
            ModelRenderer rarm = ((ModelBiped)renderer.field_78810_s).field_78112_f;
            ModelRenderer lleg = ((ModelBiped)renderer.field_78810_s).field_78124_i;
            ModelRenderer rleg = ((ModelBiped)renderer.field_78810_s).field_78123_h;
            if (this.pivotsEqual(renderer, head)) {
                return EnumAnimationPart.HEAD;
            }
            if (this.pivotsEqual(renderer, body)) {
                return EnumAnimationPart.BODY;
            }
            if (this.pivotsEqual(renderer, rarm)) {
                return EnumAnimationPart.RIGHT_ARM;
            }
            if (this.pivotsEqual(renderer, larm)) {
                return EnumAnimationPart.LEFT_ARM;
            }
            if (this.pivotsEqual(renderer, rleg)) {
                return EnumAnimationPart.RIGHT_LEG;
            }
            if (this.pivotsEqual(renderer, lleg)) {
                return EnumAnimationPart.LEFT_LEG;
            }
        }
        return null;
    }

    public boolean pivotsEqual(ModelRenderer m1, ModelRenderer m2) {
        return m1.field_78800_c == m2.field_78800_c && m1.field_78797_d == m2.field_78797_d && m1.field_78798_e == m2.field_78798_e;
    }

    public EnumAnimationPart getPartType(ModelRenderer renderer) {
        ModelBase model = renderer.field_78810_s;
        Set<Map.Entry<EnumAnimationPart, String[]>> entrySet = ClientEventHandler.partNames.entrySet();
        for (Class<?> RenderClass = renderer.field_78810_s.getClass(); RenderClass != Object.class; RenderClass = RenderClass.getSuperclass()) {
            Field[] declared;
            if (ClientEventHandler.declaredFieldCache.containsKey(RenderClass)) {
                declared = ClientEventHandler.declaredFieldCache.get(RenderClass);
            } else {
                declared = RenderClass.getDeclaredFields();
                ClientEventHandler.declaredFieldCache.put(RenderClass, declared);
            }
            for (Field f : declared) {
                f.setAccessible(true);
                for (Map.Entry<EnumAnimationPart, String[]> entry : entrySet) {
                    String[] names;
                    for (String partName : names = entry.getValue()) {
                        try {
                            if (!partName.equals(f.getName()) || renderer != f.get(model)) continue;
                            return entry.getKey();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return null;
    }
}

