/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.config.ConfigScript;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.INpcScriptHandler;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.event.PlayerEvent;

public class PlayerDataScript
implements INpcScriptHandler {
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public String scriptLanguage = "ECMAScript";
    private EntityPlayer player;
    private IPlayer playerAPI;
    private long lastPlayerUpdate = 0L;
    public long lastInited = -1L;
    public boolean enabled = false;

    public PlayerDataScript(EntityPlayer player) {
        if (player != null) {
            this.player = player;
        }
    }

    public void clear() {
        this.scripts = new ArrayList<ScriptContainer>();
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts = compound.func_74764_b("Scripts") ? NBTTags.GetScriptOld(compound.func_150295_c("Scripts", 10), this) : NBTTags.GetScript(compound, this);
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        if (!ScriptController.Instance.languages.containsKey(this.scriptLanguage)) {
            this.scriptLanguage = !ScriptController.Instance.languages.isEmpty() ? (String)ScriptController.Instance.languages.keySet().toArray()[0] : "ECMAScript";
        }
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("TotalScripts", this.scripts.size());
        for (int i = 0; i < this.scripts.size(); ++i) {
            compound.func_74782_a("Tab" + i, (NBTBase)this.scripts.get(i).writeToNBT(new NBTTagCompound()));
        }
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    public boolean isEnabled() {
        return ConfigScript.GlobalPlayerScripts && ScriptController.Instance.playerScripts.enabled && ScriptController.HasStart && (this.player == null || !this.player.field_70170_p.field_72995_K);
    }

    @Override
    public void callScript(EnumScriptType type, Event event) {
        this.callScript(type.function, event);
    }

    @Override
    public void callScript(String hookName, Event event) {
        if (this.isEnabled()) {
            if (ScriptController.Instance.lastLoaded > this.lastInited || ScriptController.Instance.lastPlayerUpdate > this.lastPlayerUpdate) {
                this.lastInited = ScriptController.Instance.lastLoaded;
                this.lastPlayerUpdate = ScriptController.Instance.lastPlayerUpdate;
                for (ScriptContainer scriptContainer : this.scripts) {
                    scriptContainer.errored = false;
                }
                if (!Objects.equals(hookName, EnumScriptType.INIT.function)) {
                    PlayerEvent playerEvent = (PlayerEvent)event;
                    EventHooks.onPlayerInit(this, playerEvent.player);
                }
            }
            for (ScriptContainer script : this.scripts) {
                if (script == null || script.errored || !script.hasCode()) continue;
                script.run(hookName, (Object)event);
            }
        }
    }

    @Override
    public boolean isClient() {
        return this.player.func_70613_aW();
    }

    @Override
    public boolean getEnabled() {
        return ScriptController.Instance.playerScripts.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        ScriptController.Instance.playerScripts.enabled = bo;
        this.enabled = bo;
    }

    @Override
    public String getLanguage() {
        return ScriptController.Instance.playerScripts.scriptLanguage;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public void setScripts(List<ScriptContainer> list) {
        this.scripts = list;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String noticeString() {
        if (this.player == null) {
            return "Global script";
        }
        BlockPos pos = new BlockPos((Entity)this.player);
        return PlayerDataScript.toStringHelper(this.player).add("x", pos.getX()).add("y", pos.getY()).add("z", pos.getZ()).toString();
    }

    public IPlayer getPlayer() {
        if (this.playerAPI == null) {
            this.playerAPI = (IPlayer)NpcAPI.Instance().getIEntity((Entity)this.player);
        }
        return this.playerAPI;
    }

    @Override
    public Map<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> longStringEntry : script.console.entrySet()) {
                map.put(longStringEntry.getKey(), " tab " + tab + ":\n" + longStringEntry.getValue());
            }
        }
        return map;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;
        private boolean omitEmptyValues;

        private ToStringHelper(String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.omitEmptyValues = false;
            this.className = (String)Preconditions.checkNotNull((Object)className);
        }

        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelper add(String name, @CheckForNull Object value) {
            return this.addHolder(name, value);
        }

        public ToStringHelper add(String name, boolean value) {
            return this.addUnconditionalHolder(name, String.valueOf(value));
        }

        public ToStringHelper add(String name, char value) {
            return this.addUnconditionalHolder(name, String.valueOf(value));
        }

        public ToStringHelper add(String name, double value) {
            return this.addUnconditionalHolder(name, String.valueOf(value));
        }

        public ToStringHelper add(String name, float value) {
            return this.addUnconditionalHolder(name, String.valueOf(value));
        }

        public ToStringHelper add(String name, int value) {
            return this.addUnconditionalHolder(name, String.valueOf(value));
        }

        public ToStringHelper add(String name, long value) {
            return this.addUnconditionalHolder(name, String.valueOf(value));
        }

        public ToStringHelper addValue(@CheckForNull Object value) {
            return this.addHolder(value);
        }

        public ToStringHelper addValue(boolean value) {
            return this.addUnconditionalHolder(String.valueOf(value));
        }

        public ToStringHelper addValue(char value) {
            return this.addUnconditionalHolder(String.valueOf(value));
        }

        public ToStringHelper addValue(double value) {
            return this.addUnconditionalHolder(String.valueOf(value));
        }

        public ToStringHelper addValue(float value) {
            return this.addUnconditionalHolder(String.valueOf(value));
        }

        public ToStringHelper addValue(int value) {
            return this.addUnconditionalHolder(String.valueOf(value));
        }

        public ToStringHelper addValue(long value) {
            return this.addUnconditionalHolder(String.valueOf(value));
        }

        private static boolean isEmpty(Object value) {
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).isEmpty();
            }
            if (value instanceof Map) {
                return ((Map)value).isEmpty();
            }
            if (value instanceof Optional) {
                return !((Optional)value).isPresent();
            }
            if (value instanceof OptionalInt) {
                return !((OptionalInt)value).isPresent();
            }
            if (value instanceof OptionalLong) {
                return !((OptionalLong)value).isPresent();
            }
            if (value instanceof OptionalDouble) {
                return !((OptionalDouble)value).isPresent();
            }
            if (value instanceof com.google.common.base.Optional) {
                return !((com.google.common.base.Optional)value).isPresent();
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) == 0;
            }
            return false;
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            boolean omitEmptyValuesSnapshot = this.omitEmptyValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object value = valueHolder.value;
                if (valueHolder instanceof UnconditionalValueHolder || !(value == null ? omitNullValuesSnapshot : omitEmptyValuesSnapshot && ToStringHelper.isEmpty(value))) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value != null && value.getClass().isArray()) {
                        Object[] objectArray = new Object[]{value};
                        String arrayString = Arrays.deepToString(objectArray);
                        builder.append(arrayString, 1, arrayString.length() - 1);
                    } else {
                        builder.append(value);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(@CheckForNull Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            return this;
        }

        private ToStringHelper addHolder(String name, @CheckForNull Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            valueHolder.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        private UnconditionalValueHolder addUnconditionalHolder() {
            UnconditionalValueHolder valueHolder = new UnconditionalValueHolder();
            this.holderTail = this.holderTail.next = valueHolder;
            return valueHolder;
        }

        private ToStringHelper addUnconditionalHolder(Object value) {
            UnconditionalValueHolder valueHolder = this.addUnconditionalHolder();
            valueHolder.value = value;
            return this;
        }

        private ToStringHelper addUnconditionalHolder(String name, Object value) {
            UnconditionalValueHolder valueHolder = this.addUnconditionalHolder();
            valueHolder.value = value;
            valueHolder.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        private static class ValueHolder {
            @CheckForNull
            String name;
            @CheckForNull
            Object value;
            @CheckForNull
            ValueHolder next;

            private ValueHolder() {
            }
        }

        private static final class UnconditionalValueHolder
        extends ValueHolder {
            private UnconditionalValueHolder() {
            }
        }
    }
}

