/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import noppes.npcs.DataDisplay;
import noppes.npcs.Server;
import noppes.npcs.api.handler.data.IAnimation;
import noppes.npcs.api.handler.data.IAnimationData;
import noppes.npcs.constants.EnumAnimationPart;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.Animation;
import noppes.npcs.controllers.data.Frame;
import noppes.npcs.controllers.data.FramePart;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;

public class AnimationData
implements IAnimationData {
    public Object parent;
    public Animation animation;
    public boolean allowAnimation = false;
    private final HashSet<Integer> cachedAnimationIDs = new HashSet();
    public EntityLivingBase animationEntity;
    public int finishedTime = -1;
    public int finishedFrame = -1;

    public AnimationData(Object parent) {
        this.parent = parent;
        if (parent instanceof DataDisplay) {
            this.animationEntity = ((DataDisplay)parent).npc;
        } else if (parent instanceof EntityPlayer) {
            this.animationEntity = (EntityLivingBase)parent;
        }
    }

    @Override
    public void updateClient() {
        this.updateClient(new EntityPlayer[0]);
    }

    public void updateClient(EntityPlayer ... excludedPlayers) {
        float range;
        EntityPlayer sendingEntity = this.parent instanceof PlayerData ? ((PlayerData)this.parent).player : (this.parent instanceof DataDisplay ? ((DataDisplay)this.parent).npc : null);
        float f = range = this.parent instanceof PlayerData ? 160.0f : 60.0f;
        if (sendingEntity != null) {
            if (sendingEntity.field_71093_bK != sendingEntity.field_70170_p.field_73011_w.field_76574_g) {
                sendingEntity.field_71093_bK = sendingEntity.field_70170_p.field_73011_w.field_76574_g;
            }
            List entities = sendingEntity.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(sendingEntity.field_70165_t - (double)range), (double)(sendingEntity.field_70163_u - (double)range), (double)(sendingEntity.field_70161_v - (double)range), (double)(sendingEntity.field_70165_t + (double)range), (double)(sendingEntity.field_70163_u + (double)range), (double)(sendingEntity.field_70161_v + (double)range)));
            entities.removeIf(player -> Arrays.stream(excludedPlayers).anyMatch(exp -> player == exp));
            NBTTagCompound animationNBT = null;
            for (EntityPlayer player2 : entities) {
                AnimationData animationData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player2).animationData;
                if (animationNBT == null && this.animation != null && !animationData.isCached(this.animation.getID())) {
                    animationNBT = this.animation.writeToNBT();
                }
                animationData.viewAnimation(this.animation, (EntityLivingBase)sendingEntity, this, animationNBT);
            }
        }
    }

    @Override
    public boolean isActive() {
        if (!this.allowAnimation || this.animation == null || this.animation.currentFrame == this.animation.frames.size() || this.animation.currentFrame() == null) {
            return false;
        }
        if (this.parent instanceof DataDisplay) {
            EntityNPCInterface npc = ((DataDisplay)this.parent).npc;
            if (!npc.func_70089_S()) {
                return false;
            }
            return this.animation.whileAttacking && npc.isAttacking() || this.animation.whileMoving && npc.isWalking() || this.animation.whileStanding && !npc.isWalking();
        }
        EntityPlayer player = this.parent instanceof PlayerData ? ((PlayerData)this.parent).player : (EntityPlayer)this.parent;
        if (!player.func_70089_S()) {
            return false;
        }
        boolean moving = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y) != 0.0;
        return this.animation.whileAttacking && player.func_142013_aG() - player.field_70173_aa < 20 || this.animation.whileMoving && moving || this.animation.whileStanding && !moving;
    }

    public boolean isCached(int id) {
        return this.cachedAnimationIDs.contains(id);
    }

    public void cacheAnimation(int id) {
        this.cachedAnimationIDs.add(id);
    }

    public void uncacheAnimation(int id) {
        this.cachedAnimationIDs.remove(id);
    }

    public void clearCache() {
        this.cachedAnimationIDs.clear();
    }

    public void viewAnimation(Animation animation, EntityLivingBase entity, AnimationData animationData, NBTTagCompound animationNBT) {
        NBTTagCompound data = animationData.writeToNBT(new NBTTagCompound());
        if (animation != null) {
            if (this.cachedAnimationIDs.contains(animation.getID())) {
                data.func_74768_a("AnimationID", animation.getID());
            } else {
                data.func_74782_a("Animation", (NBTBase)animationNBT);
            }
        }
        if (!(entity instanceof EntityPlayer)) {
            data.func_74768_a("EntityId", entity.func_145782_y());
        }
        Server.sendData((EntityPlayerMP)((PlayerData)this.parent).player, EnumPacketClient.UPDATE_ANIMATIONS, data, entity.func_70005_c_());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("AllowAnimation", this.allowAnimation);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.setEnabled(compound.func_74767_n("AllowAnimation"));
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.allowAnimation != enabled) {
            this.allowAnimation = enabled;
            if (this.parent instanceof EntityPlayer) {
                this.finishedTime = enabled ? -1 : ((EntityPlayer)this.parent).func_70654_ax();
            }
        }
    }

    @Override
    public boolean enabled() {
        return this.allowAnimation;
    }

    @Override
    public void setAnimation(IAnimation animation) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.animation = (Animation)animation;
        } else {
            Frame frame;
            Animation newAnim = new Animation();
            newAnim.readFromNBT(((Animation)animation).writeToNBT());
            if (this.isActive() && !newAnim.frames.isEmpty() && (frame = (Frame)this.animation.currentFrame()) != null) {
                Frame firstFrame = newAnim.frames.get(0);
                for (Map.Entry<EnumAnimationPart, FramePart> entry : frame.frameParts.entrySet()) {
                    if (!firstFrame.frameParts.containsKey((Object)entry.getKey())) continue;
                    FramePart prevFramePart = entry.getValue();
                    FramePart newFramePart = firstFrame.frameParts.get((Object)entry.getKey());
                    for (int i = 0; i < 3; ++i) {
                        newFramePart.prevPivots[i] = prevFramePart.prevPivots[i];
                        newFramePart.prevRotations[i] = prevFramePart.prevRotations[i];
                    }
                }
            }
            this.animation = newAnim;
            newAnim.parent = this;
        }
    }

    @Override
    public IAnimation getAnimation() {
        return this.animation;
    }
}

