/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.ImageDownloadAlt;
import noppes.npcs.client.renderer.ImageBufferDownloadAlt;
import noppes.npcs.client.renderer.RenderNPCInterface;

public class ImageData {
    private final ResourceLocation location;
    private final boolean isUrl;
    private ImageDownloadAlt imageDownloadAlt = null;
    private BufferedImage bufferedImage = null;
    private int totalWidth;
    private int totalHeight;
    private boolean gotWidthHeight;
    private boolean invalid;

    public ImageData(String directory) {
        this.location = new ResourceLocation(directory);
        if (directory.startsWith("https://")) {
            this.isUrl = true;
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            this.imageDownloadAlt = new ImageDownloadAlt(null, directory, new ResourceLocation("customnpcs:textures/gui/invisible.png"), (IImageBuffer)new ImageBufferDownloadAlt(true, false));
            texturemanager.func_110579_a(this.location, (ITextureObject)this.imageDownloadAlt);
        } else {
            this.isUrl = false;
        }
    }

    public ImageData(String directory, boolean x64, ResourceLocation resource) {
        this.location = resource;
        this.isUrl = true;
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        this.imageDownloadAlt = new ImageDownloadAlt(null, directory, SkinManager.field_152793_a, (IImageBuffer)new ImageBufferDownloadAlt(x64));
        texturemanager.func_110579_a(this.location, (ITextureObject)this.imageDownloadAlt);
    }

    public boolean imageLoaded() {
        if (!this.gotWidthHeight) {
            try {
                if (!this.isUrl) {
                    this.getWidthHeight();
                } else {
                    this.getURLWidthHeight();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return !this.invalid && this.location != null && this.gotWidthHeight;
    }

    public boolean invalid() {
        return this.invalid;
    }

    public void bindTexture() {
        ResourceLocation location = this.getLocation();
        if (location != null && !this.invalid) {
            try {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
            }
            catch (Exception exception) {
                this.invalid = true;
            }
        }
    }

    public void renderEngineBind() {
        ResourceLocation location = this.getLocation();
        if (location != null && !this.invalid) {
            try {
                RenderNPCInterface.staticRenderManager.field_78724_e.func_110577_a(location);
            }
            catch (Exception exception) {
                this.invalid = true;
            }
        }
    }

    public ResourceLocation getLocation() {
        return this.isUrl && this.imageDownloadAlt.getBufferedImage() == null ? null : this.location;
    }

    public BufferedImage getBufferedImage() {
        if (this.bufferedImage == null) {
            if (!this.isUrl) {
                try {
                    IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.location);
                    InputStream inputstream = iresource.func_110527_b();
                    this.bufferedImage = ImageIO.read(inputstream);
                }
                catch (IOException iOException) {}
            } else {
                this.bufferedImage = this.imageDownloadAlt.getBufferedImage();
            }
        }
        return this.bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWidthHeight() throws IOException {
        if (this.invalid) {
            return;
        }
        try (InputStream inputstream = null;){
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.location);
            inputstream = iresource.func_110527_b();
            BufferedImage bufferedimage = ImageIO.read(inputstream);
            this.gotWidthHeight = true;
            this.totalWidth = bufferedimage.getWidth();
            this.totalHeight = bufferedimage.getHeight();
            this.correctWidthHeight();
        }
    }

    private void getURLWidthHeight() {
        if (this.imageDownloadAlt.getBufferedImage() != null && !this.invalid) {
            this.gotWidthHeight = true;
            this.totalWidth = this.imageDownloadAlt.getBufferedImage().getWidth();
            this.totalHeight = this.imageDownloadAlt.getBufferedImage().getHeight();
            this.correctWidthHeight();
        }
    }

    private void correctWidthHeight() {
        this.totalWidth = Math.max(this.totalWidth, 1);
        this.totalHeight = Math.max(this.totalHeight, 1);
    }

    public int getTotalWidth() {
        return this.gotWidthHeight ? this.totalWidth : -1;
    }

    public int getTotalHeight() {
        return this.gotWidthHeight ? this.totalHeight : -1;
    }
}

