/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.command;

import java.util.Collection;
import java.util.List;
import kamkeel.command.CommandKamkeelBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.PlayerData;

public class DialogCategoryCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "dialogcat";
    }

    @Override
    public String getDescription() {
        return "Dialog Category operations";
    }

    @CommandKamkeelBase.SubCommand(desc="Find dialog category id number by its name", usage="<dialog cat name>")
    public void id(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            DialogCategoryCommand.sendError(sender, "Please provide a name for the dialog category", new Object[0]);
            return;
        }
        String catName = String.join((CharSequence)" ", args).toLowerCase();
        Collection<DialogCategory> dialogCats = DialogController.Instance.categories.values();
        int count = 0;
        for (DialogCategory cat : dialogCats) {
            if (!cat.getName().toLowerCase().contains(catName)) continue;
            DialogCategoryCommand.sendResult(sender, String.format("Dialog Cat \u00a7e%d\u00a77 - \u00a7c'%s'", cat.id, cat.getName()), new Object[0]);
            ++count;
        }
        if (count == 0) {
            DialogCategoryCommand.sendResult(sender, String.format("No Dialog Cat found with name: \u00a7c'%s'", catName), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Read a dialog category for a player", usage="<player> <dialogcatid>")
    public void read(ICommandSender sender, String[] args) throws CommandException {
        int dialogCatId;
        String playername = args[0];
        try {
            dialogCatId = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            DialogCategoryCommand.sendError(sender, "DialogCatID must be an integer: " + args[1], new Object[0]);
            return;
        }
        List<PlayerData> data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            DialogCategoryCommand.sendError(sender, String.format("Unknown player '%s'", playername), new Object[0]);
            return;
        }
        DialogCategory dialogCategory = DialogController.Instance.categories.get(dialogCatId);
        if (dialogCategory == null) {
            DialogCategoryCommand.sendError(sender, "Unknown DialogCatID: " + dialogCatId, new Object[0]);
            return;
        }
        int count = 0;
        for (PlayerData playerdata : data) {
            for (Dialog dialog : dialogCategory.dialogs.values()) {
                playerdata.dialogData.dialogsRead.add(dialog.id);
                ++count;
            }
            playerdata.save();
            playerdata.updateClient = true;
            DialogCategoryCommand.sendResult(sender, String.format("Read Dialog Cat \u00a7c'%s' \u00a7e%d\u00a77 for Player '\u00a7b%s\u00a77'", dialogCategory.getName(), dialogCatId, playerdata.playername), new Object[0]);
            DialogCategoryCommand.sendResult(sender, String.format("Read a total of \u00a7b%d \u00a77dialogs", count), new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Unread a dialog category for a player", usage="<player> <dialogcatid>")
    public void unread(ICommandSender sender, String[] args) throws CommandException {
        int dialogCatId;
        String playername = args[0];
        try {
            dialogCatId = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            DialogCategoryCommand.sendError(sender, "DialogCatID must be an integer: " + args[1], new Object[0]);
            return;
        }
        List<PlayerData> data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            DialogCategoryCommand.sendError(sender, String.format("Unknown player '%s'", playername), new Object[0]);
            return;
        }
        DialogCategory dialogCategory = DialogController.Instance.categories.get(dialogCatId);
        if (dialogCategory == null) {
            DialogCategoryCommand.sendError(sender, "Unknown DialogCatID: " + dialogCatId, new Object[0]);
            return;
        }
        int count = 0;
        for (PlayerData playerdata : data) {
            for (Dialog dialog : dialogCategory.dialogs.values()) {
                playerdata.dialogData.dialogsRead.remove(dialog.id);
                ++count;
            }
            playerdata.save();
            playerdata.updateClient = true;
            DialogCategoryCommand.sendResult(sender, String.format("Unread Dialog Cat \u00a7c'%s' \u00a7e%d\u00a77 for Player '\u00a7b%s\u00a77'", dialogCategory.getName(), dialogCatId, playerdata.playername), new Object[0]);
            DialogCategoryCommand.sendResult(sender, String.format("Unread a total of \u00a7b%d \u00a77dialogs", count), new Object[0]);
        }
    }
}

