/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.utils;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import ru.laytin.exlntab.handlers.ConfigHandler;

public class PhotoLoader
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(PhotoLoader.class.getName());
    private final String username;
    private final ConcurrentHashMap<String, BufferedImage> skinImages;
    private final List<String> endUpload;

    public PhotoLoader(String username, ConcurrentHashMap<String, BufferedImage> skinImages, List<String> endUpload) {
        this.username = username;
        this.skinImages = skinImages;
        this.endUpload = endUpload;
        LOGGER.log(Level.INFO, "Created PhotoLoader for username: {0}", username);
    }

    @Override
    public void run() {
        LOGGER.log(Level.INFO, "Starting image loading for username: {0}", this.username);
        BufferedImage skinImage = null;
        try {
            String avatarUrl = ConfigHandler.avatarUrl.replace("%player%", this.username);
            LOGGER.log(Level.INFO, "Attempting to load avatar from URL: {0}", avatarUrl);
            skinImage = ImageIO.read(new URL(avatarUrl));
            if (skinImage != null) {
                LOGGER.log(Level.INFO, "Successfully loaded avatar for username: {0}", this.username);
                this.skinImages.put(this.username, skinImage);
                this.endUpload.add(this.username);
                LOGGER.log(Level.INFO, "Added avatar to skinImages and endUpload for username: {0}", this.username);
            } else {
                LOGGER.log(Level.WARNING, "Loaded avatar is null for username: {0}", this.username);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load avatar for username: " + this.username, e);
        }
        if (!this.endUpload.contains(this.username)) {
            LOGGER.log(Level.INFO, "Avatar not available, attempting to load skin for username: {0}", this.username);
            try {
                String skinUrl = ConfigHandler.skinUrl.replace("%player%", this.username);
                LOGGER.log(Level.INFO, "Attempting to load skin from URL: {0}", skinUrl);
                skinImage = ImageIO.read(new URL(skinUrl));
                if (skinImage != null) {
                    LOGGER.log(Level.INFO, "Successfully loaded skin for username: {0}", this.username);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load skin for username: " + this.username + ", falling back to default Steve skin", e);
                try {
                    skinImage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("textures/entity/steve.png")).func_110527_b());
                    LOGGER.log(Level.INFO, "Using default Steve skin for username: {0}", this.username);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Failed to load default Steve skin for username: " + this.username, ex);
                    throw new RuntimeException("Could not load any skin for " + this.username, ex);
                }
            }
            if (skinImage != null) {
                BufferedImage faceImage = this.faceFromSkin(skinImage);
                this.skinImages.put(this.username, faceImage);
                this.endUpload.add(this.username);
                LOGGER.log(Level.INFO, "Processed and stored face image for username: {0}", this.username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage faceFromSkin(BufferedImage skinImage) {
        if (skinImage == null) {
            LOGGER.warning("Skin image is null for username: " + this.username);
            return this.createDefaultFace();
        }
        int BASE_SKIN_SIZE = 64;
        int BASE_FACE_SIZE = 8;
        int BASE_OVERLAY_OFFSET = 40;
        double scale = (double)skinImage.getHeight() / 64.0;
        int faceSize = (int)(8.0 * scale);
        int overlayOffset = (int)(40.0 * scale);
        if (skinImage.getWidth() < overlayOffset + faceSize || skinImage.getHeight() < faceSize * 2) {
            LOGGER.warning("Skin is too small for face extraction (using default): " + this.username);
            return this.createDefaultFace();
        }
        BufferedImage merged = new BufferedImage(faceSize, faceSize, 2);
        Graphics g = merged.getGraphics();
        try {
            BufferedImage face = skinImage.getSubimage(faceSize, faceSize, faceSize, faceSize);
            g.drawImage(face, 0, 0, null);
            if (skinImage.getWidth() >= overlayOffset + faceSize) {
                BufferedImage overlay = skinImage.getSubimage(overlayOffset, faceSize, faceSize, faceSize);
                g.drawImage(overlay, 0, 0, null);
            } else {
                LOGGER.fine("No overlay found in skin for username: " + this.username);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Failed to extract face for " + this.username + ": " + e.getMessage());
            BufferedImage bufferedImage = this.createDefaultFace();
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
        return merged;
    }

    private BufferedImage createDefaultFace() {
        try {
            return ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("textures/entity/steve.png")).func_110527_b());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to load default Steve face", e);
            return new BufferedImage(8, 8, 2);
        }
    }
}

