/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.render.font;

import java.awt.Font;
import java.awt.Point;
import java.awt.font.GlyphVector;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;
import ru.laytin.exlntab.render.font.GlyphCache;

public class StringCache {
    private static final int BASELINE_OFFSET = 7;
    private static final int UNDERLINE_OFFSET = 1;
    private static final int UNDERLINE_THICKNESS = 2;
    private static final int STRIKETHROUGH_OFFSET = -6;
    private static final int STRIKETHROUGH_THICKNESS = 2;
    private final GlyphCache glyphCache;
    private int[] colorTable;
    private WeakHashMap<Key, Entry> stringCache = new WeakHashMap();
    private WeakHashMap<String, Key> weakRefCache = new WeakHashMap();
    private Key lookupKey = new Key();
    private Glyph[][] digitGlyphs = new Glyph[4][];
    private boolean digitGlyphsReady = false;
    private boolean antiAliasEnabled = false;
    private Thread mainThread = Thread.currentThread();
    public float fontHeight;

    public StringCache() {
        this.glyphCache = new GlyphCache();
        this.colorTable = new int[32];
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
                int k1 = (k * 30 + l * 70) / 100;
                int l1 = (k * 30 + i1 * 70) / 100;
                k = j1;
                l = k1;
                i1 = l1;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            this.colorTable[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
        this.cacheDightGlyphs();
    }

    public GlyphCache getGlyphCache() {
        return this.glyphCache;
    }

    public void setDefaultFont(String fontName, int fontSize, boolean antiAlias) {
        this.glyphCache.setDefaultFont(fontName, fontSize, antiAlias);
        this.antiAliasEnabled = antiAlias;
        this.weakRefCache.clear();
        this.stringCache.clear();
        this.cacheUnicodeGlyphs();
        this.cacheDightGlyphs();
        this.updateHeight();
    }

    public Font usedFont() {
        return this.glyphCache.getUsedFonts().get(0);
    }

    public void setCustomFont(InputStream stream, int fontSize, boolean antiAlias) throws Exception {
        this.glyphCache.setCustomFont(stream, fontSize, antiAlias);
        this.antiAliasEnabled = antiAlias;
        this.weakRefCache.clear();
        this.stringCache.clear();
        this.cacheUnicodeGlyphs();
        this.cacheDightGlyphs();
        this.updateHeight();
    }

    private void cacheUnicodeGlyphs() {
        StringBuilder sb = new StringBuilder();
        for (char c = ' '; c < '\u0400'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        this.cacheString(sb.toString());
    }

    public void updateHeight() {
        float height = 0.0f;
        float minY = 2.1474836E9f;
        float maxY = -2.1474836E9f;
        for (Glyph g : this.cacheString((String)"AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz\u0410\u0430\u0411\u0431\u0412\u0432\u0413\u0433\u0414\u0434\u0415\u0435\u0401\u0451\u0416\u0436\u0417\u0437\u0418\u0438\u0439\u0419\u041a\u043a\u041b\u043b\u041c\u043c\u041d\u043d\u041e\u043e\u041f\u043f\u0420\u0440\u0421\u0441\u0422\u0442\u0423\u0443\u0424\u0444\u0425\u0445\u0426\u0446\u0427\u0447\u0428\u0448\u0429\u0449\u042a\u044a\u042b\u044b\u042c\u044c\u042d\u044d\u042e\u044e\u042f\u044f1234567890").glyphs) {
            if ((float)g.texture.height > height) {
                height = g.texture.height;
            }
            if (g.y < minY) {
                minY = g.y;
            }
            if (!(g.y > maxY)) continue;
            maxY = g.y;
        }
        this.fontHeight = (maxY + height) / 2.0f - minY / 2.0f;
    }

    private void cacheDightGlyphs() {
        this.digitGlyphsReady = false;
        this.digitGlyphs[0] = this.cacheString((String)"0123456789").glyphs;
        this.digitGlyphs[1] = this.cacheString((String)"\u00a7l0123456789").glyphs;
        this.digitGlyphs[2] = this.cacheString((String)"\u00a7o0123456789").glyphs;
        this.digitGlyphs[3] = this.cacheString((String)"\u00a7l\u00a7o0123456789").glyphs;
        this.digitGlyphsReady = true;
    }

    public float renderString(String str, float startX, float startY, int initialColor, boolean shadowFlag) {
        if (str == null) {
            return 0.0f;
        }
        if (str.isEmpty()) {
            return startX;
        }
        Entry entry = this.cacheString(str);
        startY += 7.0f;
        if ((initialColor >> 24 & 0xFF) == 0) {
            initialColor -= 0x1000000;
        }
        int color = initialColor;
        int boundTextureName = 0;
        if (this.antiAliasEnabled) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        if (shadowFlag) {
            tessellator.func_78370_a(0, 0, 0, color >> 24 & 0xFF);
        } else {
            tessellator.func_78370_a(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
        }
        byte fontStyle = 0;
        int colorIndex = 0;
        for (int glyphIndex = 0; glyphIndex < entry.glyphs.length; ++glyphIndex) {
            while (colorIndex < entry.colors.length && entry.glyphs[glyphIndex].stringIndex >= entry.colors[colorIndex].stringIndex) {
                if (!shadowFlag) {
                    color = this.applyColorCode(entry.colors[colorIndex].colorCode, initialColor, shadowFlag);
                }
                fontStyle = entry.colors[colorIndex].fontStyle;
                ++colorIndex;
            }
            Glyph glyph = entry.glyphs[glyphIndex];
            GlyphCache.Entry texture = glyph.texture;
            if (texture == null) {
                System.out.println("WARNING: Glyph texture is null for char: '" + str.charAt(glyph.stringIndex) + "' at index " + glyph.stringIndex);
                continue;
            }
            float glyphX = glyph.x;
            char c = str.charAt(glyph.stringIndex);
            if (c >= '0' && c <= '9') {
                int oldWidth = texture.width;
                GlyphCache.Entry digitTexture = this.digitGlyphs[fontStyle][c - 48].texture;
                if (digitTexture != null) {
                    int newWidth = digitTexture.width;
                    glyphX += (float)(oldWidth - newWidth >> 1);
                    texture = digitTexture;
                } else {
                    System.out.println("WARNING: Digit glyph texture is null for char: " + c);
                }
            }
            if (boundTextureName != texture.textureName) {
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                if (shadowFlag) {
                    tessellator.func_78370_a(0, 0, 0, color >> 24 & 0xFF);
                } else {
                    tessellator.func_78370_a(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
                }
                GL11.glBindTexture((int)3553, (int)texture.textureName);
                boundTextureName = texture.textureName;
            }
            float x1 = startX + glyphX / 2.0f;
            float x2 = startX + (glyphX + (float)texture.width) / 2.0f;
            float y1 = startY + glyph.y / 2.0f;
            float y2 = startY + (glyph.y + (float)texture.height) / 2.0f;
            tessellator.func_78374_a((double)x1, (double)y1, 0.0, (double)texture.u1, (double)texture.v1);
            tessellator.func_78374_a((double)x1, (double)y2, 0.0, (double)texture.u1, (double)texture.v2);
            tessellator.func_78374_a((double)x2, (double)y2, 0.0, (double)texture.u2, (double)texture.v2);
            tessellator.func_78374_a((double)x2, (double)y1, 0.0, (double)texture.u2, (double)texture.v1);
        }
        tessellator.func_78381_a();
        if (entry.specialRender) {
            int renderStyle = 0;
            color = initialColor;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78370_a(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
            int j = 0;
            for (int i = 0; i < entry.glyphs.length; ++i) {
                float y2;
                float y1;
                float x2;
                float x1;
                while (j < entry.colors.length && entry.glyphs[i].stringIndex >= entry.colors[j].stringIndex) {
                    color = this.applyColorCode(entry.colors[j].colorCode, initialColor, shadowFlag);
                    renderStyle = entry.colors[j].renderStyle;
                    ++j;
                }
                Glyph glyph = entry.glyphs[i];
                float glyphSpace = glyph.advance - (float)glyph.texture.width;
                if (renderStyle & true) {
                    x1 = startX + (glyph.x - glyphSpace) / 2.0f;
                    x2 = startX + (glyph.x + glyph.advance) / 2.0f;
                    y1 = startY + 0.5f;
                    y2 = startY + 1.5f;
                    tessellator.func_78377_a((double)x1, (double)y1, 0.0);
                    tessellator.func_78377_a((double)x1, (double)y2, 0.0);
                    tessellator.func_78377_a((double)x2, (double)y2, 0.0);
                    tessellator.func_78377_a((double)x2, (double)y1, 0.0);
                }
                if ((renderStyle & 2) == 0) continue;
                x1 = startX + (glyph.x - glyphSpace) / 2.0f;
                x2 = startX + (glyph.x + glyph.advance) / 2.0f;
                y1 = startY + -3.0f;
                y2 = startY + -2.0f;
                tessellator.func_78377_a((double)x1, (double)y1, 0.0);
                tessellator.func_78377_a((double)x1, (double)y2, 0.0);
                tessellator.func_78377_a((double)x2, (double)y2, 0.0);
                tessellator.func_78377_a((double)x2, (double)y1, 0.0);
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        return (float)entry.advance / 2.0f + startX;
    }

    public float getStringWidth(String str) {
        if (str == null || str.isEmpty()) {
            return 0.0f;
        }
        Entry entry = this.cacheString(str);
        return (float)entry.advance / 2.0f;
    }

    private int sizeString(String str, float width, boolean breakAtSpaces) {
        int index;
        if (str == null || str.isEmpty()) {
            return 0;
        }
        width += width;
        Glyph[] glyphs = this.cacheString((String)str).glyphs;
        int wsIndex = -1;
        int advance = 0;
        for (index = 0; index < glyphs.length && (float)advance <= width; ++index) {
            if (breakAtSpaces) {
                char c = str.charAt(glyphs[index].stringIndex);
                if (c == ' ') {
                    wsIndex = index;
                } else if (c == '\n') {
                    wsIndex = index;
                    break;
                }
            }
            advance = (int)((float)advance + glyphs[index].advance);
        }
        if (index < glyphs.length && wsIndex != -1 && wsIndex < index) {
            index = wsIndex + 1;
        }
        return index < glyphs.length ? glyphs[index].stringIndex : str.length();
    }

    public float sizeStringToWidth(String str, float width) {
        return this.sizeString(str, width, true);
    }

    public String trimStringToWidth(String str, float width, boolean reverse) {
        int length = this.sizeString(str, width, false);
        str = str.substring(0, length);
        if (reverse) {
            str = new StringBuilder(str).reverse().toString();
        }
        return str;
    }

    public String trimStringToWidthSaveWords(String str, float width, boolean reverse) {
        int length = this.sizeString(str, width, true);
        str = str.substring(0, length);
        if (reverse) {
            str = new StringBuilder(str).reverse().toString();
        }
        return str;
    }

    private int applyColorCode(int colorCode, int color, boolean shadowFlag) {
        if (colorCode != -1) {
            colorCode = shadowFlag ? colorCode + 16 : colorCode;
            color = this.colorTable[colorCode] & 0xFFFFFF | color & 0xFF000000;
        }
        Tessellator.field_78398_a.func_78370_a(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
        return color;
    }

    private Entry cacheString(String str) {
        Entry entry = null;
        if (this.mainThread == Thread.currentThread()) {
            this.lookupKey.str = str;
            entry = this.stringCache.get(this.lookupKey);
        }
        if (entry == null) {
            char[] text = str.toCharArray();
            entry = new Entry();
            int length = this.stripColorCodes(entry, str, text);
            ArrayList<Glyph> glyphList = new ArrayList<Glyph>();
            entry.advance = this.layoutBidiString(glyphList, text, 0, length, entry.colors);
            entry.glyphs = new Glyph[glyphList.size()];
            entry.glyphs = glyphList.toArray(entry.glyphs);
            Arrays.sort(entry.glyphs);
            int colorIndex = 0;
            int shift = 0;
            for (int glyphIndex = 0; glyphIndex < entry.glyphs.length; ++glyphIndex) {
                Glyph glyph = entry.glyphs[glyphIndex];
                while (colorIndex < entry.colors.length && glyph.stringIndex + shift >= entry.colors[colorIndex].stringIndex) {
                    shift += 2;
                    ++colorIndex;
                }
                glyph.stringIndex += shift;
            }
            if (this.mainThread == Thread.currentThread()) {
                Key key = new Key();
                key.str = new String(str);
                entry.keyRef = new WeakReference<Key>(key);
                this.stringCache.put(key, entry);
            }
        }
        if (this.mainThread == Thread.currentThread()) {
            Key oldKey = (Key)entry.keyRef.get();
            if (oldKey != null) {
                this.weakRefCache.put(str, oldKey);
            }
            this.lookupKey.str = null;
        }
        return entry;
    }

    private int stripColorCodes(Entry cacheEntry, String str, char[] text) {
        int next;
        ArrayList<ColorCode> colorList = new ArrayList<ColorCode>();
        int start = 0;
        int shift = 0;
        int fontStyle = 0;
        int renderStyle = 0;
        int colorCode = -1;
        while ((next = str.indexOf(167, start)) != -1 && next + 1 < str.length()) {
            System.arraycopy(text, next - shift + 2, text, next - shift, text.length - next - 2);
            int code = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(str.charAt(next + 1)));
            switch (code) {
                case 16: {
                    break;
                }
                case 17: {
                    fontStyle = (byte)(fontStyle | 1);
                    break;
                }
                case 18: {
                    renderStyle = (byte)(renderStyle | 2);
                    cacheEntry.specialRender = true;
                    break;
                }
                case 19: {
                    renderStyle = (byte)(renderStyle | 1);
                    cacheEntry.specialRender = true;
                    break;
                }
                case 20: {
                    fontStyle = (byte)(fontStyle | 2);
                    break;
                }
                case 21: {
                    fontStyle = 0;
                    renderStyle = 0;
                    colorCode = -1;
                    break;
                }
                default: {
                    if (code < 0 || code > 15) break;
                    colorCode = (byte)code;
                    fontStyle = 0;
                    renderStyle = 0;
                }
            }
            ColorCode entry = new ColorCode();
            entry.stringIndex = next;
            entry.stripIndex = next - shift;
            entry.colorCode = (byte)colorCode;
            entry.fontStyle = (byte)fontStyle;
            entry.renderStyle = (byte)renderStyle;
            colorList.add(entry);
            start = next + 2;
            shift += 2;
        }
        cacheEntry.colors = new ColorCode[colorList.size()];
        cacheEntry.colors = colorList.toArray(cacheEntry.colors);
        return text.length - shift;
    }

    private int layoutBidiString(List<Glyph> glyphList, char[] text, int start, int limit, ColorCode[] colors) {
        int advance = 0;
        if (Bidi.requiresBidi(text, start, limit)) {
            Bidi bidi = new Bidi(text, start, null, 0, limit - start, -2);
            if (bidi.isRightToLeft()) {
                return this.layoutStyle(glyphList, text, start, limit, 1, advance, colors);
            }
            int runCount = bidi.getRunCount();
            byte[] levels = new byte[runCount];
            Integer[] ranges = new Integer[runCount];
            for (int index = 0; index < runCount; ++index) {
                levels[index] = (byte)bidi.getRunLevel(index);
                ranges[index] = new Integer(index);
            }
            Bidi.reorderVisually(levels, 0, ranges, 0, runCount);
            for (int visualIndex = 0; visualIndex < runCount; ++visualIndex) {
                int logicalIndex = ranges[visualIndex];
                int layoutFlag = (bidi.getRunLevel(logicalIndex) & 1) == 1 ? 1 : 0;
                advance = this.layoutStyle(glyphList, text, start + bidi.getRunStart(logicalIndex), start + bidi.getRunLimit(logicalIndex), layoutFlag, advance, colors);
            }
            return advance;
        }
        return this.layoutStyle(glyphList, text, start, limit, 0, advance, colors);
    }

    private int layoutStyle(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, int advance, ColorCode[] colors) {
        byte currentFontStyle = 0;
        int colorIndex = Arrays.binarySearch(colors, (Object)start);
        if (colorIndex < 0) {
            colorIndex = -colorIndex - 2;
        }
        while (start < limit) {
            int next = limit;
            while (colorIndex >= 0 && colorIndex < colors.length - 1 && colors[colorIndex].stripIndex == colors[colorIndex + 1].stripIndex) {
                ++colorIndex;
            }
            if (colorIndex >= 0 && colorIndex < colors.length) {
                currentFontStyle = colors[colorIndex].fontStyle;
            }
            while (++colorIndex < colors.length) {
                if (colors[colorIndex].fontStyle == currentFontStyle) continue;
                next = colors[colorIndex].stripIndex;
                break;
            }
            advance = this.layoutString(glyphList, text, start, next, layoutFlags, advance, currentFontStyle);
            start = next;
        }
        return advance;
    }

    private int layoutString(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, int advance, int style) {
        if (this.digitGlyphsReady) {
            for (int index = start; index < limit; ++index) {
                if (text[index] < '0' || text[index] > '9') continue;
                text[index] = 48;
            }
        }
        while (start < limit) {
            Font font = this.glyphCache.lookupFont(text, start, limit, style);
            int next = font.canDisplayUpTo(text, start, limit);
            if (next == -1) {
                next = limit;
            }
            if (next == start) {
                ++next;
            }
            advance = this.layoutFont(glyphList, text, start, next, layoutFlags, advance, font);
            start = next;
        }
        return advance;
    }

    private int layoutFont(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, int advance, Font font) {
        if (this.mainThread == Thread.currentThread()) {
            this.glyphCache.cacheGlyphs(font, text, start, limit, layoutFlags);
        }
        GlyphVector vector = this.glyphCache.layoutGlyphVector(font, text, start, limit, layoutFlags);
        Glyph glyph = null;
        int numGlyphs = vector.getNumGlyphs();
        for (int index = 0; index < numGlyphs; ++index) {
            Point position = vector.getGlyphPixelBounds(index, null, advance, 0.0f).getLocation();
            if (glyph != null) {
                glyph.advance = (float)position.x - glyph.x;
            }
            glyph = new Glyph();
            glyph.stringIndex = start + vector.getGlyphCharIndex(index);
            glyph.texture = this.glyphCache.lookupGlyph(font, vector.getGlyphCode(index));
            glyph.x = position.x;
            glyph.y = position.y;
            glyphList.add(glyph);
        }
        advance = (int)((double)advance + vector.getGlyphPosition(numGlyphs).getX());
        if (glyph != null) {
            glyph.advance = (float)advance - glyph.x;
        }
        return advance;
    }

    private static class Key {
        public String str;

        private Key() {
        }

        public int hashCode() {
            int code = 0;
            int length = this.str.length();
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                int c = this.str.charAt(index);
                if (c >= 48 && c <= 57 && !colorCode) {
                    c = 48;
                }
                code = code * 31 + c;
                colorCode = c == 167;
            }
            return code;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            String other = o.toString();
            int length = this.str.length();
            if (length != other.length()) {
                return false;
            }
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                char c2;
                char c1 = this.str.charAt(index);
                if (c1 != (c2 = other.charAt(index)) && (c1 < '0' || c1 > '9' || c2 < '0' || c2 > '9' || colorCode)) {
                    return false;
                }
                colorCode = c1 == '\u00a7';
            }
            return true;
        }

        public String toString() {
            return this.str;
        }
    }

    private static class Glyph
    implements Comparable<Glyph> {
        public int stringIndex;
        public GlyphCache.Entry texture;
        public float x;
        public float y;
        public float advance;

        private Glyph() {
        }

        @Override
        public int compareTo(Glyph o) {
            return this.stringIndex == o.stringIndex ? 0 : (this.stringIndex < o.stringIndex ? -1 : 1);
        }
    }

    private static class Entry {
        public WeakReference<Key> keyRef;
        public int advance;
        public Glyph[] glyphs;
        public ColorCode[] colors;
        public boolean specialRender;

        private Entry() {
        }
    }

    private static class ColorCode
    implements Comparable<Integer> {
        public static final byte UNDERLINE = 1;
        public static final byte STRIKETHROUGH = 2;
        public int stringIndex;
        public int stripIndex;
        public byte colorCode;
        public byte fontStyle;
        public byte renderStyle;

        private ColorCode() {
        }

        @Override
        public int compareTo(Integer i) {
            return this.stringIndex == i ? 0 : (this.stringIndex < i ? -1 : 1);
        }
    }
}

