/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.render.font;

import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import ru.laytin.exlntab.render.font.FontAlign;
import ru.laytin.exlntab.render.font.StringCache;

public class FontMagicObj {
    private StringCache textFont = null;
    public boolean useCustomFont = true;

    private FontMagicObj() {
    }

    public FontMagicObj(String fontType, int fontSize) {
        this(fontType, fontSize, null);
    }

    public FontMagicObj(String fontType, int fontSize, ResourceLocation resLoc) {
        this.textFont = new StringCache();
        System.out.println("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0431\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u0448\u0440\u0438\u0444\u0442\u0430: " + fontType + ", ResourceLocation: " + resLoc);
        try {
            if (resLoc != null) {
                try {
                    System.out.println("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0447\u0435\u0440\u0435\u0437 ResourceLocation: " + resLoc);
                    InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc).func_110527_b();
                    this.textFont.setCustomFont(stream, fontSize, true);
                    System.out.println("\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u0448\u0440\u0438\u0444\u0442! \u0418\u043c\u044f: " + this.getName() + ", \u0420\u0430\u0437\u043c\u0435\u0440: " + fontSize);
                }
                catch (Exception e) {
                    System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0447\u0435\u0440\u0435\u0437 ResourceLocation " + resLoc + ": " + e.getMessage());
                    e.printStackTrace();
                    System.out.println("\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u0441\u044f \u043d\u0430 Arial \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438");
                    this.textFont.setDefaultFont("Arial", fontSize, true);
                }
            } else {
                System.out.println("ResourceLocation = null, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0448\u0440\u0438\u0444\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (Arial)");
                this.textFont.setDefaultFont("Arial", fontSize, true);
                System.out.println("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d Arial \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c " + fontSize);
            }
        }
        catch (Exception e) {
            System.err.println("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u0440\u0438\u0444\u0442\u0430 " + fontType + ": " + e.getMessage());
            e.printStackTrace();
            try {
                this.textFont.setDefaultFont("Arial", fontSize, true);
                System.out.println("Fallback \u043d\u0430 Arial \u043f\u043e\u0441\u043b\u0435 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u0438");
            }
            catch (Exception ex) {
                System.err.println("\u0414\u0430\u0436\u0435 Arial \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public float height() {
        if (this.useCustomFont) {
            return this.textFont.fontHeight;
        }
        return Minecraft.func_71410_x().field_71466_p.field_78288_b;
    }

    public float width(String text) {
        if (this.useCustomFont) {
            return this.textFont.getStringWidth(text);
        }
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    public FontMagicObj copy() {
        FontMagicObj font = new FontMagicObj();
        font.textFont = this.textFont;
        font.useCustomFont = this.useCustomFont;
        return font;
    }

    public float drawStringWithShadow(String text, float x, float y, int color) {
        float l;
        if (this.useCustomFont) {
            l = this.textFont.renderString(text, x + 1.0f, y + 1.0f, color, true);
            l = Math.max(l, this.textFont.renderString(text, x, y, color, false));
        } else {
            l = Minecraft.func_71410_x().field_71466_p.func_78261_a(text, (int)x, (int)y, color);
        }
        return l;
    }

    public float drawString(String text, float x, float y, int color) {
        if (this.useCustomFont) {
            return this.textFont.renderString(text, x, y, color, false);
        }
        return Minecraft.func_71410_x().field_71466_p.func_78261_a(text, (int)x, (int)y, color);
    }

    public float drawString(String text, float x, float y, int color, FontAlign f) {
        if (this.useCustomFont) {
            return this.textFont.renderString(text, x, y, color, false);
        }
        return Minecraft.func_71410_x().field_71466_p.func_78261_a(text, (int)x, (int)y, color);
    }

    public String getName() {
        if (!this.useCustomFont) {
            return "Minecraft";
        }
        try {
            return this.textFont.usedFont().getFontName();
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0438\u043c\u0435\u043d\u0438 \u0448\u0440\u0438\u0444\u0442\u0430: " + e.getMessage());
            return "Unknown";
        }
    }

    public StringCache getTextFont() {
        return this.textFont;
    }
}

