/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.render;

import java.awt.Color;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import ru.laytin.exlntab.render.Sprite2D;
import ru.laytin.exlntab.render.font.FontMagicObj;
import ru.laytin.exlntab.render.font.FontStyles;

public class DrawUtil {
    public static HashMap<String, ResourceLocation> externalTextures = new HashMap();
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static RenderBlocks renderBlocksRi = new RenderBlocks();
    static double zLevel = 50.0;
    static RenderBlocks field_147909_c = new RenderBlocks();

    public static void drawString(FontMagicObj fontContainer, String string, float x, float y, float scale, int color) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        fontContainer.drawString(string, 0.0f, 0.0f, color);
        GL11.glPopMatrix();
    }

    public static void drawStringWithDepth(FontMagicObj fontContainer, String string, float x, float y, float scale, int color) {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        fontContainer.drawStringWithShadow(string, 0.0f, 0.0f, color);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    public static void drawCenterStringWithDepth(FontMagicObj fontContainer, String string, float x, float y, float scale, int color) {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x - fontContainer.width(string) * scale / 2.0f), (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        fontContainer.drawStringWithShadow(string, 0.0f, 0.0f, color);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    public static void drawCenteredString(FontStyles fontType, String string, float x, float y, float scale, int color) {
        FontMagicObj fontContainer = fontType.getFontContainer();
        DrawUtil.drawString(fontContainer, string, x - fontContainer.width(string) * scale / 2.0f, y, scale, color);
    }

    public static void drawString(FontStyles fontType, String string, float x, float y, float scale, int color) {
        DrawUtil.drawString(fontType.getFontContainer(), string, x, y, scale, color);
    }

    public static void drawStringWithAplha(FontStyles fontType, String string, float x, float y, float scale, int color, float alpha) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        DrawUtil.drawString(fontType.getFontContainer(), string, x, y, scale, color);
    }

    public static Sprite2D drawImage(float x, float y, float width, float height, ResourceLocation resourceLocation) {
        return DrawUtil.drawImage(x, y, width, height, resourceLocation, 1.0f);
    }

    public static Sprite2D drawImage(float x, float y, float width, float height, ResourceLocation resourceLocation, float alpha) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glDisable((int)3008);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        return new Sprite2D(x, y, width, height);
    }

    public static void drawImage(int x, int y, int width, int height, int u, int v, int texWidth, int texHeight, ResourceLocation texture, int textureImageWidth, int textureImageHeight) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        float f = 1.0f / (float)textureImageWidth;
        float f1 = 1.0f / (float)textureImageHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)((float)u * f), (double)((float)(v + texHeight) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((float)(u + texWidth) * f), (double)((float)(v + texHeight) * f1));
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)((float)(u + texWidth) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }

    public static ResourceLocation getExternalTexture(String id, String fileUrl) {
        if (externalTextures.containsKey(id)) {
            return externalTextures.get(id);
        }
        ResourceLocation keyToTexture = new ResourceLocation("id" + id);
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        texturemanager.func_110579_a(keyToTexture, (ITextureObject)new ThreadDownloadImageData(null, fileUrl, null, null));
        ITextureObject object = texturemanager.func_110581_b(keyToTexture);
        externalTextures.put(id, keyToTexture);
        return keyToTexture;
    }

    public static void renderItemIntoGUI(TextureManager textureManager, ItemStack itemStack, float posX, float posY, boolean renderEffect, float width, float height, boolean renderStackSize) {
        try {
            if (!DrawUtil.forgeHookRender(field_147909_c, textureManager, itemStack, true, (float)zLevel, posX, posY, width, height)) {
                DrawUtil.renderItemIntoGUI1(textureManager, itemStack, posX, posY, renderEffect, width, height, renderStackSize);
            }
        }
        catch (NullPointerException e) {
            System.out.println("null while render");
        }
    }

    public static void renderItemIntoGUI1(TextureManager textureManager, ItemStack itemStack, float posX, float posY, boolean renderEffect, float width, float height, boolean renderStackSize) {
        if (itemStack == null) {
            // empty if block
        }
        int k = itemStack.func_77960_j();
        IIcon object = itemStack.func_77954_c();
        boolean renderWithColor = true;
        if (itemStack.func_94608_d() == 0 && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemStack.func_77973_b()).func_149645_b())) {
            textureManager.func_110577_a(TextureMap.field_110575_b);
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            GL11.glEnable((int)3008);
            if (block.func_149701_w() != 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            } else {
                GL11.glAlphaFunc((int)516, (float)0.5f);
                GL11.glDisable((int)3042);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(posX - 2.0f), (float)(posY + 3.0f), (float)((float)(-3.0 + zLevel)));
            GL11.glScalef((float)(10.0f * width / 16.0f), (float)(10.0f * height / 16.0f), (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int l = itemStack.func_77973_b().func_82790_a(itemStack, 0);
            float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f = (float)(l & 0xFF) / 255.0f;
            if (renderWithColor) {
                GL11.glColor4f((float)f3, (float)f4, (float)f, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            DrawUtil.renderBlocksRi.field_147844_c = renderWithColor;
            renderBlocksRi.func_147800_a(block, k, 1.0f);
            DrawUtil.renderBlocksRi.field_147844_c = true;
            if (block.func_149701_w() == 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            GL11.glPopMatrix();
        } else if (itemStack.func_77973_b().func_77623_v()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            textureManager.func_110577_a(TextureMap.field_110576_c);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)0, (int)0, (int)0, (int)0);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78378_d(-1);
            tessellator.func_78377_a((double)(posX - 2.0f), (double)(posY + 18.0f), zLevel);
            tessellator.func_78377_a((double)(posX + 18.0f), (double)(posY + 18.0f), zLevel);
            tessellator.func_78377_a((double)(posX + 18.0f), (double)(posY - 2.0f), zLevel);
            tessellator.func_78377_a((double)(posX - 2.0f), (double)(posY - 2.0f), zLevel);
            tessellator.func_78381_a();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            Item item = itemStack.func_77973_b();
            for (int l = 0; l < item.getRenderPasses(k); ++l) {
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                textureManager.func_110577_a(item.func_94901_k() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
                IIcon iicon = item.getIcon(itemStack, l);
                int i1 = itemStack.func_77973_b().func_82790_a(itemStack, l);
                float f = (float)(i1 >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i1 >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i1 & 0xFF) / 255.0f;
                if (renderWithColor) {
                    GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
                }
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3008);
                DrawUtil.renderIcon(posX, posY, iicon, width, height);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)2896);
                if (!renderEffect || !itemStack.hasEffect(l)) continue;
                DrawUtil.renderEffect(textureManager, posX, posY, width, height);
            }
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            ResourceLocation resourcelocation = textureManager.func_130087_a(itemStack.func_94608_d());
            textureManager.func_110577_a(resourcelocation);
            if (object == null) {
                object = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(resourcelocation)).func_110572_b("missingno");
            }
            int l = itemStack.func_77973_b().func_82790_a(itemStack, 0);
            float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f = (float)(l & 0xFF) / 255.0f;
            if (renderWithColor) {
                GL11.glColor4f((float)f3, (float)f4, (float)f, (float)1.0f);
            }
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            DrawUtil.renderIcon(posX, posY, object, width, height);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3042);
            if (renderEffect && itemStack.hasEffect(0)) {
                DrawUtil.renderEffect(textureManager, posX, posY, width, height);
            }
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2929);
        if (renderStackSize && itemStack.field_77994_a > 1) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(posX + 12.0f * width / 16.0f), (float)(posY + 14.0f * width / 16.0f), (float)0.0f);
            GL11.glScalef((float)(0.35f * width / 16.0f), (float)(0.35f * width / 16.0f), (float)1.0f);
            FontStyles.SemiBold.getFontContainer().drawStringWithShadow(String.valueOf(itemStack.field_77994_a), 0.0f, 0.0f, Color.WHITE.getRGB());
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public static boolean forgeHookRender(RenderBlocks renderBlocks, TextureManager engine, ItemStack item, boolean inColor, float zLevel, float x, float y, float width, float height) {
        if (MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY) == null) {
            return false;
        }
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
        engine.func_110577_a(item.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.INVENTORY, item, IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2.0f), (float)(y + 3.0f), (float)(-3.0f + zLevel));
            GL11.glScalef((float)(10.0f * width / 16.0f), (float)(10.0f * height / 16.0f), (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (inColor) {
                int color = item.func_77973_b().func_82790_a(item, 0);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderBlocks.field_147844_c = inColor;
            customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, item, new Object[]{renderBlocks});
            renderBlocks.field_147844_c = true;
            GL11.glPopMatrix();
        } else {
            GL11.glDisable((int)2896);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)(-3.0f + zLevel));
            if (inColor) {
                int color = item.func_77973_b().func_82790_a(item, 0);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            }
            customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, item, new Object[]{renderBlocks});
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
        }
        return true;
    }

    public static void renderIcon(float p_94149_1_, float p_94149_2_, IIcon p_94149_3_, float p_94149_4_, float p_94149_5_) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_94149_1_ + 0.0f), (double)(p_94149_2_ + p_94149_5_), zLevel, (double)p_94149_3_.func_94209_e(), (double)p_94149_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94149_1_ + p_94149_4_), (double)(p_94149_2_ + p_94149_5_), zLevel, (double)p_94149_3_.func_94212_f(), (double)p_94149_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94149_1_ + p_94149_4_), (double)(p_94149_2_ + 0.0f), zLevel, (double)p_94149_3_.func_94212_f(), (double)p_94149_3_.func_94206_g());
        tessellator.func_78374_a((double)(p_94149_1_ + 0.0f), (double)(p_94149_2_ + 0.0f), zLevel, (double)p_94149_3_.func_94209_e(), (double)p_94149_3_.func_94206_g());
        tessellator.func_78381_a();
    }

    public static void renderEffect(TextureManager manager, float x, float y, float width, float height) {
        GL11.glDepthFunc((int)514);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        manager.func_110577_a(RES_ITEM_GLINT);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
        DrawUtil.renderGlint(x * 4.3127862E8f + y * 3.217816E7f, x - 2.0f, y - 2.0f, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
    }

    private static void renderGlint(float p_77018_1_, float p_77018_2_, float p_77018_3_, float p_77018_4_, float p_77018_5_) {
        for (int j1 = 0; j1 < 2; ++j1) {
            OpenGlHelper.func_148821_a((int)772, (int)1, (int)0, (int)0);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            float f2 = (float)(Minecraft.func_71386_F() % (long)(3000 + j1 * 1873)) / (3000.0f + (float)(j1 * 1873)) * 256.0f;
            float f3 = 0.0f;
            Tessellator tessellator = Tessellator.field_78398_a;
            float f4 = 4.0f;
            if (j1 == 1) {
                f4 = -1.0f;
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(p_77018_2_ + 0.0f), (double)(p_77018_3_ + p_77018_5_), zLevel, (double)((f2 + p_77018_5_ * f4) * f), (double)((f3 + p_77018_5_) * f1));
            tessellator.func_78374_a((double)(p_77018_2_ + p_77018_4_), (double)(p_77018_3_ + p_77018_5_), zLevel, (double)((f2 + p_77018_4_ + p_77018_5_ * f4) * f), (double)((f3 + p_77018_5_) * f1));
            tessellator.func_78374_a((double)(p_77018_2_ + p_77018_4_), (double)(p_77018_3_ + 0.0f), zLevel, (double)((f2 + p_77018_4_) * f), (double)((f3 + 0.0f) * f1));
            tessellator.func_78374_a((double)(p_77018_2_ + 0.0f), (double)(p_77018_3_ + 0.0f), zLevel, (double)((f2 + 0.0f) * f), (double)((f3 + 0.0f) * f1));
            tessellator.func_78381_a();
        }
    }

    public static void drawRectFloat(float x, float y, float x2, float y2, int color, float alpha) {
        float j1;
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (x < x2) {
            j1 = x;
            x = x2;
            x2 = j1;
        }
        if (y < y2) {
            j1 = y;
            y = y2;
            y2 = j1;
        }
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)alpha);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    public static void drawRoundedSquare(float x, float y, float width, float height, float radius, int color, float alpha) {
        DrawUtil.drawRectFloat(x + radius, y, x + width - radius, y + height, color, 1.0f);
        DrawUtil.drawRectFloat(x, y + radius, x + width, y + height - radius, color, 1.0f);
        GL11.glBindTexture((int)3553, (int)0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
        DrawUtil.circleProgress(x + radius, y + radius, x, y, radius, radius, radius, radius, 90.0f, 90.0f, 32, true);
        DrawUtil.circleProgress(x + radius, y + height - radius, x, y + height - radius, radius, radius, radius, radius, 90.0f, 0.0f, 32, true);
        DrawUtil.circleProgress(x + width - radius, y + radius, x, y + height - radius, radius, radius, radius, radius, 90.0f, 180.0f, 32, true);
        DrawUtil.circleProgress(x + width - radius, y + height - radius, x, y + height - radius, radius, radius, radius, radius, 90.0f, 270.0f, 32, true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    public static void circleProgress(float x, float y, float u, float v, float sizeU, float sizeV, float radius, float radiusUV, float progress, float initialDegree, int segment, boolean clockwise) {
        float a = 360.0f / (float)segment;
        float b = 0.0f;
        double osin = 0.0;
        double ocos = 0.0;
        float offsetU = 1.0f / sizeU;
        float offsetV = 1.0f / sizeV;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(4);
        for (int i = 0; i <= segment; ++i) {
            double cos;
            double sin;
            b = a * (float)i;
            double degree = b < progress ? (double)(initialDegree + b) * Math.PI / 180.0 : (double)(initialDegree + progress) * Math.PI / 180.0;
            if (clockwise) {
                sin = Math.sin(-degree);
                cos = Math.cos(-degree);
                tessellator.func_78374_a((double)x + osin * (double)radius, (double)y + ocos * (double)radius, 0.0, (double)((float)((double)u + osin * (double)radiusUV) * offsetU), (double)((float)((double)v + ocos * (double)radiusUV) * offsetV));
                tessellator.func_78374_a((double)x, (double)y, 0.0, (double)(u * offsetU), (double)(v * offsetV));
                tessellator.func_78374_a((double)x + sin * (double)radius, (double)y + cos * (double)radius, 0.0, (double)((float)((double)u + sin * (double)radiusUV) * offsetU), (double)((float)((double)v + cos * (double)radiusUV) * offsetV));
                osin = sin;
                ocos = cos;
            } else {
                sin = Math.sin(degree);
                cos = Math.cos(degree);
                tessellator.func_78374_a((double)x + sin * (double)radius, (double)y + cos * (double)radius, 0.0, (double)((float)((double)u + sin * (double)radiusUV) * offsetU), (double)((float)((double)v + cos * (double)radiusUV) * offsetV));
                tessellator.func_78374_a((double)x, (double)y, 0.0, (double)(u * offsetU), (double)(v * offsetV));
                tessellator.func_78374_a((double)x + osin * (double)radius, (double)y + ocos * (double)radius, 0.0, (double)((float)((double)u + osin * (double)radiusUV) * offsetU), (double)((float)((double)v + ocos * (double)radiusUV) * offsetV));
                osin = sin;
                ocos = cos;
            }
            if (b > progress) break;
        }
        tessellator.func_78381_a();
    }
}

