/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.mixins;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.laytin.exlntab.ExlnTab;
import ru.laytin.exlntab.render.font.FontMagicObj;
import ru.laytin.exlntab.render.font.FontStyles;

@Mixin(value={FontRenderer.class}, priority=5000, remap=true)
public abstract class MixinFontRenderer {
    private static boolean INITIALIZED = false;
    private static FontMagicObj customFont = null;
    private static final String[] EXCLUDED_MODS = new String[]{"OpenComputers", "journeymap", "oc", "jm"};
    private static final String[] EXCLUDED_CLASSES = new String[]{"SplashProgress", "LoadingScreen", "Splash"};

    @Shadow
    protected abstract void func_78265_b();

    @Shadow
    public abstract int func_78263_a(char var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=true)
    private void onInit(GameSettings settings, ResourceLocation location, TextureManager textureManager, boolean unicodeFlag, CallbackInfo ci) {
        if (!INITIALIZED) {
            try {
                customFont = FontStyles.MainFontBold.getFontContainer();
                ExlnTab.logger.info("\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                INITIALIZED = true;
            }
            catch (Exception e) {
                ExlnTab.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0433\u043e \u0448\u0440\u0438\u0444\u0442\u0430", (Throwable)e);
            }
        }
    }

    private boolean shouldSkipForCurrentMod() {
        if (customFont == null) {
            return true;
        }
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String callerClassName = "";
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName().toLowerCase();
                for (String excludedClass : EXCLUDED_CLASSES) {
                    if (!className.contains(excludedClass.toLowerCase())) continue;
                    return true;
                }
                if (callerClassName.isEmpty() && !className.contains("thread") && !className.contains("mixin")) {
                    callerClassName = element.getClassName();
                }
                for (String excludedMod : EXCLUDED_MODS) {
                    if (!className.contains(excludedMod.toLowerCase())) continue;
                    return true;
                }
            }
            if (!Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
                return true;
            }
            for (ModContainer mod : Loader.instance().getActiveModList()) {
                if (mod.isImmutable() || mod.getMod() == null) continue;
                for (String excludedMod : EXCLUDED_MODS) {
                    if (!mod.getModId().toLowerCase().contains(excludedMod.toLowerCase()) || mod.getMod().getClass().getName().equals(callerClassName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Inject(method={"drawStringWithShadow"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectDrawStringWithShadow(String text, int x, int y, int color, CallbackInfoReturnable<Integer> cir) {
        if (this.shouldSkipForCurrentMod()) {
            return;
        }
        int result = (int)customFont.drawStringWithShadow(text, x, y, color);
        cir.setReturnValue((Object)result);
        cir.cancel();
    }

    @Inject(method={"drawString"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectDrawString(String text, int x, int y, int color, CallbackInfoReturnable<Integer> cir) {
        if (this.shouldSkipForCurrentMod()) {
            return;
        }
        int result = (int)customFont.drawString(text, x, y, color);
        cir.setReturnValue((Object)result);
        cir.cancel();
    }

    @Inject(method={"getStringWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectGetStringWidth(String text, CallbackInfoReturnable<Integer> cir) {
        if (this.shouldSkipForCurrentMod()) {
            return;
        }
        float width = customFont.width(text);
        cir.setReturnValue((Object)((int)width));
        cir.cancel();
    }
}

