/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.mixins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinErrorHandler
implements IMixinErrorHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"Chibi-Mixin");

    public IMixinErrorHandler.ErrorAction onPrepareError(IMixinConfig config, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0435 \u043c\u0438\u043a\u0441\u0438\u043d\u0430 " + mixin.getName(), th);
        return IMixinErrorHandler.ErrorAction.WARN;
    }

    public IMixinErrorHandler.ErrorAction onApplyError(String targetClassName, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043c\u0438\u043a\u0441\u0438\u043d\u0430 " + mixin.getName() + " \u043a " + targetClassName, th);
        return IMixinErrorHandler.ErrorAction.WARN;
    }

    private void logError(String message, Throwable th) {
        LOGGER.error(message, th);
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String timestamp = dateFormat.format(new Date());
            File errorFile = new File("logs/Chibi-mixin-error-" + timestamp + ".log");
            if (!errorFile.getParentFile().exists()) {
                errorFile.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(errorFile);){
                writer.write("\u0412\u0440\u0435\u043c\u044f: " + timestamp + "\n");
                writer.write("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: " + message + "\n\n");
                writer.write("\u0422\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0430 \u0441\u0442\u0435\u043a\u0430:\n");
                writer.write(this.getStackTraceAsString(th));
            }
            LOGGER.info("\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u0432 " + errorFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u0441 \u043e\u0442\u0447\u0435\u0442\u043e\u043c \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435", (Throwable)e);
        }
    }

    private String getStackTraceAsString(Throwable th) {
        StringBuilder sb = new StringBuilder();
        sb.append(th.toString()).append("\n");
        for (StackTraceElement element : th.getStackTrace()) {
            sb.append("\tat ").append(element.toString()).append("\n");
        }
        Throwable cause = th.getCause();
        if (cause != null) {
            sb.append("Caused by: ").append(this.getStackTraceAsString(cause));
        }
        return sb.toString();
    }
}

