/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.lucko.spark.api.Spark;
import me.lucko.spark.api.SparkProvider;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.types.DoubleStatistic;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;
import ru.laytin.exlntab.bukkit.permission.PluginAdapterLP;
import ru.laytin.exlntab.packets.AddPlayerListPacket;
import ru.laytin.exlntab.packets.ConfigPacket;
import ru.laytin.exlntab.packets.FillPlayerListPacket;
import ru.laytin.exlntab.packets.PingPacket;
import ru.laytin.exlntab.packets.RemovePlayerListPacket;
import ru.laytin.exlntab.packets.TpsPacket;
import ru.laytin.exlntab.utils.PlayerInfoObj;

@SideOnly(value=Side.SERVER)
public class ListenerServer {
    private int tpsTicks;
    private Map<String, PlayerInfoObj> playerListTemp = new HashMap<String, PlayerInfoObj>();
    private boolean inited = false;
    private boolean sparkInited = true;
    private static int abc = 0;

    @GradleSideOnly(value={GradleSide.SERVER})
    private void init() {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("LuckPerms")) {
            try {
                PluginAdapterLP.init();
                abc = 2;
            }
            catch (IllegalAccessException | InstantiationException e) {
                System.err.println("[DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 LuckPerms \u0430\u0434\u0430\u043f\u0442\u0435\u0440\u0430: " + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("[EXLNTab] No permission plugin found. Just use PermissionEX or LuckPerms!");
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("spark")) {
            this.sparkInited = true;
        }
        this.inited = true;
    }

    @SubscribeEvent
    @GradleSideOnly(value={GradleSide.SERVER})
    public void onJoinEvent(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerInfoObj ib;
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        ConfigPacket.fromCurrentConfig().sendToPlayer(player);
        int ping = player.field_71138_i;
        new PingPacket(ping).sendToClients();
        if (!this.inited) {
            this.init();
        }
        switch (abc) {
            case 2: {
                ib = PluginAdapterLP.getPlayerGroupWithWeight(event.player.getDisplayName());
                break;
            }
            default: {
                ib = new PlayerInfoObj("default", "Player", event.player.getDisplayName(), 0);
            }
        }
        this.playerListTemp.put(ib.getUsername(), ib);
        ArrayList<PlayerInfoObj> playersToSend = new ArrayList<PlayerInfoObj>(this.playerListTemp.values());
        for (PlayerInfoObj playerInfoObj : playersToSend) {
        }
        new FillPlayerListPacket(playersToSend).sendToPlayer((EntityPlayerMP)event.player);
        new AddPlayerListPacket(ib).sendToClients();
    }

    @SubscribeEvent
    @GradleSideOnly(value={GradleSide.SERVER})
    public void tpsTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (this.tpsTicks >= 200) {
                if (!this.inited) {
                    this.init();
                }
                for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                    int ping = player.field_71138_i;
                    new PingPacket(ping).sendToPlayer(player);
                }
                if (this.sparkInited) {
                    try {
                        DoubleStatistic tpsStat;
                        Spark spark = SparkProvider.get();
                        if (spark != null && (tpsStat = spark.tps()) != null) {
                            double tpsValue = tpsStat.poll((Enum)StatisticWindow.TicksPerSecond.SECONDS_10);
                            new TpsPacket((int)Math.round(tpsValue)).sendToClients();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 TPS: " + e.getMessage());
                    }
                }
                this.tpsTicks = 0;
            }
            ++this.tpsTicks;
        }
    }

    @SubscribeEvent
    @GradleSideOnly(value={GradleSide.SERVER})
    public void onLeftEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        this.playerListTemp.remove(event.player.getDisplayName());
        new RemovePlayerListPacket(event.player.getDisplayName()).sendToClients();
    }
}

