/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.JsonException;
import net.minecraftforge.client.event.MouseEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import ru.laytin.exlntab.gui.GuiCustomTab;
import ru.laytin.exlntab.handlers.ConfigHandler;
import ru.laytin.exlntab.proxy.ResourcesProxy;
import ru.laytin.exlntab.render.DrawUtil;
import ru.laytin.exlntab.render.PhotoRender;
import ru.laytin.exlntab.render.font.FontMagicObj;
import ru.laytin.exlntab.render.font.FontStyles;
import ru.laytin.exlntab.utils.PlayerInfoObj;

@SideOnly(value=Side.CLIENT)
public class ListenerClient {
    public Map<String, PlayerInfoObj> playerList = new HashMap<String, PlayerInfoObj>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private float referenceWidth = 427.0f;
    private float referenceHeight = 240.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float minScale = 1.0f;
    private float alpha = 0.3f;
    private float scrollOffset = 0.0f;
    private float maxScrollOffset = 0.0f;
    private static ListenerClient instance;
    public static int tps;
    public static int playerPing;
    public static boolean DEBUG_TAB;
    FontMagicObj tabFont = FontStyles.TabFontBold.getFontContainer();
    private Field _listShaders;
    private long start;
    private static float blurProgress;
    private static final float BLUR_SPEED = 0.05f;

    public static void updateTps(int newTps) {
        tps = newTps;
    }

    public static void updatePing(int newPing) {
        playerPing = newPing;
    }

    public static ListenerClient getInstance() {
        return instance;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71462_r == null && Keyboard.isKeyDown((int)15)) {
            GuiCustomTab tab = GuiCustomTab.getInstance();
            if (tab != null) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)tab);
            } else {
                System.err.println("[ERROR] GuiCustomTab.getInstance() \u0432\u0435\u0440\u043d\u0443\u043b null \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0442\u0430\u0431");
            }
        }
    }

    private void drawDebugTab(int widthScreen, int heightScreen) throws JsonException {
        if (this.mc.field_71474_y.field_74321_H.func_151470_d() && this.alpha != 0.0f) {
            this.recalculateScale(widthScreen, heightScreen);
            if ((double)this.alpha < 0.9) {
                this.alpha += 0.03f;
            }
            DrawUtil.drawImage((float)(widthScreen / 2) - 150.0f * this.minScale, (float)(heightScreen / 2) - 80.0f * this.minScale, 300.0f * this.minScale, 160.0f * this.minScale, ResourcesProxy.bigWindow, this.alpha);
            DrawUtil.drawRectFloat((float)(widthScreen / 2) - 140.0f * this.minScale, (float)(heightScreen / 2) - 60.0f * this.minScale, (float)(widthScreen / 2) + 140.0f * this.minScale, (float)(heightScreen / 2) - 61.0f * this.minScale, this.hex2Rgb("#FF8102").getRGB(), this.alpha);
            DrawUtil.drawStringWithDepth(this.tabFont, "DEBUG MODE - \u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0435 \u043f\u0440\u043e\u0444\u0438\u043b\u0438", (float)(widthScreen / 2) - 140.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.3f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
            float startX = (float)(widthScreen / 2) - 140.0f * this.minScale;
            float startY = (float)(heightScreen / 2) - 55.0f * this.minScale;
            String[][] testPlayers = new String[][]{{"TestPlayer1", "admin", "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440"}, {"TestPlayer2", "vip", "VIP-\u0438\u0433\u0440\u043e\u043a"}, {"TestPlayer3", "player", "\u0418\u0433\u0440\u043e\u043a"}, {"TestPlayer4", "admin", "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440"}, {"TestPlayer5", "vip", "VIP-\u0438\u0433\u0440\u043e\u043a"}, {"TestPlayer6", "player", "\u0418\u0433\u0440\u043e\u043a"}};
            for (int i = 0; i < testPlayers.length; ++i) {
                float xPos = startX + (float)(i % 4) * 71.3f * this.minScale;
                float yPos = startY + (float)(i / 4 * 20) * this.minScale;
                DrawUtil.drawImage(xPos, yPos, 66.0f * this.minScale, 15.0f * this.minScale, ResourcesProxy.buttonHover, this.alpha);
                try {
                    PhotoRender.getInstance().drawAvatar(testPlayers[i][0], xPos + 2.0f * this.minScale, yPos + 2.0f * this.minScale, 11.0f * this.minScale, 11.0f * this.minScale, 1.0f);
                }
                catch (Exception e) {
                    System.out.println("[DEBUG_TAB] \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0438 \u0430\u0432\u0430\u0442\u0430\u0440\u0430: " + e.getMessage());
                }
                DrawUtil.drawStringWithDepth(this.tabFont, testPlayers[i][0], xPos + 15.0f * this.minScale, yPos + 4.0f * this.minScale, 0.2f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
                String roleColor = testPlayers[i][1].equals("admin") ? "#FF8102" : (testPlayers[i][1].equals("vip") ? "#00AAFF" : "#525252");
                DrawUtil.drawRoundedSquare(xPos + 15.0f * this.minScale, yPos + 8.0f * this.minScale, Math.min(this.tabFont.width(testPlayers[i][2]) * 0.17f * this.minScale + 6.0f * this.minScale, 51.0f * this.minScale), 5.0f * this.minScale, 1.0f * this.minScale, this.hex2Rgb(roleColor).getRGB(), this.alpha);
                DrawUtil.drawStringWithDepth(this.tabFont, testPlayers[i][2], xPos + 18.0f * this.minScale, yPos + 10.5f * this.minScale, 0.17f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            }
        }
    }

    private int getColor(int r, int g, int b, float alpha) {
        int a = (int)(alpha * 255.0f) & 0xFF;
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private void drawScrollRect(int widthScreen, int heightScreen) {
        if (this.maxScrollOffset == 0.0f) {
            return;
        }
        float ww = 125.0f / (125.0f + this.maxScrollOffset);
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 145.0f * this.minScale, (float)(heightScreen / 2) - 54.0f * this.minScale + this.scrollOffset * this.minScale * ww, (float)(widthScreen / 2) + 146.0f * this.minScale, Math.min((float)(heightScreen / 2) - 50.0f * this.minScale + ww * this.minScale * 110.0f + this.scrollOffset * this.minScale * ww, (float)(heightScreen / 2) - 55.0f * this.minScale + this.minScale * 125.0f), this.hex2Rgb("#FF8102").getRGB(), this.alpha);
    }

    private void drawScissorList(int widthScreen, int heightScreen, List<String> list1) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(widthScreen / 2) - 140.0f * this.minScale), (float)((float)(heightScreen / 2) - 55.0f * this.minScale), (float)0.0f);
        GL11.glEnable((int)3089);
        this.scissorViewport((int)((float)(widthScreen / 2) - 140.0f * this.minScale), (int)((float)(heightScreen / 2) - 55.0f * this.minScale), (int)(this.minScale * 280.0f), (int)(this.minScale * 125.0f));
        if (!ConfigHandler.useVanillaTeams) {
            if (DEBUG_TAB) {
                this.forceDraw(list1);
            } else {
                this.drawPlayers(list1);
            }
        }
        GL11.glDisable((int)3089);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glPopMatrix();
    }

    private void scissorViewport(int x, int y, int width, int height) {
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
        if (DEBUG_TAB) {
            System.out.println("[DEBUG] glScissor \u0432\u044b\u0437\u0432\u0430\u043d \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438: x=" + x + ", y=" + y + ", width=" + width + ", height=" + height);
        }
    }

    private void drawPlayers(List<String> list1) {
        AtomicInteger a = new AtomicInteger();
        ArrayList<PlayerInfoObj> playersToRender = new ArrayList<PlayerInfoObj>();
        for (String playerName : list1) {
            PlayerInfoObj player = this.playerList.get(playerName);
            if (player != null) {
                playersToRender.add(player);
                continue;
            }
            if (!DEBUG_TAB) continue;
            PlayerInfoObj newPlayer = new PlayerInfoObj("player", "\u0418\u0433\u0440\u043e\u043a", playerName, 1);
            this.playerList.put(playerName, newPlayer);
            playersToRender.add(newPlayer);
        }
        if (playersToRender.isEmpty() && DEBUG_TAB) {
            playersToRender.addAll(this.playerList.values());
        }
        for (PlayerInfoObj ob : playersToRender) {
            float yVal;
            float xVal;
            block10: {
                xVal = (float)(a.get() % 4) * 71.3f * this.minScale;
                yVal = (float)(a.get() / 4 * 20) * this.minScale - this.scrollOffset * this.minScale;
                DrawUtil.drawImage(xVal, yVal, 66.0f * this.minScale, 15.0f * this.minScale, ResourcesProxy.buttonHover, this.alpha);
                try {
                    PhotoRender.getInstance().drawAvatar(ob.getUsername(), xVal + 2.0f * this.minScale, yVal + 2.0f * this.minScale, 11.0f * this.minScale, 11.0f * this.minScale, 1.0f);
                }
                catch (Exception e) {
                    if (!DEBUG_TAB) break block10;
                    System.out.println("[DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435 \u0430\u0432\u0430\u0442\u0430\u0440\u0430: " + e.getMessage());
                }
            }
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), FontStyles.SemiBold.getFontContainer().getTextFont().trimStringToWidth(ob.getUsername(), 200.0f, false), xVal + 15.0f * this.minScale, yVal + 4.0f * this.minScale, 0.2f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            if (ConfigHandler.drawRoles) {
                String drawRoleText;
                block11: {
                    drawRoleText = ConfigHandler.useGroupName ? ob.getRole() : ob.getRoleDisplayName();
                    drawRoleText = drawRoleText.equals("exlntab") ? "\u041c\u0443\u0441\u043e\u0440" : drawRoleText;
                    drawRoleText = !ConfigHandler.useColorCodes ? drawRoleText.replaceAll("&.", "").replaceAll("\u00a7.", "") : drawRoleText.replace("&", "\u00a7");
                    drawRoleText = FontStyles.SemiBold.getFontContainer().getTextFont().trimStringToWidth(drawRoleText, 150.0f, false);
                    if (ConfigHandler.useColouredBg) {
                        String roleColor = ConfigHandler.getColourByRole(ob.getRole());
                        try {
                            DrawUtil.drawRoundedSquare(xVal + 15.0f * this.minScale, yVal + 8.0f * this.minScale, Math.min(FontStyles.SemiBold.getFontContainer().width(drawRoleText) * 0.17f * this.minScale + 6.0f * this.minScale, 51.0f * this.minScale), 5.0f * this.minScale, 1.0f * this.minScale, this.hex2Rgb(roleColor).getRGB(), this.alpha);
                        }
                        catch (Exception e) {
                            if (!DEBUG_TAB) break block11;
                            System.out.println("[DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435 \u0444\u043e\u043d\u0430 \u0440\u043e\u043b\u0438: " + e.getMessage());
                        }
                    }
                }
                DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), drawRoleText, ConfigHandler.useColouredBg ? xVal + 18.0f * this.minScale : xVal + 15.0f * this.minScale, yVal + 10.5f * this.minScale, 0.17f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            }
            a.incrementAndGet();
        }
    }

    private void forceDraw(List<String> displayNames) {
        if (!this.playerList.containsKey("TestAdmin")) {
            this.forceInitDebugPlayers();
        }
        AtomicInteger index = new AtomicInteger(0);
        try {
            String currentPlayerName = this.mc.func_110432_I().func_111285_a();
            this.drawPlayerDirectly(currentPlayerName, "player", "\u0418\u0433\u0440\u043e\u043a", index.getAndIncrement());
            this.drawPlayerDirectly("TestAdmin", "admin", "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440", index.getAndIncrement());
            this.drawPlayerDirectly("TestVIP", "vip", "VIP-\u0438\u0433\u0440\u043e\u043a", index.getAndIncrement());
        }
        catch (Exception e) {
            System.err.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435: " + e);
            e.printStackTrace();
        }
    }

    private void drawPlayerDirectly(String username, String role, String roleDisplayName, int index) {
        try {
            float xVal = (float)(index % 4) * 71.3f * this.minScale;
            float yVal = (float)(index / 4 * 20) * this.minScale - this.scrollOffset * this.minScale;
            DrawUtil.drawImage(xVal, yVal, 66.0f * this.minScale, 15.0f * this.minScale, ResourcesProxy.buttonHover, this.alpha);
            try {
                PhotoRender.getInstance().drawAvatar(username, xVal + 2.0f * this.minScale, yVal + 2.0f * this.minScale, 11.0f * this.minScale, 11.0f * this.minScale, 1.0f);
            }
            catch (Exception e) {
                System.out.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0438 \u0430\u0432\u0430\u0442\u0430\u0440\u0430: " + e.getMessage());
            }
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), username, xVal + 15.0f * this.minScale, yVal + 4.0f * this.minScale, 0.2f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            String roleColor = role.equals("admin") ? "#FF8102" : (role.equals("vip") ? "#00AAFF" : "#525252");
            try {
                DrawUtil.drawRoundedSquare(xVal + 15.0f * this.minScale, yVal + 8.0f * this.minScale, Math.min(FontStyles.SemiBold.getFontContainer().width(roleDisplayName) * 0.17f * this.minScale + 6.0f * this.minScale, 51.0f * this.minScale), 5.0f * this.minScale, 1.0f * this.minScale, this.hex2Rgb(roleColor).getRGB(), this.alpha);
                DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), roleDisplayName, xVal + 18.0f * this.minScale, yVal + 10.5f * this.minScale, 0.17f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            }
            catch (Exception e) {
                System.out.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0438 \u0440\u043e\u043b\u0438: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435 \u0438\u0433\u0440\u043e\u043a\u0430 " + username + ": " + e);
            e.printStackTrace();
        }
    }

    private void forceInitDebugPlayers() {
        this.playerList.clear();
        String playerName = this.mc.func_110432_I().func_111285_a();
        PlayerInfoObj selfPlayer = new PlayerInfoObj("player", "\u0418\u0433\u0440\u043e\u043a", playerName, 50);
        this.playerList.put(playerName, selfPlayer);
        PlayerInfoObj adminPlayer = new PlayerInfoObj("admin", "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440", "TestAdmin", 100);
        this.playerList.put("TestAdmin", adminPlayer);
        PlayerInfoObj vipPlayer = new PlayerInfoObj("vip", "VIP-\u0438\u0433\u0440\u043e\u043a", "TestVIP", 75);
        this.playerList.put("TestVIP", vipPlayer);
        ConfigHandler.roleColors.put("admin", "#FF8102");
        ConfigHandler.roleColors.put("vip", "#00AAFF");
        ConfigHandler.roleColors.put("player", "#525252");
    }

    private void drawBackground(int widthScreen, int heightScreen, int ping, int online) {
        DrawUtil.drawImage((float)(widthScreen / 2) - 150.0f * this.minScale, (float)(heightScreen / 2) - 80.0f * this.minScale, 300.0f * this.minScale, 160.0f * this.minScale, ResourcesProxy.bigWindow, this.alpha);
        DrawUtil.drawRectFloat((float)(widthScreen / 2) - 140.0f * this.minScale, (float)(heightScreen / 2) - 60.0f * this.minScale, (float)(widthScreen / 2) + 140.0f * this.minScale, (float)(heightScreen / 2) - 61.0f * this.minScale, this.hex2Rgb("#FF8102").getRGB(), this.alpha);
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), FontStyles.SemiBold.getFontContainer().getTextFont().trimStringToWidth(ConfigHandler.tabHeader, 350.0f, false), (float)(widthScreen / 2) - 140.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.3f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
        this.drawPing(widthScreen, heightScreen, ping);
        if (ConfigHandler.drawTPS) {
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), "TPS: ", (float)(widthScreen / 2) + 5.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), String.valueOf(tps), (float)(widthScreen / 2) + 23.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.getTpsColor(tps));
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), "|", (float)(widthScreen / 2) + 41.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.15f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
        }
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), "\u041e\u043d\u043b\u0430\u0439\u043d: ", (float)(widthScreen / 2) + 46.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), String.valueOf(online), (float)(widthScreen / 2) + 70.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.hex2Rgb("#498f03").getRGB());
    }

    private void drawPing(int widthScreen, int heightScreen, int ping) {
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 132.0f * this.minScale, (float)(heightScreen / 2) - 66.0f * this.minScale, (float)(widthScreen / 2) + 134.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, this.getPingColor(ping, 1), this.alpha);
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 135.0f * this.minScale, (float)(heightScreen / 2) - 66.0f * this.minScale, (float)(widthScreen / 2) + 137.0f * this.minScale, (float)(heightScreen / 2) - 71.0f * this.minScale, this.getPingColor(ping, 2), this.alpha);
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 138.0f * this.minScale, (float)(heightScreen / 2) - 66.0f * this.minScale, (float)(widthScreen / 2) + 140.0f * this.minScale, (float)(heightScreen / 2) - 73.0f * this.minScale, this.getPingColor(ping, 3), this.alpha);
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), String.valueOf(playerPing), (float)(widthScreen / 2) + 130.0f * this.minScale, (float)(heightScreen / 2) - 74.0f * this.minScale, 0.15f * this.minScale, this.hex2Rgb("#525252").getRGB());
    }

    private int getPingColor(int ping, int nump) {
        if (ping > 150) {
            if (nump > 1) {
                return this.hex2Rgb("#525252").getRGB();
            }
            return this.hex2Rgb("#eb4034").getRGB();
        }
        if (ping > 80) {
            if (nump > 2) {
                return this.hex2Rgb("#525252").getRGB();
            }
            return this.hex2Rgb("#eb8f34").getRGB();
        }
        return this.hex2Rgb("#498f03").getRGB();
    }

    private int getTpsColor(double tps) {
        if (tps < 10.0) {
            return this.hex2Rgb("#eb4034").getRGB();
        }
        if (tps < 15.0) {
            return this.hex2Rgb("#eb8f34").getRGB();
        }
        return this.hex2Rgb("#498f03").getRGB();
    }

    private Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    private void recalculateScale(int widthScreen, int heightScreen) {
        float minSc;
        this.scaleX = (float)widthScreen / this.referenceWidth;
        this.scaleY = (float)heightScreen / this.referenceHeight;
        this.minScale = minSc = Math.min(this.scaleX, this.scaleY);
    }

    @SubscribeEvent
    public void rightClick(MouseEvent event) {
        if ((double)this.alpha == 0.0 || this.maxScrollOffset == 0.0f) {
            return;
        }
        int dw = event.dwheel;
        event.setCanceled(true);
        if (dw != 0) {
            float amountScrolled = (dw = dw > 0 ? -1 : 1) * 5;
            this.scrollOffset = this.scrollOffset + amountScrolled > this.maxScrollOffset ? (float)((int)this.maxScrollOffset) : (this.scrollOffset + amountScrolled > 0.0f ? (this.scrollOffset += amountScrolled) : 0.0f);
        }
    }

    static {
        tps = 25;
        playerPing = 0;
        DEBUG_TAB = false;
        blurProgress = 0.0f;
    }
}

