/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.handlers;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;
    public static String avatarUrl;
    public static String skinUrl;
    public static String tabHeader;
    public static boolean useGroupName;
    public static boolean useColouredBg;
    public static boolean useColorCodes;
    public static boolean drawTPS;
    public static boolean drawRoles;
    public static boolean useVanillaTeams;
    public static Map<String, String> roleColors;
    public static boolean enableBlurredContainers;

    public static String getColourByRole(String role) {
        if (roleColors.containsKey(role)) {
            return roleColors.get(role);
        }
        return "#525252";
    }

    public static void init(File confFile) {
        if (config == null) {
            config = new Configuration(confFile);
            config.load();
            ConfigHandler.syncConfig();
        }
    }

    public static void reloadConfig() {
        if (config != null) {
            config.load();
            ConfigHandler.syncConfig();
        }
    }

    public static void syncConfig() {
        try {
            avatarUrl = ConfigHandler.getString("tab", "Avatar URL", avatarUrl);
            skinUrl = ConfigHandler.getString("tab", "Skins URL", skinUrl);
            tabHeader = ConfigHandler.getString("tab", "Tab Header", tabHeader);
            ConfigCategory cc = config.getCategory("tabGroupColor");
            cc.getOrderedValues().stream().forEach(f -> roleColors.put(f.getName(), f.getString()));
            useGroupName = config.get("tabSpecific", "Use group name", useGroupName).getBoolean();
            useColorCodes = config.get("tabSpecific", "Use colour codes", useColorCodes).getBoolean();
            useColouredBg = config.get("tabSpecific", "Use colored bg", useColouredBg).getBoolean();
            drawTPS = config.get("tabSpecific", "Draw TPS", drawTPS).getBoolean();
            drawRoles = config.get("tabSpecific", "Draw role", drawRoles).getBoolean();
            useVanillaTeams = config.get("tabSpecific", "Use Vanilla teams", useVanillaTeams).getBoolean();
        }
        catch (Exception var4) {
            System.out.println("Unable to load Config");
            var4.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static String getString(String category, String propertyName, String defaultValue) {
        return config.get(category, propertyName, defaultValue).getString();
    }

    private static int getInt(String category, String propertyName, int defaultValue) {
        return config.get(category, propertyName, defaultValue).getInt(defaultValue);
    }

    static {
        avatarUrl = "";
        skinUrl = "https://stalnoy.online/public/users/skins/%player%.png";
        tabHeader = "STALNOY | Project server";
        useGroupName = false;
        useColouredBg = false;
        useColorCodes = true;
        drawTPS = true;
        drawRoles = true;
        roleColors = new HashMap<String, String>();
        enableBlurredContainers = true;
        roleColors.put("\u0418\u0433\u0440\u043e\u043a", "#525252");
    }
}

