/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.gui;

import net.minecraft.util.ResourceLocation;
import ru.laytin.exlntab.render.DrawUtil;

public class PlayerCardButton {
    private float x;
    private float y;
    private float width;
    private float height;
    private String text;
    private ResourceLocation texture;
    private Runnable onClickAction;
    private boolean hovered;
    private boolean visible = true;

    public PlayerCardButton(float x, float y, float width, float height, String text, ResourceLocation texture, Runnable onClick) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
        this.texture = texture;
        this.onClickAction = onClick;
    }

    public void draw(float alpha) {
        if (!this.visible) {
            return;
        }
        if (this.hovered) {
            DrawUtil.drawImage(this.x, this.y, this.width, this.height, this.texture, alpha * 1.2f);
        } else {
            DrawUtil.drawImage(this.x, this.y, this.width, this.height, this.texture, alpha * 0.8f);
        }
    }

    public void update(int mouseX, int mouseY) {
        if (!this.visible) {
            this.hovered = false;
            return;
        }
        this.hovered = this.isMouseOver(mouseX, mouseY);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        boolean over;
        if (!this.visible) {
            return false;
        }
        boolean bl = over = (float)mouseX >= this.x && (float)mouseX <= this.x + this.width && (float)mouseY >= this.y && (float)mouseY <= this.y + this.height;
        if (this.text.equals("\u041f\u0440\u0438\u0433\u043b") || this.text.equals("\u0427\u0430\u0442")) {
            // empty if block
        }
        return over;
    }

    public boolean mouseClicked(int mouseX, int mouseY) {
        if (!this.visible) {
            return false;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.onClickAction != null) {
                this.onClickAction.run();
            }
            return true;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (!visible) {
            this.hovered = false;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }
}

