/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.gui;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import ru.laytin.exlntab.ExlnTab;
import ru.laytin.exlntab.blur.BlurRenderer;
import ru.laytin.exlntab.gui.PlayerCardButton;
import ru.laytin.exlntab.handlers.ConfigHandler;
import ru.laytin.exlntab.proxy.ResourcesProxy;
import ru.laytin.exlntab.render.DrawUtil;
import ru.laytin.exlntab.render.PhotoRender;
import ru.laytin.exlntab.render.font.FontMagicObj;
import ru.laytin.exlntab.render.font.FontStyles;
import ru.laytin.exlntab.utils.PlayerInfoObj;

public class GuiCustomTab
extends GuiScreen {
    @SideOnly(value=Side.CLIENT)
    private static final float SCROLL_BAR_WIDTH = 2.0f;
    private static final float SCROLL_BAR_PADDING = 3.0f;
    private float targetScrollOffset = 0.0f;
    private float scrollVelocity = 0.0f;
    private long lastScrollTime = 0L;
    private static final float SCROLL_SMOOTHING = 0.3f;
    private static final float SCROLL_DECELERATION = 0.9f;
    private static final float MAX_SCROLL_VELOCITY = 30.0f;
    public Map<String, PlayerInfoObj> playerList = new HashMap<String, PlayerInfoObj>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private float referenceWidth = 327.0f;
    private float referenceHeight = 180.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float minScale = 1.0f;
    private float alpha = 0.3f;
    private float scrollOffset = 0.0f;
    private float maxScrollOffset = 0.0f;
    private static GuiCustomTab instance;
    private List<PlayerCardButton> allButtons = new ArrayList<PlayerCardButton>();
    public static int tps;
    public static int playerPing;
    public static boolean DEBUG_TAB;
    FontMagicObj tabFont = FontStyles.TabFontBold.getFontContainer();
    private Field _listShaders;
    private long start;
    Logger logger = ExlnTab.logger;
    private static float blurProgress;
    private static final float BLUR_SPEED = 0.05f;

    public GuiCustomTab() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void updateTps(int newTps) {
        tps = newTps;
    }

    public static void updatePing(int newPing) {
        playerPing = newPing;
    }

    public static GuiCustomTab getInstance() {
        return instance;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int widthScreen = res.func_78326_a();
        int heightScreen = res.func_78328_b();
        int translatedX = (int)((float)mouseX - ((float)(widthScreen / 2) - 140.0f * this.minScale));
        int translatedY = (int)((float)mouseY - ((float)(heightScreen / 2) - 55.0f * this.minScale) + this.scrollOffset);
        for (int i = 0; i < this.allButtons.size(); ++i) {
            boolean clicked;
            PlayerCardButton button = this.allButtons.get(i);
            if (!button.isVisible() || !(clicked = button.mouseClicked(translatedX, translatedY))) continue;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void handleScrolling() {
        if (!Keyboard.isKeyDown((int)15)) {
            this.targetScrollOffset = 0.0f;
            this.scrollVelocity = 0.0f;
            return;
        }
        if (this.maxScrollOffset <= 0.0f) {
            return;
        }
        int wheel = Mouse.getDWheel();
        if (wheel != 0 && this.maxScrollOffset > 0.0f) {
            long currentTime = System.currentTimeMillis();
            float deltaTime = (float)Math.min(50L, currentTime - this.lastScrollTime) / 16.0f;
            this.lastScrollTime = currentTime;
            float scrollAmount = (float)wheel * (1.0f + Math.abs(this.scrollVelocity) * 0.5f);
            this.scrollVelocity = Math.max(-30.0f, Math.min(30.0f, this.scrollVelocity - scrollAmount * deltaTime));
            if (Math.abs(scrollAmount) > 1.0f && this.mc.field_71439_g != null) {
                this.mc.field_71439_g.func_85030_a("random.click", 0.1f, 1.0f + scrollAmount * 0.01f);
            }
        }
        if (Math.abs(this.scrollVelocity) > 0.1f) {
            this.scrollVelocity *= 0.9f;
            this.targetScrollOffset = Math.max(0.0f, Math.min(this.targetScrollOffset + this.scrollVelocity, this.maxScrollOffset));
        } else {
            this.scrollVelocity = 0.0f;
        }
        this.scrollOffset += (this.targetScrollOffset - this.scrollOffset) * 0.3f;
        if (this.scrollOffset < 5.0f) {
            this.scrollOffset = 0.0f;
        }
        if (this.scrollOffset > this.maxScrollOffset - 5.0f) {
            this.scrollOffset = this.maxScrollOffset;
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            event.setCanceled(true);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!Keyboard.isKeyDown((int)15)) {
            this.mc.func_147108_a(null);
            return;
        }
        boolean tabPressed = Keyboard.isKeyDown((int)15);
        blurProgress = tabPressed ? Math.min(blurProgress + 0.05f, 1.0f) : Math.max(blurProgress - 0.05f, 0.0f);
        if (blurProgress > 0.01f) {
            BlurRenderer.renderBlur(blurProgress);
        }
        this.mc.field_71460_t.func_78478_c();
        this.func_146276_q_();
        if (!Keyboard.isKeyDown((int)15)) {
            this.alpha = Math.max(this.alpha - 0.1f, 0.0f);
            this.scrollOffset *= 0.9f;
            if (this.alpha <= 0.01f) {
                this.mc.func_147108_a(null);
                return;
            }
        } else {
            this.handleScrolling();
        }
        ScoreObjective scoreobjective = this.mc.field_71441_e.func_96441_U().func_96539_a(0);
        NetHandlerPlayClient handler = this.mc.field_71439_g.field_71174_a;
        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int widthScreen = res.func_78326_a();
        int heightScreen = res.func_78328_b();
        this.recalculateScale(widthScreen, heightScreen);
        ArrayList vanillaPlayers = new ArrayList(handler.field_147303_b);
        ArrayList<String> playerNames = new ArrayList<String>();
        String currentPlayerName = this.mc.func_110432_I().func_111285_a();
        playerNames.add(currentPlayerName);
        for (GuiPlayerInfo info : vanillaPlayers) {
            String playerName = info.field_78831_a;
            if (playerNames.contains(playerName)) continue;
            playerNames.add(playerName);
        }
        if (playerNames.size() > 1 && DEBUG_TAB) {
            DEBUG_TAB = false;
        }
        float itemHeight = 20.0f * this.minScale;
        float visibleAreaHeight = 125.0f * this.minScale;
        int actualPlayerCount = 0;
        if (DEBUG_TAB) {
            actualPlayerCount = 50;
        } else {
            for (String playerName : playerNames) {
                if (!this.playerList.containsKey(playerName)) continue;
                ++actualPlayerCount;
            }
        }
        int totalRows = (int)Math.ceil((double)actualPlayerCount / 4.0);
        float totalContentHeight = (float)totalRows * itemHeight;
        this.maxScrollOffset = Math.max(0.0f, totalContentHeight - visibleAreaHeight);
        this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, this.maxScrollOffset));
        int playerPing = 10;
        try {
            if (!vanillaPlayers.isEmpty()) {
                playerPing = ((GuiPlayerInfo)vanillaPlayers.get((int)0)).field_78829_b;
            }
        }
        catch (Exception e) {
            System.out.println("[DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043f\u0438\u043d\u0433\u0430: " + e.getMessage());
        }
        this.drawBackground(widthScreen, heightScreen, playerPing, this.playerList.size());
        this.drawScissorList(widthScreen, heightScreen, playerNames, mouseX, mouseY);
        if (this.maxScrollOffset > 0.0f) {
            this.drawScrollRect(widthScreen, heightScreen);
        }
        if ((double)this.alpha < 0.9) {
            this.alpha += 0.03f;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    private int getColor(int r, int g, int b, float alpha) {
        int a = (int)(alpha * 255.0f) & 0xFF;
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private void drawScrollRect(int widthScreen, int heightScreen) {
        if (this.maxScrollOffset <= 0.0f) {
            return;
        }
        float scrollAreaHeight = 125.0f * this.minScale;
        float scrollBarHeight = scrollAreaHeight * (scrollAreaHeight / (scrollAreaHeight + this.maxScrollOffset));
        float scrollRatio = this.scrollOffset / this.maxScrollOffset;
        float scrollAreaTop = (float)(heightScreen / 2) - 55.0f * this.minScale;
        float scrollBarY = scrollAreaTop + (scrollAreaHeight - scrollBarHeight) * scrollRatio;
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 145.0f * this.minScale - 3.0f, scrollBarY, (float)(widthScreen / 2) + 145.0f * this.minScale + 2.0f - 3.0f, scrollBarY + scrollBarHeight, this.hex2Rgb("#FF8102").getRGB(), this.alpha);
    }

    private void drawScissorList(int widthScreen, int heightScreen, List<String> list1, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(widthScreen / 2) - 140.0f * this.minScale), (float)((float)(heightScreen / 2) - 55.0f * this.minScale), (float)0.0f);
        GL11.glEnable((int)3089);
        this.scissorViewport((int)((float)(widthScreen / 2) - 140.0f * this.minScale), (int)((float)(heightScreen / 2) - 55.0f * this.minScale), (int)(this.minScale * 280.0f), (int)(this.minScale * 125.0f));
        GL11.glTranslatef((float)0.0f, (float)(-this.scrollOffset), (float)0.0f);
        int translatedX = (int)((float)mouseX - ((float)(widthScreen / 2) - 140.0f * this.minScale));
        int translatedY = (int)((float)mouseY - ((float)(heightScreen / 2) - 55.0f * this.minScale) + this.scrollOffset);
        if (!ConfigHandler.useVanillaTeams) {
            this.drawPlayers(list1, translatedX, translatedY);
        }
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    private void scissorViewport(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int scaleFactor = sr.func_78325_e();
        int displayHeight = mc.field_71440_d;
        int scissorX = x * scaleFactor;
        int scissorY = displayHeight - (y + height) * scaleFactor;
        int scissorWidth = width * scaleFactor;
        int scissorHeight = height * scaleFactor;
        GL11.glScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
    }

    private void drawPlayers(List<String> list1, int translatedX, int translatedY) {
        this.allButtons.clear();
        AtomicInteger a = new AtomicInteger(0);
        ArrayList<PlayerInfoObj> playersToRender = new ArrayList<PlayerInfoObj>();
        for (String playerName : list1) {
            PlayerInfoObj player = this.playerList.get(playerName);
            if (player == null) continue;
            playersToRender.add(player);
        }
        for (PlayerInfoObj ob : playersToRender) {
            float yVal;
            float xVal;
            block12: {
                xVal = (float)(a.get() % 4) * 71.3f * this.minScale;
                yVal = (float)(a.get() / 4 * 20) * this.minScale;
                float visibleAreaHeight = 130.0f * this.minScale;
                boolean isVisible = yVal >= 0.0f && yVal + 20.0f * this.minScale <= visibleAreaHeight;
                DrawUtil.drawImage(xVal, yVal, 66.0f * this.minScale, 15.0f * this.minScale, ResourcesProxy.buttonHover, this.alpha);
                try {
                    PhotoRender.getInstance().drawAvatar(ob.getUsername(), xVal + 2.0f * this.minScale, yVal + 2.0f * this.minScale, 11.0f * this.minScale, 11.0f * this.minScale, 1.0f);
                }
                catch (Exception e) {
                    if (!DEBUG_TAB) break block12;
                    System.out.println("[DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435 \u0430\u0432\u0430\u0442\u0430\u0440\u0430: " + e.getMessage());
                }
            }
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), FontStyles.SemiBold.getFontContainer().getTextFont().trimStringToWidth(ob.getUsername(), 200.0f, false), xVal + 15.0f * this.minScale, yVal + 4.0f * this.minScale, 0.2f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            float buttonWidth = 7.0f * this.minScale;
            float buttonHeight = 7.0f * this.minScale;
            float buttonsStartX = xVal + 58.0f * this.minScale;
            float buttonsStartY = yVal + 4.0f * this.minScale;
            PlayerCardButton button1 = new PlayerCardButton(buttonsStartX, buttonsStartY, buttonWidth, buttonHeight, "\u041f\u0440\u0438\u0433\u043b", ResourcesProxy.buttonTP, () -> this.handleInviteClick(ob.getUsername()));
            PlayerCardButton button2 = new PlayerCardButton(buttonsStartX + buttonWidth + 2.0f * this.minScale, buttonsStartY, buttonWidth, buttonHeight, "\u0427\u0430\u0442", ResourcesProxy.buttonTP, () -> this.handleMessageClick(ob.getUsername()));
            this.allButtons.add(button1);
            this.allButtons.add(button2);
            float buttonY = yVal + 4.0f * this.minScale;
            boolean buttonsVisible = true;
            button1.setVisible(buttonsVisible);
            button2.setVisible(false);
            if (buttonsVisible) {
                button1.update(translatedX, translatedY);
                button2.update(translatedX, translatedY);
                button1.draw(this.alpha);
                button2.draw(this.alpha);
            } else {
                button1.update(-1000, -1000);
                button2.update(-1000, -1000);
            }
            if (ConfigHandler.drawRoles) {
                String drawRoleText;
                block13: {
                    String oldText;
                    drawRoleText = ConfigHandler.useGroupName ? ob.getRole() : ob.getRoleDisplayName();
                    String string = drawRoleText = drawRoleText.equals("exlntab") ? "\u041c\u0443\u0441\u043e\u0440" : drawRoleText;
                    if (!ConfigHandler.useColorCodes) {
                        oldText = drawRoleText;
                        drawRoleText = drawRoleText.replaceAll("&.", "").replaceAll("\u00a7.", "");
                    } else {
                        oldText = drawRoleText;
                        drawRoleText = drawRoleText.replace("&", "\u00a7");
                    }
                    drawRoleText = FontStyles.SemiBold.getFontContainer().getTextFont().trimStringToWidth(drawRoleText, 150.0f, false);
                    if (ConfigHandler.useColouredBg) {
                        String roleColor = ConfigHandler.getColourByRole(ob.getRole());
                        try {
                            DrawUtil.drawRoundedSquare(xVal + 15.0f * this.minScale, yVal + 8.0f * this.minScale, Math.min(FontStyles.SemiBold.getFontContainer().width(drawRoleText) * 0.17f * this.minScale + 6.0f * this.minScale, 51.0f * this.minScale), 5.0f * this.minScale, 1.0f * this.minScale, this.hex2Rgb(roleColor).getRGB(), this.alpha);
                        }
                        catch (Exception e) {
                            if (!DEBUG_TAB) break block13;
                            System.out.println("[DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435 \u0444\u043e\u043d\u0430 \u0440\u043e\u043b\u0438: " + e.getMessage());
                        }
                    }
                }
                DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), drawRoleText, ConfigHandler.useColouredBg ? xVal + 18.0f * this.minScale : xVal + 15.0f * this.minScale, yVal + 10.5f * this.minScale, 0.17f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            }
            a.incrementAndGet();
        }
    }

    private void handleInviteClick(String username) {
        Minecraft.func_71410_x().field_71439_g.func_71165_d("/tpa " + username);
    }

    private void handleMessageClick(String username) {
        System.out.println("\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0447\u0430\u0442 \u0441: " + username);
    }

    private void forceDraw(List<String> displayNames, int translatedX, int translatedY) {
        this.allButtons.clear();
        if (!this.playerList.containsKey("TestAdmin")) {
            this.forceInitDebugPlayers();
        }
        AtomicInteger index = new AtomicInteger(0);
        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int widthScreen = res.func_78326_a();
        int heightScreen = res.func_78328_b();
        try {
            String currentPlayerName = this.mc.func_110432_I().func_111285_a();
            this.drawPlayerDirectly(currentPlayerName, "player", "\u0418\u0433\u04400\u043e\u043a", index.getAndIncrement(), translatedX, translatedY, widthScreen, heightScreen);
            this.drawPlayerDirectly("TestAdmin", "admin", "\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440", index.getAndIncrement(), translatedX, translatedY, widthScreen, heightScreen);
            for (int i = 0; i < 50; ++i) {
                this.drawPlayerDirectly("TestVIP", "vip", "VIP-\u0438\u0433\u0440\u043e\u043a", index.getAndIncrement(), translatedX, translatedY, widthScreen, heightScreen);
            }
        }
        catch (Exception e) {
            System.err.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435: " + e);
            e.printStackTrace();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    private void drawPlayerDirectly(String username, String role, String roleDisplayName, int index, int translatedX, int translatedY, int widthScreen, int heightScreen) {
        try {
            float xVal = (float)(index % 4) * 71.3f * this.minScale;
            float yVal = (float)(index / 4 * 20) * this.minScale;
            float visibleAreaHeight = 130.0f * this.minScale;
            boolean isVisible = yVal >= 0.0f && yVal + 20.0f * this.minScale <= visibleAreaHeight;
            DrawUtil.drawImage(xVal, yVal, 66.0f * this.minScale, 15.0f * this.minScale, ResourcesProxy.buttonHover, this.alpha);
            try {
                PhotoRender.getInstance().drawAvatar(username, xVal + 2.0f * this.minScale, yVal + 2.0f * this.minScale, 11.0f * this.minScale, 11.0f * this.minScale, 1.0f);
            }
            catch (Exception e) {
                System.out.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0438 \u0430\u0432\u0430\u0442\u0430\u0440\u0430: " + e.getMessage());
            }
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), username, xVal + 15.0f * this.minScale, yVal + 4.0f * this.minScale, 0.2f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            float buttonWidth = 7.0f * this.minScale;
            float buttonHeight = 7.0f * this.minScale;
            float buttonsStartX = xVal + 58.0f * this.minScale;
            float buttonsStartY = yVal + 4.0f * this.minScale;
            PlayerCardButton button1 = new PlayerCardButton(buttonsStartX, buttonsStartY, buttonWidth, buttonHeight, "\u041f\u0440\u0438\u0433\u043b", ResourcesProxy.buttonTP, () -> this.handleInviteClick(username));
            PlayerCardButton button2 = new PlayerCardButton(buttonsStartX + buttonWidth + 2.0f * this.minScale, buttonsStartY, buttonWidth, buttonHeight, "\u0427\u0430\u0442", ResourcesProxy.buttonTP, () -> this.handleMessageClick(username));
            this.allButtons.add(button1);
            this.allButtons.add(button2);
            boolean buttonsVisible = true;
            button1.setVisible(buttonsVisible);
            button2.setVisible(buttonsVisible);
            if (buttonsVisible) {
                button1.update(translatedX, translatedY);
                button2.update(translatedX, translatedY);
                button1.draw(this.alpha);
                button2.draw(this.alpha);
            } else {
                button1.update(-1000, -1000);
                button2.update(-1000, -1000);
            }
            String roleColor = role.equals("admin") ? "#FF8102" : (role.equals("vip") ? "#00AAFF" : "#525252");
            try {
                DrawUtil.drawRoundedSquare(xVal + 15.0f * this.minScale, yVal + 8.0f * this.minScale, Math.min(FontStyles.SemiBold.getFontContainer().width(roleDisplayName) * 0.17f * this.minScale + 6.0f * this.minScale, 51.0f * this.minScale), 5.0f * this.minScale, 1.0f * this.minScale, this.hex2Rgb(roleColor).getRGB(), this.alpha);
                DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), roleDisplayName, xVal + 18.0f * this.minScale, yVal + 10.5f * this.minScale, 0.17f * this.minScale, this.hex2Rgb("#FFFFFF").getRGB());
            }
            catch (Exception e) {
                System.out.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0438 \u0440\u043e\u043b\u0438: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("[FORCE_DEBUG] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0435 \u0438\u0433\u0440\u043e\u043a\u0430 " + username + ": " + e);
            e.printStackTrace();
        }
    }

    private void forceInitDebugPlayers() {
        this.playerList.clear();
        ArrayList<String> testNames = new ArrayList<String>();
        for (int i = 1; i <= 50; ++i) {
            String name = "TestPlayer" + i;
            this.playerList.put(name, new PlayerInfoObj("player", "\u0418\u0433\u0440\u043e\u043a", name, 50));
            testNames.add(name);
        }
        ArrayList playerNames = new ArrayList(testNames);
        if (DEBUG_TAB) {
            playerNames = new ArrayList(testNames);
        }
        this.logger.info("Initialized test players: " + playerNames.size());
    }

    private void drawBackground(int widthScreen, int heightScreen, int ping, int online) {
        DrawUtil.drawImage((float)(widthScreen / 2) - 150.0f * this.minScale, (float)(heightScreen / 2) - 80.0f * this.minScale, 300.0f * this.minScale, 160.0f * this.minScale, ResourcesProxy.bigWindow, this.alpha);
        DrawUtil.drawRectFloat((float)(widthScreen / 2) - 140.0f * this.minScale, (float)(heightScreen / 2) - 60.0f * this.minScale, (float)(widthScreen / 2) + 140.0f * this.minScale, (float)(heightScreen / 2) - 61.0f * this.minScale, this.hex2Rgb("#FF8102").getRGB(), this.alpha);
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), FontStyles.SemiBold.getFontContainer().getTextFont().trimStringToWidth(ConfigHandler.tabHeader, 350.0f, false), (float)(widthScreen / 2) - 140.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.3f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
        this.drawPing(widthScreen, heightScreen, ping);
        if (ConfigHandler.drawTPS) {
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), "TPS: ", (float)(widthScreen / 2) + 5.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), String.valueOf(tps), (float)(widthScreen / 2) + 23.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.getTpsColor(tps));
            DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), "|", (float)(widthScreen / 2) + 41.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.15f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
        }
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), "\u041e\u043d\u043b\u0430\u0439\u043d: ", (float)(widthScreen / 2) + 46.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.hex2Rgb("#FF8102").getRGB());
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), String.valueOf(online), (float)(widthScreen / 2) + 70.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, 0.25f * this.minScale, this.hex2Rgb("#498f03").getRGB());
    }

    private void drawPing(int widthScreen, int heightScreen, int ping) {
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 132.0f * this.minScale, (float)(heightScreen / 2) - 66.0f * this.minScale, (float)(widthScreen / 2) + 134.0f * this.minScale, (float)(heightScreen / 2) - 69.0f * this.minScale, this.getPingColor(ping, 1), this.alpha);
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 135.0f * this.minScale, (float)(heightScreen / 2) - 66.0f * this.minScale, (float)(widthScreen / 2) + 137.0f * this.minScale, (float)(heightScreen / 2) - 71.0f * this.minScale, this.getPingColor(ping, 2), this.alpha);
        DrawUtil.drawRectFloat((float)(widthScreen / 2) + 138.0f * this.minScale, (float)(heightScreen / 2) - 66.0f * this.minScale, (float)(widthScreen / 2) + 140.0f * this.minScale, (float)(heightScreen / 2) - 73.0f * this.minScale, this.getPingColor(ping, 3), this.alpha);
        DrawUtil.drawStringWithDepth(FontStyles.SemiBold.getFontContainer(), String.valueOf(playerPing), (float)(widthScreen / 2) + 130.0f * this.minScale, (float)(heightScreen / 2) - 74.0f * this.minScale, 0.15f * this.minScale, this.hex2Rgb("#525252").getRGB());
    }

    private int getPingColor(int ping, int nump) {
        if (ping > 150) {
            if (nump > 1) {
                return this.hex2Rgb("#525252").getRGB();
            }
            return this.hex2Rgb("#eb4034").getRGB();
        }
        if (ping > 80) {
            if (nump > 2) {
                return this.hex2Rgb("#525252").getRGB();
            }
            return this.hex2Rgb("#eb8f34").getRGB();
        }
        return this.hex2Rgb("#498f03").getRGB();
    }

    private int getTpsColor(double tps) {
        if (tps < 10.0) {
            return this.hex2Rgb("#eb4034").getRGB();
        }
        if (tps < 15.0) {
            return this.hex2Rgb("#eb8f34").getRGB();
        }
        return this.hex2Rgb("#498f03").getRGB();
    }

    private Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    private void recalculateScale(int widthScreen, int heightScreen) {
        this.scaleX = (float)widthScreen / this.referenceWidth;
        this.scaleY = (float)heightScreen / this.referenceHeight;
        this.minScale = Math.min(Math.min(this.scaleX, this.scaleY), 4.0f);
        this.logger.info(String.format("Scale: screen=%dx%d, X=%.2f, Y=%.2f, min=%.2f", widthScreen, heightScreen, Float.valueOf(this.scaleX), Float.valueOf(this.scaleY), Float.valueOf(this.minScale)));
    }

    @SubscribeEvent
    public void onMouseScroll(MouseEvent event) {
        if (!Keyboard.isKeyDown((int)15)) {
            return;
        }
        if (this.maxScrollOffset <= 0.0f) {
            return;
        }
        int wheel = event.dwheel;
        if (wheel != 0) {
            event.setCanceled(true);
            System.out.println("[DEBUG] Event scroll canceled, using direct scroll instead");
        }
    }

    static {
        tps = 25;
        playerPing = 0;
        DEBUG_TAB = false;
        blurProgress = 0.0f;
    }
}

