/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.blur;

import java.io.InputStream;
import java.util.Scanner;
import org.lwjgl.opengl.GL20;

public class BlurShader {
    private final int program;

    public BlurShader(InputStream vertexStream, InputStream fragmentStream) throws Exception {
        int vertexShader = this.loadShader(vertexStream, 35633);
        int fragmentShader = this.loadShader(fragmentStream, 35632);
        this.program = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.program, (int)vertexShader);
        GL20.glAttachShader((int)this.program, (int)fragmentShader);
        GL20.glLinkProgram((int)this.program);
        if (GL20.glGetProgrami((int)this.program, (int)35714) == 0) {
            throw new RuntimeException("Failed to link shader: " + GL20.glGetProgramInfoLog((int)this.program, (int)512));
        }
    }

    private int loadShader(InputStream in, int type) throws Exception {
        String source = new Scanner(in, "UTF-8").useDelimiter("\\A").next();
        int shader = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)shader, (CharSequence)source);
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            throw new RuntimeException("Failed to compile shader: " + GL20.glGetShaderInfoLog((int)shader, (int)512));
        }
        return shader;
    }

    public void use() {
        GL20.glUseProgram((int)this.program);
    }

    public void release() {
        GL20.glUseProgram((int)0);
    }

    public void setUniform(String name, int value) {
        int loc = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
        GL20.glUniform1i((int)loc, (int)value);
    }

    public void setUniform(String name, float x, float y) {
        int loc = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
        GL20.glUniform2f((int)loc, (float)x, (float)y);
    }

    public void setUniform(String name, float value) {
        int loc = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
        GL20.glUniform1f((int)loc, (float)value);
    }
}

