/*
 * Decompiled with CFR 0.152.
 */
package ru.laytin.exlntab.blur;

import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import ru.laytin.exlntab.blur.BlurShader;

public class BlurRenderer {
    private static BlurShader horizontalShader;
    private static BlurShader verticalShader;
    private static Framebuffer pingPongFbo;
    private static int lastWidth;
    private static int lastHeight;

    public static void init() {
        try {
            horizontalShader = new BlurShader(BlurRenderer.class.getResourceAsStream("/assets/blur/vertex.vsh"), BlurRenderer.class.getResourceAsStream("/assets/blur/blur_horiz.fsh"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            verticalShader = new BlurShader(BlurRenderer.class.getResourceAsStream("/assets/blur/vertex.vsh"), BlurRenderer.class.getResourceAsStream("/assets/blur/blur_vert.fsh"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderBlur(float progress) {
        Minecraft mc = Minecraft.func_71410_x();
        int w = mc.field_71443_c;
        int h = mc.field_71440_d;
        Framebuffer screenFbo = mc.func_147110_a();
        if (w != lastWidth || h != lastHeight) {
            if (pingPongFbo != null) {
                pingPongFbo.func_147608_a();
            }
            pingPongFbo = new Framebuffer(w, h, false);
            lastWidth = w;
            lastHeight = h;
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        try {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)-1.0, (double)1.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            pingPongFbo.func_147610_a(true);
            GL11.glClear((int)16640);
            horizontalShader.use();
            horizontalShader.setUniform("tex", 0);
            horizontalShader.setUniform("resolution", w, h);
            horizontalShader.setUniform("progress", progress);
            GL11.glBindTexture((int)3553, (int)screenFbo.field_147617_g);
            BlurRenderer.drawFullScreenQuad();
            horizontalShader.release();
            screenFbo.func_147610_a(true);
            GL11.glClear((int)16640);
            verticalShader.use();
            verticalShader.setUniform("tex", 0);
            verticalShader.setUniform("resolution", w, h);
            verticalShader.setUniform("progress", progress);
            GL11.glBindTexture((int)3553, (int)BlurRenderer.pingPongFbo.field_147617_g);
            BlurRenderer.drawFullScreenQuad();
            verticalShader.release();
        }
        finally {
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    private static void drawFullScreenQuad() {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)1.0f);
        GL11.glEnd();
    }

    static {
        lastWidth = -1;
        lastHeight = -1;
    }
}

