/*
 * Decompiled with CFR 0.152.
 */
package pct.botanic.energistics.blocks.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import pct.botanic.energistics.blocks.AEPureDaisy;
import pct.botanic.energistics.blocks.tile.TileGeneric;
import pct.botanic.energistics.items.RuneAssemblerCraftingPattern;
import pct.botanic.energistics.utilities.Config;
import pct.botanic.energistics.utilities.RecipeChecker;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.common.block.decor.IFloatingFlower;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class TileAEDaisy
extends TileGeneric
implements IFloatingFlower {
    private int currMana = 0;
    private int maxMana = 30000;
    private int manaCost = 0;
    private int multiplier = 1;
    private ItemStack input;
    private ItemStack output;
    private boolean isCrafting = false;

    public void provideCrafting(ICraftingProviderHelper helper) {
        for (RecipePureDaisy rec : BotaniaAPI.pureDaisyRecipes) {
            helper.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)new RuneAssemblerCraftingPattern(new Object[]{rec.getInput()}, new ItemStack(rec.getOutput()), 10000));
        }
    }

    public boolean pushPattern(ICraftingPatternDetails pattern, InventoryCrafting inventoryCrafting) {
        if (!this.isCrafting && pattern instanceof RuneAssemblerCraftingPattern) {
            this.output = pattern.getOutputs()[0].getItemStack();
            this.input = pattern.getInputs()[0].getItemStack();
            this.manaCost = ((RuneAssemblerCraftingPattern)pattern).getManaUsage() * this.multiplier;
            return this.currMana >= this.manaCost;
        }
        return false;
    }

    public boolean isBusy() {
        return this.isCrafting;
    }

    public boolean isFull() {
        return this.currMana >= this.maxMana;
    }

    public void recieveMana(int i) {
        if (this.isFull()) {
            return;
        }
        this.currMana = this.currMana + i <= this.maxMana ? this.currMana + i : this.maxMana;
    }

    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public int getCurrentMana() {
        return this.currMana;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TileEvent(value=TileEventType.TICK)
    public void onTick() {
        List entities = this.func_145831_w().func_72872_a(EntityManaBurst.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)this.field_145848_d - 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 1.5)));
        for (EntityManaBurst manaBurst : entities) {
            TileEntity te;
            ChunkCoordinates coord = manaBurst.getBurstSourceChunkCoordinates();
            if (coord.field_71574_a == 0 && coord.field_71572_b == -1 && coord.field_71573_c == 0 || manaBurst.getMana() == 120) {
                manaBurst.setFake(true);
                manaBurst.setMana(0);
                manaBurst.func_70106_y();
            }
            if (!((te = this.field_145850_b.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) instanceof TileSpreader)) continue;
            ChunkCoordinates boundpos = ((TileSpreader)te).getBinding();
            if (boundpos == null) {
                return;
            }
            TileEntity boundtile = this.field_145850_b.func_147438_o(boundpos.field_71574_a, boundpos.field_71572_b, boundpos.field_71573_c);
            if (boundtile == null || boundtile.field_145851_c != this.field_145851_c || boundtile.field_145848_d != this.field_145848_d || boundtile.field_145849_e != this.field_145849_e || !((TileSpreader)te).isULTRA_SPREADER() && !((TileSpreader)te).isDreamwood()) continue;
            manaBurst.func_70106_y();
        }
        if (Config.isPassiveMode()) {
            try {
                boolean returnv = true;
                Item daisy = ItemBlockSpecialFlower.ofType((String)"puredaisy").func_77973_b();
                if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) != Blocks.field_150350_a && Item.func_150898_a((Block)this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).equals(daisy)) {
                    returnv = false;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) != Blocks.field_150350_a && Item.func_150898_a((Block)this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).equals(daisy)) {
                    returnv = false;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) != Blocks.field_150350_a && Item.func_150898_a((Block)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).equals(daisy)) {
                    returnv = false;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != Blocks.field_150350_a && Item.func_150898_a((Block)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).equals(daisy)) {
                    returnv = false;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) != Blocks.field_150350_a && Item.func_150898_a((Block)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).equals(daisy)) {
                    returnv = false;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) != Blocks.field_150350_a && (Item.func_150898_a((Block)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) == null ? Item.func_150898_a((Block)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) : this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1).func_149650_a(0, null, 0)).equals(daisy)) {
                    returnv = false;
                }
                if (returnv) {
                    return;
                }
            }
            catch (Exception ignored) {
                return;
            }
        }
        boolean validRecipe = false;
        if (this.input != null && this.output != null) {
            validRecipe = RecipeChecker.isDaisyRecipe(this.input, this.output);
        }
        if (validRecipe && this.currMana >= this.manaCost) {
            this.isCrafting = true;
            validRecipe = false;
            try {
                this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)AEApi.instance().storage().createItemStack(this.output.func_77946_l()), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.input = null;
                this.output = null;
                this.currMana -= this.manaCost;
            }
            catch (GridAccessException gridAccessException) {
            }
            finally {
                this.isCrafting = false;
            }
        }
    }

    public ItemStack getDisplayStack() {
        return new ItemStack((Block)new AEPureDaisy());
    }

    public IFloatingFlower.IslandType getIslandType() {
        return IFloatingFlower.IslandType.GRASS;
    }

    public void setIslandType(IFloatingFlower.IslandType islandType) {
    }

    @Override
    public void setMana(int i) {
        this.currMana = i;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeNBT(NBTTagCompound cmp) {
        NBTTagCompound root = new NBTTagCompound();
        root.func_74768_a(NBTKeys.currMana.toString(), this.currMana);
        cmp.func_74782_a(NBTKeys.Root.toString(), (NBTBase)root);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readNBT(NBTTagCompound cmp) {
        if (cmp.func_74764_b(NBTKeys.Root.toString())) {
            this.currMana = ((NBTTagCompound)cmp.func_74781_a(NBTKeys.Root.toString())).func_74762_e(NBTKeys.currMana.toString());
        }
    }

    private static enum NBTKeys {
        currMana,
        Root;

    }
}

