/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorReagent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MeteorComponent {
    private final int weight;
    private final ItemStack itemStack;
    private final ArrayList<Reagent> reagent;
    public static MeteorComponent defaultMeteorBlock;
    private static final Pattern itemNamePattern;
    private static final Pattern oredictPattern;

    public static void setDefaultMeteorBlock() {
        String string = AlchemicalWizardry.defaultMeteorBlock;
        String[] split = string.split(":");
        ItemStack stack = null;
        if (!string.isEmpty() && split.length >= 3) {
            stack = GameRegistry.findItemStack((String)split[0], (String)split[1], (int)1);
        }
        if (stack != null) {
            Items.field_151008_G.setDamage(stack, Integer.parseInt(split[2]));
        } else {
            stack = new ItemStack(Blocks.field_150348_b);
        }
        defaultMeteorBlock = new MeteorComponent(stack, 1);
    }

    public MeteorComponent(ItemStack stack, int weight) {
        this(stack, weight, new ArrayList<Reagent>());
    }

    public MeteorComponent(ItemStack stack, int weight, ArrayList<Reagent> reagent) {
        this.itemStack = stack;
        this.weight = weight;
        this.reagent = reagent;
    }

    public static List<MeteorComponent> parseStringArray(String[] blockArray) {
        ArrayList<MeteorComponent> addList = new ArrayList<MeteorComponent>();
        if (blockArray == null) {
            return addList;
        }
        for (String blockName : blockArray) {
            MeteorComponent component = MeteorComponent.parseString(blockName);
            if (component == null) continue;
            addList.add(component);
        }
        return addList;
    }

    public static MeteorComponent parseString(String blockName) {
        Matcher matcher = itemNamePattern.matcher(blockName);
        if (matcher.matches()) {
            String modID = matcher.group(1);
            String itemName = matcher.group(2);
            int meta = Integer.parseInt(matcher.group(3));
            int weight = Integer.parseInt(matcher.group(4));
            String reagent = matcher.group(5);
            ArrayList<Reagent> reagentList = MeteorReagent.parseReagents(reagent, blockName);
            ItemStack stack = GameRegistry.findItemStack((String)modID, (String)itemName, (int)1);
            if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
                stack.func_77964_b(meta);
                return new MeteorComponent(stack, weight, reagentList);
            }
        } else {
            matcher = oredictPattern.matcher(blockName);
            if (matcher.matches()) {
                String oreDict = matcher.group(1);
                int weight = Integer.parseInt(matcher.group(2));
                String reagent = matcher.group(3);
                ArrayList<Reagent> reagentList = MeteorReagent.parseReagents(reagent, blockName);
                ArrayList list = OreDictionary.getOres((String)oreDict);
                for (ItemStack stack : list) {
                    if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                    return new MeteorComponent(stack, weight, reagentList);
                }
            }
        }
        AlchemicalWizardry.logger.warn("Unable to add Meteor Component \"{}\"", new Object[]{blockName});
        AlchemicalWizardry.logger.warn("Valid formats are \"modId:itemName:meta:weight(:reagent1, reagent2, ... optional)\" and \"OREDICT:oreDictName:weight(:reagent1, reagent2, ... optional)\".");
        return null;
    }

    public int getWeight() {
        return this.weight;
    }

    public static int getTotalListWeight(List<MeteorComponent> blockList) {
        int totalWeight = 0;
        for (MeteorComponent component : blockList) {
            totalWeight += component.getWeight();
        }
        return totalWeight;
    }

    public ItemStack getBlock() {
        return this.itemStack;
    }

    public ArrayList<Reagent> getRequiredReagents() {
        return this.reagent;
    }

    public boolean checkForReagent(List<Reagent> reagentList) {
        if (this.reagent.isEmpty()) {
            return true;
        }
        for (Reagent r1 : reagentList) {
            for (Reagent r2 : this.reagent) {
                if (!r1.equals(r2)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        itemNamePattern = Pattern.compile("(.*):(.*):(\\d+):(\\d+)(:.*)?");
        oredictPattern = Pattern.compile("OREDICT:(.*):(\\d+)(:.*)?");
    }
}

