/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect.cse.earth;

import WayofTime.alchemicalWizardry.api.spell.ComplexSpellEffect;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellModifier;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellType;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigm;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigmSelf;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.earth.SelfDefensiveEarth;

public class CSESelfDefensiveEarth
extends ComplexSpellEffect {
    public CSESelfDefensiveEarth() {
        super(ComplexSpellType.EARTH, ComplexSpellModifier.DEFENSIVE);
    }

    public CSESelfDefensiveEarth(int power, int cost, int potency) {
        this();
        this.powerEnhancement = power;
        this.costEnhancement = cost;
        this.potencyEnhancement = potency;
    }

    @Override
    public void modifyParadigm(SpellParadigm parad) {
        if (parad instanceof SpellParadigmSelf) {
            ((SpellParadigmSelf)parad).addSelfSpellEffect(new SelfDefensiveEarth(this.powerEnhancement, this.potencyEnhancement, this.costEnhancement));
        }
    }

    @Override
    public ComplexSpellEffect copy(int power, int cost, int potency) {
        return new CSESelfDefensiveEarth(power, cost, potency);
    }

    @Override
    public int getCostOfEffect() {
        return (int)(750.0 * (1.1 * (double)this.powerEnhancement + 1.0) * (0.5 * (double)this.potencyEnhancement + 1.0) * Math.pow(0.85, this.costEnhancement));
    }
}

