/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.items;

import codechicken.lib.math.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.Lumberjack;
import fox.spiteful.avaritia.items.ItemStackWrapper;
import fox.spiteful.avaritia.items.LudicrousItems;
import fox.spiteful.avaritia.items.tools.ToolHelper;
import fox.spiteful.avaritia.render.ICosmicRenderItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemMatterCluster
extends Item
implements ICosmicRenderItem {
    public static final String MAINTAG = "clusteritems";
    public static final String LISTTAG = "items";
    public static final String ITEMTAG = "item";
    public static final String COUNTTAG = "count";
    public static final String MAINCOUNTTAG = "total";
    public static int capacity = 16384;
    public IIcon iconFull;
    public IIcon cosmicIcon;
    public IIcon cosmicIconFull;

    public ItemMatterCluster() {
        this.func_77625_d(1);
        this.func_77655_b("avaritia_mattercluster");
        this.func_111206_d("avaritia:mattercluster");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        super.func_94581_a(ir);
        this.cosmicIcon = ir.func_94245_a("avaritia:mattercluster_mask");
        this.iconFull = ir.func_94245_a("avaritia:mattercluster_full");
        this.cosmicIconFull = ir.func_94245_a("avaritia:mattercluster_full_mask");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return LudicrousItems.cosmic;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean debug) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(MAINTAG)) {
            return;
        }
        NBTTagCompound clustertag = stack.func_77978_p().func_74775_l(MAINTAG);
        tooltip.add(clustertag.func_74762_e(MAINCOUNTTAG) + "/" + capacity + " " + StatCollector.func_74838_a((String)"tooltip.matter_cluster.counter"));
        tooltip.add("");
        if (GuiScreen.func_146272_n()) {
            NBTTagList list = clustertag.func_150295_c(LISTTAG, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ItemStack countstack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(ITEMTAG));
                int count = tag.func_74762_e(COUNTTAG);
                if (countstack != null) {
                    tooltip.add(countstack.func_77973_b().func_77613_e((ItemStack)countstack).field_77937_e + countstack.func_82833_r() + EnumChatFormatting.GRAY + " x " + count);
                    continue;
                }
                tooltip.add(EnumChatFormatting.RED + "DELETED" + EnumChatFormatting.GRAY + " x " + count);
            }
        } else {
            tooltip.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"tooltip.matter_cluster.desc"));
            tooltip.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.matter_cluster.desc2"));
        }
    }

    public static List<ItemStack> makeClusters(List<ItemStack> input) {
        Map<ItemStackWrapper, Integer> items = ToolHelper.collateMatterCluster(input);
        ArrayList<ItemStack> clusters = new ArrayList<ItemStack>();
        ArrayList<Map.Entry<ItemStackWrapper, Integer>> itemlist = new ArrayList<Map.Entry<ItemStackWrapper, Integer>>(items.entrySet());
        int currentTotal = 0;
        HashMap<ItemStackWrapper, Integer> currentItems = new HashMap<ItemStackWrapper, Integer>();
        while (!itemlist.isEmpty()) {
            Map.Entry e = (Map.Entry)itemlist.get(0);
            ItemStackWrapper wrap = (ItemStackWrapper)e.getKey();
            int wrapcount = (Integer)e.getValue();
            int count = Math.min(capacity - currentTotal, wrapcount);
            if (!currentItems.containsKey(e.getKey())) {
                currentItems.put(wrap, count);
            } else {
                currentItems.put(wrap, (Integer)currentItems.get(wrap) + count);
            }
            currentTotal += count;
            e.setValue(wrapcount - count);
            if ((Integer)e.getValue() == 0) {
                itemlist.remove(0);
            }
            if (currentTotal != capacity) continue;
            ItemStack cluster = ItemMatterCluster.makeCluster(currentItems);
            clusters.add(cluster);
            currentTotal = 0;
            currentItems = new HashMap();
        }
        if (currentTotal > 0) {
            ItemStack cluster = ItemMatterCluster.makeCluster(currentItems);
            clusters.add(cluster);
        }
        return clusters;
    }

    public static ItemStack makeCluster(Map<ItemStackWrapper, Integer> input) {
        ItemStack cluster = new ItemStack(LudicrousItems.matter_cluster);
        int total = 0;
        for (int num : input.values()) {
            total += num;
        }
        ItemMatterCluster.setClusterData(cluster, input, total);
        return cluster;
    }

    public static Map<ItemStackWrapper, Integer> getClusterData(ItemStack cluster) {
        if (!cluster.func_77942_o() || !cluster.func_77978_p().func_74764_b(MAINTAG)) {
            return new HashMap<ItemStackWrapper, Integer>();
        }
        NBTTagCompound tag = cluster.func_77978_p().func_74775_l(MAINTAG);
        NBTTagList list = tag.func_150295_c(LISTTAG, 10);
        HashMap<ItemStackWrapper, Integer> data = new HashMap<ItemStackWrapper, Integer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)entry.func_74775_l(ITEMTAG));
            if (stack == null) continue;
            ItemStackWrapper wrap = new ItemStackWrapper(stack);
            int count = entry.func_74762_e(COUNTTAG);
            data.put(wrap, count);
        }
        return data;
    }

    public static int getClusterSize(ItemStack cluster) {
        if (!cluster.func_77942_o() || !cluster.func_77978_p().func_74764_b(MAINTAG)) {
            return 0;
        }
        return cluster.func_77978_p().func_74775_l(MAINTAG).func_74762_e(MAINCOUNTTAG);
    }

    public static void setClusterData(ItemStack stack, Map<ItemStackWrapper, Integer> data, int count) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound clustertag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ItemStackWrapper, Integer> entry : data.entrySet()) {
            NBTTagCompound itemtag = new NBTTagCompound();
            itemtag.func_74782_a(ITEMTAG, (NBTBase)entry.getKey().stack.func_77955_b(new NBTTagCompound()));
            itemtag.func_74768_a(COUNTTAG, entry.getValue().intValue());
            list.func_74742_a((NBTBase)itemtag);
        }
        clustertag.func_74782_a(LISTTAG, (NBTBase)list);
        clustertag.func_74768_a(MAINCOUNTTAG, count);
        stack.func_77978_p().func_74782_a(MAINTAG, (NBTBase)clustertag);
    }

    public static void mergeClusters(ItemStack donor, ItemStack recipient) {
        int count;
        int recipientcount;
        int donorcount = ItemMatterCluster.getClusterSize(donor);
        Lumberjack.info(donorcount + ", " + recipientcount);
        if (donorcount == 0 || donorcount == capacity || recipientcount == capacity) {
            return;
        }
        Map<ItemStackWrapper, Integer> donordata = ItemMatterCluster.getClusterData(donor);
        Map<ItemStackWrapper, Integer> recipientdata = ItemMatterCluster.getClusterData(recipient);
        ArrayList<Map.Entry<ItemStackWrapper, Integer>> datalist = new ArrayList<Map.Entry<ItemStackWrapper, Integer>>(donordata.entrySet());
        for (recipientcount = ItemMatterCluster.getClusterSize(recipient); recipientcount < capacity && donorcount > 0; donorcount -= count, recipientcount += count) {
            Map.Entry e = (Map.Entry)datalist.get(0);
            ItemStackWrapper wrap = (ItemStackWrapper)e.getKey();
            int wrapcount = (Integer)e.getValue();
            count = Math.min(capacity - recipientcount, wrapcount);
            if (!recipientdata.containsKey(wrap)) {
                recipientdata.put(wrap, count);
            } else {
                recipientdata.put(wrap, recipientdata.get(wrap) + count);
            }
            if (wrapcount - count > 0) {
                e.setValue(wrapcount - count);
                continue;
            }
            donordata.remove(wrap);
            datalist.remove(0);
        }
        ItemMatterCluster.setClusterData(recipient, recipientdata, recipientcount);
        if (donorcount > 0) {
            ItemMatterCluster.setClusterData(donor, donordata, donorcount);
        } else {
            donor.func_77982_d(null);
            donor.field_77994_a = 0;
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            List<ItemStack> drops = ToolHelper.collateMatterClusterContents(ItemMatterCluster.getClusterData(stack));
            for (ItemStack drop : drops) {
                ToolHelper.dropItem(drop, world, MathHelper.floor_double((double)player.field_70165_t), MathHelper.floor_double((double)player.field_70163_u), MathHelper.floor_double((double)player.field_70161_v));
            }
        }
        stack.field_77994_a = 0;
        return stack;
    }

    @Override
    public IIcon getMaskTexture(ItemStack stack, EntityPlayer player) {
        int count = ItemMatterCluster.getClusterSize(stack);
        if (count == capacity) {
            return this.cosmicIconFull;
        }
        return this.cosmicIcon;
    }

    @Override
    public float getMaskMultiplier(ItemStack stack, EntityPlayer player) {
        int count = ItemMatterCluster.getClusterSize(stack);
        return (float)count / (float)capacity;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        int count = ItemMatterCluster.getClusterSize(stack);
        if (count == capacity) {
            return this.iconFull;
        }
        return super.getIcon(stack, pass);
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public String func_77667_c(ItemStack stack) {
        int count = ItemMatterCluster.getClusterSize(stack);
        if (count == capacity) {
            return super.func_77667_c(stack) + ".full";
        }
        return super.func_77667_c(stack);
    }
}

