/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.mobspawn;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.AlfheimCore;
import alfheim.common.core.asm.superwrapper.SuperWrapperHandler;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.world.dim.alfheim.WorldProviderAlfheim;
import alfheim.common.world.dim.alfheim.biome.BiomeAlfheim;
import alfheim.common.world.dim.alfheim.biome.BiomeField;
import alfheim.common.world.dim.alfheim.biome.BiomeIslandForest;
import alfheim.common.world.dim.alfheim.biome.BiomeIslandGiantFlowers;
import alfheim.common.world.dim.alfheim.biome.BiomeMountHigh;
import alfheim.common.world.dim.alfheim.biome.BiomeMountLow;
import alfheim.common.world.dim.alfheim.biome.BiomeMountMid;
import alfheim.common.world.dim.alfheim.biome.BiomeMountTopField;
import alfheim.common.world.dim.alfheim.biome.BiomeMountTopForest;
import alfheim.common.world.dim.alfheim.biome.BiomePitForest;
import alfheim.common.world.dim.alfheim.customgens.NiflheimLocationGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.vamig.worldengine.WE_Biome;
import ru.vamig.worldengine.WE_ChunkProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J%\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0005JF\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0016\b\u0002\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0013\u0018\u00010\"J.\u0010#\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)J.\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0013\u0018\u00010\"2\b\b\u0002\u0010-\u001a\u00020\u0013J\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050/2\u0006\u0010(\u001a\u00020)J&\u00100\u001a\u0004\u0018\u0001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002010\t2\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u00068"}, d2={"Lalfheim/common/world/mobspawn/MobSpawnHandler;", "", "<init>", "()V", "despawnRadiusHard", "", "despawnRadiusSoft", "registeredMobs", "Ljava/util/HashMap;", "Ljava/util/HashSet;", "Lalfheim/common/world/mobspawn/MobSpawnHandler$MobData;", "getRegisteredMobs", "()Ljava/util/HashMap;", "mobNames", "", "getMobNames", "tfIntegration", "", "biomeCheck", "", "Lnet/minecraft/entity/Entity;", "biomes", "", "Lalfheim/common/world/dim/alfheim/biome/BiomeAlfheim;", "(Lnet/minecraft/entity/Entity;[Lalfheim/common/world/dim/alfheim/biome/BiomeAlfheim;)Z", "registerMob", "name", "data", "", "dim", "maxCountPerPlayer", "minBatchSize", "maxBatchSize", "spawnCheck", "Lkotlin/Function1;", "unregisterMob", "worldTickEvent", "e", "Lcpw/mods/fml/common/gameevent/TickEvent$WorldTickEvent;", "doSpawning", "world", "Lnet/minecraft/world/World;", "checkSpawn", "entity", "Lnet/minecraft/entity/EntityLiving;", "force", "selectBalancedSpawnLocation", "Lkotlin/Pair;", "selectClosestChunkPrioritizedToDistant", "Lnet/minecraft/world/ChunkCoordIntPair;", "candidates", "center", "rand", "Ljava/util/Random;", "doDespawn", "MobData", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nMobSpawnHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobSpawnHandler.kt\nalfheim/common/world/mobspawn/MobSpawnHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n12511#2,2:276\n11132#2:301\n11467#2,3:302\n2632#3,3:278\n295#3:281\n1782#3,4:282\n296#3:286\n1628#3,3:287\n865#3,2:290\n774#3:293\n865#3,2:294\n774#3:296\n865#3,2:297\n1863#3,2:299\n1#4:292\n*S KotlinDebug\n*F\n+ 1 MobSpawnHandler.kt\nalfheim/common/world/mobspawn/MobSpawnHandler\n*L\n80#1:276,2\n56#1:301\n56#1:302,3\n102#1:278,3\n145#1:281\n154#1:282,4\n145#1:286\n203#1:287,3\n213#1:290,2\n235#1:293\n235#1:294,2\n241#1:296\n241#1:297,2\n241#1:299,2\n*E\n"})
public final class MobSpawnHandler {
    @NotNull
    public static final MobSpawnHandler INSTANCE;
    private static final int despawnRadiusHard;
    private static final int despawnRadiusSoft;
    @NotNull
    private static final HashMap<Integer, HashSet<MobData>> registeredMobs;
    @NotNull
    private static final HashMap<Integer, HashSet<String>> mobNames;

    private MobSpawnHandler() {
    }

    @NotNull
    public final HashMap<Integer, HashSet<MobData>> getRegisteredMobs() {
        return registeredMobs;
    }

    @NotNull
    public final HashMap<Integer, HashSet<String>> getMobNames() {
        return mobNames;
    }

    public final void tfIntegration() {
        int d = AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim();
        this.registerMob("TwilightForest.Forest Bunny", 10, 1, 3, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$1));
        this.registerMob("TwilightForest.Wild Deer", 8, 2, 4, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$2));
        this.registerMob("TwilightForest.Forest Raven", 4, 1, 1, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$3));
        this.registerMob("TwilightForest.Forest Squirrel", 10, 1, 3, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$4));
        this.registerMob("TwilightForest.Tiny Bird", 10, 1, 3, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$5));
        this.registerMob("TwilightForest.Bighorn Sheep", 10, 2, 4, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$6));
        this.registerMob("TwilightForest.Wild Boar", 10, 2, 4, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$7));
        this.registerMob("TwilightForest.Glacier Penguin", 8, 1, 4, d, (Function1<? super Entity, Boolean>)((Function1)MobSpawnHandler::tfIntegration$lambda$8));
    }

    private final boolean biomeCheck(Entity $this$biomeCheck, BiomeAlfheim ... biomes) {
        boolean bl;
        block1: {
            Integer[] integerArray = Vector3.Companion.fromEntity($this$biomeCheck).mf();
            int x = ((Number)integerArray[0]).intValue();
            int z = ((Number)integerArray[2]).intValue();
            WorldProvider worldProvider = $this$biomeCheck.field_70170_p.field_73011_w;
            Intrinsics.checkNotNull((Object)worldProvider, (String)"null cannot be cast to non-null type alfheim.common.world.dim.alfheim.WorldProviderAlfheim");
            WE_Biome at = WE_Biome.getBiomeAt((WE_ChunkProvider)((WorldProviderAlfheim)worldProvider).getChunkProvider(), (int)x, (int)z);
            BiomeAlfheim[] $this$any$iv = biomes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                BiomeAlfheim element$iv;
                BiomeAlfheim it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it == at)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final void registerMob(@NotNull String name, @NotNull int[] data, int dim) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int m = data[0];
        int n = data[1];
        int b = data[2];
        MobSpawnHandler.registerMob$default(this, name, m, n, b, dim, null, 32, null);
    }

    public static /* synthetic */ void registerMob$default(MobSpawnHandler mobSpawnHandler, String string, int[] nArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim();
        }
        mobSpawnHandler.registerMob(string, nArray, n);
    }

    public final void registerMob(@NotNull String name, int maxCountPerPlayer, int minBatchSize, int maxBatchSize, int dim, @Nullable Function1<? super Entity, Boolean> spawnCheck) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HashSet hashSet = registeredMobs.computeIfAbsent(dim, arg_0 -> MobSpawnHandler.registerMob$lambda$11(MobSpawnHandler::registerMob$lambda$10, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"computeIfAbsent(...)");
        Collection collection = hashSet;
        collection.add(new MobData(name, maxCountPerPlayer, minBatchSize, maxBatchSize, spawnCheck));
        HashSet hashSet2 = mobNames.computeIfAbsent(dim, arg_0 -> MobSpawnHandler.registerMob$lambda$13(MobSpawnHandler::registerMob$lambda$12, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashSet2, (String)"computeIfAbsent(...)");
        ((Collection)hashSet2).add(name);
    }

    public static /* synthetic */ void registerMob$default(MobSpawnHandler mobSpawnHandler, String string, int n, int n2, int n3, int n4, Function1 function1, int n5, Object object) {
        if ((n5 & 0x20) != 0) {
            function1 = null;
        }
        mobSpawnHandler.registerMob(string, n, n2, n3, n4, (Function1<? super Entity, Boolean>)function1);
    }

    public final void unregisterMob(@NotNull String name, int maxCountPerPlayer, int minBatchSize, int maxBatchSize, int dim) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            HashSet hashSet = registeredMobs.computeIfAbsent(dim, arg_0 -> MobSpawnHandler.unregisterMob$lambda$15(MobSpawnHandler::unregisterMob$lambda$14, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"computeIfAbsent(...)");
            HashSet set = hashSet;
            CollectionsKt.removeAll((Iterable)set, arg_0 -> MobSpawnHandler.unregisterMob$lambda$16(name, maxCountPerPlayer, minBatchSize, maxBatchSize, arg_0));
            Iterable $this$none$iv = set;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    MobData it = (MobData)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            HashSet hashSet = mobNames.computeIfAbsent(dim, arg_0 -> MobSpawnHandler.unregisterMob$lambda$19(MobSpawnHandler::unregisterMob$lambda$18, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"computeIfAbsent(...)");
            ((Collection)hashSet).remove(name);
        }
    }

    @SubscribeEvent
    public final void worldTickEvent(@NotNull TickEvent.WorldTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        World world = e.world;
        if (registeredMobs.computeIfAbsent(world.field_73011_w.field_76574_g, arg_0 -> MobSpawnHandler.worldTickEvent$lambda$21(MobSpawnHandler::worldTickEvent$lambda$20, arg_0)).isEmpty()) {
            return;
        }
        if (e.phase == TickEvent.Phase.START) {
            Intrinsics.checkNotNull((Object)world);
            this.doDespawn(world);
        } else {
            Intrinsics.checkNotNull((Object)world);
            this.doSpawning(world);
        }
    }

    public final void doSpawning(@NotNull World world) {
        Object v6;
        Entity entity;
        int canSpawn;
        Vector3 suitablePos;
        Object object;
        Random rand;
        block20: {
            int n;
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            if (world.field_73010_i.isEmpty()) {
                return;
            }
            if (!world.func_82736_K().func_82766_b("doMobSpawning")) {
                return;
            }
            rand = world.field_73012_v;
            Pair<Integer, Integer> pair = this.selectBalancedSpawnLocation(world);
            int pcx = ((Number)pair.component1()).intValue();
            int pcz = ((Number)pair.component2()).intValue();
            HashSet<ChunkCoordIntPair> candidates = new HashSet<ChunkCoordIntPair>();
            IntRange intRange = ExtensionsKt.bidiRange((int)0, (int)AlfheimConfigHandler.INSTANCE.getMaxChunks());
            int rcx = intRange.getFirst();
            if (rcx <= (n = intRange.getLast())) {
                while (true) {
                    int n2;
                    int rcz;
                    if (Math.abs(rcx) > AlfheimConfigHandler.INSTANCE.getMinChunks() && (rcz = (object = ExtensionsKt.bidiRange((int)0, (int)AlfheimConfigHandler.INSTANCE.getMaxChunks())).getFirst()) <= (n2 = object.getLast())) {
                        while (true) {
                            ChunkCoordIntPair candidate;
                            if (Math.abs(rcz) > AlfheimConfigHandler.INSTANCE.getMinChunks() && world.field_72993_I.contains(candidate = new ChunkCoordIntPair(pcx + rcx, pcz + rcz))) {
                                ((Collection)candidates).add(candidate);
                            }
                            if (rcz == n2) break;
                            ++rcz;
                        }
                    }
                    if (rcx == n) break;
                    ++rcx;
                }
            }
            ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(pcx, pcz);
            Intrinsics.checkNotNull((Object)rand);
            ChunkCoordIntPair chunkCoordIntPair2 = this.selectClosestChunkPrioritizedToDistant(candidates, chunkCoordIntPair, rand);
            if (chunkCoordIntPair2 == null) {
                return;
            }
            ChunkCoordIntPair chunk = chunkCoordIntPair2;
            suitablePos = new Vector3(null, null, null, 7, null);
            canSpawn = 0;
            HashSet<MobData> hashSet = registeredMobs.get(world.field_73011_w.field_76574_g);
            Intrinsics.checkNotNull(hashSet);
            List $this$doSpawning_u24lambda_u2424 = CollectionsKt.toMutableList((Collection)hashSet);
            boolean bl = false;
            Collections.shuffle($this$doSpawning_u24lambda_u2424);
            Iterable $this$firstOrNull$iv = $this$doSpawning_u24lambda_u2424;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl2;
                MobData data = (MobData)element$iv;
                boolean bl3 = false;
                entity = EntityList.func_75620_a((String)data.getName(), (World)world);
                if ((entity instanceof EntityLiving ? (EntityLiving)entity : null) == null) {
                    bl2 = false;
                } else {
                    EntityLiving mob;
                    mob = mob;
                    Vector3 vector3 = Vector3.mul$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)6, null, null, (int)6, null).add((Number)5, (Number)0, (Number)5).add((Number)(chunk.field_77276_a * 16), (Number)0, (Number)(chunk.field_77275_b * 16));
                    double x = vector3.component1();
                    double z = vector3.component3();
                    double y = ExtensionsKt.getD((Number)world.func_72825_h(ExtensionsKt.mfloor((double)x), ExtensionsKt.mfloor((double)z)));
                    mob.func_70107_b(x, y, z);
                    if (!MobSpawnHandler.checkSpawn$default(INSTANCE, mob, data.getSpawnCheck(), false, 4, null)) {
                        bl2 = false;
                    } else {
                        int n3;
                        suitablePos.set((Number)x, (Number)y, (Number)z);
                        List list = world.field_72996_f;
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadedEntityList");
                        Iterable $this$count$iv = list;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n3 = 0;
                        } else {
                            int count$iv = 0;
                            Iterator iterator = $this$count$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv2;
                                Object it = element$iv2 = iterator.next();
                                boolean bl4 = false;
                                if (!mob.getClass().isInstance(it) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n3 = count$iv;
                        }
                        int mobsInWorld = n3;
                        int mobsInWorldMax = data.getMaxCountPerPlayer() * world.field_73010_i.size();
                        canSpawn = mobsInWorldMax - mobsInWorld;
                        bl2 = canSpawn > 0;
                    }
                }
                if (!bl2) continue;
                v6 = element$iv;
                break block20;
            }
            v6 = null;
        }
        MobData mobData = v6;
        if (mobData == null) {
            return;
        }
        object = mobData;
        String name = ((MobData)object).component1();
        int min = ((MobData)object).component3();
        int max = ((MobData)object).component4();
        Function1<Entity, Boolean> spawnCheck = ((MobData)object).component5();
        int count = Math.min(ASJUtilities.randInBounds((int)min, (int)max, (Random)rand), canSpawn);
        Vector3 offset = new Vector3(null, null, null, 7, null);
        IEntityLivingData data = null;
        for (int i = 0; i < count; ++i) {
            Entity entity2 = EntityList.func_75620_a((String)name, (World)world);
            Intrinsics.checkNotNull((Object)entity2, (String)"null cannot be cast to non-null type net.minecraft.entity.EntityLiving");
            EntityLiving mob = (EntityLiving)entity2;
            int retries = 10;
            do {
                entity = Vector3.mul$default((Vector3)Vector3.sub$default((Vector3)offset.rand(), (Number)0.5, null, null, (int)6, null).normalize(), (Number)(Math.random() * (double)3 + 1.0), null, null, (int)6, null).add(suitablePos);
                double x = entity.component1();
                double z = entity.component3();
                double y = ExtensionsKt.getD((Number)world.func_72825_h(ExtensionsKt.mfloor((double)x), ExtensionsKt.mfloor((double)z)));
                mob.func_70107_b(x, y, z);
            } while (!MobSpawnHandler.checkSpawn$default(this, mob, spawnCheck, false, 4, null) && retries-- > 0);
            double x = suitablePos.component1();
            double y = suitablePos.component2();
            double z = suitablePos.component3();
            if (!MobSpawnHandler.checkSpawn$default(this, mob, spawnCheck, false, 4, null)) {
                mob.func_70107_b(x, y, z);
            }
            if (!this.checkSpawn(mob, spawnCheck, true)) continue;
            ExtensionsKt.spawn((Entity)((Entity)mob), (World)world);
            if (ForgeEventFactory.doSpecialSpawn((EntityLiving)mob, (World)world, (float)ExtensionsKt.getF((Number)mob.field_70165_t), (float)ExtensionsKt.getF((Number)mob.field_70163_u), (float)ExtensionsKt.getF((Number)mob.field_70161_v))) continue;
            data = mob.func_110161_a(data);
        }
    }

    public final boolean checkSpawn(@NotNull EntityLiving entity, @Nullable Function1<? super Entity, Boolean> spawnCheck, boolean force) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Event.Result result = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)entity.field_70170_p, (float)ExtensionsKt.getF((Number)entity.field_70165_t), (float)ExtensionsKt.getF((Number)entity.field_70163_u), (float)ExtensionsKt.getF((Number)entity.field_70161_v));
        switch (result == null ? -1 : WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                if (force) {
                    bl = true;
                    break;
                }
                Function1<? super Entity, Boolean> function1 = spawnCheck;
                Boolean test = function1 != null ? (Boolean)function1.invoke((Object)entity) : null;
                bl = Intrinsics.areEqual((Object)test, (Object)false) ? false : entity.func_70601_bi();
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean checkSpawn$default(MobSpawnHandler mobSpawnHandler, EntityLiving entityLiving, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return mobSpawnHandler.checkSpawn(entityLiving, (Function1<? super Entity, Boolean>)function1, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Integer, Integer> selectBalancedSpawnLocation(@NotNull World world) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        List list = world.field_73010_i;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"playerEntities");
        Iterable iterable = list;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv;
            Object t = item$iv = iterator.next();
            Collection collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            EntityPlayer cfr_ignored_0 = (EntityPlayer)it;
            collection.add(TuplesKt.to((Object)((EntityPlayer)it).field_70176_ah, (Object)((EntityPlayer)it).field_70164_aj));
        }
        ArrayList playerCoords = (ArrayList)destination$iv;
        HashSet balanced = new HashSet();
        HashSet ignore = new HashSet();
        Iterator iterator2 = playerCoords.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            double d;
            void $this$filterTo$iv;
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Pair coord = (Pair)e;
            if (ignore.contains(coord)) continue;
            Iterable it = playerCoords;
            Collection destination$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv : $this$filterTo$iv) {
                Pair it2 = (Pair)element$iv;
                boolean bl = false;
                if (!(Vector3.Companion.pointDistancePlane((Number)it2.getFirst(), (Number)it2.getSecond(), (Number)coord.getFirst(), (Number)coord.getSecond()) <= (double)AlfheimConfigHandler.INSTANCE.getPlayerGroupDistance())) continue;
                destination$iv2.add(element$iv);
            }
            ArrayList group = (ArrayList)destination$iv2;
            ((Collection)group).add(coord);
            CollectionsKt.addAll((Collection)ignore, (Iterable)group);
            Iterable $i$f$filterTo22 = group;
            double d2 = 0.0;
            for (Object t : $i$f$filterTo22) {
                void it3;
                Pair pair = (Pair)t;
                double d3 = d2;
                boolean bl = false;
                d = ExtensionsKt.getD((Number)((Number)it3.getFirst()));
                d2 = d3 + d;
            }
            double centerX = d2 / (double)group.size();
            Iterable iterable2 = group;
            double d4 = 0.0;
            for (Object e2 : iterable2) {
                void it4;
                Pair pair = (Pair)e2;
                double d5 = d4;
                boolean bl = false;
                d = ExtensionsKt.getD((Number)((Number)it4.getSecond()));
                d4 = d5 + d;
            }
            double centerZ = d4 / (double)group.size();
            ((Collection)balanced).add(TuplesKt.to((Object)ExtensionsKt.mfloor((double)centerX), (Object)ExtensionsKt.mfloor((double)centerZ)));
        }
        Collection collection = balanced;
        Random random = world.field_73012_v;
        Intrinsics.checkNotNullExpressionValue((Object)random, (String)"rand");
        Pair pair = (Pair)ExtensionsKt.random((Collection)collection, (Random)random);
        if (pair == null) {
            pair = TuplesKt.to((Object)0, (Object)0);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ChunkCoordIntPair selectClosestChunkPrioritizedToDistant(@NotNull HashSet<ChunkCoordIntPair> candidates, @NotNull ChunkCoordIntPair center, @NotNull Random rand) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        ArrayList<WeightedRandom.Item> list = new ArrayList<WeightedRandom.Item>();
        int i = AlfheimConfigHandler.INSTANCE.getMinChunks();
        int n = AlfheimConfigHandler.INSTANCE.getMaxChunks();
        if (i <= n) {
            while (true) {
                list.add(new WeightedRandom.Item(AlfheimConfigHandler.INSTANCE.getMaxChunks() + 1 - i));
                if (i == n) break;
                ++i;
            }
        }
        int distance = WeightedRandom.func_76271_a((Random)rand, (Collection)((Collection)list)).field_76292_a;
        Iterable $this$filter$iv = candidates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChunkCoordIntPair c = (ChunkCoordIntPair)element$iv$iv;
            boolean bl = false;
            if (!(Math.max(Math.abs(center.field_77276_a - c.field_77276_a), Math.abs(center.field_77275_b - c.field_77275_b)) == distance)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ChunkCoordIntPair)ExtensionsKt.random((Collection)((List)destination$iv$iv), (Random)rand);
    }

    /*
     * WARNING - void declaration
     */
    public final void doDespawn(@NotNull World world) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        HashSet hashSet = mobNames.computeIfAbsent(world.field_73011_w.field_76574_g, arg_0 -> MobSpawnHandler.doDespawn$lambda$31(MobSpawnHandler::doDespawn$lambda$30, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"computeIfAbsent(...)");
        HashSet namesForWorld = hashSet;
        List list = world.field_72996_f;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadedEntityList");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl = false;
            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type net.minecraft.entity.Entity");
            if (!namesForWorld.contains(EntityList.func_75621_b((Entity)((Entity)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        block5: while (object.hasNext()) {
            double minDistance;
            Double d;
            Object element$iv;
            Object entity = element$iv = object.next();
            boolean bl = false;
            if (!(entity instanceof EntityLiving) || !SuperWrapperHandler.canDespawn((EntityLiving)entity)) continue;
            if (((EntityLiving)entity).func_104002_bU()) {
                ((EntityLiving)entity).field_70708_bq = 0;
                continue;
            }
            if ((((EntityLiving)entity).field_70708_bq & 0x1F) == 31) {
                Event.Result result = ForgeEventFactory.canEntityDespawn((EntityLiving)((EntityLiving)entity));
                switch (result == null ? -1 : WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                    case 1: {
                        ((EntityLiving)entity).field_70708_bq = 0;
                        continue block5;
                    }
                    case 2: {
                        ((EntityLiving)entity).func_70106_y();
                        continue block5;
                    }
                }
            }
            List list2 = world.field_73010_i;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"playerEntities");
            Iterator iterator2 = ((Iterable)list2).iterator();
            if (!iterator2.hasNext()) {
                d = null;
            } else {
                Object player = iterator2.next();
                boolean bl2 = false;
                Intrinsics.checkNotNull(player, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                EntityPlayer cfr_ignored_0 = (EntityPlayer)player;
                double d2 = Math.min(Math.abs(((EntityLiving)entity).field_70165_t - ((EntityPlayer)player).field_70165_t), Math.abs(((EntityLiving)entity).field_70161_v - ((EntityPlayer)player).field_70161_v));
                while (iterator2.hasNext()) {
                    Object player2 = iterator2.next();
                    $i$a$-minOfOrNull-MobSpawnHandler$doDespawn$2$minDistance$1 = false;
                    Intrinsics.checkNotNull(player2, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                    EntityPlayer cfr_ignored_1 = (EntityPlayer)player2;
                    double d3 = Math.min(Math.abs(((EntityLiving)entity).field_70165_t - ((EntityPlayer)player2).field_70165_t), Math.abs(((EntityLiving)entity).field_70161_v - ((EntityPlayer)player2).field_70161_v));
                    d2 = Math.min(d2, d3);
                }
                d = d2;
            }
            double d4 = minDistance = d != null ? d : Double.MAX_VALUE;
            if (minDistance > (double)despawnRadiusHard) {
                ((EntityLiving)entity).func_70106_y();
                continue;
            }
            if (minDistance > (double)despawnRadiusSoft) {
                if (((EntityLiving)entity).field_70708_bq <= 1200 && (((EntityLiving)entity).field_70708_bq <= 600 || ((EntityLiving)entity).func_70681_au().nextInt(800) != 0)) continue;
                ((EntityLiving)entity).func_70106_y();
                continue;
            }
            ((EntityLiving)entity).field_70708_bq = 0;
        }
    }

    private static final boolean tfIntegration$lambda$1(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeField.INSTANCE, BiomeIslandForest.INSTANCE, BiomeMountTopField.INSTANCE, BiomeMountTopForest.INSTANCE, BiomePitForest.INSTANCE};
        return INSTANCE.biomeCheck(it, biomeAlfheimArray);
    }

    private static final boolean tfIntegration$lambda$2(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeIslandForest.INSTANCE, BiomeMountTopForest.INSTANCE, BiomePitForest.INSTANCE};
        return INSTANCE.biomeCheck(it, biomeAlfheimArray);
    }

    private static final boolean tfIntegration$lambda$3(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeField.INSTANCE, BiomeIslandForest.INSTANCE, BiomeMountTopField.INSTANCE, BiomeMountTopForest.INSTANCE, BiomePitForest.INSTANCE};
        return INSTANCE.biomeCheck(it, biomeAlfheimArray);
    }

    private static final boolean tfIntegration$lambda$4(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeIslandForest.INSTANCE, BiomeMountTopForest.INSTANCE, BiomePitForest.INSTANCE};
        return INSTANCE.biomeCheck(it, biomeAlfheimArray);
    }

    private static final boolean tfIntegration$lambda$5(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeField.INSTANCE, BiomeIslandForest.INSTANCE, BiomeIslandGiantFlowers.INSTANCE, BiomeMountLow.INSTANCE, BiomeMountMid.INSTANCE, BiomeMountHigh.INSTANCE, BiomeMountTopField.INSTANCE, BiomeMountTopForest.INSTANCE, BiomePitForest.INSTANCE};
        return INSTANCE.biomeCheck(it, biomeAlfheimArray);
    }

    private static final boolean tfIntegration$lambda$6(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeField.INSTANCE, BiomeIslandForest.INSTANCE, BiomeIslandGiantFlowers.INSTANCE, BiomeMountTopField.INSTANCE, BiomeMountTopForest.INSTANCE, BiomePitForest.INSTANCE};
        return INSTANCE.biomeCheck(it, biomeAlfheimArray);
    }

    private static final boolean tfIntegration$lambda$7(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeField.INSTANCE, BiomeIslandForest.INSTANCE, BiomeMountTopField.INSTANCE, BiomeMountTopForest.INSTANCE, BiomePitForest.INSTANCE};
        return INSTANCE.biomeCheck(it, biomeAlfheimArray);
    }

    private static final boolean tfIntegration$lambda$8(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        World world = it.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        Pair<Integer, Integer> pair = NiflheimLocationGenerator.INSTANCE.portalXZ(world);
        int xOff = ((Number)pair.component1()).intValue();
        int zOff = ((Number)pair.component2()).intValue();
        return NiflheimLocationGenerator.INSTANCE.yobaFunction2d(ExtensionsKt.mfloor((double)it.field_70165_t) - xOff, ExtensionsKt.mfloor((double)it.field_70161_v) - zOff);
    }

    private static final HashSet registerMob$lambda$10(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet registerMob$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final HashSet registerMob$lambda$12(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet registerMob$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final HashSet unregisterMob$lambda$14(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet unregisterMob$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final boolean unregisterMob$lambda$16(String $name, int $maxCountPerPlayer, int $minBatchSize, int $maxBatchSize, MobData it) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name) && it.getMaxCountPerPlayer() == $maxCountPerPlayer && it.getMinBatchSize() == $minBatchSize && it.getMaxBatchSize() == $maxBatchSize;
    }

    private static final HashSet unregisterMob$lambda$18(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet unregisterMob$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final HashSet worldTickEvent$lambda$20(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet worldTickEvent$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final HashSet doDespawn$lambda$30(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet doDespawn$lambda$31(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashSet)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_5;
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        INSTANCE = new MobSpawnHandler();
        despawnRadiusHard = AlfheimConfigHandler.INSTANCE.getMaxChunks() * 16 + AlfheimConfigHandler.INSTANCE.getDespawnChunks() * 16;
        despawnRadiusSoft = AlfheimConfigHandler.INSTANCE.getMaxChunks() * 8 + AlfheimConfigHandler.INSTANCE.getDespawnChunks() * 16;
        registeredMobs = new HashMap();
        mobNames = new HashMap();
        ExtensionsKt.eventForge((Object)ExtensionsKt.eventFML((Object)INSTANCE));
        MobSpawnHandler.registerMob$default(INSTANCE, "alfheim.Butterfly", AlfheimConfigHandler.INSTANCE.getButterflySpawn(), 0, 4, null);
        MobSpawnHandler.registerMob$default(INSTANCE, "Chicken", AlfheimConfigHandler.INSTANCE.getChickSpawn(), 0, 4, null);
        MobSpawnHandler.registerMob$default(INSTANCE, "Cow", AlfheimConfigHandler.INSTANCE.getCowSpawn(), 0, 4, null);
        MobSpawnHandler.registerMob$default(INSTANCE, "alfheim.Elf", AlfheimConfigHandler.INSTANCE.getElvesSpawn(), 0, 4, null);
        MobSpawnHandler.registerMob$default(INSTANCE, "alfheim.Jellyfish", AlfheimConfigHandler.INSTANCE.getJellySpawn(), 0, 4, null);
        MobSpawnHandler.registerMob$default(INSTANCE, "Pig", AlfheimConfigHandler.INSTANCE.getPigSpawn(), 0, 4, null);
        MobSpawnHandler.registerMob$default(INSTANCE, "alfheim.Pixie", AlfheimConfigHandler.INSTANCE.getPixieSpawn(), 0, 4, null);
        MobSpawnHandler.registerMob$default(INSTANCE, "Sheep", AlfheimConfigHandler.INSTANCE.getSheepSpawn(), 0, 4, null);
        int[] nArray = AlfheimConfigHandler.INSTANCE.getPixieSpawn();
        String string = "alfheim.SnowSprite";
        MobSpawnHandler mobSpawnHandler = INSTANCE;
        boolean $i$f$map = false;
        void var2_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)(it * 2));
        }
        collection = (List)var3_5;
        MobSpawnHandler.registerMob$default(mobSpawnHandler, string, CollectionsKt.toIntArray((Collection)collection), 0, 4, null);
        if (AlfheimCore.INSTANCE.getTwilightForestLoaded() && AlfheimConfigHandler.INSTANCE.getTfMobs()) {
            INSTANCE.tfIntegration();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0017\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tH\u00c6\u0003JI\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001f\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lalfheim/common/world/mobspawn/MobSpawnHandler$MobData;", "", "name", "", "maxCountPerPlayer", "", "minBatchSize", "maxBatchSize", "spawnCheck", "Lkotlin/Function1;", "Lnet/minecraft/entity/Entity;", "", "<init>", "(Ljava/lang/String;IIILkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "getMaxCountPerPlayer", "()I", "getMinBatchSize", "getMaxBatchSize", "getSpawnCheck", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "Alfheim"})
    public static final class MobData {
        @NotNull
        private final String name;
        private final int maxCountPerPlayer;
        private final int minBatchSize;
        private final int maxBatchSize;
        @Nullable
        private final Function1<Entity, Boolean> spawnCheck;

        public MobData(@NotNull String name, int maxCountPerPlayer, int minBatchSize, int maxBatchSize, @Nullable Function1<? super Entity, Boolean> spawnCheck) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.maxCountPerPlayer = maxCountPerPlayer;
            this.minBatchSize = minBatchSize;
            this.maxBatchSize = maxBatchSize;
            this.spawnCheck = spawnCheck;
        }

        public /* synthetic */ MobData(String string, int n, int n2, int n3, Function1 function1, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 0x10) != 0) {
                function1 = null;
            }
            this(string, n, n2, n3, (Function1<? super Entity, Boolean>)function1);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getMaxCountPerPlayer() {
            return this.maxCountPerPlayer;
        }

        public final int getMinBatchSize() {
            return this.minBatchSize;
        }

        public final int getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Nullable
        public final Function1<Entity, Boolean> getSpawnCheck() {
            return this.spawnCheck;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.maxCountPerPlayer;
        }

        public final int component3() {
            return this.minBatchSize;
        }

        public final int component4() {
            return this.maxBatchSize;
        }

        @Nullable
        public final Function1<Entity, Boolean> component5() {
            return this.spawnCheck;
        }

        @NotNull
        public final MobData copy(@NotNull String name, int maxCountPerPlayer, int minBatchSize, int maxBatchSize, @Nullable Function1<? super Entity, Boolean> spawnCheck) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new MobData(name, maxCountPerPlayer, minBatchSize, maxBatchSize, spawnCheck);
        }

        public static /* synthetic */ MobData copy$default(MobData mobData, String string, int n, int n2, int n3, Function1 function1, int n4, Object object) {
            if ((n4 & 1) != 0) {
                string = mobData.name;
            }
            if ((n4 & 2) != 0) {
                n = mobData.maxCountPerPlayer;
            }
            if ((n4 & 4) != 0) {
                n2 = mobData.minBatchSize;
            }
            if ((n4 & 8) != 0) {
                n3 = mobData.maxBatchSize;
            }
            if ((n4 & 0x10) != 0) {
                function1 = mobData.spawnCheck;
            }
            return mobData.copy(string, n, n2, n3, function1);
        }

        @NotNull
        public String toString() {
            return "MobData(name=" + this.name + ", maxCountPerPlayer=" + this.maxCountPerPlayer + ", minBatchSize=" + this.minBatchSize + ", maxBatchSize=" + this.maxBatchSize + ", spawnCheck=" + this.spawnCheck + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.maxCountPerPlayer);
            result = result * 31 + Integer.hashCode(this.minBatchSize);
            result = result * 31 + Integer.hashCode(this.maxBatchSize);
            result = result * 31 + (this.spawnCheck == null ? 0 : this.spawnCheck.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MobData)) {
                return false;
            }
            MobData mobData = (MobData)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)mobData.name)) {
                return false;
            }
            if (this.maxCountPerPlayer != mobData.maxCountPerPlayer) {
                return false;
            }
            if (this.minBatchSize != mobData.minBatchSize) {
                return false;
            }
            if (this.maxBatchSize != mobData.maxBatchSize) {
                return false;
            }
            return Intrinsics.areEqual(this.spawnCheck, mobData.spawnCheck);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Event.Result.values().length];
            try {
                nArray[Event.Result.DENY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Event.Result.ALLOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

