/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.gen;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006!"}, d2={"Lalfheim/common/world/gen/HeartWoodTreeGen;", "Lnet/minecraft/world/gen/feature/WorldGenAbstractTree;", "minTreeHeight", "", "regWood", "Lnet/minecraft/block/Block;", "regMeta", "heartWood", "heartMeta", "leaves", "leavesMeta", "berry", "<init>", "(ILnet/minecraft/block/Block;ILnet/minecraft/block/Block;ILnet/minecraft/block/Block;ILnet/minecraft/block/Block;)V", "getMinTreeHeight", "()I", "getRegWood", "()Lnet/minecraft/block/Block;", "getRegMeta", "getHeartWood", "getHeartMeta", "getLeaves", "getLeavesMeta", "getBerry", "generate", "", "world", "Lnet/minecraft/world/World;", "random", "Ljava/util/Random;", "x", "y", "z", "Alfheim"})
public final class HeartWoodTreeGen
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    @NotNull
    private final Block regWood;
    private final int regMeta;
    @NotNull
    private final Block heartWood;
    private final int heartMeta;
    @NotNull
    private final Block leaves;
    private final int leavesMeta;
    @NotNull
    private final Block berry;

    public HeartWoodTreeGen(int minTreeHeight, @NotNull Block regWood, int regMeta, @NotNull Block heartWood, int heartMeta, @NotNull Block leaves, int leavesMeta, @NotNull Block berry) {
        Intrinsics.checkNotNullParameter((Object)regWood, (String)"regWood");
        Intrinsics.checkNotNullParameter((Object)heartWood, (String)"heartWood");
        Intrinsics.checkNotNullParameter((Object)leaves, (String)"leaves");
        Intrinsics.checkNotNullParameter((Object)berry, (String)"berry");
        super(true);
        this.minTreeHeight = minTreeHeight;
        this.regWood = regWood;
        this.regMeta = regMeta;
        this.heartWood = heartWood;
        this.heartMeta = heartMeta;
        this.leaves = leaves;
        this.leavesMeta = leavesMeta;
        this.berry = berry;
    }

    public final int getMinTreeHeight() {
        return this.minTreeHeight;
    }

    @NotNull
    public final Block getRegWood() {
        return this.regWood;
    }

    public final int getRegMeta() {
        return this.regMeta;
    }

    @NotNull
    public final Block getHeartWood() {
        return this.heartWood;
    }

    public final int getHeartMeta() {
        return this.heartMeta;
    }

    @NotNull
    public final Block getLeaves() {
        return this.leaves;
    }

    public final int getLeavesMeta() {
        return this.leavesMeta;
    }

    @NotNull
    public final Block getBerry() {
        return this.berry;
    }

    public boolean func_76484_a(@NotNull World world, @NotNull Random random, int x, int y, int z) {
        int n;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        int height = random.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        int b0 = 0;
        int j = y;
        int n2 = y + 1 + height;
        if (j <= n2) {
            block0: while (true) {
                int n3;
                int i;
                b0 = 1;
                if (j == y) {
                    b0 = 0;
                }
                if (j >= y + 1 + height - 2) {
                    b0 = 2;
                }
                if ((i = x - b0) <= (n3 = x + b0)) {
                    while (true) {
                        int n4;
                        int k;
                        if ((k = z - b0) <= (n4 = z + b0)) {
                            while (true) {
                                boolean bl = 0 <= j ? j < 256 : false;
                                if (bl) {
                                    Block block = world.func_147439_a(i, j, k);
                                    if (!(block.isReplaceable((IBlockAccess)world, i, j, k) || block.isLeaves((IBlockAccess)world, i, j, k) || Intrinsics.areEqual((Object)block, (Object)this.regWood) || Intrinsics.areEqual((Object)block, (Object)this.heartWood))) {
                                        flag = false;
                                        break block0;
                                    }
                                } else {
                                    flag = false;
                                    break block0;
                                }
                                if (k == n4) break;
                                ++k;
                            }
                        }
                        if (i == n3) break;
                        ++i;
                    }
                }
                if (j == n2) break;
                ++j;
            }
        }
        if (!flag) {
            return false;
        }
        if (y >= 256 - height - 1) {
            return false;
        }
        world.func_147439_a(x, y - 1, z).onPlantGrow(world, x, y - 1, z, x, y, z);
        j = 0;
        if (j <= height) {
            while (true) {
                Block block;
                if ((block = world.func_147439_a(x, y + j, z)).isAir((IBlockAccess)world, x, y + j, z) || block.isLeaves((IBlockAccess)world, x, y + j, z)) {
                    n = j;
                    if (n == height) {
                        this.func_150516_a(world, x, y + j, z, this.leaves, this.leavesMeta);
                    } else if (n == height - 1) {
                        this.func_150516_a(world, x, y + j, z, this.heartWood, this.heartMeta);
                    } else {
                        this.func_150516_a(world, x, y + j, z, this.regWood, this.regMeta);
                    }
                }
                if (j == height) break;
                ++j;
            }
        }
        boolean hasBerry = false;
        int j2 = y - 3 + height;
        n = y + height;
        if (j2 <= n) {
            while (true) {
                int n5;
                int i3;
                int l1;
                int i;
                if ((i = x - (l1 = 1 - (i3 = j2 - (y + height)) / 2)) <= (n5 = x + l1)) {
                    while (true) {
                        int wx = i - x;
                        int k = z - l1;
                        int n6 = z + l1;
                        if (k <= n6) {
                            while (true) {
                                if (i != x || k != z) {
                                    Block block;
                                    int wz = k - z;
                                    if ((Math.abs(wx) != l1 || Math.abs(wz) != l1 || random.nextInt(2) != 0 && i3 != 0) && ((block = world.func_147439_a(i, j2, k)).isAir((IBlockAccess)world, i, j2, k) || block.isLeaves((IBlockAccess)world, i, j2, k))) {
                                        this.func_150516_a(world, i, j2, k, this.leaves, this.leavesMeta);
                                        if (!hasBerry && world.func_147437_c(i, j2 - 1, k) && random.nextInt(50) == 0 && this.berry.func_149718_j(world, i, j2 - 1, k)) {
                                            this.func_150516_a(world, i, j2 - 1, k, this.berry, 0);
                                            hasBerry = true;
                                        }
                                    }
                                }
                                if (k == n6) break;
                                ++k;
                            }
                        }
                        if (i == n5) break;
                        ++i;
                    }
                }
                if (j2 == n) break;
                ++j2;
            }
        }
        return true;
    }
}

