/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.niflheim;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.SchemaUtils;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.block.tile.TileDomainLobby;
import alfheim.common.integration.ThermalFoundationIntegration;
import alfheim.common.world.dim.niflheim.biome.BiomeGenIce;
import alfheim.common.world.dim.niflheim.biome.BiomeGenPoison;
import alfheim.common.world.dim.niflheim.biome.BiomeGenSnow;
import alfheim.common.world.dim.niflheim.customgens.MapGenCustomCaves;
import alfheim.common.world.dim.niflheim.customgens.MapGenCustomRavine;
import alfheim.common.world.dim.niflheim.customgens.WorldGenCaveHangs;
import alfheim.common.world.dim.niflheim.customgens.WorldGenGigaHangs;
import alfheim.common.world.dim.niflheim.customgens.WorldGenGigaRoot;
import alfheim.common.world.dim.niflheim.customgens.WorldGenHole;
import alfheim.common.world.dim.niflheim.customgens.WorldGenIcePikes;
import alfheim.common.world.dim.niflheim.customgens.WorldGenIcyGeyser;
import alfheim.common.world.dim.niflheim.customgens.WorldGenIglu;
import alfheim.common.world.dim.niflheim.customgens.WorldGenLakes;
import alfheim.common.world.dim.niflheim.customgens.WorldGenNifleur;
import alfheim.common.world.dim.niflheim.customgens.WorldGenRibs;
import alfheim.common.world.dim.niflheim.customgens.WorldGenRoot;
import alfheim.common.world.dim.niflheim.customgens.WorldGenTentacles;
import alfheim.common.world.dim.niflheim.customgens.WorldGenWaterfall;
import alfheim.common.world.dim.niflheim.structure.WorldGenBigDungeons;
import alfheim.common.world.dim.niflheim.structure.WorldGenBridge;
import alfheim.common.world.dim.niflheim.structure.WorldGenDungeons;
import alfheim.common.world.dim.niflheim.structure.WorldGenRuins;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.vamig.worldengine.WE_PerlinNoise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ~2\u00020\u0001:\u0001~B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J\u0018\u0010C\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J)\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020A2\u0006\u0010G\u001a\u00020A2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I07\u00a2\u0006\u0002\u0010JJ)\u0010K\u001a\u00020E2\u0006\u0010F\u001a\u00020A2\u0006\u0010G\u001a\u00020A2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I07\u00a2\u0006\u0002\u0010JJ\u001e\u0010L\u001a\u00020A2\u0006\u0010@\u001a\u00020A2\u0006\u0010M\u001a\u00020A2\u0006\u0010B\u001a\u00020AJ-\u0010N\u001a\b\u0012\u0004\u0012\u00020I072\f\u0010O\u001a\b\u0012\u0004\u0012\u00020I072\f\u0010P\u001a\b\u0012\u0004\u0012\u00020I07\u00a2\u0006\u0002\u0010QJ7\u0010R\u001a\u00020E2\u0006\u0010F\u001a\u00020A2\u0006\u0010G\u001a\u00020A2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I072\f\u0010S\u001a\b\u0012\u0004\u0012\u00020807\u00a2\u0006\u0002\u0010TJ>\u0010U\u001a\u00020\u00152\u0006\u0010V\u001a\u00020\u00152\u0006\u0010W\u001a\u00020A2\u0006\u0010X\u001a\u00020A2\u0006\u0010Y\u001a\u00020A2\u0006\u0010Z\u001a\u00020A2\u0006\u0010[\u001a\u00020A2\u0006\u0010\\\u001a\u00020AJ)\u0010]\u001a\u00020E2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020I072\u0006\u0010_\u001a\u00020A2\u0006\u0010`\u001a\u00020A\u00a2\u0006\u0002\u0010aJ \u0010b\u001a\u00020E2\u0006\u0010c\u001a\u00020\u00012\u0006\u0010F\u001a\u00020A2\u0006\u0010G\u001a\u00020AH\u0016J\u0016\u0010d\u001a\u00020E2\u0006\u0010F\u001a\u00020A2\u0006\u0010G\u001a\u00020AJ2\u0010e\u001a\u0004\u0018\u00010f2\u0006\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020i2\u0006\u0010X\u001a\u00020A2\u0006\u0010j\u001a\u00020A2\u0006\u0010k\u001a\u00020AH\u0016J2\u0010l\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010n\u0018\u00010m2\u0006\u0010o\u001a\u00020p2\u0006\u0010@\u001a\u00020A2\u0006\u0010M\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J\b\u0010q\u001a\u00020AH\u0016J\u0018\u0010r\u001a\u00020E2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J\b\u0010s\u001a\u00020\u0007H\u0016J\b\u0010t\u001a\u00020EH\u0016J\u0018\u0010u\u001a\u00020\u00072\u0006\u0010v\u001a\u00020A2\u0006\u0010w\u001a\u00020AH\u0016J\u0018\u0010x\u001a\u00020\u00072\u0006\u0010y\u001a\u00020\u00072\u0006\u0010z\u001a\u00020{H\u0016J\b\u0010|\u001a\u00020\u0007H\u0016J\b\u0010}\u001a\u00020iH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001c\u0010 \u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R\u001c\u0010#\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0011\u0010,\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0011\u0010.\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00103R\"\u00106\u001a\b\u0012\u0004\u0012\u00020807X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010=\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006\u007f"}, d2={"Lalfheim/common/world/dim/niflheim/ChunkProviderNiflheim;", "Lnet/minecraft/world/chunk/IChunkProvider;", "world", "Lnet/minecraft/world/World;", "seed", "", "useStructures", "", "<init>", "(Lnet/minecraft/world/World;JZ)V", "getWorld", "()Lnet/minecraft/world/World;", "getSeed", "()J", "getUseStructures", "()Z", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "noiseField", "", "getNoiseField", "()[D", "setNoiseField", "([D)V", "gravelNoise", "getGravelNoise", "setGravelNoise", "noiseData1", "getNoiseData1", "setNoiseData1", "noiseData2", "getNoiseData2", "setNoiseData2", "noiseData3", "getNoiseData3", "setNoiseData3", "noiseGen1", "Lnet/minecraft/world/gen/NoiseGeneratorOctaves;", "getNoiseGen1", "()Lnet/minecraft/world/gen/NoiseGeneratorOctaves;", "noiseGen2", "getNoiseGen2", "noiseGen3", "getNoiseGen3", "noiseGen4", "getNoiseGen4", "ravineGenerator", "Lnet/minecraft/world/gen/MapGenBase;", "getRavineGenerator", "()Lnet/minecraft/world/gen/MapGenBase;", "caveGenerator", "getCaveGenerator", "biomesForGeneration", "", "Lnet/minecraft/world/biome/BiomeGenBase;", "getBiomesForGeneration", "()[Lnet/minecraft/world/biome/BiomeGenBase;", "setBiomesForGeneration", "([Lnet/minecraft/world/biome/BiomeGenBase;)V", "[Lnet/minecraft/world/biome/BiomeGenBase;", "loadChunk", "Lnet/minecraft/world/chunk/Chunk;", "x", "", "z", "provideChunk", "generateCaves", "", "cX", "cZ", "chunk", "Lnet/minecraft/block/Block;", "(II[Lnet/minecraft/block/Block;)V", "generateMountains", "index", "y", "mergeArrays", "cavesArray", "mountainsArray", "([Lnet/minecraft/block/Block;[Lnet/minecraft/block/Block;)[Lnet/minecraft/block/Block;", "replaceBlocksForBiome", "biomes", "(II[Lnet/minecraft/block/Block;[Lnet/minecraft/world/biome/BiomeGenBase;)V", "initializeNoiseField", "_list", "par2", "par3", "par4", "par5", "par6", "par7", "makeRiver", "chunkArray", "cx", "cz", "([Lnet/minecraft/block/Block;II)V", "populate", "provider", "generateThrymDomain", "func_147416_a", "", "par1World", "par2Str", "", "i", "j", "getPossibleCreatures", "", "", "type", "Lnet/minecraft/entity/EnumCreatureType;", "getLoadedChunkCount", "recreateStructures", "unloadQueuedChunks", "saveExtraData", "chunkExists", "chunkX", "chunkZ", "saveChunks", "flag", "iprogressupdate", "Lnet/minecraft/util/IProgressUpdate;", "canSave", "makeString", "Companion", "Alfheim"})
public final class ChunkProviderNiflheim
implements IChunkProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final long seed;
    private final boolean useStructures;
    @NotNull
    private final Random random;
    @NotNull
    private double[] noiseField;
    @NotNull
    private double[] gravelNoise;
    @Nullable
    private double[] noiseData1;
    @Nullable
    private double[] noiseData2;
    @Nullable
    private double[] noiseData3;
    @NotNull
    private final NoiseGeneratorOctaves noiseGen1;
    @NotNull
    private final NoiseGeneratorOctaves noiseGen2;
    @NotNull
    private final NoiseGeneratorOctaves noiseGen3;
    @NotNull
    private final NoiseGeneratorOctaves noiseGen4;
    @NotNull
    private final MapGenBase ravineGenerator;
    @NotNull
    private final MapGenBase caveGenerator;
    @NotNull
    private BiomeGenBase[] biomesForGeneration;
    @NotNull
    private static final Block[] surfaceBlocks;

    public ChunkProviderNiflheim(@NotNull World world, long seed, boolean useStructures) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.seed = seed;
        this.useStructures = useStructures;
        this.noiseField = new double[0];
        this.biomesForGeneration = new BiomeGenBase[0];
        this.ravineGenerator = MapGenCustomRavine.INSTANCE;
        this.caveGenerator = MapGenCustomCaves.INSTANCE;
        this.random = new Random(this.seed);
        this.gravelNoise = new double[256];
        this.noiseGen1 = new NoiseGeneratorOctaves(this.random, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.random, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.random, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.random, 4);
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    public final long getSeed() {
        return this.seed;
    }

    public final boolean getUseStructures() {
        return this.useStructures;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @NotNull
    public final double[] getNoiseField() {
        return this.noiseField;
    }

    public final void setNoiseField(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.noiseField = dArray;
    }

    @NotNull
    public final double[] getGravelNoise() {
        return this.gravelNoise;
    }

    public final void setGravelNoise(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.gravelNoise = dArray;
    }

    @Nullable
    public final double[] getNoiseData1() {
        return this.noiseData1;
    }

    public final void setNoiseData1(@Nullable double[] dArray) {
        this.noiseData1 = dArray;
    }

    @Nullable
    public final double[] getNoiseData2() {
        return this.noiseData2;
    }

    public final void setNoiseData2(@Nullable double[] dArray) {
        this.noiseData2 = dArray;
    }

    @Nullable
    public final double[] getNoiseData3() {
        return this.noiseData3;
    }

    public final void setNoiseData3(@Nullable double[] dArray) {
        this.noiseData3 = dArray;
    }

    @NotNull
    public final NoiseGeneratorOctaves getNoiseGen1() {
        return this.noiseGen1;
    }

    @NotNull
    public final NoiseGeneratorOctaves getNoiseGen2() {
        return this.noiseGen2;
    }

    @NotNull
    public final NoiseGeneratorOctaves getNoiseGen3() {
        return this.noiseGen3;
    }

    @NotNull
    public final NoiseGeneratorOctaves getNoiseGen4() {
        return this.noiseGen4;
    }

    @NotNull
    public final MapGenBase getRavineGenerator() {
        return this.ravineGenerator;
    }

    @NotNull
    public final MapGenBase getCaveGenerator() {
        return this.caveGenerator;
    }

    @NotNull
    public final BiomeGenBase[] getBiomesForGeneration() {
        return this.biomesForGeneration;
    }

    public final void setBiomesForGeneration(@NotNull BiomeGenBase[] biomeGenBaseArray) {
        Intrinsics.checkNotNullParameter((Object)biomeGenBaseArray, (String)"<set-?>");
        this.biomesForGeneration = biomeGenBaseArray;
    }

    @NotNull
    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    @NotNull
    public Chunk func_73154_d(int x, int z) {
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        int n = 0;
        byte[] byArray = new byte[65536];
        while (n < 65536) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        byte[] metaArray = byArray;
        int n3 = 0;
        Block[] blockArray = new Block[32768];
        while (n3 < 32768) {
            int n4 = n3++;
            blockArray[n4] = Blocks.field_150350_a;
        }
        Block[] cavesArray = blockArray;
        int n5 = 0;
        Block[] blockArray2 = new Block[32768];
        while (n5 < 32768) {
            int n6 = n5++;
            blockArray2[n6] = Blocks.field_150350_a;
        }
        Block[] mountainsArray = blockArray2;
        this.generateCaves(x, z, cavesArray);
        this.generateMountains(x, z, mountainsArray);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, cavesArray, this.biomesForGeneration);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.world, x, z, cavesArray);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.world, x, z, cavesArray);
        Block[] chunkArray = this.mergeArrays(cavesArray, mountainsArray);
        this.makeRiver(chunkArray, x, z);
        Chunk chunk = new Chunk(this.world, chunkArray, metaArray, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    public final void generateCaves(int cX, int cZ, @NotNull Block[] chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        int var4 = 4;
        int floorLevel = 32;
        int var6 = var4 + 1;
        int var7 = 17;
        int var8 = var4 + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, cX * var4, 0, cZ * var4, var6, var7, var8);
        for (int var9 = 0; var9 < var4; ++var9) {
            for (int var10 = 0; var10 < var4; ++var10) {
                for (int var11 = 0; var11 < 16; ++var11) {
                    double var12 = 0.125;
                    double var14 = this.noiseField[(var9 * var8 + var10) * var7 + var11];
                    double var16 = this.noiseField[(var9 * var8 + var10 + 1) * var7 + var11];
                    double var18 = this.noiseField[((var9 + 1) * var8 + var10) * var7 + var11];
                    double var20 = this.noiseField[((var9 + 1) * var8 + var10 + 1) * var7 + var11];
                    double var22 = (this.noiseField[(var9 * var8 + var10) * var7 + var11 + 1] - var14) * var12;
                    double var24 = (this.noiseField[(var9 * var8 + var10 + 1) * var7 + var11 + 1] - var16) * var12;
                    double var26 = (this.noiseField[((var9 + 1) * var8 + var10) * var7 + var11 + 1] - var18) * var12;
                    double var28 = (this.noiseField[((var9 + 1) * var8 + var10 + 1) * var7 + var11 + 1] - var20) * var12;
                    for (int var30 = 0; var30 < 8; ++var30) {
                        double var31 = 0.25;
                        double var33 = var14;
                        double var35 = var16;
                        double var37 = (var18 - var14) * var31;
                        double var39 = (var20 - var16) * var31;
                        for (int var41 = 0; var41 < 4; ++var41) {
                            int x = var9 * 4 + var41;
                            int y = var11 * 8 + var30;
                            int z = var10 * 4;
                            int var42 = this.index(x, y, z);
                            int var43 = 128;
                            double var44 = 0.25;
                            double var46 = var33;
                            double var48 = (var35 - var33) * var44;
                            for (int var50 = 0; var50 < 4; ++var50) {
                                double scale;
                                Block var51 = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                                if (var46 > 0.0) {
                                    var51 = Blocks.field_150350_a;
                                }
                                if (y < floorLevel) {
                                    var51 = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                                }
                                if ((double)y > WE_PerlinNoise.PerlinNoise2D((long)this.seed, (double)((double)(cX * 16 + x) / (scale = 10.0)), (double)((double)(cZ * 16 + z + var50) / scale), (double)5.0, (int)1) + (double)106) {
                                    var51 = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                                }
                                chunk[var42] = var51;
                                var42 += var43;
                                var46 += var48;
                            }
                            var33 += var37;
                            var35 += var39;
                        }
                        var14 += var22;
                        var16 += var24;
                        var18 += var26;
                        var20 += var28;
                    }
                }
            }
        }
    }

    public final void generateMountains(int cX, int cZ, @NotNull Block[] chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        double amplitude = 64.0;
        double scaleXZMin = 64.0;
        double scaleXZMax = 128.0;
        double scaleY = 5.0;
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int x = cX * 16 + i;
                int z = cZ * 16 + k;
                double minHeight = WE_PerlinNoise.PerlinNoise2D((long)this.seed, (double)((double)x / scaleXZMin), (double)((double)z / scaleXZMin), (double)8.0, (int)1);
                minHeight = Math.max(0.0, Math.min(minHeight, 127.0));
                double maxHeight = WE_PerlinNoise.PerlinNoise2D((long)this.seed, (double)((double)x / scaleXZMax), (double)((double)z / scaleXZMax), (double)amplitude, (int)1) * scaleY;
                maxHeight = Math.max(minHeight, Math.min(maxHeight, 127.0));
                int n = ExtensionsKt.getI((Number)maxHeight);
                for (int y = 0; y < n; ++y) {
                    chunk[this.index((int)i, (int)y, (int)k)] = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                }
                int n2 = this.index(i, ExtensionsKt.getI((Number)maxHeight), k);
                Block block = Blocks.field_150431_aC;
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"snow_layer");
                chunk[n2] = block;
            }
        }
    }

    public final int index(int x, int y, int z) {
        return x << 11 | z << 7 | y;
    }

    @NotNull
    public final Block[] mergeArrays(@NotNull Block[] cavesArray, @NotNull Block[] mountainsArray) {
        Intrinsics.checkNotNullParameter((Object)cavesArray, (String)"cavesArray");
        Intrinsics.checkNotNullParameter((Object)mountainsArray, (String)"mountainsArray");
        int n = 0;
        int n2 = cavesArray.length + mountainsArray.length;
        Block[] blockArray = new Block[n2];
        while (n < n2) {
            int n3 = n++;
            Intrinsics.checkNotNullExpressionValue((Object)Blocks.field_150350_a, (String)"air");
        }
        Block[] chunkArray = blockArray;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    int i = x << 12 | z << 8 | y;
                    chunkArray[i] = (y < 128 ? cavesArray : mountainsArray)[this.index(x, y % 128, z)];
                }
            }
        }
        return chunkArray;
    }

    public final void replaceBlocksForBiome(int cX, int cZ, @NotNull Block[] chunk, @NotNull BiomeGenBase[] biomes) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)biomes, (String)"biomes");
        int var5 = 33;
        double var6 = 0.03125;
        this.gravelNoise = this.noiseGen4.func_76304_a(this.gravelNoise, cX * 16, 109, cZ * 16, 16, 1, 16, var6, 1.0, var6);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeGenBase biome = biomes[z + x * 16];
                boolean gravel = this.gravelNoise[x + z * 16] + this.random.nextDouble() * 0.2 > 0.0;
                float temperature = biome.func_150564_a(0, 65, 0);
                int var12 = ExtensionsKt.getI((Number)(this.gravelNoise[x + z * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25));
                int var13 = -1;
                Block top = biome.field_76752_A;
                Block filler = biome.field_76753_B;
                for (int y = 127; -1 < y; --y) {
                    Block block;
                    int index = (z * 16 + x) * 128 + y;
                    if (index >= chunk.length) continue;
                    if (y == 0) {
                        Intrinsics.checkNotNullExpressionValue((Object)Blocks.field_150357_h, (String)"bedrock");
                        continue;
                    }
                    Block current = chunk[index];
                    if (index + 1 < chunk.length && current == Blocks.field_150350_a && chunk[index + 1] == AlfheimBlocks.INSTANCE.getNiflheimBlock() && top == Blocks.field_150433_aE) {
                        Block block2 = Blocks.field_150432_aD;
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"ice");
                        chunk[index + 1] = block2;
                    }
                    if (index + 2 < chunk.length && current == Blocks.field_150350_a && chunk[index + 1] == Blocks.field_150432_aD && chunk[index + 2] == AlfheimBlocks.INSTANCE.getNiflheimBlock() && top == Blocks.field_150433_aE) {
                        Block block3 = Blocks.field_150432_aD;
                        Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"ice");
                        chunk[index + 2] = block3;
                    }
                    if (current == Blocks.field_150350_a) {
                        var13 = -1;
                    }
                    if (current != AlfheimBlocks.INSTANCE.getNiflheimBlock()) continue;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            top = Blocks.field_150350_a;
                            filler = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                        } else if (y >= var5 - 4 && y <= var5 + 1) {
                            top = biome.field_76752_A;
                            filler = biome.field_76753_B;
                        }
                        if (y >= var5 - 4 && y <= var5 + 1) {
                            if (gravel && top == AlfheimBlocks.INSTANCE.getNiflheimBlock()) {
                                top = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                                filler = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                            } else if (gravel && top == Blocks.field_150433_aE) {
                                filler = Blocks.field_150433_aE;
                            }
                        }
                        if (y < var5 && top == Blocks.field_150350_a) {
                            top = temperature < 0.15f ? Blocks.field_150432_aD : Blocks.field_150355_j;
                        }
                        var13 = var12;
                        if (y >= var5 - 1) {
                            block = top;
                            Intrinsics.checkNotNull((Object)block);
                            chunk[index] = block;
                        } else {
                            block = filler;
                            Intrinsics.checkNotNull((Object)block);
                            chunk[index] = block;
                        }
                    } else if (var13 > 0) {
                        block = filler;
                        Intrinsics.checkNotNull((Object)block);
                        chunk[index] = block;
                        if (--var13 == 0 && filler == AlfheimBlocks.INSTANCE.getNiflheimBlock()) {
                            var13 = this.random.nextInt(4);
                            filler = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                        }
                    }
                    if (y <= 123) continue;
                    chunk[index] = AlfheimBlocks.INSTANCE.getNiflheimBlock();
                }
            }
        }
    }

    @NotNull
    public final double[] initializeNoiseField(@NotNull double[] _list, int par2, int par3, int par4, int par5, int par6, int par7) {
        int l;
        Intrinsics.checkNotNullParameter((Object)_list, (String)"_list");
        double[] list = _list;
        if (list.length < par5 * par6 * par7) {
            list = new double[par5 * par6 * par7];
        }
        double d = 684.41;
        double d1 = 2053.23;
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, par2, par3, par4, par5, par6, par7, d / (double)90, d1 / (double)60, d / (double)70);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, par2, par3, par4, par5, par6, par7, d, d1, d);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, par2, par3, par4, par5, par6, par7, d, d1, d);
        int i = 0;
        double[] ad = new double[par6];
        for (l = 0; l < par6; ++l) {
            ad[l] = Math.cos(ExtensionsKt.getD((Number)l) * Math.PI * 6.0 / ExtensionsKt.getD((Number)par6)) * 2.0;
            double i1 = ExtensionsKt.getD((Number)l);
            if (l > par6 / 2) {
                i1 = ExtensionsKt.getD((Number)(par6 - 1 - l));
            }
            if (!(i1 < 4.0)) continue;
            i1 = 4.0 - i1;
            int n = l;
            ad[n] = ad[n] - i1 * i1 * i1 * 10.0;
        }
        for (l = 0; l < par5; ++l) {
            for (int var36 = 0; var36 < par7; ++var36) {
                double d4 = 0.0;
                for (int j1 = 0; j1 < par6; ++j1) {
                    double d6 = 0.0;
                    double d7 = ad[j1];
                    Intrinsics.checkNotNull((Object)this.noiseData2);
                    double d8 = this.noiseData2[i] / 512.0;
                    Intrinsics.checkNotNull((Object)this.noiseData3);
                    double d9 = this.noiseData3[i] / 512.0;
                    Intrinsics.checkNotNull((Object)this.noiseData1);
                    double d10 = (this.noiseData1[i] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    double d12 = 0.0;
                    if (j1 > par6 - 4) {
                        d12 = (double)(j1 - (par6 - 4)) / 3.0;
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    if (ExtensionsKt.getD((Number)j1) < d4) {
                        d12 = (d4 - ExtensionsKt.getD((Number)j1)) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    list[i] = d6;
                    ++i;
                }
            }
        }
        return list;
    }

    public final void makeRiver(@NotNull Block[] chunkArray, int cx, int cz) {
        Intrinsics.checkNotNullParameter((Object)chunkArray, (String)"chunkArray");
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int x = cx * 16 + i;
                int z = cz * 16 + k;
                int f = Companion.f(x);
                IntRange intRange = ExtensionsKt.bidiRange((int)z, (int)6);
                int n = intRange.getFirst();
                boolean bl = f <= intRange.getLast() ? n <= f : false;
                if (!bl) continue;
                int deltaZ = 6 - Math.abs(z - f);
                for (int y = 121; y < 135; ++y) {
                    double deltaY = (double)Math.abs(127 - y) / 1.5;
                    if (deltaY > (double)deltaZ) continue;
                    int id = i << 12 | k << 8 | y;
                    Block block = y < 128 ? Blocks.field_150355_j : Blocks.field_150350_a;
                    Intrinsics.checkNotNull((Object)block);
                    chunkArray[id] = block;
                }
                if (chunkArray[i << 12 | k << 8 | 0x87] == Blocks.field_150431_aC) {
                    Block block = Blocks.field_150350_a;
                    Intrinsics.checkNotNullExpressionValue((Object)block, (String)"air");
                    chunkArray[i << 12 | k << 8 | 0x87] = block;
                }
                chunkArray[i << 12 | k << 8 | 0x78] = AlfheimBlocks.INSTANCE.getNiflheimBlock();
            }
        }
    }

    public void func_73153_a(@NotNull IChunkProvider provider, int cX, int cZ) {
        BiomeGenBase biomeGenBase;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        BlockSand.field_149832_M = true;
        this.random.setSeed(this.seed * (long)cX + (long)(cZ * cZ) * 107L + 2394720L);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(provider, this.world, this.random, cX, cZ, false));
        int i = cX * 16;
        int k = cZ * 16;
        BiomeGenBase biomegenbase = this.world.func_72959_q().func_76935_a(i, k);
        int m = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        for (m = 0; m < 8; ++m) {
            x = i + this.random.nextInt(16) + 8;
            y = this.random.nextInt(120) + 4;
            z = k + this.random.nextInt(16) + 8;
            WorldGenRoot.INSTANCE.generate(this.world, this.random, x, y, z);
        }
        BiomeGenBase biomegenbase2 = null;
        for (m = 0; m < 8; ++m) {
            x = i + this.random.nextInt(16) + 8;
            y = this.random.nextInt(128);
            z = k + this.random.nextInt(16) + 8;
            biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
            WorldGenDungeons.INSTANCE.generate(this.world, this.random, x, y, z, biomegenbase2);
        }
        BiomeGenBase var12 = null;
        if (this.random.nextInt(4) == 0 && !(biomegenbase instanceof BiomeGenPoison)) {
            m = i + this.random.nextInt(16) + 8;
            x = this.random.nextInt(100);
            y = k + this.random.nextInt(16) + 8;
            var12 = this.world.func_72959_q().func_76935_a(m, y);
            if (!(var12 instanceof BiomeGenPoison)) {
                Block block = Blocks.field_150355_j;
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"water");
                biomeGenBase = var12;
                Intrinsics.checkNotNull((Object)biomeGenBase);
                WorldGenLakes.INSTANCE.generate(this.world, this.random, m, x, y, block, biomeGenBase);
            }
        }
        if ((biomegenbase instanceof BiomeGenIce || biomegenbase instanceof BiomeGenPoison) && this.random.nextInt(8) == 0) {
            m = i + this.random.nextInt(16) + 8;
            x = this.random.nextInt(this.random.nextInt(92) + 8);
            y = k + this.random.nextInt(16) + 8;
            var12 = this.world.func_72959_q().func_76935_a(m, y);
            if (x < 63 || this.random.nextInt(10) == 0 && (var12 instanceof BiomeGenIce || var12 instanceof BiomeGenPoison)) {
                Block block = AlfheimBlocks.INSTANCE.getPoisonIce();
                biomeGenBase = var12;
                Intrinsics.checkNotNull((Object)biomeGenBase);
                WorldGenLakes.INSTANCE.generate(this.world, this.random, m, x, y, block, biomeGenBase);
            }
        }
        if (biomegenbase instanceof BiomeGenPoison && this.random.nextInt(3) == 0) {
            m = i + this.random.nextInt(16) + 8;
            x = this.random.nextInt(this.random.nextInt(92) + 8);
            y = k + this.random.nextInt(16) + 8;
            var12 = this.world.func_72959_q().func_76935_a(m, y);
            if (var12 instanceof BiomeGenPoison) {
                WorldGenLakes.INSTANCE.generate(this.world, this.random, m, x, y, AlfheimBlocks.INSTANCE.getPoisonIce(), var12);
            }
        }
        if (biomegenbase instanceof BiomeGenSnow) {
            for (m = 0; m < 20; ++m) {
                boolean bl;
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(50) + 20;
                z = k + this.random.nextInt(16) + 8;
                biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
                if (!(biomegenbase2 instanceof BiomeGenSnow)) continue;
                if (ThermalFoundationIntegration.INSTANCE.getLoaded() && this.random.nextInt(10) == 0) {
                    bl = WorldGenWaterfall.INSTANCE.generateRandom(this.world, this.random, x, y, z, ThermalFoundationIntegration.INSTANCE.getCryothenumBlock());
                    continue;
                }
                Block block = Blocks.field_150432_aD;
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"ice");
                bl = WorldGenWaterfall.INSTANCE.generateFrozenDirect(this.world, x, y, z, block);
            }
        }
        if (biomegenbase instanceof BiomeGenIce) {
            for (m = 0; m < 20; ++m) {
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(50) + 20;
                z = k + this.random.nextInt(16) + 8;
                biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
                if (!(biomegenbase2 instanceof BiomeGenIce)) continue;
                BlockLiquid blockLiquid = Blocks.field_150358_i;
                Intrinsics.checkNotNullExpressionValue((Object)blockLiquid, (String)"flowing_water");
                Block block = (Block)blockLiquid;
                Block block2 = Blocks.field_150355_j;
                Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"water");
                WorldGenWaterfall.INSTANCE.generateDirect(this.world, this.random, x, y, z, block, block2);
            }
        }
        if (biomegenbase instanceof BiomeGenIce || biomegenbase instanceof BiomeGenPoison) {
            for (m = 0; m < 20; ++m) {
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(50) + 20;
                z = k + this.random.nextInt(16) + 8;
                biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
                if (!(biomegenbase2 instanceof BiomeGenIce) && !(biomegenbase2 instanceof BiomeGenPoison)) continue;
                WorldGenWaterfall.INSTANCE.generateFrozenDirect(this.world, x, y, z, AlfheimBlocks.INSTANCE.getPoisonIce());
            }
        }
        if (biomegenbase instanceof BiomeGenIce) {
            for (m = 0; m < 2; ++m) {
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(100) + 10;
                z = k + this.random.nextInt(16) + 8;
                biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
                if (!(biomegenbase2 instanceof BiomeGenIce)) continue;
                BlockLiquid blockLiquid = Blocks.field_150358_i;
                Intrinsics.checkNotNullExpressionValue((Object)blockLiquid, (String)"flowing_water");
                WorldGenWaterfall.INSTANCE.generateRandom(this.world, this.random, x, y, z, (Block)blockLiquid);
            }
        }
        if (biomegenbase instanceof BiomeGenPoison) {
            for (m = 0; m < 6; ++m) {
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(100) + 10;
                z = k + this.random.nextInt(16) + 8;
                biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
                if (!(biomegenbase2 instanceof BiomeGenPoison)) continue;
                BlockLiquid blockLiquid = Blocks.field_150358_i;
                Intrinsics.checkNotNullExpressionValue((Object)blockLiquid, (String)"flowing_water");
                WorldGenWaterfall.INSTANCE.generateRandom(this.world, this.random, x, y, z, (Block)blockLiquid);
            }
        }
        if (this.useStructures) {
            for (m = 0; m < 4; ++m) {
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(60) + 50;
                z = k + this.random.nextInt(16) + 8;
                WorldGenBridge.INSTANCE.generateX(this.world, this.random, x, y, z);
            }
            for (m = 0; m < 4; ++m) {
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(60) + 50;
                z = k + this.random.nextInt(16) + 8;
                WorldGenBridge.INSTANCE.generateZ(this.world, this.random, x, y, z);
            }
            x = i + this.random.nextInt(16) + 8;
            y = this.random.nextInt(30) + 5;
            z = k + this.random.nextInt(16) + 8;
            WorldGenRuins.INSTANCE.generate(this.world, this.random, x, y, z);
        }
        for (m = 0; m < 8; ++m) {
            x = i + this.random.nextInt(16) + 8;
            y = this.random.nextInt(128);
            z = k + this.random.nextInt(16) + 8;
            WorldGenNifleur.INSTANCE.generate(this.world, x, y, z);
        }
        if (this.random.nextInt(10) == 0) {
            x = i + this.random.nextInt(16) + 8;
            z = k + this.random.nextInt(16) + 8;
            biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
            if (biomegenbase2 instanceof BiomeGenIce) {
                WorldGenIcyGeyser.INSTANCE.generate(this.world, x, z);
            }
        }
        for (m = 0; m < 128; ++m) {
            x = i + this.random.nextInt(16) + 8;
            y = this.random.nextInt(128);
            z = k + this.random.nextInt(16) + 8;
            biomeGenBase = biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
            Intrinsics.checkNotNull((Object)biomeGenBase);
            WorldGenCaveHangs.INSTANCE.generate(this.world, this.random, x, y, z, biomeGenBase);
        }
        if (biomegenbase instanceof BiomeGenSnow) {
            for (m = 0; m < 6; ++m) {
                x = i + this.random.nextInt(16) + 8;
                y = this.random.nextInt(128);
                z = k + this.random.nextInt(16) + 8;
                biomegenbase2 = this.world.func_72959_q().func_76935_a(x, z);
                if (!(biomegenbase2 instanceof BiomeGenSnow)) continue;
                WorldGenBigDungeons.INSTANCE.generate(this.world, this.random, x, y, z);
            }
        }
        if (this.random.nextInt(2) == 0) {
            m = i + this.random.nextInt(16) + 8;
            x = this.random.nextInt(2) + 98;
            y = k + this.random.nextInt(16) + 8;
            Block block = Blocks.field_150355_j;
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"water");
            Intrinsics.checkNotNull((Object)biomegenbase);
            WorldGenLakes.INSTANCE.generate(this.world, this.random, m, x, y, block, biomegenbase);
        }
        ChunkProviderNiflheim $this$populate_u24lambda_u240 = this;
        boolean bl = false;
        if (biomegenbase instanceof BiomeGenSnow || $this$populate_u24lambda_u240.random.nextInt(5) == 0) {
            for (m = 0; m < (!(biomegenbase instanceof BiomeGenSnow) ? 1 : 5); ++m) {
                x = i + $this$populate_u24lambda_u240.random.nextInt(16) + 8;
                z = k + $this$populate_u24lambda_u240.random.nextInt(16) + 8;
                y = $this$populate_u24lambda_u240.world.func_72825_h(x, z);
                WorldGenIcePikes.INSTANCE.generate($this$populate_u24lambda_u240.world, $this$populate_u24lambda_u240.random, x, y, z);
            }
        }
        if (this.random.nextInt(8) == 0) {
            x = i + this.random.nextInt(16) + 8;
            z = k + this.random.nextInt(16) + 8;
            y = this.world.func_72825_h(x, z);
            WorldGenHole.INSTANCE.generate(this.world, this.random, x, y - 1, z);
        }
        if (this.random.nextInt(64) == 0) {
            x = i + this.random.nextInt(16) + 8;
            y = this.random.nextInt(20) + 4;
            z = k + this.random.nextInt(16) + 8;
            var12 = this.world.func_72959_q().func_76935_a(x, z);
            Block block = AlfheimBlocks.INSTANCE.getNiflheimPortal();
            biomeGenBase = var12;
            Intrinsics.checkNotNull((Object)biomeGenBase);
            WorldGenLakes.INSTANCE.generate(this.world, this.random, x, y, z, block, biomeGenBase);
        }
        if (this.random.nextInt(64) == 0) {
            x = i + this.random.nextInt(16) + 8;
            z = k + this.random.nextInt(16) + 8;
            WorldGenTentacles.INSTANCE.generate(this.world, this.random, x, z);
        }
        if (this.random.nextInt(16) == 0) {
            x = i + this.random.nextInt(16) + 8;
            z = k + this.random.nextInt(16) + 8;
            WorldGenRibs.INSTANCE.generate(this.world, this.random, x, z);
        }
        if (this.random.nextInt(16) == 0) {
            x = i + this.random.nextInt(16) + 8;
            z = k + this.random.nextInt(16) + 8;
            WorldGenGigaHangs.INSTANCE.generate(this.world, this.random, x, z);
        }
        ChunkProviderNiflheim $this$populate_u24lambda_u241 = this;
        boolean bl2 = false;
        x = i + $this$populate_u24lambda_u241.random.nextInt(16) + 8;
        z = k + $this$populate_u24lambda_u241.random.nextInt(16) + 8;
        WorldGenGigaRoot.INSTANCE.generate($this$populate_u24lambda_u241.world, $this$populate_u24lambda_u241.random, x, z);
        if (this.random.nextInt(16) == 0) {
            x = i + this.random.nextInt(16) + 8;
            z = k + this.random.nextInt(16) + 8;
            WorldGenIglu.INSTANCE.generate(this.world, this.random, x, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(provider, this.world, this.random, cX, cZ, false));
        this.generateThrymDomain(cX, cZ);
        BlockSand.field_149832_M = false;
        if (cX == 0 && cZ == 0) {
            int top = this.world.func_72825_h(0, 0);
            this.world.func_72950_A(0, top + 1, 0);
        }
    }

    public final void generateThrymDomain(int cX, int cZ) {
        int x = ASJUtilities.randInBounds((int)-1000, (int)1000, (Random)new Random(this.seed));
        if (x >> 4 != cX) {
            return;
        }
        int z = Companion.f(x) + 16;
        if (z >> 4 != cZ) {
            return;
        }
        int y = 128;
        for (int i = -3; i < 4; ++i) {
            block1: for (int k = -16; k < 5; ++k) {
                int maxJ;
                int minJ = Math.abs(i) == 3 ? 1 : 0;
                int j = minJ;
                if (j > (maxJ = Math.abs(i) == 3 ? 5 : 6)) continue;
                while (true) {
                    if (this.world.func_147439_a(x + i, y + j, z + k) == AlfheimBlocks.INSTANCE.getNiflheimBlock()) {
                        this.world.func_147468_f(x + i, y + j, z + k);
                    }
                    if (j == maxJ) continue block1;
                    ++j;
                }
            }
        }
        SchemaUtils.generate$default((SchemaUtils)SchemaUtils.INSTANCE, (World)this.world, (int)x, (int)y, (int)z, (String)"alfheim/schemas/Domain", (boolean)false, (boolean)false, (boolean)false, (int)0, (int)448, null);
        TileEntity tileEntity = this.world.func_147438_o(x, y + 3, z + 3);
        Intrinsics.checkNotNull((Object)tileEntity, (String)"null cannot be cast to non-null type alfheim.common.block.tile.TileDomainLobby");
        TileDomainLobby lobby = (TileDomainLobby)tileEntity;
        lobby.setName("Thrym");
        lobby.lock(x, y + 3, z + 3, this.world.field_73011_w.field_76574_g);
    }

    @Nullable
    public Void func_147416_a(@NotNull World par1World, @NotNull String par2Str, int par3, int i, int j) {
        Intrinsics.checkNotNullParameter((Object)par1World, (String)"par1World");
        Intrinsics.checkNotNullParameter((Object)par2Str, (String)"par2Str");
        return null;
    }

    @Nullable
    public List<Object> func_73155_a(@NotNull EnumCreatureType type2, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        BiomeGenBase biomeGenBase = this.world.func_72807_a(x, z);
        return biomeGenBase != null ? biomeGenBase.func_76747_a(type2) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int x, int z) {
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public boolean func_73149_a(int chunkX, int chunkZ) {
        return true;
    }

    public boolean func_73151_a(boolean flag, @NotNull IProgressUpdate iprogressupdate) {
        Intrinsics.checkNotNullParameter((Object)iprogressupdate, (String)"iprogressupdate");
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    @NotNull
    public String func_73148_d() {
        return "Niflheim";
    }

    static {
        Block[] blockArray = new Block[]{AlfheimBlocks.INSTANCE.getNiflheimBlock(), Blocks.field_150433_aE, Blocks.field_150432_aD, Blocks.field_150403_cj, AlfheimBlocks.INSTANCE.getPoisonIce()};
        surfaceBlocks = blockArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR!\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lalfheim/common/world/dim/niflheim/ChunkProviderNiflheim$Companion;", "", "<init>", "()V", "surfaceBlocks", "", "Lnet/minecraft/block/Block;", "kotlin.jvm.PlatformType", "getSurfaceBlocks", "()[Lnet/minecraft/block/Block;", "[Lnet/minecraft/block/Block;", "f", "", "x", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Block[] getSurfaceBlocks() {
            return surfaceBlocks;
        }

        public final int f(int x) {
            return ExtensionsKt.getI((Number)((Math.sin((double)x / 32.0) + Math.cos((double)x / 128.0)) * (double)16));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

