/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.helheim.gen;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.SchemaUtils;
import alfheim.api.entity.EnumRace;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.block.AlfheimFluffBlocks;
import alfheim.common.block.tile.TileRainbowManaFlame;
import alfheim.common.block.tile.TileVafthrudnirSoul;
import alfheim.common.core.handler.AlfheimConfigHandler;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lalfheim/common/world/dim/helheim/gen/WorldGenHelheim;", "Lcpw/mods/fml/common/IWorldGenerator;", "<init>", "()V", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkProvider;", "chunkProvider", "genSoul", "genVafthrudnir", "", "soulColors", "", "getSoulColors", "()Ljava/util/List;", "genStairs", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nWorldGenHelheim.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGenHelheim.kt\nalfheim/common/world/dim/helheim/gen/WorldGenHelheim\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1557#2:90\n1628#2,3:91\n*S KotlinDebug\n*F\n+ 1 WorldGenHelheim.kt\nalfheim/common/world/dim/helheim/gen/WorldGenHelheim\n*L\n59#1:90\n59#1:91,3\n*E\n"})
public final class WorldGenHelheim
implements IWorldGenerator {
    @NotNull
    public static final WorldGenHelheim INSTANCE;
    @NotNull
    private static final List<Integer> soulColors;

    private WorldGenHelheim() {
    }

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @Nullable IChunkProvider chunkGenerator, @Nullable IChunkProvider chunkProvider) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDHelheim()) {
            return;
        }
        if (chunkX == 0 && chunkZ == 0) {
            this.genStairs(world);
        }
        this.genSoul(world, random, chunkX, chunkZ);
    }

    public final void genSoul(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (this.genVafthrudnir(world, chunkX, chunkZ)) {
            return;
        }
        if (random.nextBoolean()) {
            return;
        }
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        if (Math.abs(x) < 24 && Math.abs(z) < 24) {
            return;
        }
        int y = world.func_72825_h(x, z) + ASJUtilities.randInBounds((int)1, (int)5, (Random)random);
        if (!world.func_147449_b(x, y, z, AlfheimBlocks.INSTANCE.getRainbowFlame())) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileRainbowManaFlame)) {
            return;
        }
        TileRainbowManaFlame tileRainbowManaFlame = (TileRainbowManaFlame)tile;
        Object object = ExtensionsKt.random((Collection)soulColors, (Random)random);
        Intrinsics.checkNotNull((Object)object);
        tileRainbowManaFlame.color = ((Number)object).intValue();
        ((TileRainbowManaFlame)tile).setSoul(true);
    }

    public final boolean genVafthrudnir(@NotNull World world, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Random rand = new Random(world.func_72905_C());
        int x = ASJUtilities.randInBounds((int)-256, (int)256, (Random)rand);
        int z = ASJUtilities.randInBounds((int)-768, (int)-256, (Random)rand);
        if (x >> 4 != chunkX || z >> 4 != chunkZ) {
            return false;
        }
        int y = world.func_72825_h(x, z) + ASJUtilities.randInBounds((int)1, (int)3, (Random)rand);
        if (!world.func_147465_d(x, y, z, AlfheimBlocks.INSTANCE.getRainbowFlame(), 1, 3) || !(world.func_147438_o(x, y, z) instanceof TileVafthrudnirSoul)) {
            throw new RuntimeException("Unable to generate Vafthrudnir soul on designated coords [" + x + ", " + y + ", " + z + "]. This would make ragnarok impossible to complete. Please, regenerate Helheim chunk at [" + chunkX + ", " + chunkZ + ']');
        }
        return true;
    }

    @NotNull
    public final List<Integer> getSoulColors() {
        return soulColors;
    }

    public final void genStairs(@NotNull World world) {
        int z;
        int x;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        String stairs = "alfheim/schemas/helstairs";
        int yStart = world.func_72825_h(0, 0);
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)yStart, (int)256)), (int)4);
        int y = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && y <= n || n2 < 0 && n <= y) {
            while (true) {
                SchemaUtils.generate$default((SchemaUtils)SchemaUtils.INSTANCE, (World)world, (int)0, (int)y, (int)0, (String)stairs, (boolean)true, (boolean)false, (boolean)false, (int)0, (int)448, null);
                if (y == n) break;
                y += n2;
            }
        }
        SchemaUtils.INSTANCE.uncache(stairs);
        for (x = -4; x < 5; ++x) {
            for (z = -4; z < 5; ++z) {
                world.func_147468_f(x, 255, z);
            }
        }
        for (x = -1; x < 2; ++x) {
            for (z = -1; z < 2; ++z) {
                if (x == 0 && z == 0) continue;
                world.func_147465_d(x, 254, z, AlfheimFluffBlocks.INSTANCE.getShrineRockWhiteSlab(), 8, 3);
            }
        }
        if (!world.func_147449_b(0, 255, 0, AlfheimBlocks.INSTANCE.getRainbowFlame())) {
            ASJUtilities.fatal$default((String)("!!!WARNING!!!\nSevere issue!!!\nSomething prevented exit block from being set in Helheim dim (" + world.field_73011_w.field_76574_g + ") on 0 255 0 coordinates!!!\nMake sure to do something about it or else there will be no exit!!!"), null, (int)2, null);
            return;
        }
        TileEntity tileEntity = world.func_147438_o(0, 255, 0);
        Intrinsics.checkNotNull((Object)tileEntity, (String)"null cannot be cast to non-null type alfheim.common.block.tile.TileRainbowManaFlame");
        ((TileRainbowManaFlame)tileEntity).setExit(true);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new WorldGenHelheim();
        Iterable $this$map$iv = (Iterable)EnumRace.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EnumRace enumRace = (EnumRace)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRgbColor());
        }
        soulColors = (List)var3_3;
    }
}

