/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.alfheim.structure;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.SchemaUtils;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.item.AlfheimItems;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.item.ModItems;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J.\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint;", "", "<init>", "()V", "inGen", "", "getInGen", "()Z", "setInGen", "(Z)V", "generate", "", "world", "Lnet/minecraft/world/World;", "rand", "Ljava/util/Random;", "generatePortal", "x", "", "y", "z", "generateStartBox", "items", "", "Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "getItems", "()[Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "[Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "RandomItemHolder", "Alfheim"})
public final class StructureSpawnpoint {
    @NotNull
    public static final StructureSpawnpoint INSTANCE = new StructureSpawnpoint();
    private static boolean inGen;
    @NotNull
    private static final RandomItemHolder[] items;

    private StructureSpawnpoint() {
    }

    public final boolean getInGen() {
        return inGen;
    }

    public final void setInGen(boolean bl) {
        inGen = bl;
    }

    public final void generate(@NotNull World world, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (inGen) {
            return;
        }
        inGen = true;
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory() || AlfheimConfigHandler.INSTANCE.getBothSpawnStructures()) {
            this.generatePortal(world, 0, 220, 0);
        }
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory() || AlfheimConfigHandler.INSTANCE.getBothSpawnStructures()) {
            this.generateStartBox(world, 0, 0, 0, rand);
        }
        ASJUtilities.log((String)"Spawn created");
        inGen = false;
    }

    public final void generatePortal(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        world.func_72950_A(x, y, z - 3);
        SchemaUtils.generate$default((SchemaUtils)SchemaUtils.INSTANCE, (World)world, (int)x, (int)y, (int)z, (String)"alfheim/schemas/portal", (boolean)false, (boolean)false, (boolean)false, (int)0, (int)448, null);
    }

    public final void generateStartBox(@NotNull World world, int x, int y, int z, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        world.func_72950_A(x, y + 2, z);
        SchemaUtils.generate$default((SchemaUtils)SchemaUtils.INSTANCE, (World)world, (int)x, (int)y, (int)z, (String)"alfheim/schemas/spawnbox", (boolean)false, (boolean)false, (boolean)false, (int)0, (int)448, null);
        world.func_147449_b(x, y, z, Blocks.field_150357_h);
        if (!AlfheimConfigHandler.INSTANCE.getBonusChest()) {
            return;
        }
        world.func_147465_d(x, y + 2, z - 5, (Block)Blocks.field_150486_ae, 0, 2);
        TileEntity tileEntity = world.func_147438_o(x, y + 2, z - 5);
        TileEntityChest tileEntityChest = tileEntity instanceof TileEntityChest ? (TileEntityChest)tileEntity : null;
        if (tileEntityChest == null) {
            return;
        }
        TileEntityChest tile = tileEntityChest;
        int count = ASJUtilities.randInBounds((int)ExtensionsKt.getI((Number)((double)items.length * 0.25)), (int)ExtensionsKt.getI((Number)((double)items.length * 0.75)), (Random)rand);
        Set itemPoses = CollectionsKt.toMutableSet((Iterable)CollectionsKt.shuffled((Iterable)((Iterable)ArraysKt.getIndices((Object[])items))));
        Set slots = CollectionsKt.toMutableSet((Iterable)CollectionsKt.shuffled((Iterable)((Iterable)RangesKt.until((int)0, (int)tile.func_70302_i_()))));
        while (count > 0) {
            Integer n = (Integer)ExtensionsKt.removeRandom((Collection)itemPoses);
            if (n == null) {
                continue;
            }
            int pos = n;
            RandomItemHolder item = items[pos];
            if (!ASJUtilities.chance((Number)item.getChance())) {
                itemPoses.add(pos);
                continue;
            }
            --count;
            int meta = item.getMaxMeta() == -1 ? item.getMeta() : ASJUtilities.randInBounds((int)item.getMeta(), (int)item.getMaxMeta(), (Random)rand);
            Integer n2 = (Integer)ExtensionsKt.removeRandom((Collection)slots);
            if (n2 == null) {
                continue;
            }
            ExtensionsKt.set((IInventory)((IInventory)tile), (int)n2, (ItemStack)new ItemStack(item.getItem(), Math.min(item.getItem().getItemStackLimit(new ItemStack(item.getItem(), 1, meta)), ASJUtilities.randInBounds((int)item.getCountMin(), (int)item.getCountMax(), (Random)rand)), meta));
        }
    }

    @NotNull
    public final RandomItemHolder[] getItems() {
        return items;
    }

    static {
        RandomItemHolder[] randomItemHolderArray = new RandomItemHolder[19];
        Item item = Items.field_151039_o;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"wooden_pickaxe");
        randomItemHolderArray[0] = new RandomItemHolder(item, 0, 1, 2, 50, 0, 32, null);
        Item item2 = Items.field_151053_p;
        Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"wooden_axe");
        randomItemHolderArray[1] = new RandomItemHolder(item2, 0, 1, 2, 50, 0, 32, null);
        Item item3 = ModItems.manaResource;
        Intrinsics.checkNotNullExpressionValue((Object)item3, (String)"manaResource");
        randomItemHolderArray[2] = new RandomItemHolder(item3, 13, 1, 4, 25, 0, 32, null);
        Item item4 = ModItems.manaResource;
        Intrinsics.checkNotNullExpressionValue((Object)item4, (String)"manaResource");
        randomItemHolderArray[3] = new RandomItemHolder(item4, 22, 4, 8, 10, 0, 32, null);
        Item item5 = Items.field_151034_e;
        Intrinsics.checkNotNullExpressionValue((Object)item5, (String)"apple");
        randomItemHolderArray[4] = new RandomItemHolder(item5, 0, 5, 10, 75, 0, 32, null);
        Item item6 = Items.field_151025_P;
        Intrinsics.checkNotNullExpressionValue((Object)item6, (String)"bread");
        randomItemHolderArray[5] = new RandomItemHolder(item6, 0, 5, 10, 75, 0, 32, null);
        Item item7 = ModItems.manaBottle;
        Intrinsics.checkNotNullExpressionValue((Object)item7, (String)"manaBottle");
        randomItemHolderArray[6] = new RandomItemHolder(item7, 0, 1, 3, 50, 0, 32, null);
        Item item8 = ModItems.blackLotus;
        Intrinsics.checkNotNullExpressionValue((Object)item8, (String)"blackLotus");
        randomItemHolderArray[7] = new RandomItemHolder(item8, 0, 1, 2, 10, 0, 32, null);
        Item item9 = ModItems.blackLotus;
        Intrinsics.checkNotNullExpressionValue((Object)item9, (String)"blackLotus");
        randomItemHolderArray[8] = new RandomItemHolder(item9, 1, 1, 1, 1, 0, 32, null);
        Item item10 = ModItems.fertilizer;
        Intrinsics.checkNotNullExpressionValue((Object)item10, (String)"fertilizer");
        randomItemHolderArray[9] = new RandomItemHolder(item10, 1, 5, 15, 50, 0, 32, null);
        Block block = Blocks.field_150345_g;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"sapling");
        Item item11 = ExtensionsKt.toItem((Block)block);
        Intrinsics.checkNotNull((Object)item11);
        randomItemHolderArray[10] = new RandomItemHolder(item11, 0, 2, 3, 50, 0, 32, null);
        Item item12 = ExtensionsKt.toItem((Block)AlfheimBlocks.INSTANCE.getDreamSapling());
        Intrinsics.checkNotNull((Object)item12);
        randomItemHolderArray[11] = new RandomItemHolder(item12, 0, 2, 3, 50, 0, 32, null);
        Item item13 = ModItems.cosmetic;
        Intrinsics.checkNotNullExpressionValue((Object)item13, (String)"cosmetic");
        randomItemHolderArray[12] = new RandomItemHolder(item13, 0, 1, 1, 25, 31);
        Item item14 = ModItems.cosmetic;
        Intrinsics.checkNotNullExpressionValue((Object)item14, (String)"cosmetic");
        randomItemHolderArray[13] = new RandomItemHolder(item14, 0, 1, 1, 10, 31);
        randomItemHolderArray[14] = new RandomItemHolder(AlfheimItems.INSTANCE.getCoatOfArms(), 0, 1, 1, 25, 17);
        randomItemHolderArray[15] = new RandomItemHolder(AlfheimItems.INSTANCE.getCoatOfArms(), 0, 1, 1, 25, 17);
        Block block2 = Blocks.field_150364_r;
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"log");
        Item item15 = ExtensionsKt.toItem((Block)block2);
        Intrinsics.checkNotNull((Object)item15);
        randomItemHolderArray[16] = new RandomItemHolder(item15, 0, 8, 16, 45, 0, 32, null);
        Block block3 = Blocks.field_150363_s;
        Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"log2");
        Item item16 = ExtensionsKt.toItem((Block)block3);
        Intrinsics.checkNotNull((Object)item16);
        randomItemHolderArray[17] = new RandomItemHolder(item16, 1, 8, 16, 45, 0, 32, null);
        Item item17 = ExtensionsKt.toItem((Block)AlfheimBlocks.INSTANCE.getAltWood1());
        Intrinsics.checkNotNull((Object)item17);
        randomItemHolderArray[18] = new RandomItemHolder(item17, 3, 8, 16, 45, 0, 32, null);
        items = randomItemHolderArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006!"}, d2={"Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "", "item", "Lnet/minecraft/item/Item;", "meta", "", "countMin", "countMax", "chance", "maxMeta", "<init>", "(Lnet/minecraft/item/Item;IIIII)V", "getItem", "()Lnet/minecraft/item/Item;", "getMeta", "()I", "getCountMin", "getCountMax", "getChance", "getMaxMeta", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "Alfheim"})
    public static final class RandomItemHolder {
        @NotNull
        private final Item item;
        private final int meta;
        private final int countMin;
        private final int countMax;
        private final int chance;
        private final int maxMeta;

        public RandomItemHolder(@NotNull Item item, int meta, int countMin, int countMax, int chance, int maxMeta) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.item = item;
            this.meta = meta;
            this.countMin = countMin;
            this.countMax = countMax;
            this.chance = chance;
            this.maxMeta = maxMeta;
        }

        public /* synthetic */ RandomItemHolder(Item item, int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 0x20) != 0) {
                n5 = -1;
            }
            this(item, n, n2, n3, n4, n5);
        }

        @NotNull
        public final Item getItem() {
            return this.item;
        }

        public final int getMeta() {
            return this.meta;
        }

        public final int getCountMin() {
            return this.countMin;
        }

        public final int getCountMax() {
            return this.countMax;
        }

        public final int getChance() {
            return this.chance;
        }

        public final int getMaxMeta() {
            return this.maxMeta;
        }

        @NotNull
        public final Item component1() {
            return this.item;
        }

        public final int component2() {
            return this.meta;
        }

        public final int component3() {
            return this.countMin;
        }

        public final int component4() {
            return this.countMax;
        }

        public final int component5() {
            return this.chance;
        }

        public final int component6() {
            return this.maxMeta;
        }

        @NotNull
        public final RandomItemHolder copy(@NotNull Item item, int meta, int countMin, int countMax, int chance, int maxMeta) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return new RandomItemHolder(item, meta, countMin, countMax, chance, maxMeta);
        }

        public static /* synthetic */ RandomItemHolder copy$default(RandomItemHolder randomItemHolder, Item item, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                item = randomItemHolder.item;
            }
            if ((n6 & 2) != 0) {
                n = randomItemHolder.meta;
            }
            if ((n6 & 4) != 0) {
                n2 = randomItemHolder.countMin;
            }
            if ((n6 & 8) != 0) {
                n3 = randomItemHolder.countMax;
            }
            if ((n6 & 0x10) != 0) {
                n4 = randomItemHolder.chance;
            }
            if ((n6 & 0x20) != 0) {
                n5 = randomItemHolder.maxMeta;
            }
            return randomItemHolder.copy(item, n, n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "RandomItemHolder(item=" + this.item + ", meta=" + this.meta + ", countMin=" + this.countMin + ", countMax=" + this.countMax + ", chance=" + this.chance + ", maxMeta=" + this.maxMeta + ')';
        }

        public int hashCode() {
            int result = this.item.hashCode();
            result = result * 31 + Integer.hashCode(this.meta);
            result = result * 31 + Integer.hashCode(this.countMin);
            result = result * 31 + Integer.hashCode(this.countMax);
            result = result * 31 + Integer.hashCode(this.chance);
            result = result * 31 + Integer.hashCode(this.maxMeta);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RandomItemHolder)) {
                return false;
            }
            RandomItemHolder randomItemHolder = (RandomItemHolder)other;
            if (!Intrinsics.areEqual((Object)this.item, (Object)randomItemHolder.item)) {
                return false;
            }
            if (this.meta != randomItemHolder.meta) {
                return false;
            }
            if (this.countMin != randomItemHolder.countMin) {
                return false;
            }
            if (this.countMax != randomItemHolder.countMax) {
                return false;
            }
            if (this.chance != randomItemHolder.chance) {
                return false;
            }
            return this.maxMeta == randomItemHolder.maxMeta;
        }
    }
}

