/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.alfheim.structure;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.SchemaUtils;
import alexsocol.asjlib.math.Vector3;
import alfheim.common.world.data.CustomWorldData;
import alfheim.common.world.dim.alfheim.biome.BiomeField;
import java.util.Collection;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import ru.vamig.worldengine.WE_Biome;
import ru.vamig.worldengine.WE_ChunkProvider;
import ru.vamig.worldengine.WE_WorldProvider;
import ru.vamig.worldengine.standardcustomgen.StructureBaseClass;
import vazkii.botania.common.block.ModBlocks;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0019"}, d2={"Lalfheim/common/world/dim/alfheim/structure/StructureArena;", "Lru/vamig/worldengine/standardcustomgen/StructureBaseClass;", "<init>", "()V", "xs", "", "", "getXs", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "zs", "getZs", "generate", "", "world", "Lnet/minecraft/world/World;", "rand", "Ljava/util/Random;", "x", "y", "z", "chunkProvider", "Lru/vamig/worldengine/WE_ChunkProvider;", "generate01", "", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nStructureArena.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureArena.kt\nalfheim/common/world/dim/alfheim/structure/StructureArena\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,87:1\n1755#2,3:88\n12511#3,2:91\n*S KotlinDebug\n*F\n+ 1 StructureArena.kt\nalfheim/common/world/dim/alfheim/structure/StructureArena\n*L\n28#1:88,3\n32#1:91,2\n*E\n"})
public final class StructureArena
extends StructureBaseClass {
    @NotNull
    public static final StructureArena INSTANCE = new StructureArena();
    @NotNull
    private static final Integer[] xs;
    @NotNull
    private static final Integer[] zs;

    private StructureArena() {
    }

    @NotNull
    public final Integer[] getXs() {
        return xs;
    }

    @NotNull
    public final Integer[] getZs() {
        return zs;
    }

    public boolean generate(@NotNull World world, @NotNull Random rand, int x, int y, int z, @NotNull WE_ChunkProvider chunkProvider) {
        int n;
        WE_WorldProvider wE_WorldProvider;
        boolean bl;
        Collection locs;
        CustomWorldData data;
        block13: {
            block16: {
                block15: {
                    Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                    Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
                    Intrinsics.checkNotNullParameter((Object)chunkProvider, (String)"chunkProvider");
                    if (ASJUtilities.isClient()) {
                        return false;
                    }
                    int n2 = x >> 4;
                    if (-32 <= n2 ? n2 < 32 : false) break block15;
                    n2 = z >> 4;
                    boolean bl2 = -32 <= n2 ? n2 < 32 : false;
                    if (!bl2) break block16;
                }
                return false;
            }
            data = CustomWorldData.Companion.getCustomData(world);
            locs = data.getStructures().get((Object)"any");
            Intrinsics.checkNotNull((Object)locs);
            Iterable $this$any$iv = locs;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                wE_WorldProvider = $this$any$iv.iterator();
                while (wE_WorldProvider.hasNext()) {
                    Object element$iv = wE_WorldProvider.next();
                    Pair it = (Pair)element$iv;
                    n = 0;
                    if (!(Vector3.Companion.pointDistancePlane((Number)x, (Number)z, (Number)it.getFirst(), (Number)it.getSecond()) < 128.0)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        WorldProvider worldProvider = world.field_73011_w;
        WE_WorldProvider wE_WorldProvider2 = worldProvider instanceof WE_WorldProvider ? (WE_WorldProvider)worldProvider : null;
        if (wE_WorldProvider2 != null && (wE_WorldProvider2 = wE_WorldProvider2.getChunkProvider()) != null) {
            boolean bl3;
            block14: {
                WE_Biome[] biomes;
                int n3;
                WE_WorldProvider cp = wE_WorldProvider = wE_WorldProvider2;
                boolean bl4 = false;
                n = 0;
                int n4 = xs.length;
                WE_Biome[] wE_BiomeArray = new WE_Biome[n4];
                while (n < n4) {
                    n3 = n++;
                    wE_BiomeArray[n3] = WE_Biome.getBiomeAt((WE_ChunkProvider)cp, (int)(x + xs[n3]), (int)(z + zs[n3]));
                }
                WE_Biome[] $this$any$iv = biomes = wE_BiomeArray;
                boolean $i$f$any = false;
                n3 = $this$any$iv.length;
                for (int i = 0; i < n3; ++i) {
                    WE_Biome element$iv;
                    WE_Biome it = element$iv = $this$any$iv[i];
                    boolean bl5 = false;
                    if (!(!(it instanceof BiomeField))) continue;
                    bl3 = true;
                    break block14;
                }
                bl3 = false;
            }
            if (bl3) {
                return false;
            }
        }
        this.generate01(world, x, y + 1, z);
        locs.add(TuplesKt.to((Object)x, (Object)z));
        data.func_76185_a();
        return true;
    }

    public final void generate01(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        SchemaUtils.generate$default((SchemaUtils)SchemaUtils.INSTANCE, (World)world, (int)x, (int)y, (int)z, (String)"alfheim/schemas/Arena", (boolean)true, (boolean)false, (boolean)false, (int)0, (int)448, null);
        BlockGrass blockGrass = Blocks.field_150349_c;
        Intrinsics.checkNotNullExpressionValue((Object)blockGrass, (String)"grass");
        ASJUtilities.fillGenHoles((World)world, (Block)((Block)blockGrass), (int)0, (int)(x + 20), (int)y, (int)(z + 20), (int)22);
        int count = world.field_73012_v.nextInt(3) + 1;
        int index = 0;
        if (count < 3 && world.field_73012_v.nextInt(count * 2) == 0) {
            index = world.field_73012_v.nextInt(4);
            switch (index) {
                case 0: {
                    world.func_147465_d(x + 16, y + 1, z + 16, ModBlocks.pylon, 2, 3);
                    break;
                }
                case 1: {
                    world.func_147465_d(x + 24, y + 1, z + 16, ModBlocks.pylon, 2, 3);
                    break;
                }
                case 2: {
                    world.func_147465_d(x + 16, y + 1, z + 24, ModBlocks.pylon, 2, 3);
                    break;
                }
                case 3: {
                    world.func_147465_d(x + 24, y + 1, z + 24, ModBlocks.pylon, 2, 3);
                }
            }
        }
        boolean[] pos = new boolean[9];
        int[] yo = new int[9];
        while (count > 0) {
            index = world.field_73012_v.nextInt(9);
            if (pos[index]) {
                ++count;
                --count;
                continue;
            }
            pos[index] = true;
            yo[index] = world.field_73012_v.nextInt(3) == 0 ? 0 : 1;
            --count;
        }
        if (pos[0]) {
            world.func_147465_d(x + 19, y + yo[0], z + 19, ModBlocks.storage, 2, 3);
        }
        if (pos[1]) {
            world.func_147465_d(x + 20, y + yo[1], z + 19, ModBlocks.storage, 2, 3);
        }
        if (pos[2]) {
            world.func_147465_d(x + 21, y + yo[2], z + 19, ModBlocks.storage, 2, 3);
        }
        if (pos[3]) {
            world.func_147465_d(x + 19, y + yo[3], z + 20, ModBlocks.storage, 2, 3);
        }
        if (pos[4]) {
            world.func_147465_d(x + 20, y + yo[4], z + 20, ModBlocks.storage, 2, 3);
        }
        if (pos[5]) {
            world.func_147465_d(x + 21, y + yo[5], z + 20, ModBlocks.storage, 2, 3);
        }
        if (pos[6]) {
            world.func_147465_d(x + 19, y + yo[6], z + 21, ModBlocks.storage, 2, 3);
        }
        if (pos[7]) {
            world.func_147465_d(x + 20, y + yo[7], z + 21, ModBlocks.storage, 2, 3);
        }
        if (pos[8]) {
            world.func_147465_d(x + 21, y + yo[8], z + 21, ModBlocks.storage, 2, 3);
        }
    }

    static {
        Integer[] integerArray = new Integer[]{0, 0, 0, 20, 20, 20, 40, 40, 40};
        xs = integerArray;
        integerArray = new Integer[]{0, 20, 40, 0, 20, 40, 0, 20, 40};
        zs = integerArray;
    }
}

