/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.alfheim.customgens;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ArrayExtKt;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.integration.thaumcraft.ThaumcraftAlfheimModule;
import alfheim.common.world.dim.alfheim.WorldProviderAlfheim;
import alfheim.common.world.dim.alfheim.biome.BiomeAlfheim;
import alfheim.common.world.dim.alfheim.biome.BiomeBeach;
import alfheim.common.world.dim.alfheim.biome.BiomeIslandGiantFlowers;
import alfheim.common.world.dim.alfheim.biome.BiomeRiver;
import alfheim.common.world.dim.alfheim.biome.BiomeSandbank;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import org.jetbrains.annotations.NotNull;
import ru.vamig.worldengine.WE_Biome;
import ru.vamig.worldengine.WE_ChunkProvider;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.lib.world.WorldGenGreatwoodTrees;
import thaumcraft.common.lib.world.WorldGenSilverwoodTrees;
import thaumcraft.common.lib.world.biomes.BiomeHandler;
import vazkii.botania.common.block.ModBlocks;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J(\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lalfheim/common/world/dim/alfheim/customgens/WorldGenAlfheimThaumcraft;", "Lcpw/mods/fml/common/IWorldGenerator;", "<init>", "()V", "noTreeBiomes", "", "Lalfheim/common/world/dim/alfheim/biome/BiomeAlfheim;", "getNoTreeBiomes", "()[Lalfheim/common/world/dim/alfheim/biome/BiomeAlfheim;", "[Lalfheim/common/world/dim/alfheim/biome/BiomeAlfheim;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkProvider;", "chunkProvider", "generateVegetation", "", "generateOres", "Alfheim"})
public final class WorldGenAlfheimThaumcraft
implements IWorldGenerator {
    @NotNull
    public static final WorldGenAlfheimThaumcraft INSTANCE = new WorldGenAlfheimThaumcraft();
    @NotNull
    private static final BiomeAlfheim[] noTreeBiomes;

    private WorldGenAlfheimThaumcraft() {
    }

    @NotNull
    public final BiomeAlfheim[] getNoTreeBiomes() {
        return noTreeBiomes;
    }

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkProvider chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)chunkProvider, (String)"chunkProvider");
        this.generateVegetation(world, random, chunkX, chunkZ);
        this.generateOres(world, random, chunkX, chunkZ);
    }

    private final boolean generateVegetation(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        WorldProvider worldProvider = world.field_73011_w;
        Intrinsics.checkNotNull((Object)worldProvider, (String)"null cannot be cast to non-null type alfheim.common.world.dim.alfheim.WorldProviderAlfheim");
        if (ArrayExtKt.inl((Object)WE_Biome.getBiomeAt((WE_ChunkProvider)((WorldProviderAlfheim)worldProvider).getChunkProvider(), (int)x, (int)z), (Object[])noTreeBiomes)) {
            return false;
        }
        int y = world.func_72976_f(x, z);
        if (random.nextInt(60) == 3) {
            return new WorldGenSilverwoodTrees(false, 7, 4).func_76484_a(world, random, x, y, z);
        }
        if (random.nextInt(25) == 7) {
            return new WorldGenGreatwoodTrees(false).generate(world, random, x, y, z, false);
        }
        return false;
    }

    private final void generateOres(World world, Random random, int chunkX, int chunkZ) {
        int i = 0;
        int randPosX = 0;
        int randPosZ = 0;
        int randPosY = 0;
        Block md = null;
        if (Config.genCinnibar) {
            for (i = 0; i < 18; ++i) {
                randPosX = chunkX * 16 + random.nextInt(16);
                md = world.func_147439_a(randPosX, randPosZ = random.nextInt(world.func_72800_K() / 5), randPosY = chunkZ * 16 + random.nextInt(16));
                if (md == null || !md.isReplaceableOreGen(world, randPosX, randPosZ, randPosY, ModBlocks.livingrock)) continue;
                world.func_147465_d(randPosX, randPosZ, randPosY, ThaumcraftAlfheimModule.INSTANCE.getAlfheimThaumOre(), 0, 0);
            }
        }
        if (Config.genAmber) {
            for (i = 0; i < 20; ++i) {
                randPosX = chunkX * 16 + random.nextInt(16);
                md = world.func_147439_a(randPosX, randPosY = world.func_72976_f(randPosX, randPosZ = chunkZ * 16 + random.nextInt(16)) - random.nextInt(25), randPosZ);
                if (md == null || !md.isReplaceableOreGen(world, randPosX, randPosY, randPosZ, ModBlocks.livingrock)) continue;
                world.func_147465_d(randPosX, randPosY, randPosZ, ThaumcraftAlfheimModule.INSTANCE.getAlfheimThaumOre(), 7, 2);
            }
        }
        if (Config.genInfusedStone) {
            for (i = 0; i < 8; ++i) {
                randPosX = chunkX * 16 + random.nextInt(16);
                randPosZ = chunkZ * 16 + random.nextInt(16);
                randPosY = random.nextInt(Math.max(5, world.func_72976_f(randPosX, randPosZ) - 5));
                int meta = random.nextInt(6) + 1;
                if (random.nextInt(3) == 0) {
                    Aspect e = BiomeHandler.getRandomBiomeTag((int)world.func_72807_a((int)randPosX, (int)randPosZ).field_76756_M, (Random)random);
                    if (e == null) {
                        meta = 1 + random.nextInt(6);
                    } else if (e == Aspect.AIR) {
                        meta = 1;
                    } else if (e == Aspect.FIRE) {
                        meta = 2;
                    } else if (e == Aspect.WATER) {
                        meta = 3;
                    } else if (e == Aspect.EARTH) {
                        meta = 4;
                    } else if (e == Aspect.ORDER) {
                        meta = 5;
                    } else if (e == Aspect.ENTROPY) {
                        meta = 6;
                    }
                }
                try {
                    new WorldGenMinable(ThaumcraftAlfheimModule.INSTANCE.getAlfheimThaumOre(), meta, 6, ModBlocks.livingrock).func_76484_a(world, random, randPosX, randPosY, randPosZ);
                    continue;
                }
                catch (Exception e) {
                    ASJUtilities.error((String)"Something went wrong while generating Thaumcraft ores in Alfheim:", (Throwable)e);
                }
            }
        }
    }

    static {
        BiomeAlfheim[] biomeAlfheimArray = new BiomeAlfheim[]{BiomeBeach.INSTANCE, BiomeSandbank.INSTANCE, BiomeRiver.INSTANCE, BiomeIslandGiantFlowers.INSTANCE};
        noTreeBiomes = biomeAlfheimArray;
        ThaumcraftWorldGenerator.addDimBlacklist((int)AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim(), (int)1);
    }
}

