/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.alfheim.customgens;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.SchemaUtils;
import alfheim.api.AlfheimAPI;
import alfheim.api.block.tile.SubTileAnomalyBase;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.block.tile.TileAnomaly;
import alfheim.common.block.tile.TileDomainLobby;
import alfheim.common.block.tile.TileYggFlower;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.world.dim.alfheim.structure.StructurePortalToNiflheim;
import alfheim.common.world.dim.alfheim.structure.StructureSpawnpoint;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J&\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J.\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ.\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006 "}, d2={"Lalfheim/common/world/dim/alfheim/customgens/WorldGenAlfheim;", "Lcpw/mods/fml/common/IWorldGenerator;", "<init>", "()V", "common", "Ljava/util/ArrayList;", "", "getCommon", "()Ljava/util/ArrayList;", "epic", "getEpic", "rare", "getRare", "generate", "", "rand", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkProvider;", "chunkProvider", "generateAlfheim", "generateAnomalies", "genRandomAnomalyOfRarity", "rarity", "Lalfheim/api/block/tile/SubTileAnomalyBase$EnumAnomalyRarity;", "setAnomaly", "type", "Alfheim"})
public final class WorldGenAlfheim
implements IWorldGenerator {
    @NotNull
    public static final WorldGenAlfheim INSTANCE = new WorldGenAlfheim();
    @NotNull
    private static final ArrayList<String> common = new ArrayList();
    @NotNull
    private static final ArrayList<String> epic = new ArrayList();
    @NotNull
    private static final ArrayList<String> rare = new ArrayList();

    private WorldGenAlfheim() {
    }

    @NotNull
    public final ArrayList<String> getCommon() {
        return common;
    }

    @NotNull
    public final ArrayList<String> getEpic() {
        return epic;
    }

    @NotNull
    public final ArrayList<String> getRare() {
        return rare;
    }

    public void generate(@NotNull Random rand, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkProvider chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)chunkProvider, (String)"chunkProvider");
        if (world.field_73011_w.field_76574_g == AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            this.generateAlfheim(world, chunkX, chunkZ, rand);
        }
    }

    public final void generateAlfheim(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (chunkX == 0 && chunkZ == 0) {
            StructureSpawnpoint.INSTANCE.generate(world, rand);
        }
        if (chunkX == 0 && chunkZ == -3) {
            world.func_147449_b(2, 226, -45, AlfheimBlocks.INSTANCE.getYggFlower());
            TileEntity tileEntity = world.func_147438_o(2, 226, -45);
            Intrinsics.checkNotNull((Object)tileEntity, (String)"null cannot be cast to non-null type alfheim.common.block.tile.TileYggFlower");
            ((TileYggFlower)tileEntity).setup();
        }
        if (chunkX == 0 && chunkZ == -6) {
            TileDomainLobby tileDomainLobby;
            SchemaUtils.generate$default((SchemaUtils)SchemaUtils.INSTANCE, (World)world, (int)0, (int)6, (int)-96, (String)"alfheim/schemas/FenrirCave", (boolean)false, (boolean)false, (boolean)false, (int)0, (int)448, null);
            TileEntity tileEntity = world.func_147438_o(0, 8, -70);
            Intrinsics.checkNotNull((Object)tileEntity, (String)"null cannot be cast to non-null type alfheim.common.block.tile.TileDomainLobby");
            TileDomainLobby $this$generateAlfheim_u24lambda_u240 = tileDomainLobby = (TileDomainLobby)tileEntity;
            boolean bl = false;
            $this$generateAlfheim_u24lambda_u240.lock(0, 8, -70, AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim());
            $this$generateAlfheim_u24lambda_u240.setName("Fenrir");
        }
        StructurePortalToNiflheim.INSTANCE.generate(world, chunkX, chunkZ);
        this.generateAnomalies(world, chunkX, chunkZ, rand);
    }

    public final void generateAnomalies(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
                if (AlfheimConfigHandler.INSTANCE.getAnomaliesDispersion() <= 0) {
                    return;
                }
                if (-16 <= chunkX ? chunkX < 16 : false) break block10;
                boolean bl = -16 <= chunkZ ? chunkZ < 16 : false;
                if (!bl) break block11;
            }
            return;
        }
        if (rand.nextInt(AlfheimConfigHandler.INSTANCE.getAnomaliesDispersion()) != 0) {
            return;
        }
        int chance = rand.nextInt(32) + 1;
        if (chance == 32) {
            this.genRandomAnomalyOfRarity(world, chunkX, chunkZ, rand, SubTileAnomalyBase.EnumAnomalyRarity.EPIC);
        } else if (chance >= 24) {
            this.genRandomAnomalyOfRarity(world, chunkX, chunkZ, rand, SubTileAnomalyBase.EnumAnomalyRarity.RARE);
        } else if (chance >= 16) {
            this.genRandomAnomalyOfRarity(world, chunkX, chunkZ, rand, SubTileAnomalyBase.EnumAnomalyRarity.COMMON);
        }
    }

    public final void genRandomAnomalyOfRarity(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand, @NotNull SubTileAnomalyBase.EnumAnomalyRarity rarity) {
        String string;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
        switch (WhenMappings.$EnumSwitchMapping$0[rarity.ordinal()]) {
            case 1: {
                string = (String)ExtensionsKt.random((Collection)common, (Random)rand);
                break;
            }
            case 2: {
                string = (String)ExtensionsKt.random((Collection)epic, (Random)rand);
                break;
            }
            case 3: {
                string = (String)ExtensionsKt.random((Collection)rare, (Random)rand);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (string == null) {
            return;
        }
        String type2 = string;
        this.setAnomaly(world, chunkX, chunkZ, rand, type2);
    }

    public final void setAnomaly(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand, @NotNull String type2) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            int x = chunkX * 16 + rand.nextInt(16);
            int z = chunkZ * 16 + rand.nextInt(16);
            int y = world.func_72825_h(x, z) + 1;
            world.func_147449_b(x, y, z, AlfheimBlocks.INSTANCE.getAnomaly());
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            TileAnomaly tileAnomaly = tileEntity instanceof TileAnomaly ? (TileAnomaly)tileEntity : null;
            if (tileAnomaly == null) {
                return;
            }
            TileAnomaly te = tileAnomaly;
            te.lock(x, y, z, world.field_73011_w.field_76574_g);
            te.setSubTileName(type2);
            if (te.getSubTile() == null) break block4;
            SubTileAnomalyBase subTileAnomalyBase = te.getSubTile();
            if (subTileAnomalyBase != null) {
                subTileAnomalyBase.setWorldGen(true);
            }
            int n = AlfheimConfigHandler.INSTANCE.getAnomaliesUpdate();
            for (int i = 0; i < n; ++i) {
                te.func_145845_h();
            }
            SubTileAnomalyBase subTileAnomalyBase2 = te.getSubTile();
            if (subTileAnomalyBase2 != null) {
                subTileAnomalyBase2.setWorldGen(false);
            }
        }
    }

    static {
        Iterator<String> iterator = AlfheimAPI.INSTANCE.getAnomalies().keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            switch (WhenMappings.$EnumSwitchMapping$0[AlfheimAPI.INSTANCE.getAnomaly(name).getRarity().ordinal()]) {
                case 1: {
                    boolean bl = common.add(name);
                    break;
                }
                case 2: {
                    boolean bl = epic.add(name);
                    break;
                }
                case 3: {
                    boolean bl = rare.add(name);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SubTileAnomalyBase.EnumAnomalyRarity.values().length];
            try {
                nArray[SubTileAnomalyBase.EnumAnomalyRarity.COMMON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubTileAnomalyBase.EnumAnomalyRarity.EPIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubTileAnomalyBase.EnumAnomalyRarity.RARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

