/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.alfheim.customgens;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.AlfheimCore;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.block.BlockNiflheimPortal;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.SheerColdHandler;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.entity.EntityElf;
import alfheim.common.world.dim.alfheim.customgens.YggdrasilGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import org.jetbrains.annotations.NotNull;
import ru.vamig.worldengine.additions.WE_CreateChunkGen;
import ru.vamig.worldengine.additions.WE_GeneratorData;
import vazkii.botania.common.entity.EntityFlyingCreature;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u001aH\u0007J\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR)\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lalfheim/common/world/dim/alfheim/customgens/NiflheimLocationGenerator;", "Lru/vamig/worldengine/additions/WE_CreateChunkGen;", "<init>", "()V", "keepAir", "Ljava/util/HashSet;", "Lkotlin/Triple;", "", "getKeepAir", "()Ljava/util/HashSet;", "gen", "", "data", "Lru/vamig/worldengine/additions/WE_GeneratorData;", "yobaFunction2d", "", "x", "z", "fillCavesFreezeLiquidsEtc", "e", "Lnet/minecraftforge/event/terraingen/PopulateChunkEvent$Post;", "freezePlayers", "Lalfheim/common/core/handler/SheerColdHandler$SheerColdTickEvent;", "worldTickClient", "Lcpw/mods/fml/common/gameevent/TickEvent$WorldTickEvent;", "forbidEntitySpawn", "Lnet/minecraftforge/event/entity/living/LivingSpawnEvent$CheckSpawn;", "portalXZ", "Lkotlin/Pair;", "world", "Lnet/minecraft/world/World;", "Alfheim"})
@SourceDebugExtension(value={"SMAP\nNiflheimLocationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NiflheimLocationGenerator.kt\nalfheim/common/world/dim/alfheim/customgens/NiflheimLocationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1557#2:157\n1628#2,3:158\n*S KotlinDebug\n*F\n+ 1 NiflheimLocationGenerator.kt\nalfheim/common/world/dim/alfheim/customgens/NiflheimLocationGenerator\n*L\n28#1:157\n28#1:158,3\n*E\n"})
public final class NiflheimLocationGenerator
extends WE_CreateChunkGen {
    @NotNull
    public static final NiflheimLocationGenerator INSTANCE;
    @NotNull
    private static final HashSet<Triple<Integer, Integer, Integer>> keepAir;

    private NiflheimLocationGenerator() {
    }

    @NotNull
    public final HashSet<Triple<Integer, Integer, Integer>> getKeepAir() {
        return keepAir;
    }

    public void gen(@NotNull WE_GeneratorData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.chunkProvider.world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            return;
        }
        int x16 = ExtensionsKt.getI((Number)data.chunk_X);
        int z16 = ExtensionsKt.getI((Number)data.chunk_Z);
        World world = data.chunkProvider.world;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        Pair<Integer, Integer> pair = this.portalXZ(world);
        int xOff = ((Number)pair.component1()).intValue();
        int zOff = ((Number)pair.component2()).intValue();
        for (int i = 0; i < 16; ++i) {
            block6: for (int k = 0; k < 16; ++k) {
                int x = x16 + i;
                int z = z16 + k;
                if (!this.yobaFunction2d(x - xOff, z - zOff)) continue;
                int c = 0;
                Block block = null;
                while ((block = this.getBlock(data, i, ++c, k)) != null && !Intrinsics.areEqual((Object)block, (Object)Blocks.field_150350_a)) {
                }
                int n = c - 4;
                int j = c;
                if (n <= j) {
                    while (true) {
                        switch (data.chunkProvider.world.field_73012_v.nextInt(3)) {
                            case 0: {
                                this.setBlock(data, Blocks.field_150346_d, (byte)1, i, j, k);
                                break;
                            }
                            case 1: {
                                this.setBlock(data, (Block)Blocks.field_150354_m, (byte)0, i, j, k);
                                break;
                            }
                            case 2: {
                                this.setBlock(data, Blocks.field_150351_n, (byte)0, i, j, k);
                            }
                        }
                        if (j == n) break;
                        --j;
                    }
                }
                if ((j = c) > (n = Math.min(255, c + 64))) continue;
                while (true) {
                    this.setBlock(data, Blocks.field_150432_aD, (byte)1, i, j, k);
                    if (j == n) continue block6;
                    ++j;
                }
            }
        }
    }

    public final boolean yobaFunction2d(int x, int z) {
        return YggdrasilGenerator.INSTANCE.yobaFunction(x, 1, z, 2.4f, 4.3f, 3.2f);
    }

    @SubscribeEvent
    public final void fillCavesFreezeLiquidsEtc(@NotNull PopulateChunkEvent.Post e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            return;
        }
        int x16 = e.chunkX * 16;
        int z16 = e.chunkZ * 16;
        World world = e.world;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        Pair<Integer, Integer> pair = this.portalXZ(world);
        int xOff = ((Number)pair.component1()).intValue();
        int zOff = ((Number)pair.component2()).intValue();
        for (int i = 0; i < 16; ++i) {
            block1: for (int k = 0; k < 16; ++k) {
                int x = x16 + i;
                int z = z16 + k;
                if (!this.yobaFunction2d(x - xOff, z - zOff)) continue;
                int j = 256;
                Block block = null;
                while (Intrinsics.areEqual((Object)(block = e.world.func_147439_a(x, --j, z)), (Object)Blocks.field_150350_a)) {
                }
                int y = 0;
                int n = j;
                if (y > n) continue;
                while (true) {
                    if (!keepAir.contains(ExtensionsKt.with((Pair)TuplesKt.to((Object)(x - xOff), (Object)(y - 33)), (Object)(z - zOff)))) {
                        block = e.world.func_147439_a(x, y, z);
                        if (block == Blocks.field_150350_a || block == Blocks.field_150355_j || block == Blocks.field_150358_i || block instanceof BlockBush) {
                            e.world.func_147465_d(x, y, z, Blocks.field_150432_aD, 1, 2);
                        } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                            e.world.func_147465_d(x, y, z, Blocks.field_150343_Z, 0, 2);
                        }
                    }
                    if (y == n) continue block1;
                    ++y;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void freezePlayers(@NotNull SheerColdHandler.SheerColdTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        EntityLivingBase entity = e.entityLiving;
        if (entity.field_71093_bK != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            return;
        }
        World world = entity.field_70170_p;
        Intrinsics.checkNotNull((Object)world);
        Pair<Integer, Integer> pair = this.portalXZ(world);
        int xOff = ((Number)pair.component1()).intValue();
        int zOff = ((Number)pair.component2()).intValue();
        Intrinsics.checkNotNull((Object)entity);
        Integer[] integerArray = Vector3.Companion.fromEntity((Entity)entity).sub((Number)xOff, (Number)0, (Number)zOff).mf();
        int x = ((Number)integerArray[0]).intValue();
        int z = ((Number)integerArray[2]).intValue();
        if (!this.yobaFunction2d(x, z)) {
            return;
        }
        float dist = ExtensionsKt.getF((Number)Vector3.Companion.vecEntityDistance(new Vector3(BlockNiflheimPortal.Companion.onlyPortalPosition(world)), (Entity)entity));
        float cold = 0.01f / (dist / (float)64);
        Float f = e.getDelta();
        e.setDelta(Float.valueOf((f != null ? f.floatValue() : 0.0f) + cold));
    }

    @SubscribeEvent
    public final void worldTickClient(@NotNull TickEvent.WorldTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim() || ASJUtilities.isClient() || e.world.field_73012_v.nextInt(5) != 0) {
            return;
        }
        World world = e.world;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        ChunkCoordinates chunkCoordinates = BlockNiflheimPortal.Companion.onlyPortalPosition(world);
        int i = ExtensionsKt.component1((ChunkCoordinates)chunkCoordinates);
        int j = ExtensionsKt.component2((ChunkCoordinates)chunkCoordinates);
        int k = ExtensionsKt.component3((ChunkCoordinates)chunkCoordinates);
        if (!Intrinsics.areEqual((Object)e.world.func_147439_a(i, j, k), (Object)Blocks.field_150355_j)) {
            return;
        }
        Vector3 vector3 = Vector3.add$default((Vector3)new Vector3((Number)i, (Number)j, (Number)k), (Number)0.5, null, null, (int)6, null);
        double x = vector3.component1();
        double y = vector3.component2();
        double z = vector3.component3();
        Vector3 vector32 = Vector3.mul$default((Vector3)Vector3.sub$default((Vector3)new Vector3(null, null, null, 7, null).rand(), (Number)0.5, null, null, (int)6, null).normalize(), (Number)(Math.random() * 0.25), null, null, (int)6, null);
        double mx = vector32.component1();
        double my = vector32.component2();
        double mz = vector32.component3();
        double[] dArray = new double[]{x, y, z, 0.75, 0.95, 1.0, Math.random() * 0.1 + 0.2, mx, my, mz, Math.random() * (double)3 + 1.0};
        VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.WISP, AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim(), dArray);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void forbidEntitySpawn(@NotNull LivingSpawnEvent.CheckSpawn e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            return;
        }
        World world = e.world;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        Pair<Integer, Integer> pair = this.portalXZ(world);
        int xOff = ((Number)pair.component1()).intValue();
        int zOff = ((Number)pair.component2()).intValue();
        if (!this.yobaFunction2d(ExtensionsKt.mfloor((double)e.entity.field_70165_t) - xOff, ExtensionsKt.mfloor((double)e.entity.field_70161_v) - zOff)) {
            return;
        }
        if (e.entity instanceof EntityElf || e.entity instanceof EntityFlyingCreature) {
            return;
        }
        if (AlfheimCore.INSTANCE.getTwilightForestLoaded() && Intrinsics.areEqual((Object)EntityList.func_75621_b((Entity)e.entity), (Object)"TwilightForest.Glacier Penguin")) {
            e.setResult(Event.Result.ALLOW);
            return;
        }
        e.setResult(Event.Result.DENY);
    }

    @NotNull
    public final Pair<Integer, Integer> portalXZ(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Random rand = new Random(world.func_72905_C());
        return TuplesKt.to((Object)ASJUtilities.randInBounds((int)-512, (int)512, (Random)rand), (Object)ASJUtilities.randInBounds((int)-4096, (int)-2048, (Random)rand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static {
        void var3_7;
        void $this$mapTo$iv$iv;
        Object it2;
        INSTANCE = new NiflheimLocationGenerator();
        InputStream inputStream = ((Object)((Object)INSTANCE)).getClass().getResourceAsStream("/assets/alfheim/schemas/PortalToNiflheimSafeFromIce");
        Intrinsics.checkNotNull((Object)inputStream);
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        object = null;
        try {
            it2 = (BufferedReader)closeable;
            boolean bl = false;
            it2 = TextStreamsKt.readLines((Reader)((Reader)it2));
        }
        catch (Throwable it2) {
            object = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Iterable $this$map$iv = (Iterable)it2;
        boolean $i$f$map = false;
        it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            List list = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)it3, (String)"[^\\d\\- ]", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String x = (String)list.get(0);
            String y = (String)list.get(1);
            String z = (String)list.get(2);
            collection.add(ExtensionsKt.with((Pair)TuplesKt.to((Object)Integer.parseInt(x), (Object)Integer.parseInt(y)), (Object)Integer.parseInt(z)));
        }
        keepAir = CollectionsKt.toHashSet((Iterable)((List)var3_7));
        ExtensionsKt.eventFML((Object)ExtensionsKt.eventForge((Object)((Object)INSTANCE)));
    }
}

