/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.data;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.core.handler.AlfheimConfigHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0016J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0007R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R)\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010&\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010\u0005\u00a8\u0006."}, d2={"Lalfheim/common/world/data/CustomWorldData;", "Lnet/minecraft/world/WorldSavedData;", "datakey", "", "<init>", "(Ljava/lang/String;)V", "dimensionId", "", "getDimensionId", "()I", "setDimensionId", "(I)V", "value", "Lnet/minecraft/util/ChunkCoordinates;", "spawnpoint", "getSpawnpoint", "()Lnet/minecraft/util/ChunkCoordinates;", "setSpawnpoint", "(Lnet/minecraft/util/ChunkCoordinates;)V", "structures", "Lcom/google/common/collect/Multimap;", "Lkotlin/Pair;", "getStructures", "()Lcom/google/common/collect/Multimap;", "data", "Ljava/util/HashMap;", "getData", "()Ljava/util/HashMap;", "nbtData", "Lnet/minecraft/nbt/NBTTagCompound;", "getNbtData", "()Lnet/minecraft/nbt/NBTTagCompound;", "setNbtData", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "writeToNBT", "", "nbt", "readFromNBT", "oldNbt", "getOldNbt", "()Ljava/lang/String;", "setOldNbt", "watchNBT", "e", "Lcpw/mods/fml/common/gameevent/TickEvent$WorldTickEvent;", "Companion", "Alfheim"})
public final class CustomWorldData
extends WorldSavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int dimensionId;
    @Nullable
    private ChunkCoordinates spawnpoint;
    @NotNull
    private final Multimap<String, Pair<Integer, Integer>> structures;
    @NotNull
    private final HashMap<String, String> data;
    @NotNull
    private NBTTagCompound nbtData;
    @NotNull
    private String oldNbt;
    @NotNull
    public static final String TAG_DIM_ID = "dim";
    @NotNull
    public static final String TAG_DATA = "data";
    @NotNull
    public static final String TAG_NBT_DATA = "nbtData";
    @NotNull
    public static final String TAG_SPAWNPOINT = "spawnpoint";
    @NotNull
    public static final String TAG_STRUCTURES = "structures";
    @NotNull
    private static final Map<Integer, String> datakeys;

    public CustomWorldData(@NotNull String datakey) {
        Intrinsics.checkNotNullParameter((Object)datakey, (String)"datakey");
        super(datakey);
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        this.structures = (Multimap)hashMultimap;
        this.data = new HashMap();
        this.nbtData = new NBTTagCompound();
        ExtensionsKt.eventFML((Object)((Object)this));
        this.oldNbt = "";
    }

    public final int getDimensionId() {
        return this.dimensionId;
    }

    public final void setDimensionId(int n) {
        this.dimensionId = n;
    }

    @Nullable
    public final ChunkCoordinates getSpawnpoint() {
        return this.spawnpoint;
    }

    public final void setSpawnpoint(@Nullable ChunkCoordinates value) {
        this.spawnpoint = value;
        this.func_76185_a();
    }

    @NotNull
    public final Multimap<String, Pair<Integer, Integer>> getStructures() {
        return this.structures;
    }

    @NotNull
    public final HashMap<String, String> getData() {
        return this.data;
    }

    @NotNull
    public final NBTTagCompound getNbtData() {
        return this.nbtData;
    }

    public final void setNbtData(@NotNull NBTTagCompound nBTTagCompound) {
        Intrinsics.checkNotNullParameter((Object)nBTTagCompound, (String)"<set-?>");
        this.nbtData = nBTTagCompound;
    }

    public void func_76187_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a(TAG_DIM_ID, this.dimensionId);
        ChunkCoordinates chunkCoordinates = this.spawnpoint;
        if (chunkCoordinates != null) {
            ChunkCoordinates it = chunkCoordinates;
            boolean bl = false;
            int x = ExtensionsKt.component1((ChunkCoordinates)it);
            int y = ExtensionsKt.component2((ChunkCoordinates)it);
            int z = ExtensionsKt.component3((ChunkCoordinates)it);
            int[] nArray = new int[]{x, y, z};
            nbt.func_74783_a(TAG_SPAWNPOINT, nArray);
        }
        NBTTagCompound structs = new NBTTagCompound();
        for (String key : this.structures.keySet()) {
            NBTTagList list = new NBTTagList();
            for (Pair y : this.structures.get((Object)key)) {
                int x = ((Number)y.component1()).intValue();
                int z = ((Number)y.component2()).intValue();
                int[] nArray = new int[]{x, z};
                list.field_74747_a.add(new NBTTagIntArray(nArray));
            }
            structs.func_74782_a(key, (NBTBase)list);
        }
        nbt.func_74782_a(TAG_STRUCTURES, (NBTBase)structs);
        NBTTagCompound adata = new NBTTagCompound();
        Iterator<Map.Entry<String, String>> iterator = this.data.entrySet().iterator();
        while (iterator.hasNext()) {
            String v;
            String k;
            Map.Entry<String, String> entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"component1(...)");
            Intrinsics.checkNotNullExpressionValue((Object)entry.getValue(), (String)"component2(...)");
            adata.func_74778_a(k, v);
        }
        nbt.func_74782_a(TAG_DATA, (NBTBase)adata);
        nbt.func_74782_a(TAG_NBT_DATA, (NBTBase)this.nbtData);
    }

    public void func_76184_a(@NotNull NBTTagCompound nbt) {
        NBTTagCompound x2;
        int[] ints;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (nbt.func_74764_b(TAG_DIM_ID)) {
            this.dimensionId = nbt.func_74762_e(TAG_DIM_ID);
        }
        if ((ints = nbt.func_74759_k(TAG_SPAWNPOINT)).length == 3) {
            Intrinsics.checkNotNull((Object)ints);
            int x2 = ints[0];
            int y = ints[1];
            int z = ints[2];
            this.setSpawnpoint(new ChunkCoordinates(x2, y, z));
        }
        NBTTagCompound $this$readFromNBT_u24lambda_u241 = x2 = nbt.func_74775_l(TAG_STRUCTURES);
        boolean bl = false;
        if (!$this$readFromNBT_u24lambda_u241.func_82582_d()) {
            this.structures.clear();
            for (Object key : $this$readFromNBT_u24lambda_u241.func_150296_c()) {
                NBTTagList list;
                NBTBase nBTBase = $this$readFromNBT_u24lambda_u241.func_74781_a(String.valueOf(key));
                if ((nBTBase instanceof NBTTagList ? (NBTTagList)nBTBase : null) == null) continue;
                list = list;
                for (Object e : list.field_74747_a) {
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.nbt.NBTTagIntArray");
                    int[] nArray = ((NBTTagIntArray)e).func_150302_c();
                    Intrinsics.checkNotNull((Object)nArray);
                    int x3 = nArray[0];
                    int z = nArray[1];
                    this.structures.put((Object)String.valueOf(key), (Object)TuplesKt.to((Object)x3, (Object)z));
                }
            }
        }
        NBTTagCompound adata = nbt.func_74775_l(TAG_DATA);
        for (Object k : adata.field_74784_a.keySet()) {
            ((Map)this.data).put(String.valueOf(k), adata.func_74779_i(String.valueOf(k)));
        }
        this.nbtData = nbt.func_74775_l(TAG_NBT_DATA);
    }

    @NotNull
    public final String getOldNbt() {
        return this.oldNbt;
    }

    public final void setOldNbt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.oldNbt = string;
    }

    @SubscribeEvent
    public final void watchNBT(@NotNull TickEvent.WorldTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.world.field_73011_w.field_76574_g != this.dimensionId || e.phase != TickEvent.Phase.END) {
            return;
        }
        if (e.world.func_82737_E() % (long)100 != 0L) {
            return;
        }
        String string = this.nbtData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String nbt = string;
        if (Intrinsics.areEqual((Object)nbt, (Object)this.oldNbt)) {
            return;
        }
        this.oldNbt = nbt;
        if (((CharSequence)this.oldNbt).length() > 0) {
            this.func_76185_a();
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)-1, (Object)"MuspelheimData"), TuplesKt.to((Object)AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim(), (Object)"AlfheimData"), TuplesKt.to((Object)AlfheimConfigHandler.INSTANCE.getDimensionIDNiflheim(), (Object)"NiflheimData")};
        datakeys = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lalfheim/common/world/data/CustomWorldData$Companion;", "", "<init>", "()V", "TAG_DIM_ID", "", "TAG_DATA", "TAG_NBT_DATA", "TAG_SPAWNPOINT", "TAG_STRUCTURES", "datakeys", "", "", "getDatakeys", "()Ljava/util/Map;", "customData", "Lalfheim/common/world/data/CustomWorldData;", "Lnet/minecraft/world/World;", "getCustomData", "(Lnet/minecraft/world/World;)Lalfheim/common/world/data/CustomWorldData;", "Alfheim"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Integer, String> getDatakeys() {
            return datakeys;
        }

        @NotNull
        public final CustomWorldData getCustomData(@NotNull World $this$customData) {
            String name;
            WorldSavedData worldSavedData;
            CustomWorldData data;
            Intrinsics.checkNotNullParameter((Object)$this$customData, (String)"<this>");
            int dimensionId = $this$customData.field_73011_w.field_76574_g;
            StringBuilder stringBuilder = new StringBuilder().append("alfheim_");
            String string = this.getDatakeys().get(dimensionId);
            if (string == null) {
                string = String.valueOf(dimensionId);
            }
            CustomWorldData customWorldData = data = (worldSavedData = $this$customData.perWorldStorage.func_75742_a(CustomWorldData.class, name = stringBuilder.append(string).toString())) instanceof CustomWorldData ? (CustomWorldData)worldSavedData : null;
            if (data == null) {
                data = new CustomWorldData(name);
                data.setDimensionId(dimensionId);
                data.func_76185_a();
                $this$customData.perWorldStorage.func_75745_a(name, (WorldSavedData)data);
            }
            return data;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

